#include "datafile.h"
using namespace std;

DATAFILE *dat = 0;

datafile_t datafile;

datafile_t::datafile_t(const string &fname) : dat(0), filename(fname)
{
    
}

void datafile_t::set_filename(const string &fname)
{
    filename = fname;
}

string datafile_t::get_filename() const
{
    return filename;
}

bool datafile_t::load()
{
    return (dat = load_datafile(filename.c_str()));
}

void datafile_t::unload()
{
    unload_datafile(dat);
    
    for(map<void*, DATAFILE*>::iterator itr = loadfinds.begin();
        itr != loadfinds.end(); ++itr) {
        
        unload_datafile_object(itr->second);
    }
    
    loadfinds.clear();
}

void *datafile_t::find(const std::string &objname, DATAFILE **datf)
{
    if(0 == dat)
        return 0;
    
    DATAFILE *obj = find_datafile_object(dat, objname.c_str());
    
    if(0 != datf)
        *datf = obj;
    
    if(0 == obj)
        return 0;
    
    return obj->dat;
}

void *datafile_t::loadfind(const std::string &objname, DATAFILE **datf){
    void *ret = 0;
    
    if((ret = find(objname, datf)))
        return ret;
    
    DATAFILE *obj = 0;
    
    for(map<void*, DATAFILE*>::iterator itr = loadfinds.begin();
        itr != loadfinds.end(); ++itr) {
        
        if(objname == get_datafile_property(itr->second, DAT_ID('N','A','M','E'))) {
            
            obj = itr->second;
        }
    }
    
    if(0 == obj)
        obj = load_datafile_object(filename.c_str(), objname.c_str());
    
    if(0 != datf)
        *datf = obj;
    
    if(0 == obj)
        return 0;
    
    loadfinds[obj->dat] = obj;
    
    return obj->dat;
}

void datafile_t::unloadfind(void *dat)
{
    unload_datafile_object(loadfinds[dat]);
    
    loadfinds[dat] = 0;
}

DATAFILE *datafile_t::get_datafile()
{
    return dat;
}
