#include "boss.h"
#include "tile.h"
#include "bomb.h"
#include "player.h"
#include "dumbo.h"
#include "particle.h"
using namespace std;

boss::boss()
    : anim("OBJECT/BOSS/BOSS"), fire0("OBJECT/BOSS/FIRE0"),
      fire1("OBJECT/BOSS/FIRE1"), fire2("OBJECT/BOSS/FIRE2"),
      leftface(rand()%2), ifire(0), lives(6), activated(0)
{
    setpos(8500 + rand()%1000, 10, force);
    for(int y = 0; !setpos(getx(), gety()) && y < SCREEN_H; y++)
        setpos(getx(), gety() + y);
    
    setw(anim.get_bmp()->w);
    seth(anim.get_bmp()->h);
}

boss::~boss()
{
    extern bool shuttingdown;
    
    if(shuttingdown)
        return;
    
#ifndef NOSOUND
        extern SAMPLE *playerdead;
        play_sample(playerdead, 255, 127, 1000, 0);
#endif
}

int boss::think()
{
    player &plr = *player::get_player();
    tileengine::tilemap &map = *tileengine::tilemap::get_collision_layer();
    
    if(dead) {
        
        ifire = 0;
        
        if(!hurtclock.check())
            for(unsigned int i = 0; i < 7 - hurtclock.seconds() / 20; i++)
                particle_manager::get_particle_manager()->add(getx() + (rand()%getw()), gety() + (rand()%geth()), 2, 0, 0);
        else
            return kill;
    }
    
    if(activated && abs(plr.getx() - getx()) > 50 && leftclock.check())
        leftface = plr.getx() < getx() ? 2 : 0, rightface = plr.getx() > getx() ? 2 : 0, leftclock.start(rand()%10);
    
    if(leftclock.check())
        leftface = rand()%3, rightface = rand()%3, leftclock.start(rand()%10);
    
    if(upclock.check())
        upface = rand()%3, downface = rand()%3, upclock.start(rand()%10);
    
    if(abs(plr.getx() - getx()) < 250 && !activated) {
        
        activated = true;
        
        dumbo_load("songs/boss.it");
    }
    
    if(getx() < 8500)
        leftface = 0, rightface = 3, leftclock.start(15);
    
    if(getx() > map.getw() - 64)
        leftface = 3, rightface = 0, leftclock.start(15);
    
    if(ifire > 0 && gunclock.check() && !dead) {
        
#ifndef NOSOUND
        extern SAMPLE *shoot;
        play_sample(shoot, 255, 127, 1000, 0);
#endif
        
        get_unit_list()->push_back(new bomb(getx() + (rand()%getw()), gety() + 24));
        gunclock.start(rand()%4);
        ifire--;
    }
    
    if(plr.getx() + plr.getw() > getx() && plr.getx() < getx() + getw() && !ifire)
        ifire = 3, gunclock.check();
    
    if(dead)
        upface = 0, downface = rand()%2;
    
    int x = getx(), y = gety();
    
    x -= leftface;
    x += rightface;
    y -= upface;
    y += downface;
    
    setpos(x, y, dead ? force : normal);
    
    return normal;
}

void boss::draw(BITMAP *dest, int x, int y)
{
    animation *anim = &this->anim;
    
    // Todo: Uncommenting below crashes, why?
    
    /*if(ifire == 3)
        anim = &fire2;
    if(ifire == 2)
        anim = &fire1;
    if(ifire == 1)
        anim = &fire0;*/
    
    if(!dead)
        draw_sprite(dest, anim->get_bmp(), x, y);
}

void boss::oncollide(unit *u)
{
    player *plr = dynamic_cast<player*>(u);
    
    if(plr)
        plr->hurt();
}

void boss::hurt()
{
    if(dead || !hurtclock.check())
        return;
    
    if(lives > 0)
        lives--;
    
    if(!lives)
        dead = true;
    
#ifndef NOSOUND
    extern SAMPLE *death;
    play_sample(death, 255, 127, 1000, 0);
#endif
    
    hurtclock.start(lives ? 10 : 15);
}

bool boss::alive()
{
    return !dead;
}
