#ifndef ANIMATION_H
#define ANIMATION_H

#include "datafile.h"
#include "stopwatch.h"
#include <vector>
#include <allegro.h>

class animation {
    
    struct frame {
        
        int msec_delay;
        BITMAP *bmp;
    };
    
    std::vector<frame> frames;
    
    unsigned int cur_frame;
    unsigned int frame_msec_start;
    
    bool running;
    
public:
    
    // path must be ready to use with the specified datafile.
    // The path will be postfixed with a number starting at 0 and
    // incremented until no image is found.  An example path could
    // be: CHARACTERS/BRILLY/FIST/LEFT/
    // 
    // Note the object in the datafile must have an attribute called
    // TIME which specifies how many milliseconds the frame will display
    // for.  If it is not specified the time defaults to 0
    
    animation(const std::string &path, datafile_t* = &datafile);

    animation();
    animation(const animation&);
    
    // Animation is running (started) by default
    
    void start();
    void restart();
    void unpause();
    void stop();
    void pause();
    
    // Alais functions representing the same data
    
    bool unpaused();
    bool paused();
    bool started();
    bool stopped();
    
    // Calculates the current BITMAP* and returns it
    
    BITMAP *get_bmp();
    
    static volatile unsigned int *msecs;
};

#endif
