#include "animation.h"
#include <sstream>
#include <iostream>
using namespace std;

volatile unsigned int *animation::msecs = 0;

animation::animation(const string &path, datafile_t *datafile)
    : cur_frame(0), running(1)
{
    DATAFILE *datf;
    BITMAP *bmp;
    
    for(int i = 0; 1; i++) {
        
        ostringstream os;
        
        os << path << i;
        
        bmp = (BITMAP*)datafile->find(os.str(), &datf);
        
        if(!bmp)
            break;
        
        frames.push_back(frame());
        
        frames.back().msec_delay = atoi(get_datafile_property(datf, DAT_ID('T', 'I', 'M', 'E')));
        
        frames.back().bmp = bmp;
    }
    
    frame_msec_start = *msecs;
}

animation::animation()
    : cur_frame(0), frame_msec_start(*msecs), running(1)
{
    
}

animation::animation(const animation &src)
    : frames(src.frames), cur_frame(src.cur_frame), frame_msec_start(src.frame_msec_start), running(src.running)
{
    
}

void animation::start()
{
    running = 1;
    frame_msec_start = *msecs;
}

void animation::restart()
{
    running = 1;
    cur_frame = 0;
    frame_msec_start = *msecs;
}

void animation::unpause()
{
    running = 1;
}

void animation::stop()
{
    cur_frame = 0;
    running = 0;
}

void animation::pause()
{
    running = 0;
}

bool animation::unpaused()
{
    return running;
}

bool animation::paused()
{
    return !running;
}

bool animation::started()
{
    return running;
}

bool animation::stopped()
{
    return !running;
}

BITMAP *animation::get_bmp()
{
    if(frames.empty())
        return 0;
    
    while(running && frame_msec_start + frames[cur_frame].msec_delay < *msecs) {
        
        frame_msec_start += frames[cur_frame].msec_delay;
        
        cur_frame++;
        
        if(cur_frame >= frames.size())
            cur_frame = 0;
        
        if(0 == frames[cur_frame].msec_delay)
            break;
    }
    
    return frames[cur_frame].bmp;
}
