/*
  Setup program fr LG Game 1
  Programmering: Patrik Lindahl (ramzeus@home.se)
*/


#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <midasdll.h>
#include <allegro.h>
#include <dpmi.h>

typedef struct
{
  char *MenuText;
  char *MenuHelp;
} TMenu;

#define MainMenuCount 4
TMenu MainMenu[MainMenuCount] =
{
  {"Sound Setup", "Setup sound and music for LG Game 1"},
  {"Joystick Setup", "Setup joystick sensitivity"},
  {"Game Speed/Sync", "Debug function, change the game speed"},
  {"Debug mode", "Enable/disable debug mode"},
};

#define SaveConfigMenuCount 2
TMenu SaveConfigMenu[SaveConfigMenuCount] =
{
  {"Yes", "Yes... Save the config"},
  {"No", "No... Don't save the config"}
};

#define SfxChoiceMenuCount 2
TMenu SfxChoiceMenu[SfxChoiceMenuCount] =
{
  {"Yes", "Yes... Play sounds"},
  {"No", "No... Don't play sounds"}
};

#define MusicChoiceMenuCount 2
TMenu MusicChoiceMenu[MusicChoiceMenuCount] =
{
  {"Yes", "Yes... Play music"},
  {"No", "No... Don't play music"}
};

#define DebugChoiceMenuCount 2
TMenu DebugChoiceMenu[DebugChoiceMenuCount] =
{
  {"Yes", "Yes... Debug mode it is"},
  {"No", "No... I dont like debug mode"}
};

#define GameSpeedEditMenuCount 1
TMenu GameSpeedEditMenu[GameSpeedEditMenuCount] =
{
  {"Game speed:", "120000 = Normal game speed, Enter 0 to disable game sync"},
};

#define SoundMenuCount 5
TMenu SoundMenu[SoundMenuCount] =
{
  {"MIDAS sound setup", "Choose sound card. Sound card is autodetected."},
  {"Play sfx", "Play soundeffects Yes/No"},
  {"Play music", "Play music Yes/no"},
  {"Sfx volume", "Enter sound effects volume"},
  {"Music volume", "Enter music volume"},
};


char *ProgramName = {"LG Game 1 setup version 0.2"};
char *CopyRight = {"(c) 2000 Legion Software"};
char *HelpText = {"Esc Exits   Move   Selects"};
int PlaySounds=0, PlayMusic=0, GameSpeed=120000, Debug=1, SfxVol=64, MusicVol=50;
char ret[10] = {"\0\0\0\0\0\0\0\0\0\0"};


int draw_background()
{
  int i;
  textbackground(LIGHTGRAY);
  textcolor(BLACK);
  gotoxy(1,1);
  clreol();
  cprintf(" %s", ProgramName);
  gotoxy(ScreenCols()-strlen(CopyRight),1);
  cprintf("%s", CopyRight);
  textbackground(BROWN);
  textcolor(BLACK);
  for (i=2;i<ScreenRows();i++)
  {
    gotoxy(1, i);
    //cprintf("");
    //cprintf("");
    cprintf("");
  }
  return 0;
}


char *draw_edit_menu(char *EditText, char *EditMenuName, char *EditHelp, int Start)
{
  int j=0, i=0, temp=0, MaxLen=0, Exit=FALSE;
  int StartX=1, EndX=1;
  int StartY=1, EndY=1;
  char ch, pos, *buff[10];
  if (strlen("Esc Aborts")+1>MaxLen)
    MaxLen=strlen("Esc Aborts")+1;
  if (strlen(EditText)+10>MaxLen)
    MaxLen=strlen(EditText)+10;
  if (strlen(EditMenuName)+1>MaxLen)
    MaxLen=strlen(EditMenuName)+1;
  StartX=(ScreenCols()/2)-((MaxLen+4)/2);
  StartY=(ScreenRows()/2)-((1+6)/2);
  EndX=(ScreenCols()/2)+((MaxLen+4)/2);
  EndY=(ScreenRows()/2)+((1+6)/2);
  textcolor(LIGHTCYAN);
  textbackground(BLUE);
  gotoxy(StartX, StartY);
  cprintf("");
  for (i=StartX;i<EndX-1;i++)
    cprintf("");
  cprintf("");
  gotoxy(StartX, StartY+1);
  cprintf("");
  for (i=StartX;i<EndX-1;i++)
    cprintf(" ");
  cprintf("");
  textcolor(DARKGRAY);
  textbackground(BLACK);
  gettext(wherex(), wherey(), wherex()+2, wherey(), buff);
  cprintf("%c%c", buff[0],buff[1]);
  textcolor(LIGHTGREEN);
  textbackground(BLUE);
  gotoxy((ScreenCols()/2)-(strlen(EditMenuName)/2), StartY+1);
  cprintf("%s", EditMenuName);
  textcolor(LIGHTCYAN);
  gotoxy(StartX, StartY+2);
  textcolor(LIGHTCYAN);
  cprintf("");
  for (j=StartX;j<EndX-1;j++)
    cprintf(" ");
  cprintf("");
  textcolor(DARKGRAY);
  textbackground(BLACK);
  gettext(wherex(), wherey(), wherex()+2, wherey(), buff);
  cprintf("%c%c", buff[0],buff[1]);
  textbackground(BLUE);
  gotoxy(StartX, StartY+2+1);
  textcolor(LIGHTCYAN);
  cprintf("");
  for (j=StartX;j<EndX-1;j++)
    cprintf(" ");
  cprintf("");
  textcolor(DARKGRAY);
  textbackground(BLACK);
  gettext(wherex(), wherey(), wherex()+2, wherey(), buff);
  cprintf("%c%c", buff[0],buff[1]);
  textbackground(BLUE);
  textcolor(LIGHTCYAN);
  gotoxy(StartX+1, StartY+2+1);
  cprintf(" %s", EditText);
  gotoxy(StartX, StartY+2+2);
    textcolor(LIGHTCYAN);
  cprintf("");
  for (i=StartX;i<EndX-1;i++)
    cprintf("");
  cprintf("");
  textcolor(DARKGRAY);
  textbackground(BLACK);
  gettext(wherex(), wherey(), wherex()+2, wherey(), buff);
  cprintf("%c%c", buff[0],buff[1]);
  textcolor(LIGHTCYAN);
  textbackground(BLUE);
  gotoxy(StartX, StartY+2+2+1);
  cprintf("");
  for (j=StartX;j<EndX-1;j++)
    cprintf(" ");
  cprintf("");
  textcolor(DARKGRAY);
  textbackground(BLACK);
  gettext(wherex(), wherey(), wherex()+2, wherey(), buff);
  cprintf("%c%c", buff[0],buff[1]);
  textcolor(LIGHTCYAN);
  textbackground(BLUE);
  gotoxy(StartX+1, StartY+2+2+1);
  cprintf("  %s", "Esc Aborts");
  gotoxy(StartX, StartY+2+2+2);
  cprintf("");
  for (i=StartX;i<EndX-1;i++)
    cprintf("");
  cprintf("");
  textcolor(DARKGRAY);
  textbackground(BLACK);
  gettext(wherex(), wherey(), wherex()+2, wherey(), buff);
  cprintf("%c%c", buff[0],buff[1]);
  gotoxy(StartX+2, StartY+2+2+3);
  for (i=StartX;i<EndX+1;i++)
  {
    gettext(wherex(), wherey(), wherex(), wherey(), buff);
    cprintf("%c", buff[0]);
  }
  gotoxy(1, ScreenRows());
  textcolor(BLACK);
  textbackground(LIGHTGRAY);
  clreol();
  gotoxy((ScreenCols()/2)-(strlen(EditHelp)/2), ScreenRows());
  cprintf("%s", EditHelp);
  textbackground(BLUE);
  textcolor(LIGHTMAGENTA);
  gotoxy(StartX+strlen(EditText)+3, StartY+2+1);
  itoa(Start, ret, 10);
  cprintf("%s", ret);
  pos=strlen(ret);
  _setcursortype(_NORMALCURSOR);
  while (ch!=13)
  {
    if (keypressed())
    {
      ch=readkey()&0xff;
      if (ch==27)
      {
        itoa(Start, ret, 10);
        ch=13;
      }
      else if (ch==8)
      {
        if (wherex()>(StartX+strlen(EditText)+3))
        {
          pos--;
          ret[pos]='\0';
          gotoxy(wherex()-1, wherey());
          cprintf(" ");
          gotoxy(wherex()-1, wherey());
        }
      }
      else if (pos<8)
      {
        ret[pos]=ch;
        pos++;
        cprintf("%c", ch);
      }
    }
  }
  _setcursortype(_NOCURSOR);
  return ret;
}


int draw_choice_menu(TMenu _Menu[], int _MenuCount, char *_MenuName, int StartPos)
{
  int j=0, i=0, temp=0, MaxLen=0, Exit=FALSE;
  int StartX=1, EndX=1;
  int StartY=1, EndY=1;
  int CurPos=StartPos, OldPos=StartPos;
  char *buff[10];
  for (i=1;i<_MenuCount;i++)
  {
    temp=strlen(_Menu[i].MenuText);
    if (temp>MaxLen)
      MaxLen=temp;
  }
  if (strlen("Esc Aborts")+1>MaxLen)
    MaxLen=strlen("Esc Aborts")+1;
  if (strlen(_MenuName)+1>MaxLen)
    MaxLen=strlen(_MenuName)+1;
  StartX=(ScreenCols()/2)-((MaxLen+4)/2);
  StartY=(ScreenRows()/2)-((_MenuCount+6)/2);
  EndX=(ScreenCols()/2)+((MaxLen+4)/2);
  EndY=(ScreenRows()/2)+((_MenuCount+6)/2);
  textcolor(LIGHTCYAN);
  textbackground(BLUE);
  gotoxy(StartX, StartY);
  cprintf("");
  for (i=StartX;i<EndX-1;i++)
    cprintf("");
  cprintf("");
  gotoxy(StartX, StartY+1);
  cprintf("");
  for (i=StartX;i<EndX-1;i++)
    cprintf(" ");
  cprintf("");
  textcolor(DARKGRAY);
  textbackground(BLACK);
  gettext(wherex(), wherey(), wherex()+2, wherey(), buff);
  cprintf("%c%c", buff[0],buff[1]);
  textcolor(LIGHTGREEN);
  textbackground(BLUE);
  gotoxy((ScreenCols()/2)-(strlen(_MenuName)/2), StartY+1);
  cprintf("%s", _MenuName);
  textcolor(LIGHTCYAN);
  gotoxy(StartX, StartY+2);
  textcolor(LIGHTCYAN);
  cprintf("");
  for (j=StartX;j<EndX-1;j++)
    cprintf(" ");
  cprintf("");
  textcolor(DARKGRAY);
  textbackground(BLACK);
  gettext(wherex(), wherey(), wherex()+2, wherey(), buff);
  cprintf("%c%c", buff[0],buff[1]);
  textbackground(BLUE);
  for (i=0;i<_MenuCount;i++)
  {
    gotoxy(StartX, StartY+2+i);
    textcolor(LIGHTCYAN);
    cprintf("");
    for (j=StartX;j<EndX-1;j++)
      cprintf(" ");
    cprintf("");
    textcolor(DARKGRAY);
    textbackground(BLACK);
    gettext(wherex(), wherey(), wherex()+2, wherey(), buff);
    cprintf("%c%c", buff[0],buff[1]);
    textbackground(BLUE);
    gotoxy(StartX+1, StartY+2+i);
    textcolor(WHITE);
    cprintf(" %s", _Menu[i].MenuText);
  }
  gotoxy(StartX, StartY+2+_MenuCount);
    textcolor(LIGHTCYAN);
  cprintf("");
  for (i=StartX;i<EndX-1;i++)
    cprintf("");
  cprintf("");
  textcolor(DARKGRAY);
  textbackground(BLACK);
  gettext(wherex(), wherey(), wherex()+2, wherey(), buff);
  cprintf("%c%c", buff[0],buff[1]);
  textcolor(LIGHTCYAN);
  textbackground(BLUE);
  gotoxy(StartX, StartY+2+_MenuCount+1);
  cprintf("");
  for (j=StartX;j<EndX-1;j++)
    cprintf(" ");
  cprintf("");
  textcolor(DARKGRAY);
  textbackground(BLACK);
  gettext(wherex(), wherey(), wherex()+2, wherey(), buff);
  cprintf("%c%c", buff[0],buff[1]);
  textcolor(LIGHTCYAN);
  textbackground(BLUE);
  gotoxy(StartX+1, StartY+2+_MenuCount+1);
  cprintf("  %s", "Esc Aborts");
  gotoxy(StartX, StartY+2+_MenuCount+2);
  cprintf("");
  for (i=StartX;i<EndX-1;i++)
    cprintf("");
  cprintf("");
  textcolor(DARKGRAY);
  textbackground(BLACK);
  gettext(wherex(), wherey(), wherex()+2, wherey(), buff);
  cprintf("%c%c", buff[0],buff[1]);
  gotoxy(StartX+2, StartY+2+_MenuCount+3);
  for (i=StartX;i<EndX+1;i++)
  {
    gettext(wherex(), wherey(), wherex(), wherey(), buff);
    cprintf("%c", buff[0]);
  }
  while (!Exit)
  {
    gotoxy(StartX, StartY+2+OldPos);
    textcolor(LIGHTCYAN);
    textbackground(BLUE);
    cprintf("");
    for (j=StartX;j<EndX-1;j++)
      cprintf(" ");
    cprintf("");
    textcolor(DARKGRAY);
    textbackground(BLACK);
    gettext(wherex(), wherey(), wherex()+2, wherey(), buff);
    cprintf("%c%c", buff[0],buff[1]);
    textbackground(BLUE);
    textcolor(WHITE);
    gotoxy(StartX+1, StartY+2+OldPos);
    cprintf(" %s", _Menu[OldPos].MenuText);

    gotoxy(StartX, StartY+2+CurPos);
    textcolor(LIGHTCYAN);
    cprintf("");
    for (j=StartX;j<EndX-1;j++)
      cprintf(" ");
    cprintf("");
    textcolor(DARKGRAY);
    textbackground(BLACK);
    gettext(wherex(), wherey(), wherex()+2, wherey(), buff);
    cprintf("%c%c", buff[0],buff[1]);
    textbackground(BLUE);
    gotoxy(StartX+1, StartY+2+CurPos);
    cprintf(" ");
    textcolor(BLUE);
    textbackground(MAGENTA);
    cprintf("%s", _Menu[CurPos].MenuText);
    textbackground(BLUE);
    gotoxy(1, ScreenRows());
    textcolor(BLACK);
    textbackground(LIGHTGRAY);
    clreol();
    gotoxy((ScreenCols()/2)-(strlen(_Menu[CurPos].MenuHelp)/2), ScreenRows());
    cprintf("%s", _Menu[CurPos].MenuHelp);
    textbackground(BLUE);

    gotoxy(ScreenCols(), ScreenRows());
    switch(readkey())
    { // Upp
      case  18432 : OldPos=CurPos;
                    CurPos--;
                    if (CurPos<0)
                      CurPos=_MenuCount-1;
                    break;
      // Ner
      case  20480 : OldPos=CurPos;
                    CurPos++;
                    if (CurPos>_MenuCount-1)
                      CurPos=0;
                    break;
      // Enter
      case  7181  : Exit=TRUE;
                    return CurPos;
                    break;
      // Esc
      case  283   : Exit=TRUE;
                    return 256;
                    break;
    };
  }
  return 256;
}


int draw_menu(TMenu _Menu[], int _MenuCount, char *_MenuName, int StartPos)
{
  int j=0, i=0, temp=0, MaxLen=0, Exit=FALSE;
  int StartX=1, EndX=1;
  int StartY=1, EndY=1;
  int CurPos=StartPos, OldPos=StartPos;
  char *buff[10];
  for (i=1;i<_MenuCount;i++)
  {
    temp=strlen(_Menu[i].MenuText);
    if (temp>MaxLen)
      MaxLen=temp;
  }
  if (strlen(HelpText)+1>MaxLen)
    MaxLen=strlen(HelpText)+1;
  StartX=(ScreenCols()/2)-((MaxLen+4)/2);
  StartY=(ScreenRows()/2)-((_MenuCount+6)/2);
  EndX=(ScreenCols()/2)+((MaxLen+4)/2);
  EndY=(ScreenRows()/2)+((_MenuCount+6)/2);
  textcolor(LIGHTCYAN);
  textbackground(BLUE);
  gotoxy(StartX, StartY);
  cprintf("");
  for (i=StartX;i<EndX-1;i++)
    cprintf("");
  cprintf("");
  gotoxy(StartX, StartY+1);
  cprintf("");
  for (i=StartX;i<EndX-1;i++)
    cprintf(" ");
  cprintf("");
  textcolor(DARKGRAY);
  textbackground(BLACK);
  gettext(wherex(), wherey(), wherex()+2, wherey(), buff);
  cprintf("%c%c", buff[0],buff[1]);
  textcolor(LIGHTCYAN);
  textbackground(BLUE);
  gotoxy((ScreenCols()/2)-(strlen(_MenuName)/2), StartY+1);
  cprintf("%s", _MenuName);
  gotoxy(StartX, StartY+2);
  cprintf("");
  for (i=StartX;i<EndX-1;i++)
    cprintf("");
  cprintf("");
  textcolor(DARKGRAY);
  textbackground(BLACK);
  gettext(wherex(), wherey(), wherex()+2, wherey(), buff);
  cprintf("%c%c", buff[0],buff[1]);
  textcolor(LIGHTCYAN);
  textbackground(BLUE);
  gotoxy(StartX, StartY+3);
  textcolor(LIGHTCYAN);
  cprintf("");
  for (j=StartX;j<EndX-1;j++)
    cprintf(" ");
  cprintf("");
  textcolor(DARKGRAY);
  textbackground(BLACK);
  gettext(wherex(), wherey(), wherex()+2, wherey(), buff);
  cprintf("%c%c", buff[0],buff[1]);
  textbackground(BLUE);

  for (i=0;i<_MenuCount;i++)
  {
    gotoxy(StartX, StartY+3+i);
    textcolor(LIGHTCYAN);
    cprintf("");
    for (j=StartX;j<EndX-1;j++)
      cprintf(" ");
    cprintf("");
    textcolor(DARKGRAY);
    textbackground(BLACK);
    gettext(wherex(), wherey(), wherex()+2, wherey(), buff);
    cprintf("%c%c", buff[0],buff[1]);
    textbackground(BLUE);
    gotoxy(StartX+1, StartY+3+i);
    textcolor(WHITE);
    cprintf(" %s", _Menu[i].MenuText);
  }
  gotoxy(StartX, StartY+3+_MenuCount);
    textcolor(LIGHTCYAN);
  cprintf("");
  for (i=StartX;i<EndX-1;i++)
    cprintf("");
  cprintf("");
  textcolor(DARKGRAY);
  textbackground(BLACK);
  gettext(wherex(), wherey(), wherex()+2, wherey(), buff);
  cprintf("%c%c", buff[0],buff[1]);
  textcolor(LIGHTCYAN);
  textbackground(BLUE);
  gotoxy(StartX, StartY+3+_MenuCount+1);
  cprintf("");
  for (j=StartX;j<EndX-1;j++)
    cprintf(" ");
  cprintf("");
  textcolor(DARKGRAY);
  textbackground(BLACK);
  gettext(wherex(), wherey(), wherex()+2, wherey(), buff);
  cprintf("%c%c", buff[0],buff[1]);
  textcolor(LIGHTCYAN);
  textbackground(BLUE);
  gotoxy(StartX+1, StartY+3+_MenuCount+1);
  cprintf("  %s", HelpText);
  gotoxy(StartX, StartY+3+_MenuCount+2);
  cprintf("");
  for (i=StartX;i<EndX-1;i++)
    cprintf("");
  cprintf("");
  textcolor(DARKGRAY);
  textbackground(BLACK);
  gettext(wherex(), wherey(), wherex()+2, wherey(), buff);
  cprintf("%c%c", buff[0],buff[1]);
  gotoxy(StartX+2, StartY+3+_MenuCount+3);
  for (i=StartX;i<EndX+1;i++)
  {
    gettext(wherex(), wherey(), wherex(), wherey(), buff);
    cprintf("%c", buff[0]);
  }
  while (!Exit)
  {
    gotoxy(StartX, StartY+3+OldPos);
    textcolor(LIGHTCYAN);
    textbackground(BLUE);
    cprintf("");
    for (j=StartX;j<EndX-1;j++)
      cprintf(" ");
    cprintf("");
    textcolor(DARKGRAY);
    textbackground(BLACK);
    gettext(wherex(), wherey(), wherex()+2, wherey(), buff);
    cprintf("%c%c", buff[0],buff[1]);
    textbackground(BLUE);
    textcolor(WHITE);
    gotoxy(StartX+1, StartY+3+OldPos);
    cprintf(" %s", _Menu[OldPos].MenuText);

    gotoxy(StartX, StartY+3+CurPos);
    textcolor(LIGHTCYAN);
    cprintf("");
    for (j=StartX;j<EndX-1;j++)
      cprintf(" ");
    cprintf("");
    textcolor(DARKGRAY);
    textbackground(BLACK);
    gettext(wherex(), wherey(), wherex()+2, wherey(), buff);
    cprintf("%c%c", buff[0],buff[1]);
    textbackground(BLUE);
    gotoxy(StartX+1, StartY+3+CurPos);
    cprintf(" ");
    textcolor(BLUE);
    textbackground(MAGENTA);
    cprintf("%s", _Menu[CurPos].MenuText);
    textbackground(BLUE);
    gotoxy(1, ScreenRows());
    textcolor(BLACK);
    textbackground(LIGHTGRAY);
    clreol();
    gotoxy((ScreenCols()/2)-(strlen(_Menu[CurPos].MenuHelp)/2), ScreenRows());
    cprintf("%s", _Menu[CurPos].MenuHelp);
    textbackground(BLUE);

    gotoxy(ScreenCols(), ScreenRows());
    switch(readkey())
    { // Upp
      case  18432 : OldPos=CurPos;
                    CurPos--;
                    if (CurPos<0)
                      CurPos=_MenuCount-1;
                    break;
      // Ner
      case  20480 : OldPos=CurPos;
                    CurPos++;
                    if (CurPos>_MenuCount-1)
                      CurPos=0;
                    break;
      // Enter
      case  7181  : Exit=TRUE;
                    return CurPos;
                    break;
      // Esc
      case  283   : Exit=TRUE;
                    return 256;
                    break;
    };
  }
  return 256;
}


int SaveConfig()
{
  FILE *F;
  MIDASsaveConfig("midas.cfg");
  F=fopen("lggame1.cfg", "wb");
  putw(GameSpeed, F);
  if (PlaySounds==0)
    putw(1, F);
  else
    putw(0, F);
  if (PlayMusic==0)
    putw(1, F);
  else
    putw(0, F);
  if (Debug==0)
    putw(1, F);
  else
    putw(0, F);
  putw(SfxVol, F);
  putw(MusicVol, F);
  fclose(F);
  return 0;
}


int LoadConfig()
{
  FILE *F;
  if (exists("midas.cfg"))
    MIDASloadConfig("midas.cfg");
  if (exists("lggame1.cfg"))
  {
    F=fopen("lggame1.cfg", "rb");
    GameSpeed=getw(F);
    if (getw(F)==1)
      PlaySounds=0;
    else
      PlaySounds=1;
    if (getw(F)==1)
      PlayMusic=0;
    else
      PlayMusic=1;
    if (getw(F)==1)
      Debug=0;
    else
      Debug=1;
    SfxVol=getw(F);
    MusicVol=getw(F);
    fclose(F);
  }
  return 0;
}

int SoundSetup()
{
  int Exit=FALSE, res=0;
  draw_background();
  while (!Exit)
  {
    if (res>4)
      res=0;
    res=draw_menu(SoundMenu, SoundMenuCount, "Sound Setup", res);
    switch(res)
    {
      case 0   : remove_keyboard();
                 MIDASstartup();
                 MIDASconfig();
                 install_keyboard();
                 set_colors();
                 draw_background();
                 break;
      case 1   : PlaySounds=draw_choice_menu(SfxChoiceMenu, SfxChoiceMenuCount, "Play sounds?", PlaySounds);
                 break;
      case 2   : PlayMusic=draw_choice_menu(MusicChoiceMenu, MusicChoiceMenuCount, "Play music?", PlayMusic);
                 break;
      case 3   : SfxVol=atoi(draw_edit_menu("Volume", "Sfx volume", "64 = Normal sound effects volume, 64 is max volume", SfxVol));
                 if (SfxVol>64)
                   SfxVol=64;
                 if (SfxVol<0)
                   SfxVol=0;
                 break;
      case 4   : MusicVol=atoi(draw_edit_menu("Volume", "Music volume", "50 = Normal music volume, 64 is max volume", MusicVol));
                 if (MusicVol>64)
                   MusicVol=64;
                 if (MusicVol<0)
                   MusicVol=0;
                 break;
      case 256 : Exit=TRUE;
                 break;
    };
  }
  return 0;
}


int set_colors()
{
  __dpmi_regs r;

  // Gr om BWOWN till DARKGRAY
  r.x.ax=0x1000;
  r.h.bl=BROWN;
  r.h.bh=56;
  __dpmi_int(0X10, &r);


  // Gr om MAGENTA till ljus WHITE
  r.x.ax=0x1000;
  r.h.bl=MAGENTA;
  r.h.bh=255;
  __dpmi_int(0X10, &r);
  return 0;
}


int main(int argc, char *argv[])
{
  int Exit=FALSE, res=0, i=0;
  set_colors();
  install_keyboard();
  LoadConfig();
  _setcursortype(_NOCURSOR);
  draw_background();
  while (!Exit)
  {
    if (res>3)
      res=0;
    res=draw_menu(MainMenu, MainMenuCount, "Main Menu", res);
    switch(res)
    {
      case 0   : SoundSetup();
                 draw_background();
                 break;
      case 1   :
                 break;
      case 2   : GameSpeed=atoi(draw_edit_menu("Speed:", "Enter game speed", "Normal game speed = 120000.  Enter 0 for no game sync.", GameSpeed));
                 break;
      case 3   : Debug=draw_choice_menu(DebugChoiceMenu, DebugChoiceMenuCount, "Debug mode?", Debug);
                 break;
      case 256 : res=draw_choice_menu(SaveConfigMenu, SaveConfigMenuCount, "Save Configuration?", 0);
                 if (res==0)
                   SaveConfig();
                 if ((res==1) || (res==0))
                   Exit=TRUE;
                 break;
    };
  }
  textcolor(LIGHTGRAY);
  textbackground(BLACK);
  clrscr();
  remove_keyboard();
  return 0;
}
