/*
        LG Game 1   - Ett spel av Legion Sommaren 2000


        Filformat fr level (.lev) filer:

        Beskrivning           | Offset | Bytes | vrigt
        ----------------------|--------| ------| ------
        Version och identitet | 0x0000 | 6     | Ska vara "LGL100"
        Namn p banan         | 0x0006 | 20    |
        Ban identitet         | 0x001A | 1     |
        Lngd i pixlar        | 0x001B | 2     | Hg byte frst
        Hjd i pixlar         | 0x001D | 2     | Hg byte frst
        Antal block i banan   | 0x001F | 2     | Hg byte frst
        Antal fiender i banan | 0x0021 | 2     | Hg byte frst
        Antal saker i banan   | 0x0023 | 2     | Hg byte frst
        Spelarestart X        | 0x0025 | 2     | Hg byte frst
        Spelarestart Y        | 0x0027 | 2     | Hg byte frst
        Blocktyp              | 0x0029 | 1     |
        Blockposition X       | 0x002A | 2     | Hg byte frst
        Blockposition Y       | 0x002C | 2     | Hg byte frst
        Blockstopp 1 X        | 0x002E | 2     | Hg byte frst
        Blockstopp 1 Y        | 0x0020 | 2     | Hg byte frst
        Blockstopp 2 X        | 0x0032 | 2     | Hg byte frst
        Blockstopp 2 Y        | 0x0034 | 2     | Hg byte frst
        ...                   ...      ...     ...
        Fiendetyp             | ?      | 1     |
        Fiendeposition X      | ?      | 2     | Hg byte frst
        Fiendeposition Y      | ?      | 2     | Hg byte frst
        Fiendestopp 1 X       | ?      | 2     | Hg byte frst
        Fiendestopp 1 Y       | ?      | 2     | Hg byte frst
        Fiendestopp 2 X       | ?      | 2     | Hg byte frst
        Fiendestopp 2 Y       | ?      | 2     | Hg byte frst
        ...                   ...      ...     ...
        Saktyp                | ?      | 1     |
        Sakposition X         | ?      | 2     | Hg byte frst
        Sakposition Y         | ?      | 2     | Hg byte frst
        Sakstopp 1 X          | ?      | 2     | Hg byte frst
        Sakstopp 1 Y          | ?      | 2     | Hg byte frst
        Sakstopp 2 X          | ?      | 2     | Hg byte frst
        Sakstopp 2 Y          | ?      | 2     | Hg byte frst
        ...                   ...      ...     ...



        [*] = Fixad
        [+] = Nytt
        [-] = Borttaget
        [!] = Fel som ska fixas
        [/] = Inaktiverad
        [^] = Information

        Versionshistoria frn och med 2000-06-25 13:56

        V 0.7.3  2000-08-17 23:57
        -------------------------
         [+] FPS mtare (stt game sync till 0)
         [+] Extra texturer
         [+] Jet pack
         [*] Frsker kra i Vesa 2 linear mode vilket ger stabilare
             bild, dvs. den flimmrar inte lika mycket. Annars i VGA
         [!] Minneslckor
         [!] Baneditorn kan krasha om minnet tar slut
         [!] Ingen bakgrund p det som r under 190 pixlar i Y led
         [!] Att man inte kan scrolla nr man placerar ut vissa saker
         [!] Skvgar till objekt
        -------------------------

        V 0.7.2  2000-08-10 21:16
        -------------------------
         [^] lggame1.dat r utbytt mot gfx.dat
         [+] Ny palett
         [+] Nya och frbttrade bildobjekt
         [*] Baneditorn r mer stabil
         [!] Minneslckor
         [!] Baneditorn kan krasha om minnet tar slut
         [!] Ingen bakgrund p det som r under 190 pixlar i Y led
         [!] Att man inte kan scrolla nr man placerar ut vissa saker
         [!] Skvgar till objekt
        -------------------------

        V 0.7.1  2000-08-08 19:31
        -------------------------
         [+] Alla bilder och fonter i en dat fil
         [+] Exefilerna r packade med UPX
         [*] Ny bttre version av setup programet (v0.2)
         [!] Minneslckor
         [!] Baneditorn kan krasha om minnet tar slut
         [!] Ingen bakgrund p det som r under 190 pixlar i Y led
         [!] Att man inte kan scrolla nr man placerar ut vissa saker
         [!] Skvgar till objekt
        -------------------------

        V 0.7.0  2000-08-08 03:42
        -------------------------
         [+] Setup program
         [+] Animationer p studsmattan
         [*] Mycket snabbare utritning av objekt
         [!] Minneslckor
         [!] Baneditorn kan krasha om minnet tar slut
         [!] Ingen bakgrund p det som r under 190 pixlar i Y led
         [!] Att man inte kan scrolla nr man placerar ut vissa saker
         [!] Skvgar till objekt
        -------------------------

        V 0.6.10  2000-08-06 00:35
        -------------------------
         [+] Studsmatta
         [+] Extra kontroll s att det inte gr att skriva utanfr
             levelmasken och andra vilktiga dynamiska variabler.
         [+] Man kan nu g upfr sneda texturer igen...
         [+] Man kan nu g i uppfrsbackar igen
         [*] Nu fungerar plattformarna nstintill perfekt
         [*] Man kan inte lngre fastna med huvudet i texturer
             som r ovanfr en stege
         [!] Minneslckor
         [!] Baneditorn kan krasha om minnet tar slut
         [!] Ingen bakgrund p det som r under 190 pixlar i Y led
         [!] Att man inte kan scrolla nr man placerar ut vissa saker
         [!] Texturfel p dom lutande texturerna
        -------------------------

        V 0.6.9  2000-08-03 15:36
        -------------------------
         [-] LevelMasken testvisningen visas nu inte
         [+] Plattformar som kan ka i luften
         [+] Bakgrundsbild p statusraden lngst upp
         [*] Diverse smbuggar
         [*] Startpositionerna placeras ut mer korrekt
         [*] Spelet krashar inte lngre om man dr nedanfr y koordinat 200
         [*] Fixade texturfelen p gubben och stegen
         [*] Fixade s att man inte kan g genom texturerna nr man klttrar
         [*] Statusraden lngst upp blir inte lngre kladdig av
             utkletade texturer
         [!] Man kan fastna med huvudet i texturer som r ovanfr en stege
         [!] Minneslckor
         [!] Baneditorn kan krasha om minnet tar slut
         [!] Man kan inte g i en uppfrsbacke
         [!] Ingen bakgrund p det som r under 190 pixlar i Y led
         [!] Att man inte kan scrolla nr man placerar ut fiender
         [!] Texturfel p dom lutande texturerna
        -------------------------

        V 0.6.8  2000-08-01 18:02
        -------------------------
         [^] DEBUG mode
         [^] Tryck p enter en extra gng nr spelet startar fr att
             komma frbi LevelMask debugskrmen
         [+] Man kan nu g upp fr en stege
         [+] Helt omskriven banladdare, fungerar bttre nu.
         [*] LevelMasken laddas annorlunda
         [*] Har frhoppningsvis fixat s att man ska kunna
             bygga alla typer av banor utan att det krashar
         [*] Pongtexten p fienderna kommer nu mer korrekt nr man r
             nedanfr y koordinat 200
         [!] Minneslckor
         [!] Spelet scrollar nedt nr man har en startposition som
             ligger under y koordinat 200
         [!] Spelet krashar om man dr nedanfr y koordinat 200
         [!] Man kan g genom texturerna nr man klttrar p en stege
         [!] Baneditorn kan krasha nr man stter ut grejjer eller fiender
         [!] Fixa stegtexturen
         [!] Fattas en pixel p gubben (vid gat)
         [!] Man kan inte g i en uppfrsbacke
         [!] Ingen bakgrund p det som r under 190 pixlar i Y led
         [!] Att man inte kan scrolla nr man placerar ut fiender
         [!] Texturfel p dom lutande texturerna
        -------------------------

        V 0.6.7  2000-07-04 20:21
        -------------------------
         [^] DEBUG mode
         [^] Ingen bana medfljer
         [-] Man kan inte lngre g upp fr "backar", kommer frmodligen
             tillbaka i nsta version
         [*] Koden prioriterar att dda fienden istllet fr att ta skada
         [+] Gubben rr p fossingarna
         [*] Vrde fr banan i hjdled r tillagd, gamla banor kommer inte
             att fungera
         [*] Frflyttningsknapparna (s, d, f, e) i editorn fungerar nu p
             alla objekt
         [*] En bugg i deletefunktionen r fixad
         [!] Ingen bakgrund p det som r under 190 pixlar i Y led
         [!] Att man inte kan scrolla nr man placerar ut fiender
         [!] Fel om man bygger fr stora banor
         [!] Texturfel p dom lutande texturerna
        -------------------------

        V 0.6.6  2000-07-02 02:57
        -------------------------
         [^] DEBUG mode
         [*] Fel nr man ska ta bort block som ligger utanfr de
             frsta 320 pixlarna
         [+] Pongsiffror visar hur mnga pong man fr p varje sak eller fiende
         [!] Att man inte kan scrolla nr man placerar ut fiender
         [!] Eventuellt fel om man bygger fr stora banor
         [!] Texturfel p dom lutande texturerna
        -------------------------

        V 0.6.5  2000-07-01 01:12
        -------------------------
         [^] DEBUG mode
         [+] Delete funktion i editorn
         [+] Man kan lta fienderna g mellan tv valfria punkter
         [*] Omskrivet filformat fr .lev filer
         [*] Diverse funktioner i editorn
         [!] Eventuellt fel om man bygger fr stora banor
         [^] Gamla .lev filer kommer inte att fungera med denna version
        -------------------------

        V 0.6.3  2000-06-29 22:16
        -------------------------
         [^] DEBUG mode
         [!] Paletten p bakgrundsbilden (by bild)
         [*] Ljudeffektsbugen, nu ska det fungera p alla datorer
         [+] Felmeddelanden om MIDAS skulle misslyckas med ngot
         [+] man kan g ver en pixel hga kanter
         [+] Nya texturer och fiender
         [*] Fixat s att fienderna ochs byter hll (som spelaren)
         -------------------------

        V 0.6.2  2000-06-26 22:16
        -------------------------
         [^] DEBUG mode
         [!] Paletten p bakgrundsbilden
         [*] Hoppbugen fixad
         [*] Gubben hoppar hgre och finare
         [+] Nya texturer och fiender
         [^] Vissa texturer ligger med, men dom laddas inte
         [^] Innom kort kommer .lev filformatet att byggas ut
         [^] Editorn kommer f nya funktioner
         -------------------------


        V 0.6.1  2000-06-26 12:09
        -------------------------
         [^] DEBUG mode
         [^] Bakgrunden laddas, men ritas fr nrvarande inte ut
         [*] Fixat s att det inte hnger sig nr man ska skapa banor
         [!] Nr man hoppar s kan man fasna i luften
         [+] Debugtexter p design_new_level();
         [^] Innom kort kommer .lev filformatet att byggas ut
         [^] Editorn kommer f nya funktioner
         -------------------------

        V 0.6.0  2000-06-26 00:23
        -------------------------
         [^] DEBUG mode
         [^] Bakgrunden laddas, men ritas fr nrvarande inte ut
         [+] Ljudeffekter
         [+] Man kan dda fienderna
        -------------------------

        V 0.5.4  2000-06-25 22:41
        -------------------------
         [^] DEBUG mode
         [*] Fienderna rr sig lngsammare
         [+] Skada och ddsfunktion
         [+] Bakgrund
         [^] Bakgrunden laddas, men ritas fr nrvarande inte ut
        -------------------------

        V 0.5.1  2000-06-25 19:38
        -------------------------
         [^] DEBUG mode
         [*] Fler kommentarer
         [*] .lev filbeskrivning
         [+] Spelsync
         [-] Joystick/Joypad std
        -------------------------

        V 0.5.0  2000-06-25 13:56
        -------------------------
         [^] DEBUG mode
         [*] Musik
         [*] Bttre kommenterad kod
         [-] Spelsync
         [^] Denna version r endast till fr test av kompatiblitet
        -------------------------

*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <bios.h>
#include <midasdll.h>
#include <allegro.h>
#include "dat.h"


#define TEXTURECOUNT 25  // Antal texturer som ska laddas
#define ENEMYCOUNT 4    // Antal fiendetexturer som ska laddas
#define ITEMCOUNT 4     // Antal saktexturer som ska laddas
#define SNDSAMPLECOUNT 5  // Antal ljudeffekter som ska laddas
#define MENUTEXT "T <->  E <->  I <-> PS Delete Exit"  // Den text som visas i levelcreatorn
#define NOMUSIC FALSE  // Om TRUE s r musiken avstngd
#define GAMESPEED 120000  // Ju strre desto snabbare
#define NOSYNC FALSE  // Om TRUE s r synkroniseringen avstngd
#define DEBUG FALSE  // Visar informationstexter
#define PLAYERBLINK 200 // Antal blinkningar nr man tar skada
#define WALKDELAY 3  // Antal loopar innan fienderna fr lov att flytta p sig...
#define SAMPFREQ 22050 // Standard samplingsfrekvens p ljudeffekter
#define SFXVOL 64    // Standard volym p ljudeffekter
#define MUSICVOL 50    // Standard volym p ljudeffekter
#define ITEMPYMAX 10  // Antal pixlar som pong siffran ska stiga p saker
#define ENEMYPYMAX 10  // Antal pixlar som pong siffran ska stiga p fiender
#define ITEMPYDEL 4   // Antal loopar innan texten stiger en pixel
#define ENEMYPYDEL 4   // Antal loopar innan texten stiger en pixel
#define FOTCHANGECOUNT 5  // Antal frames innan han byter fotsteg
#define STUDSCOUNT 80 // Antal frames under vilket man studsar
#define ITEMANIMCHANGE 40 // Antal frames mellan varje animeringsndring p saker
#define ENEMYANIMCHANGE 10 // Antal frames mellan varje animeringsndring p fiender
#define BLOCKANIMCHANGE 10 // Antal frames mellan varje animeringsndring p block



struct TItemPos  // Sparar undan alla variabler som ett objekt kan tnkas behva
{
  int ident;
  int Visible;
  long x;
  long y;
  long Stop1x;
  long Stop1y;
  long Stop2x;
  long Stop2y;
  long StartX;
  long StartY;
  int Py;
  int PyDel;
  int xdec, xinc;
  int ydec, yinc;
  int Colll, Collr;
  int Dir;
  int fall;
  int WalkDelay;
  struct TBlockBan *BlockBan;
  int BlockBanCount;
  char BlockBanChange;
  int BlockBanPos;
  char BlockBanDelay;
  int BlockBanPosX, BlockBanPosY;
  struct TLevelMask *BlockBanMask;
  int Anim, AnimChange;
} TItemPos;

struct TLevelMask     // Kollisionsmask fr banan
{
  int mask:4; // OBS! endast fyra bitar
};

struct TBlockBan
{
  int x, y;
};

typedef struct TLevelData  // Alla variabler som har med den aktulla banan att gra
{
  unsigned short Length;
  unsigned short Height;
  BITMAP *LevelBitmap;
  BITMAP *Background;
  BITMAP *LevelBackgr;
  PALETTE Pal;
  char Name[20];
  unsigned short ident;
  unsigned short BlockCount;
  unsigned short EnemyCount;
  unsigned short ItemCount;
  unsigned int xoff, xoffstart;
  unsigned int yoff, yoffstart;
  int xinc, xdec;
  int yinc, ydec;
  struct TItemPos *BlockPos;     // Allokeras dynamiskt vid inladdning av banan
  struct TItemPos *EnemyPos;     // -//-
  struct TItemPos *ItemPos;      // -//-
  struct TLevelMask *LevelMask;  // -//-
  int Scroll;
} TLevelData;


typedef struct TTexture     // Information om texturer
{
  BITMAP *Bitmap;
  unsigned int Width;
  unsigned int Height;
  PALETTE Pal;
} TTexture;

typedef struct TPlayerInfo  // Alla variabler som behvs fr att styra spelaren
{
  BITMAP *Bitmap1, *Bitmap2, *Bitmap3, *Bitmap4, *Bitmap5, *Bitmap6, *Bitmap7, *Bitmap8, *Bitmap9, *Bitmap10, *Bitmap11, *Bitmap12, *Bitmap13, *Bitmap14, *Bitmap15, *Bitmap16;
  unsigned int x;
  unsigned int y;
  unsigned int StartX;
  unsigned int StartY;
  int xdec, xinc, yinc, ydec;
  int xdecj, xincj, yincj, ydecj;
  int jump, fall, Ladder, LadderTop;
  unsigned int jumpx, jumpy;
  int Colll, Collr, Collu, Colld;
  PALETTE Pal;
  int Dir, OldDir;
  unsigned long Score;
  int Blink, BlinkCount;
  int Health;
  int fot;
  int BlockBan;
  int StudsNum, Studs;
  int JetPack, JetPackOn;
} TPlayerInfo;

typedef struct TEnemyInfo  // Alla variabler som behvs fr fiendetexturer
{
  BITMAP *Bitmap1, *Bitmap2, *Bitmap3, *Bitmap4, *Bitmap5, *Bitmap6, *Bitmap7, *Bitmap8;
  PALETTE Pal;
} TEnemyInfo;

typedef struct TItemInfo  // Alla variabler som behvs fr Saktexturer
{
  BITMAP *Bitmap1, *Bitmap2, *Bitmap3, *Bitmap4;
  PALETTE Pal;
} TItemInfo;

 typedef struct TSndSample  // Alla variabler som behvs fr Saktexturer
{
  MIDASsample Sample;
  MIDASsamplePlayHandle Handle;
} TSndSample;


MIDASmodule testmod;
MIDASmodulePlayHandle playHandle;
int gKey=0, gFastKey=0;            // Innehller vilken knapp man tryckte p
int  gfxmode=GFX_TEXT, joyen=FALSE, mouseen=TRUE;
int SfxVol=SFXVOL, MusicVol=MUSICVOL;
TLevelData LevelData;
TTexture Texture[TEXTURECOUNT];
TPlayerInfo Player;
TEnemyInfo Enemy[ENEMYCOUNT];
TItemInfo Item[ITEMCOUNT];
TTexture Studs[4];
TTexture Fan[2];
int BlockTextureCount=TEXTURECOUNT, EnemyTextureCount=ENEMYCOUNT, ItemTextureCount=ITEMCOUNT;
TSndSample SndSample[SNDSAMPLECOUNT];
BITMAP *Vir1, *StatusBar, *StatusBarBitmap;
DATAFILE *Dat;
FONT *Pfont;
DATAFILE *Datafile;
int LevelCount=0;
int GameSpeed=GAMESPEED;
int FotChange=0;
struct TItemPos *TempPos;
int Refr=FALSE;
int Design=FALSE;
int StudsSprite=1, StudsSpriteChange=1;
int JumpPathNum=0;   // JumpPath bestmmer hur spelaren ska hoppa
//int LastBlockIdent=1000, LastEnemyIdent=1000, LastItemIdent=1000;
int LastIdent=1000;
int Sfx=TRUE, Music=TRUE, Debug=DEBUG, Nomusic=NOMUSIC, NoSync=NOSYNC;
#define JUMPPATHCOUNT 60
int JumpPath[JUMPPATHCOUNT] =
{1,1,1,1,1,1,1,1,1,1,1,1,1,1,0,1,1,1,0,1,1,1,1,0,1,1,1,1,1,1,1,1,0,1,1,0,1,0,1,1,0,1,1,0,1,0,0,1,0,0,1,0,1,0,0,1,0,0,0,1};

int equit(char *exitstr)  // Stnger ner programmet och visar ett felmeddelande
{
  if (gfxmode!=GFX_TEXT)
    set_gfx_mode(GFX_TEXT, 640, 480, 0, 0);
  //remove_textures();
  //unload_level();
  printf("Error!\n  - %s\nSorry...",exitstr);
  if (Design)
    remove_mouse();
  if (joyen)
    remove_joystick();
  remove_keyboard();
  allegro_exit();
  exit(1);
  return 0;
}

int quit(char *exitstr)  // Stnger programmet och visar ett meddelande
{
  if (gfxmode!=GFX_TEXT)
    set_gfx_mode(GFX_TEXT, 640, 480, 0, 0);
  printf("%s",exitstr);
  if (joyen)
    remove_joystick();
  remove_keyboard();
  allegro_exit();
  exit(0);
  return 0;
}

void MIDASerror(void)
{
  int error;
  if (gfxmode!=GFX_TEXT)
    set_gfx_mode(GFX_TEXT, 640, 480, 0, 0);
  error = MIDASgetLastError();
  printf("\nMIDAS error: %s\n", MIDASgetErrorMessage(error));
  if ( !MIDASclose() )
  {
    printf("\nBIG PANIC!! MIDASclose Failed: %s\nARGH!!!  I hate errors!", MIDASgetErrorMessage(
      MIDASgetLastError()));
  }
  if (joyen)
    remove_joystick();
  remove_keyboard();
  allegro_exit();
  exit(1);
}

void KeyRelease(int Key)    // Kallas vid keyboard interupt
{
  gFastKey=Key;
  if (Key & 0x80)
  {
    switch(Key & 127)   // Nr man slpper knappen
    {
      case  31 : Player.xdec=FALSE;
                 break;
      case  33 : Player.xinc=FALSE;
                 break;
      case  77 : if (Design)
                   LevelData.xinc=FALSE;
                 else
                 {
                   Player.xinc=FALSE;
                 }
                 break;
      case  75 : if (Design)
                   LevelData.xdec=FALSE;
                 else
                 {
                   Player.xdec=FALSE;
                 }
                 break;
      case  18 : if (Player.Ladder)
                   Player.ydec=FALSE;
                 if (Player.JetPack)
                 {
                   Player.JetPackOn=FALSE;
                 }
                 break;
      case  32 : if (Player.Ladder)
                   Player.yinc=FALSE;
                 break;
      case  72 : if (Player.Ladder)
                   Player.ydec=FALSE;
                 if (Design)
                   LevelData.ydec=FALSE;
                 if (Player.JetPack)
                 {
                   Player.JetPackOn=FALSE;
                 }
                 break;
      case  80 : if (Player.Ladder)
                   Player.yinc=FALSE;
                 if (Design)
                   LevelData.yinc=FALSE;
                 break;
    }
  }
  else
  {
    switch(Key & 127)    // Nr man trycker...
    {
      case  32 : if (Player.Ladder)
                 {
                   Player.yinc=TRUE;
                 }
                 break;
      case  18 : if ((!Player.fall) && (!Player.Studs) && (!Player.jump) && ((!Player.Ladder) || (Player.LadderTop)) && (!Player.JetPack))
                 {
                   if ((!Nomusic) && (!Design) && (Sfx))
                     if ((SndSample[2].Handle=MIDASplaySample(SndSample[2].Sample, MIDAS_CHANNEL_AUTO, 0, SAMPFREQ, SfxVol, MIDAS_PAN_MIDDLE))==0)
                       MIDASerror();
                   Player.jump=TRUE;
                   Player.jumpx=Player.x;
                   Player.jumpy=Player.y;
                   JumpPathNum=0;
                 }
                 if (Player.Ladder)
                 {
                   Player.ydec=TRUE;
                 }
                 if (Player.JetPack)
                 {
                   Player.JetPackOn=TRUE;
                 }
                 break;
      case  72 : if ((!Player.fall) && (!Player.Studs) && (!Player.jump) && ((!Player.Ladder) || (Player.LadderTop)) && (!Player.JetPack))
                 {
                   if ((!Nomusic) && (!Design) && (Sfx))
                     if ((SndSample[2].Handle=MIDASplaySample(SndSample[2].Sample, MIDAS_CHANNEL_AUTO, 0, SAMPFREQ, SfxVol, MIDAS_PAN_MIDDLE))==0)
                       MIDASerror();
                   Player.jump=TRUE;
                   Player.jumpx=Player.x;
                   Player.jumpy=Player.y;
                   JumpPathNum=0;
                 }
                 if (Player.Ladder)
                 {
                   Player.ydec=TRUE;
                 }
                 if (Player.JetPack)
                 {
                   Player.JetPackOn=TRUE;
                 }
                 if (Design)
                   LevelData.ydec=TRUE;
                 break;
      case  80 : if (Player.Ladder)
                 {
                   Player.yinc=TRUE;
                 }
                 if (Design)
                   LevelData.yinc=TRUE;
                 break;
      case  31 : Player.xdec=TRUE;
                 Player.Dir=1;
                 break;
      case  33 : Player.xinc=TRUE;
                 Player.Dir=Player.OldDir;
                 Player.Dir=0;
                 break;
      case  77:  if (Design)
                   LevelData.xinc=TRUE;
                 else
                 {
                   Player.xinc=TRUE;
                   Player.Dir=0;
                 }
                 break;
      case  75:  if (Design)
                   LevelData.xdec=TRUE;
                 else
                 {
                   Player.xdec=TRUE;
                   Player.Dir=1;
                 }
                 break;
    }
  }
}

unsigned short hi(unsigned int inpt)  // Returnerar den hga byten
{
  return ((inpt & 0xFF00) >> 8);
}

unsigned short lo(unsigned int inpt)  // Returnerar den lga byten
{
  return (inpt & 0x00FF);
}

int update_level()
{
  int a=181, i, j;
  //BITMAP *LevelMask;
  blit(LevelData.LevelBackgr, Vir1, LevelData.xoff, LevelData.yoff, 0, 10, 320, 190);
  for (i=0;i<LevelData.BlockCount;i++)
  {
    if ((LevelData.BlockPos[i].ident!=15) && (LevelData.BlockPos[i].ident!=16) && (LevelData.BlockPos[i].ident!=22) && (LevelData.BlockPos[i].ident!=24))
    {
      draw_sprite(Vir1, Texture[LevelData.BlockPos[i].ident].Bitmap, LevelData.BlockPos[i].x-LevelData.xoff, LevelData.BlockPos[i].y-LevelData.yoff+10);
    }
  }
  //masked_blit(LevelData.LevelBitmap, Vir1, LevelData.xoff, LevelData.yoff, 0, 10, 320, 190);
  blit(StatusBarBitmap, StatusBar, 0, 0, 0, 0, 320, 10);
  text_mode(-1);
  //blit(LevelMask, Vir1, LevelData.xoff, LevelData.yoff, 0, 10, 320, 190);
  textprintf(StatusBar, font, 3,1, 100, "%s  Score: %i  Health: %i", LevelData.Name, Player.Score, Player.Health);
  //textprintf(StatusBar, font, 3,1,100, "BBX: %i BBY: %i BBP: %i BBCH: %i", LevelData.BlockPos[a].BlockBanPosX, LevelData.BlockPos[a].BlockBanPosY, LevelData.BlockPos[a].BlockBanPos, LevelData.BlockPos[a].BlockBanChange);
  //textprintf(StatusBar, font, 3,1,100, "Xo: %i Yo: %i BB: %i", LevelData.xoff, LevelData.yoff, Player.BlockBan);
  //textprintf(StatusBar, font, 3,1,100, "Jmp: %i Studs: %i JP: %i, JPO: %i", Player.jump, Player.Studs, Player.JetPack, Player.JetPackOn);
  //textprintf(StatusBar, Pfont, 3,1,100, "ABCDEFGHIJKLMNOPQRSTUVWXYZ");
  //hline(Vir1, 0, 9, 320, 100);
  //destroy_bitmap(LevelMask);
 return 0;
}



int player_die()
{
  int y=0, a=0;
  if ((!Design) && (!Nomusic) && (Music))
  {
    MIDASstopModule(playHandle);
  }
  y=Player.y;
  while ((y-30)<Player.y)
  {
    Player.y--;
    update_level();
    if (Player.Dir==0)
      draw_sprite(Vir1, Player.Bitmap1, Player.x, Player.y);
    if (Player.Dir==1)
      draw_sprite(Vir1, Player.Bitmap2, Player.x, Player.y);
    if (!NoSync)
      while (!Refr) {}
    blit(Vir1, screen, 0,0,0,0, 320,200);
  }
  while (Player.y<200)
  {
    Player.y++;
    update_level();
    if (Player.Dir==0)
      draw_sprite(Vir1, Player.Bitmap1, Player.x, Player.y);
    if (Player.Dir==1)
      draw_sprite(Vir1, Player.Bitmap2, Player.x, Player.y);
    if (!NoSync)
      while (!Refr) {}
    blit(Vir1, screen, 0,0,0,0, 320,200);
  }
  for (a=0;a<LevelData.EnemyCount;a++)
  {
    LevelData.EnemyPos[a].x=LevelData.EnemyPos[a].StartX;
    LevelData.EnemyPos[a].y=LevelData.EnemyPos[a].StartY;
    LevelData.EnemyPos[a].Visible=TRUE;
  }
  for (a=0;a<LevelData.ItemCount;a++)
  {
    LevelData.ItemPos[a].Visible=TRUE;
  }
  Player.Score=0;
  Player.Health=3;
  Player.Blink=FALSE;
  Player.BlinkCount=0;
  clear(Vir1);
  clear(screen);
  //readkey();
  LevelData.xoff=LevelData.xoffstart;
  LevelData.yoff=LevelData.yoffstart;
  Player.x=Player.StartX;
  Player.y=Player.StartY;
  if ((!Design) && (!Nomusic) && (Music))
  {
    if ((playHandle=MIDASplayModule(testmod, TRUE))==0)
      MIDASerror();
    if (MIDASsetMusicVolume(playHandle, MusicVol)==0)
      MIDASerror();
  }
  return 0;
}

int player_hurt()
{
  if ((!Nomusic) && (Sfx))
    SndSample[3].Handle=MIDASplaySample(SndSample[3].Sample, MIDAS_CHANNEL_AUTO, 0, 22050, SfxVol, MIDAS_PAN_MIDDLE);
  Player.Health--;
  if (Player.Health<1)
  {
    player_die();
  }
  Player.Blink=TRUE;
  Player.BlinkCount=PLAYERBLINK;
  return 0;
}


int update_blocks()
{
  int a, x, y, temp;
  for (a=0;a<LevelData.BlockCount;a++)
  {
    if ((LevelData.BlockPos[a].ident==15) || (LevelData.BlockPos[a].ident==16))
    {
      LevelData.BlockPos[a].BlockBanPosX=LevelData.BlockPos[a].x+LevelData.BlockPos[a].BlockBan[LevelData.BlockPos[a].BlockBanPos].x;
      LevelData.BlockPos[a].BlockBanPosY=LevelData.BlockPos[a].y+LevelData.BlockPos[a].BlockBan[LevelData.BlockPos[a].BlockBanPos].y+10;
      LevelData.BlockPos[a].BlockBanDelay++;
      if (LevelData.BlockPos[a].BlockBanDelay>=4)
      {
        //readkey();
        for (x=0;x<Texture[LevelData.BlockPos[a].ident].Bitmap->w;x++)
        {
          for (y=0;y<Texture[LevelData.BlockPos[a].ident].Bitmap->h;y++)
          {
            temp=((y+LevelData.BlockPos[a].BlockBanPosY-10)*LevelData.Length)+x+LevelData.BlockPos[a].BlockBanPosX;
            if (temp<(LevelData.Length*LevelData.Height) && (temp>0))
              LevelData.LevelMask[temp].mask=0;//LevelData.BlockPos[a].BlockBanMaskBackup[(y*LevelData.Length)+x].mask;
          }
        }
        LevelData.BlockPos[a].BlockBanDelay=0;
        LevelData.BlockPos[a].BlockBanPos+=LevelData.BlockPos[a].BlockBanChange;
        if (LevelData.BlockPos[a].BlockBanPos>=LevelData.BlockPos[a].BlockBanCount-1)
          LevelData.BlockPos[a].BlockBanChange=-1;
        if (LevelData.BlockPos[a].BlockBanPos<1)
          LevelData.BlockPos[a].BlockBanChange=1;
        LevelData.BlockPos[a].BlockBanPosX=LevelData.BlockPos[a].x+LevelData.BlockPos[a].BlockBan[LevelData.BlockPos[a].BlockBanPos].x;
        LevelData.BlockPos[a].BlockBanPosY=LevelData.BlockPos[a].y+LevelData.BlockPos[a].BlockBan[LevelData.BlockPos[a].BlockBanPos].y+10;
        for (x=0;x<Texture[LevelData.BlockPos[a].ident].Bitmap->w;x++)
        {
          for (y=0;y<Texture[LevelData.BlockPos[a].ident].Bitmap->h;y++)
          {
            temp=((y+LevelData.BlockPos[a].BlockBanPosY-10)*LevelData.Length)+x+LevelData.BlockPos[a].BlockBanPosX;
            if (temp<(LevelData.Length*LevelData.Height) && (temp>0))
              LevelData.LevelMask[temp].mask=LevelData.BlockPos[a].BlockBanMask[(y*Texture[LevelData.BlockPos[a].ident].Bitmap->w)+x].mask;
          }
        }
      }
      draw_sprite(Vir1, Texture[LevelData.BlockPos[a].ident].Bitmap, LevelData.BlockPos[a].BlockBanPosX-LevelData.xoff, LevelData.BlockPos[a].BlockBanPosY-LevelData.yoff);
    }
    else if (LevelData.BlockPos[a].ident==22)
    {
      if ((Player.Studs) && (StudsSprite>0))
      {
        draw_sprite(Vir1, Studs[StudsSprite].Bitmap, LevelData.BlockPos[a].x-LevelData.xoff, LevelData.BlockPos[a].y-LevelData.yoff+10);
        if (StudsSprite>2)
          StudsSpriteChange=-1;
        StudsSprite+=StudsSpriteChange;
      }
      else
      {
        draw_sprite(Vir1, Studs[0].Bitmap, LevelData.BlockPos[a].x-LevelData.xoff, LevelData.BlockPos[a].y-LevelData.yoff+10);
      }
    }
    else if (LevelData.BlockPos[a].ident==24)
    {
      LevelData.BlockPos[a].AnimChange++;
      if (LevelData.BlockPos[a].AnimChange>BLOCKANIMCHANGE)
      {
        LevelData.BlockPos[a].AnimChange=0;
        LevelData.BlockPos[a].Anim++;
        if (LevelData.BlockPos[a].Anim>1)
          LevelData.BlockPos[a].Anim=0;
      }
      if (LevelData.BlockPos[a].Anim==0)
        draw_sprite(Vir1, Fan[0].Bitmap, LevelData.BlockPos[a].x-LevelData.xoff, LevelData.BlockPos[a].y-LevelData.yoff+10);
      if (LevelData.BlockPos[a].Anim==1)
        draw_sprite(Vir1, Fan[1].Bitmap, LevelData.BlockPos[a].x-LevelData.xoff, LevelData.BlockPos[a].y-LevelData.yoff+10);
    }
  }
  return 0;
}


int update_items()
{
  int a;
  for (a=0;a<LevelData.ItemCount;a++)
  {
    if (LevelData.ItemPos[a].Visible)
    {
      LevelData.ItemPos[a].AnimChange++;
      if (LevelData.ItemPos[a].AnimChange>ITEMANIMCHANGE)
      {
        LevelData.ItemPos[a].AnimChange=0;
        LevelData.ItemPos[a].Anim++;
        if (LevelData.ItemPos[a].Anim>3)
          LevelData.ItemPos[a].Anim=0;
      }
      if (LevelData.ItemPos[a].Anim==0)
        draw_sprite(Vir1, Item[LevelData.ItemPos[a].ident].Bitmap1, LevelData.ItemPos[a].x-LevelData.xoff, LevelData.ItemPos[a].y+10-LevelData.yoff);
      if (LevelData.ItemPos[a].Anim==1)
        draw_sprite(Vir1, Item[LevelData.ItemPos[a].ident].Bitmap2, LevelData.ItemPos[a].x-LevelData.xoff, LevelData.ItemPos[a].y+10-LevelData.yoff);
      if (LevelData.ItemPos[a].Anim==2)
        draw_sprite(Vir1, Item[LevelData.ItemPos[a].ident].Bitmap3, LevelData.ItemPos[a].x-LevelData.xoff, LevelData.ItemPos[a].y+10-LevelData.yoff);
      if (LevelData.ItemPos[a].Anim==3)
        draw_sprite(Vir1, Item[LevelData.ItemPos[a].ident].Bitmap4, LevelData.ItemPos[a].x-LevelData.xoff, LevelData.ItemPos[a].y+10-LevelData.yoff);
    }
    else
    {
      if (LevelData.ItemPos[a].Py<ITEMPYMAX)
      {
        text_mode(-1);
        textprintf(Vir1, Pfont, LevelData.ItemPos[a].x-LevelData.xoff, LevelData.ItemPos[a].y-LevelData.ItemPos[a].Py-LevelData.yoff, 125, "%i", (LevelData.ItemPos[a].ident+1)*25);
        LevelData.ItemPos[a].PyDel++;
        if (LevelData.ItemPos[a].PyDel>=ITEMPYDEL)
        {
          LevelData.ItemPos[a].Py++;
          LevelData.ItemPos[a].PyDel=0;
        }
      }
    }
  }
  return 0;
}

int update_enemies()
{
  int i, a;
  for (i=0;i<LevelData.EnemyCount;i++)
  {
    if (LevelData.EnemyPos[i].Visible)
    {
      LevelData.EnemyPos[i].Colll=LevelData.EnemyPos[i].Collr=FALSE;
      LevelData.EnemyPos[i].fall=TRUE;

      for (a=0;a<Enemy[LevelData.EnemyPos[i].ident].Bitmap1->w;a++)
        if ((LevelData.LevelMask[((LevelData.EnemyPos[i].y+Enemy[LevelData.EnemyPos[i].ident].Bitmap1->h-10)*LevelData.Length)+(LevelData.EnemyPos[i].x/*+LevelData.xoff*/+a)].mask==1) || (LevelData.LevelMask[((LevelData.EnemyPos[i].y+Enemy[LevelData.EnemyPos[i].ident].Bitmap1->h-10)*LevelData.Length)+(LevelData.EnemyPos[i].x/*+LevelData.xoff*/+a)].mask==2))
          LevelData.EnemyPos[i].fall=FALSE;

      for (a=0;a<Enemy[LevelData.EnemyPos[i].ident].Bitmap1->h;a++)
        if ((LevelData.LevelMask[((LevelData.EnemyPos[i].y-10+a)*LevelData.Length)+(LevelData.EnemyPos[i].x/*+LevelData.xoff*/-1)].mask==1))// || (LevelData.LevelMask[((LevelData.EnemyPos[i].y-10+a)*LevelData.Length)+(LevelData.EnemyPos[i].x/*+LevelData.xoff*/-1)].mask==2))
          LevelData.EnemyPos[i].Colll=TRUE;

      for (a=0;a<Enemy[LevelData.EnemyPos[i].ident].Bitmap1->h;a++)
        if ((LevelData.LevelMask[((LevelData.EnemyPos[i].y-10+a)*LevelData.Length)+(LevelData.EnemyPos[i].x+Enemy[LevelData.EnemyPos[i].ident].Bitmap1->w/*+LevelData.xoff*/)].mask==1))// || (LevelData.LevelMask[((LevelData.EnemyPos[i].y-10+a)*LevelData.Length)+(LevelData.EnemyPos[i].x+Enemy[LevelData.EnemyPos[i].ident].Bitmap1->w/*+LevelData.xoff*/)].mask==2))
          LevelData.EnemyPos[i].Collr=TRUE;

      if ((LevelData.EnemyPos[i].x==LevelData.EnemyPos[i].Stop1x) || (LevelData.EnemyPos[i].x==LevelData.EnemyPos[i].Stop2x) || (LevelData.EnemyPos[i].x<=0))
        LevelData.EnemyPos[i].Colll=TRUE;

      if (((LevelData.EnemyPos[i].x+Enemy[LevelData.EnemyPos[i].ident].Bitmap1->w)==LevelData.EnemyPos[i].Stop1x) || ((LevelData.EnemyPos[i].x+Enemy[LevelData.EnemyPos[i].ident].Bitmap1->w)==LevelData.EnemyPos[i].Stop2x) || (LevelData.EnemyPos[i].x>=LevelData.Length))
        LevelData.EnemyPos[i].Collr=TRUE;

      if (LevelData.EnemyPos[i].fall)
        if ((LevelData.EnemyPos[i].y+Enemy[LevelData.EnemyPos[i].ident].Bitmap1->h)<LevelData.Height)
          LevelData.EnemyPos[i].y++;

      if (LevelData.EnemyPos[i].Colll)
      {
        LevelData.EnemyPos[i].xinc=TRUE;
        LevelData.EnemyPos[i].xdec=FALSE;
        LevelData.EnemyPos[i].Colll=FALSE;
      }
      if (LevelData.EnemyPos[i].Collr)
      {
        LevelData.EnemyPos[i].xdec=TRUE;
        LevelData.EnemyPos[i].xinc=FALSE;
        LevelData.EnemyPos[i].Collr=FALSE;
      }

      LevelData.EnemyPos[i].WalkDelay--;

      if ((LevelData.EnemyPos[i].xdec) && (!LevelData.EnemyPos[i].fall) && (LevelData.EnemyPos[i].x>0) && (LevelData.EnemyPos[i].WalkDelay==0))
      {
        LevelData.EnemyPos[i].Dir=0;
        LevelData.EnemyPos[i].x--;
      }
      if ((LevelData.EnemyPos[i].xinc) && (!LevelData.EnemyPos[i].fall) && (LevelData.EnemyPos[i].x<LevelData.Length) && (LevelData.EnemyPos[i].WalkDelay==0))
      {
       LevelData.EnemyPos[i].Dir=1;
       LevelData.EnemyPos[i].x++;
      }
      if (LevelData.EnemyPos[i].WalkDelay<1)
        LevelData.EnemyPos[i].WalkDelay=WALKDELAY;

      LevelData.EnemyPos[i].AnimChange++;
      if (LevelData.EnemyPos[i].AnimChange>ENEMYANIMCHANGE)
      {
        LevelData.EnemyPos[i].AnimChange=0;
        LevelData.EnemyPos[i].Anim++;
        if (LevelData.EnemyPos[i].Anim>3)
          LevelData.EnemyPos[i].Anim=0;
      }
      if (LevelData.EnemyPos[i].Dir==0)
      {
        if (LevelData.EnemyPos[i].Anim==0)
          draw_sprite(Vir1, Enemy[LevelData.EnemyPos[i].ident].Bitmap1, LevelData.EnemyPos[i].x-LevelData.xoff, LevelData.EnemyPos[i].y-LevelData.yoff);
        if (LevelData.EnemyPos[i].Anim==1)
          draw_sprite(Vir1, Enemy[LevelData.EnemyPos[i].ident].Bitmap2, LevelData.EnemyPos[i].x-LevelData.xoff, LevelData.EnemyPos[i].y-LevelData.yoff);
        if (LevelData.EnemyPos[i].Anim==2)
          draw_sprite(Vir1, Enemy[LevelData.EnemyPos[i].ident].Bitmap3, LevelData.EnemyPos[i].x-LevelData.xoff, LevelData.EnemyPos[i].y-LevelData.yoff);
        if (LevelData.EnemyPos[i].Anim==3)
          draw_sprite(Vir1, Enemy[LevelData.EnemyPos[i].ident].Bitmap4, LevelData.EnemyPos[i].x-LevelData.xoff, LevelData.EnemyPos[i].y-LevelData.yoff);
      }
      if (LevelData.EnemyPos[i].Dir==1)
      {
        if (LevelData.EnemyPos[i].Anim==0)
          draw_sprite(Vir1, Enemy[LevelData.EnemyPos[i].ident].Bitmap5, LevelData.EnemyPos[i].x-LevelData.xoff, LevelData.EnemyPos[i].y-LevelData.yoff);
        if (LevelData.EnemyPos[i].Anim==1)
          draw_sprite(Vir1, Enemy[LevelData.EnemyPos[i].ident].Bitmap6, LevelData.EnemyPos[i].x-LevelData.xoff, LevelData.EnemyPos[i].y-LevelData.yoff);
        if (LevelData.EnemyPos[i].Anim==2)
          draw_sprite(Vir1, Enemy[LevelData.EnemyPos[i].ident].Bitmap7, LevelData.EnemyPos[i].x-LevelData.xoff, LevelData.EnemyPos[i].y-LevelData.yoff);
        if (LevelData.EnemyPos[i].Anim==3)
          draw_sprite(Vir1, Enemy[LevelData.EnemyPos[i].ident].Bitmap8, LevelData.EnemyPos[i].x-LevelData.xoff, LevelData.EnemyPos[i].y-LevelData.yoff);
      }
      //textprintf(Vir1, font, 0,0,100, "Cll %i Clr %i xi %i xd %i F %i X %i Y %i", LevelData.EnemyPos[i].Colll, LevelData.EnemyPos[i].Collr, LevelData.EnemyPos[i].xinc, LevelData.EnemyPos[i].xdec, LevelData.EnemyPos[i].fall, LevelData.EnemyPos[i].x, LevelData.EnemyPos[i].y);
    }
    else
    {
      if (LevelData.EnemyPos[i].Py<ENEMYPYMAX)
      {
        text_mode(-1);
        textprintf(Vir1, Pfont, LevelData.EnemyPos[i].x-LevelData.xoff, LevelData.EnemyPos[i].y-LevelData.EnemyPos[i].Py-LevelData.yoff, 125, "%i", (LevelData.EnemyPos[i].ident+1)*100);
        LevelData.EnemyPos[i].PyDel++;
        if (LevelData.EnemyPos[i].PyDel>=ENEMYPYDEL)
        {
          LevelData.EnemyPos[i].Py++;
          LevelData.EnemyPos[i].PyDel=0;
        }
      }
    }
  }
  return 0;
}


int update_player()
{
  int a, UpOk=FALSE, i, j, LadderChk, BanX=0, BanY=0, b;
  Player.fall=TRUE;
  LevelData.Scroll=FALSE;
 // PreventExtraJump=FALSE;
  Player.BlockBan=Player.Colll=Player.Collr=Player.LadderTop=Player.Ladder=Player.Colld=Player.Collu=FALSE;

  /*  if (Player.y<Player.jumpy-30)
  {
    Player.jump=FALSE;
  }*/
  if ((JumpPathNum>JUMPPATHCOUNT-1))
  {
    Player.jump=FALSE;
    Player.Studs=FALSE;
  }
/*  if ((!Player.jump) &&
      (_getpixel(Vir1, Player.x+0, Player.y+Player.Bitmap1->h)==0) &&
      (_getpixel(Vir1, Player.x+1, Player.y+Player.Bitmap1->h)==0) &&
      (_getpixel(Vir1, Player.x+2, Player.y+Player.Bitmap1->h)==0) &&
      (_getpixel(Vir1, Player.x+3, Player.y+Player.Bitmap1->h)==0) &&
      (_getpixel(Vir1, Player.x+4, Player.y+Player.Bitmap1->h)==0) &&
      (_getpixel(Vir1, Player.x+5, Player.y+Player.Bitmap1->h)==0) &&
      (_getpixel(Vir1, Player.x+6, Player.y+Player.Bitmap1->h)==0) &&
      (_getpixel(Vir1, Player.x+7, Player.y+Player.Bitmap1->h)==0) &&
      (_getpixel(Vir1, Player.x+8, Player.y+Player.Bitmap1->h)==0) &&
      (_getpixel(Vir1, Player.x+9, Player.y+Player.Bitmap1->h)==0))
  {
    Player.fall=TRUE;
    PreventExtraJump=FALSE;
    //Player.ydec=FALSE;
    //Player.yinc=FALSE;
  }
  else
    PreventExtraJump=FALSE;*/
/*  for (a=0;a<Player.Bitmap1->w;a++)
    if (_getpixel(screen, Player.x+a, Player.y-1)!=0)
      Player.jump=FALSE;
  Player.Colll=FALSE;
  for (a=0;a<Player.Bitmap1->h;a++)
    if (_getpixel(screen, Player.x-1, Player.y+a)!=0)
    {
      //Player.xdec=FALSE;
      //Player.xdecj=FALSE;
      Player.Colll=TRUE;
    }
  Player.Collr=FALSE;
  for (a=0;a<Player.Bitmap1->h;a++)
    if (_getpixel(screen, Player.x+Player.Bitmap1->w, Player.y+a)!=0)
    {
      //Player.xinc=FALSE;
      //Player.xincj=FALSE;
      Player.Collr=TRUE;
    }                   */
/*
  px1=Player.x+LevelData.xoff;
  px2=Player.x+Player.Bitmap1->w+LevelData.xoff;
  py1=Player.y+Player.Bitmap1->h;
  py2=Player.y;

  for (a=0;a<LevelData.ItemCount;a++)
  {
    if ((px2>LevelData.ItemPos[a].x) && (px1<LevelData.ItemPos[a].x+Texture[LevelData.ItemPos[a].ident].Bitmap->w) && (py1==LevelData.ItemPos[a].y) || (Player.jump))
    {
      Player.fall=FALSE;
      PreventExtraJump=FALSE;
    }
    if ((((LevelData.ItemPos[a].y+Texture[LevelData.ItemPos[a].ident].Bitmap->h)>Player.y) && (LevelData.ItemPos[a].y<Player.y+Player.Bitmap1->h)) && ((LevelData.ItemPos[a].x+Texture[LevelData.ItemPos[a].ident].Bitmap->w)==Player.x+LevelData.xoff))
    {
      Player.Colll=TRUE;
    }
    if (((LevelData.ItemPos[a].y+Texture[LevelData.ItemPos[a].ident].Bitmap->h)>Player.y) && (LevelData.ItemPos[a].y<(Player.y+Player.Bitmap1->h)) && (LevelData.ItemPos[a].x==(Player.x+Player.Bitmap1->w+LevelData.xoff)))
    {
      Player.Collr=TRUE;
    }
    if (((LevelData.ItemPos[a].x+Texture[LevelData.ItemPos[a].ident].Bitmap->w)>(Player.x+LevelData.xoff)) && (LevelData.ItemPos[a].x<(Player.x+Player.Bitmap1->w+LevelData.xoff)) && ((LevelData.ItemPos[a].y+Texture[LevelData.ItemPos[a].ident].Bitmap->h)==Player.y))
    {
      Player.jump=FALSE;
      Player.fall=TRUE;
    }
  }
   */
  for (a=0;a<Player.Bitmap1->w;a++)
    if ((LevelData.LevelMask[((Player.y+Player.Bitmap1->h-10+LevelData.yoff)*LevelData.Length)+(Player.x+LevelData.xoff+a)].mask==1))
    {
      Player.Colld=TRUE;
      Player.JetPack=FALSE;
    }
    else if ((LevelData.LevelMask[((Player.y+Player.Bitmap1->h-10+LevelData.yoff)*LevelData.Length)+(Player.x+LevelData.xoff+a)].mask==2))
    {
      Player.Ladder=TRUE;
      Player.JetPack=FALSE;
    }
    else if ((LevelData.LevelMask[((Player.y+Player.Bitmap1->h-10+LevelData.yoff)*LevelData.Length)+(Player.x+LevelData.xoff+a)].mask==3))
    {
      Player.Colld=Player.BlockBan=TRUE;
      Player.JetPack=FALSE;
    }
    else if ((LevelData.LevelMask[((Player.y+Player.Bitmap1->h-10+LevelData.yoff)*LevelData.Length)+(Player.x+LevelData.xoff+a)].mask==4))
      if ((!Player.jump) && (!Player.Studs))
      {
        Player.Colld=Player.Studs=TRUE;
        Player.JetPack=FALSE;
        StudsSprite=StudsSpriteChange=1;
        Player.StudsNum=0;
        if ((!Nomusic) && (Sfx))
          if ((SndSample[4].Handle=MIDASplaySample(SndSample[4].Sample, MIDAS_CHANNEL_AUTO, 0, 11025, SfxVol, MIDAS_PAN_MIDDLE))==0)
            MIDASerror();
      }

  for (a=0;a<Player.Bitmap1->h;a++)
    if ((LevelData.LevelMask[((Player.y-10+a+LevelData.yoff)*LevelData.Length)+(Player.x+LevelData.xoff-1)].mask==1) || (LevelData.LevelMask[((Player.y-10+a+LevelData.yoff)*LevelData.Length)+(Player.x+LevelData.xoff-1)].mask==3))
      Player.Colll=TRUE;
//    else if ((LevelData.LevelMask[((Player.y-10+a+LevelData.yoff)*LevelData.Length)+(Player.x+LevelData.xoff-1)].mask==2))
      //if (!Player.jump)
//        Player.Ladder=TRUE;

  for (a=0;a<Player.Bitmap1->h;a++)
    if ((LevelData.LevelMask[((Player.y-10+a+LevelData.yoff)*LevelData.Length)+(Player.x+Player.Bitmap1->w+LevelData.xoff)].mask==1) || (LevelData.LevelMask[((Player.y-10+a+LevelData.yoff)*LevelData.Length)+(Player.x+Player.Bitmap1->w+LevelData.xoff)].mask==3))
      Player.Collr=TRUE;
//    else if ((LevelData.LevelMask[((Player.y-10+a+LevelData.yoff)*LevelData.Length)+(Player.x+Player.Bitmap1->w+LevelData.xoff)].mask==2))
     // if (!Player.jump)
//        Player.Ladder=TRUE;

/*  if ((Player.Studs) && (!Player.jump))
  {
    for (b=0;b<Player.Bitmap1->h;b++)
      for (a=0;a<Player.Bitmap1->w;a++)
        if ((LevelData.LevelMask[((Player.y-10+LevelData.yoff-1+b)*LevelData.Length)+(Player.x+LevelData.xoff+a)].mask==1) || (LevelData.LevelMask[((Player.y-10+LevelData.yoff-1+b)*LevelData.Length)+(Player.x+LevelData.xoff+a)].mask==3))
        {
          Player.Collu=TRUE;
          Player.Studs=FALSE;
        }
  }
  else
  {*/
    for (a=0;a<Player.Bitmap1->w;a++)
      if ((LevelData.LevelMask[((Player.y-10+LevelData.yoff-1)*LevelData.Length)+(Player.x+LevelData.xoff+a)].mask==1) || (LevelData.LevelMask[((Player.y-10+LevelData.yoff-1)*LevelData.Length)+(Player.x+LevelData.xoff+a)].mask==3))
      {
        Player.Collu=TRUE;
        Player.Studs=FALSE;
      }
 // }

//    else if ((LevelData.LevelMask[((Player.y-10+LevelData.yoff)*LevelData.Length)+(Player.x+LevelData.xoff+a)].mask==2))
      //if (!Player.jump)
//        Player.Ladder=TRUE;
  LadderChk=0;

/*  if ((Player.xdec) && (LevelData.LevelMask[((Player.y-11+Player.Bitmap1->h+LevelData.yoff)*LevelData.Length)+(Player.x+LevelData.xoff-1)].mask!=0) && (LevelData.LevelMask[((Player.y-11+Player.Bitmap1->h-1)*LevelData.Length)+(Player.x+LevelData.xoff-1)].mask==0))
  {
    Player.Colll=FALSE;
    Player.y--;
  }
  if ((Player.xinc) && (LevelData.LevelMask[((Player.y-11+Player.Bitmap1->h+LevelData.yoff)*LevelData.Length)+(Player.x+Player.Bitmap1->w+LevelData.xoff)].mask!=0) && (LevelData.LevelMask[((Player.y-11+Player.Bitmap1->h-1)*LevelData.Length)+(Player.x+Player.Bitmap1->w+LevelData.xoff)].mask!=0))
  {
    Player.Collr=FALSE;
    Player.y--;
  }*/
/*  UpOk=FALSE;
  putpixel(Vir1, Player.x+Player.Bitmap1->w, Player.y+Player.Bitmap1->h, 100);
  if ((LevelData.LevelMask[((Player.y-11+Player.Bitmap1->h+LevelData.yoff)*LevelData.Length)+Player.x+Player.Bitmap1->w+LevelData.xoff].mask!=0))
    UpOk=TRUE;
  for (a=1;a<Player.Bitmap1->h;a++)
    if ((LevelData.LevelMask[((Player.y-11+Player.Bitmap1->h+LevelData.yoff-a)*LevelData.Length)+Player.x+Player.Bitmap1->w+LevelData.xoff].mask!=0))
      UpOk=FALSE;
  if (UpOk)
  {
    Player.Collr=FALSE;
    Player.y--;
  }
  UpOk=FALSE;
  if (UpOk)
  {
    Player.Colll=FALSE;
    Player.y--;
  }*/
/*  for (a=0;a<LevelData.BlockCount;a++)
  {
    if (LevelData.BlockPos[a].ident==14)
    {
      BanX=LevelData.BlockPos[a].BlockBanPosX;
      BanY=LevelData.BlockPos[a].BlockBanPosY;
      if (((BanY+Texture[LevelData.BlockPos[a].ident].Bitmap->h)>Player.y+LevelData.yoff) && (BanY<(Player.y+Player.Bitmap1->h+LevelData.yoff)) && (BanX==(Player.x+Player.Bitmap1->w+LevelData.xoff)))
        Player.Collr=TRUE;
      if ((BanY+Texture[LevelData.BlockPos[a].ident].Bitmap->h>Player.y+LevelData.yoff) && (BanY<(Player.y+Player.Bitmap1->h+LevelData.yoff)) && ((BanX+Texture[LevelData.BlockPos[a].ident].Bitmap->w)==(Player.x+LevelData.xoff)))
        Player.Colll=TRUE;
      if (((BanX+Texture[LevelData.BlockPos[a].ident].Bitmap->w)>(Player.x+LevelData.xoff)) && (BanX<(Player.x+Player.Bitmap1->w+LevelData.xoff)) && (BanY==(Player.y+Player.Bitmap1->h+LevelData.yoff)) && (!Player.jump))
      {
        Player.Colld=TRUE;
        Player.y=BanY-11;
      }
      if (((BanX+Texture[LevelData.BlockPos[a].ident].Bitmap->w)>(Player.x+LevelData.xoff)) && (BanX<(Player.x+Player.Bitmap1->w+LevelData.xoff)) && ((BanY+Texture[LevelData.BlockPos[a].ident].Bitmap->h)==(Player.y+LevelData.yoff)) && (!Player.jump))
        Player.Collu=TRUE;
    }
  }   */

  for (a=0;a<LevelData.EnemyCount;a++)
  {
    if (LevelData.EnemyPos[a].Visible)
    {
      if (((LevelData.EnemyPos[a].y+Enemy[LevelData.EnemyPos[a].ident].Bitmap1->h)>Player.y+LevelData.yoff) && (LevelData.EnemyPos[a].y<(Player.y+Player.Bitmap1->h+LevelData.yoff)) && (LevelData.EnemyPos[a].x==(Player.x+Player.Bitmap1->w+LevelData.xoff)))
        if (!Player.Blink)
        {
          if (!Nomusic)
            SndSample[1].Handle=MIDASplaySample(SndSample[1].Sample, MIDAS_CHANNEL_AUTO, 0, 22050, SfxVol, MIDAS_PAN_MIDDLE);
          player_hurt();
        }
      if (((LevelData.EnemyPos[a].y+Enemy[LevelData.EnemyPos[a].ident].Bitmap1->h)>Player.y+LevelData.yoff) && (LevelData.EnemyPos[a].y<(Player.y+Player.Bitmap1->h+LevelData.yoff)) && ((LevelData.EnemyPos[a].x+Enemy[LevelData.EnemyPos[a].ident].Bitmap1->w)==(Player.x+LevelData.xoff)))
        if (!Player.Blink)
        {
          if (!Nomusic)
            SndSample[1].Handle=MIDASplaySample(SndSample[1].Sample, MIDAS_CHANNEL_AUTO, 0, 22050, SfxVol, MIDAS_PAN_MIDDLE);
          player_hurt();
        }
      if (((LevelData.EnemyPos[a].x+Enemy[LevelData.EnemyPos[a].ident].Bitmap1->w)>(Player.x+LevelData.xoff)) && (LevelData.EnemyPos[a].x<(Player.x+Player.Bitmap1->w+LevelData.xoff)) && (LevelData.EnemyPos[a].y==(Player.y+Player.Bitmap1->h+LevelData.yoff)) && (!Player.jump))
      {
        if ((!Nomusic) && (Sfx))
          SndSample[0].Handle=MIDASplaySample(SndSample[0].Sample, MIDAS_CHANNEL_AUTO, 0, 22050, SfxVol, MIDAS_PAN_MIDDLE);
        LevelData.EnemyPos[a].Visible=FALSE;
        LevelData.EnemyPos[a].Py=0;
        LevelData.EnemyPos[a].PyDel=0;
        Player.Score+=(LevelData.EnemyPos[a].ident+1)*100;
        Player.jump=TRUE;
      }
    }
  }
/*  if (Player.y+LevelData.yoff+Player.Bitmap1->h>199)
  {
    if (!Nomusic)
      SndSample[1].Handle=MIDASplaySample(SndSample[1].Sample, MIDAS_CHANNEL_AUTO, 0, 22050, SfxVol, MIDAS_PAN_MIDDLE);
    player_die();
  }*/
  for (a=0;a<LevelData.ItemCount;a++)
  {
    if ((LevelData.ItemPos[a].x<(Player.x+Player.Bitmap1->w+LevelData.xoff)) && ((LevelData.ItemPos[a].x+Item[LevelData.ItemPos[a].ident].Bitmap1->w)>(Player.x+LevelData.xoff)) && ((LevelData.ItemPos[a].y+Item[LevelData.ItemPos[a].ident].Bitmap1->h+10)==Player.y+LevelData.yoff) && (LevelData.ItemPos[a].Visible))
    {
      LevelData.ItemPos[a].Visible=FALSE;
      LevelData.ItemPos[a].Py=0;
      LevelData.ItemPos[a].PyDel=0;
      if (LevelData.ItemPos[a].ident==3)
      {
        Player.JetPack=TRUE;
        Player.jump=TRUE;
      }
      else
      {
        Player.Score+=(LevelData.ItemPos[a].ident+1)*25;
        if ((!Nomusic) && (Sfx))
          SndSample[1].Handle=MIDASplaySample(SndSample[1].Sample, MIDAS_CHANNEL_AUTO, 0, 22050, SfxVol, MIDAS_PAN_MIDDLE);
      }
    }
    if (((LevelData.ItemPos[a].y+Item[LevelData.ItemPos[a].ident].Bitmap1->h+10)>Player.y+LevelData.yoff) && ((LevelData.ItemPos[a].y+10)<(Player.y+Player.Bitmap1->h+LevelData.yoff)) && (LevelData.ItemPos[a].x==(Player.x+Player.Bitmap1->w+LevelData.xoff)) && (LevelData.ItemPos[a].Visible))
    {
      LevelData.ItemPos[a].Visible=FALSE;
      LevelData.ItemPos[a].Py=0;
      LevelData.ItemPos[a].PyDel=0;
      if (LevelData.ItemPos[a].ident==3)
      {
        Player.JetPack=TRUE;
        Player.jump=TRUE;
      }
      else
      {
        Player.Score+=(LevelData.ItemPos[a].ident+1)*25;
        if ((!Nomusic) && (Sfx))
          SndSample[1].Handle=MIDASplaySample(SndSample[1].Sample, MIDAS_CHANNEL_AUTO, 0, 22050, SfxVol, MIDAS_PAN_MIDDLE);
      }
    }
    if (((LevelData.ItemPos[a].y+Item[LevelData.ItemPos[a].ident].Bitmap1->h+10)>Player.y+LevelData.yoff) && ((LevelData.ItemPos[a].y+10)<(Player.y+Player.Bitmap1->h+LevelData.yoff)) && ((LevelData.ItemPos[a].x+Item[LevelData.ItemPos[a].ident].Bitmap1->w)==(Player.x+LevelData.xoff)) && (LevelData.ItemPos[a].Visible))
    {
      LevelData.ItemPos[a].Visible=FALSE;
      LevelData.ItemPos[a].Py=0;
      LevelData.ItemPos[a].PyDel=0;
      if (LevelData.ItemPos[a].ident==3)
      {
        Player.JetPack=TRUE;
        Player.jump=TRUE;
      }
      else
      {
        Player.Score+=(LevelData.ItemPos[a].ident+1)*25;
        if ((!Nomusic) && (Sfx))
          SndSample[1].Handle=MIDASplaySample(SndSample[1].Sample, MIDAS_CHANNEL_AUTO, 0, 22050, SfxVol, MIDAS_PAN_MIDDLE);
      }
    }
    if ((LevelData.ItemPos[a].x<(Player.x+Player.Bitmap1->w+LevelData.xoff)) && ((LevelData.ItemPos[a].x+Item[LevelData.ItemPos[a].ident].Bitmap1->w)>(Player.x+LevelData.xoff)) && ((LevelData.ItemPos[a].y+10)==(Player.y+Player.Bitmap1->h+LevelData.yoff)) && (LevelData.ItemPos[a].Visible))
    {
      LevelData.ItemPos[a].Visible=FALSE;
      LevelData.ItemPos[a].Py=0;
      LevelData.ItemPos[a].PyDel=0;
      if (LevelData.ItemPos[a].ident==3)
      {
        Player.JetPack=TRUE;
        Player.jump=TRUE;
      }
      else
      {
        Player.Score+=(LevelData.ItemPos[a].ident+1)*25;
        if ((!Nomusic) && (Sfx))
          SndSample[1].Handle=MIDASplaySample(SndSample[1].Sample, MIDAS_CHANNEL_AUTO, 0, 22050, SfxVol, MIDAS_PAN_MIDDLE);
      }
    }
  }

  LadderChk=0;
  for (j=0;j<Player.Bitmap1->w;j++)
  {
    if ((LevelData.LevelMask[((Player.y-10+LevelData.yoff+Player.Bitmap1->h-1)*LevelData.Length)+(Player.x+LevelData.xoff+j)].mask==3))
      LadderChk++;
  }
  if (LadderChk>0)
    Player.y--;

  if ((Player.xdec) || (Player.xdecj))
  {
    LadderChk=0;
    for (j=0;j<Player.Bitmap1->h-2;j++)
    {
      if ((LevelData.LevelMask[((Player.y-10+LevelData.yoff+j)*LevelData.Length)+(Player.x+LevelData.xoff-1)].mask==0))
        LadderChk++;
    }
    if ((LadderChk==(Player.Bitmap1->h-2)) && ((LevelData.LevelMask[((Player.y-10+LevelData.yoff+Player.Bitmap1->h-1)*LevelData.Length)+(Player.x+LevelData.xoff-1)].mask==1) || (LevelData.LevelMask[((Player.y-10+LevelData.yoff+Player.Bitmap1->h-2)*LevelData.Length)+(Player.x+LevelData.xoff-1)].mask==1)))
      Player.y--;
  }
  if ((Player.xinc) || (Player.xincj))
  {
    LadderChk=0;
    for (j=0;j<Player.Bitmap1->h-2;j++)
    {
      if ((LevelData.LevelMask[((Player.y-10+LevelData.yoff+j)*LevelData.Length)+(Player.x+LevelData.xoff+Player.Bitmap1->w)].mask==0))
        LadderChk++;
    }
    if ((LadderChk==(Player.Bitmap1->h-2)) && ((LevelData.LevelMask[((Player.y-10+LevelData.yoff+Player.Bitmap1->h-1)*LevelData.Length)+(Player.x+LevelData.xoff+Player.Bitmap1->w)].mask==1) || (LevelData.LevelMask[((Player.y-10+LevelData.yoff+Player.Bitmap1->h-2)*LevelData.Length)+(Player.x+LevelData.xoff+Player.Bitmap1->w)].mask==1)))
      Player.y--;
  }

  LadderChk=0;
  if (Player.Collu)
    Player.jump=FALSE;
  if (Player.Colld)
    Player.fall=FALSE;
  if (Player.JetPackOn)
    Player.fall=FALSE;
  if (Player.Ladder)
  {
    for (i=0;i<Player.Bitmap1->w;i++)
    {
      for (j=0;j<Player.Bitmap1->h-1;j++)
      {
        if ((LevelData.LevelMask[((Player.y-10+LevelData.yoff+j)*LevelData.Length)+(Player.x+LevelData.xoff+i)].mask!=2))
          LadderChk++;
      }
    }
    if (LadderChk==(Player.Bitmap1->w*(Player.Bitmap1->h-1)))
      Player.LadderTop=TRUE;
    else
      Player.LadderTop=FALSE;
  }

  if (Player.Ladder)
  {
    if (!Player.LadderTop)
      Player.jump=FALSE;
    Player.fall=FALSE;
  }
  else
  {
    Player.yinc=Player.ydec=Player.yincj=Player.ydecj=FALSE;
  }

  if (Player.BlockBan)
  {
    for (i=0;i<LevelData.BlockCount;i++)
    {
      if ((LevelData.BlockPos[i].ident==15) || (LevelData.BlockPos[i].ident==16))
      {
        if (((LevelData.BlockPos[i].BlockBanPosX-LevelData.xoff)<(Player.x+Player.Bitmap1->w)) && ((LevelData.BlockPos[i].BlockBanPosX-LevelData.xoff+Texture[LevelData.BlockPos[i].ident].Bitmap->w)>(Player.x)) && ((LevelData.BlockPos[i].BlockBanPosY-LevelData.yoff)==(Player.y+Player.Bitmap1->h)))
        {
          //putpixel(Vir1, 160, 100, 255);
          if (LevelData.BlockPos[i].BlockBanDelay>=3)
          {
            Player.x-=LevelData.BlockPos[i].BlockBan[LevelData.BlockPos[i].BlockBanPos].x-LevelData.BlockPos[i].BlockBan[LevelData.BlockPos[i].BlockBanPos+(1*LevelData.BlockPos[i].BlockBanChange)].x;
          }
        }
      }
    }
  }

  if ((Player.jump) || (Player.Studs))
    Player.fall=FALSE;

  if (((Player.xdec) || (Player.xdecj)) && (!Player.Colll))
    if (Player.x>0)
      Player.x--;
  if (((Player.xinc) || (Player.xincj)) && (!Player.Collr))
    if (Player.x<(320-Player.Bitmap1->w))
      Player.x++;
  if (((Player.ydec) || (Player.ydecj)) && (!Player.Collu))
    if (Player.y>10)
      Player.y--;
  if (((Player.yinc) || (Player.yincj)) && (!Player.Colld))
    if (Player.y<(200-Player.Bitmap1->h))
      Player.y++;

  if (Player.fall)
  {
    if (Player.y<(200-Player.Bitmap1->h))
      Player.y+=JumpPath[JumpPathNum];
    if (JumpPathNum>0)
      JumpPathNum--;
  }


  if (Player.Studs)
  {
    if (Player.StudsNum<STUDSCOUNT)
    {
      Player.StudsNum++;
      if (Player.y>10)
        Player.y-=2;
      else
        Player.Studs=FALSE;
    }
    else
    {
      Player.Studs=FALSE;
      Player.StudsNum=0;
      Player.jump=TRUE;
    }
  }

  if ((Player.JetPack) && (Player.JetPackOn) && (!Player.Collu))
  {
    if (Player.y>10)
      Player.y--;
  }

  if ((Player.jump) && (!Player.Ladder))
  {
    if (Player.y>10)
      Player.y-=JumpPath[JumpPathNum];
    else
      Player.jump=FALSE;
    if (JumpPathNum<JUMPPATHCOUNT)
      JumpPathNum++;
  }
/*  if (Player.yinc)
    Player.y++;*/
  if ((Player.x>(320-100)))
    if (LevelData.xoff<(LevelData.Length-320))
    {
     LevelData.xoff++;
     Player.x--;
     LevelData.Scroll=TRUE;
    }
  if ((Player.x<100))
    if (LevelData.xoff>0)
    {
      LevelData.xoff--;
      Player.x++;
      LevelData.Scroll=TRUE;
    }
  if ((Player.y>(200-50)))
    if (LevelData.yoff<(LevelData.Height-200))
    {
     LevelData.yoff++;
     Player.y--;
     LevelData.Scroll=TRUE;
    }
  if ((Player.y<100))
    if (LevelData.yoff>0)
    {
      LevelData.yoff--;
      Player.y++;
      LevelData.Scroll=TRUE;
    }
  //masked_blit(Player.Bitmap, Vir1, 0, 0, Player.x, Player.y, Player.Bitmap->w, Player.Bitmap->h);
  if ((Player.Ladder) && (!Player.LadderTop))
  {
    if (Player.Dir!=2)
      Player.OldDir=Player.Dir;
    Player.Dir=2;
  }
  else
    if (Player.Dir==2)
      Player.Dir=Player.OldDir;

  if ((Player.JetPack))
  {
    if ((Player.Dir!=3) || (Player.Dir!=4))
      Player.OldDir=Player.Dir;
    if (Player.xinc)
      Player.Dir=3;
    if (Player.xdec)
      Player.Dir=4;
  }
  else
    if ((Player.Dir==3) || (Player.Dir==4))
      Player.Dir=Player.OldDir;

  if ((Player.xinc) || (Player.xdec) || (Player.yinc) || (Player.ydec) || (Player.xincj) || (Player.xdecj) || (Player.yincj) || (Player.ydecj) || (Player.JetPackOn))
  {
    if (FotChange>=FOTCHANGECOUNT)
    {
      FotChange=0;
      Player.fot++;
      if (Player.fot>3)
        Player.fot=0;
    }
    FotChange++;
  }
  if (Player.Blink)
  {
    Player.BlinkCount--;
    if (Player.BlinkCount<1)
    {
      Player.BlinkCount=PLAYERBLINK;
      Player.Blink=FALSE;
    }
    if (Player.BlinkCount % 2 == 0)
    {
      if (Player.Dir==0)
      {
        if (Player.fot==0)
          draw_sprite(Vir1, Player.Bitmap1, Player.x, Player.y);
        if (Player.fot==1)
          draw_sprite(Vir1, Player.Bitmap2, Player.x, Player.y);
        if (Player.fot==2)
          draw_sprite(Vir1, Player.Bitmap3, Player.x, Player.y);
        if (Player.fot==3)
          draw_sprite(Vir1, Player.Bitmap4, Player.x, Player.y);
      }
      if (Player.Dir==1)
      {
        if (Player.fot==0)
          draw_sprite(Vir1, Player.Bitmap5, Player.x, Player.y);
        if (Player.fot==1)
          draw_sprite(Vir1, Player.Bitmap6, Player.x, Player.y);
        if (Player.fot==2)
          draw_sprite(Vir1, Player.Bitmap7, Player.x, Player.y);
        if (Player.fot==3)
          draw_sprite(Vir1, Player.Bitmap8, Player.x, Player.y);
      }
      if (Player.Dir==2)
      {
        if (Player.fot==0)
          draw_sprite(Vir1, Player.Bitmap9, Player.x, Player.y);
        if (Player.fot==1)
          draw_sprite(Vir1, Player.Bitmap10, Player.x, Player.y);
        if (Player.fot==2)
          draw_sprite(Vir1, Player.Bitmap9, Player.x, Player.y);
        if (Player.fot==3)
          draw_sprite(Vir1, Player.Bitmap10, Player.x, Player.y);
      }
      if (Player.Dir==3)
      {
        if (Player.JetPackOn)
        {
          if (Player.fot==0)
            draw_sprite(Vir1, Player.Bitmap11, Player.x, Player.y);
          if (Player.fot==1)
            draw_sprite(Vir1, Player.Bitmap12, Player.x, Player.y);
          if (Player.fot==2)
            draw_sprite(Vir1, Player.Bitmap11, Player.x, Player.y);
          if (Player.fot==3)
            draw_sprite(Vir1, Player.Bitmap12, Player.x, Player.y);
        }
        else
        {
          draw_sprite(Vir1, Player.Bitmap13, Player.x, Player.y);
        }
      }
      if (Player.Dir==4)
      {
        if (Player.JetPackOn)
        {
          if (Player.fot==0)
            draw_sprite(Vir1, Player.Bitmap14, Player.x, Player.y);
          if (Player.fot==1)
            draw_sprite(Vir1, Player.Bitmap15, Player.x, Player.y);
          if (Player.fot==2)
            draw_sprite(Vir1, Player.Bitmap14, Player.x, Player.y);
          if (Player.fot==3)
            draw_sprite(Vir1, Player.Bitmap15, Player.x, Player.y);
        }
        else
        {
          draw_sprite(Vir1, Player.Bitmap16, Player.x, Player.y);
        }
      }
    }
  }
  else
  {
    if (Player.Dir==0)
    {
      if (Player.fot==0)
        draw_sprite(Vir1, Player.Bitmap1, Player.x, Player.y);
      if (Player.fot==1)
        draw_sprite(Vir1, Player.Bitmap2, Player.x, Player.y);
      if (Player.fot==2)
        draw_sprite(Vir1, Player.Bitmap3, Player.x, Player.y);
      if (Player.fot==3)
        draw_sprite(Vir1, Player.Bitmap4, Player.x, Player.y);
    }
    if (Player.Dir==1)
    {
      if (Player.fot==0)
        draw_sprite(Vir1, Player.Bitmap5, Player.x, Player.y);
      if (Player.fot==1)
        draw_sprite(Vir1, Player.Bitmap6, Player.x, Player.y);
      if (Player.fot==2)
        draw_sprite(Vir1, Player.Bitmap7, Player.x, Player.y);
      if (Player.fot==3)
        draw_sprite(Vir1, Player.Bitmap8, Player.x, Player.y);
    }
    if (Player.Dir==2)
    {
      if (Player.fot==0)
        draw_sprite(Vir1, Player.Bitmap9, Player.x, Player.y);
      if (Player.fot==1)
        draw_sprite(Vir1, Player.Bitmap10, Player.x, Player.y);
      if (Player.fot==2)
        draw_sprite(Vir1, Player.Bitmap9, Player.x, Player.y);
      if (Player.fot==3)
        draw_sprite(Vir1, Player.Bitmap10, Player.x, Player.y);
    }
    if (Player.Dir==3)
    {
      if (Player.JetPackOn)
      {
        if (Player.fot==0)
          draw_sprite(Vir1, Player.Bitmap11, Player.x, Player.y);
        if (Player.fot==1)
          draw_sprite(Vir1, Player.Bitmap12, Player.x, Player.y);
        if (Player.fot==2)
          draw_sprite(Vir1, Player.Bitmap11, Player.x, Player.y);
        if (Player.fot==3)
          draw_sprite(Vir1, Player.Bitmap12, Player.x, Player.y);
      }
      else
      {
        draw_sprite(Vir1, Player.Bitmap13, Player.x, Player.y);
      }
    }
    if (Player.Dir==4)
    {
      if (Player.JetPackOn)
      {
        if (Player.fot==0)
          draw_sprite(Vir1, Player.Bitmap14, Player.x, Player.y);
        if (Player.fot==1)
          draw_sprite(Vir1, Player.Bitmap15, Player.x, Player.y);
        if (Player.fot==2)
          draw_sprite(Vir1, Player.Bitmap14, Player.x, Player.y);
        if (Player.fot==3)
          draw_sprite(Vir1, Player.Bitmap15, Player.x, Player.y);
      }
      else
      {
        draw_sprite(Vir1, Player.Bitmap16, Player.x, Player.y);
      }
    }
  }
  return 0;
}


int get_input()     // Hmtar aktuell knapptryckning och joystick data
{
  if (keypressed())
  {
    gKey=readkey();
  }
  if (joyen)
  {
    poll_joystick();
  }
  return 0;
}


int load_level(char *filename, int create)
{
  FILE *F;
  char *temp;
  int i, j, k;
  double xslope, yslope, Yres, Xres;
  unsigned short BlockType;
  unsigned short x,y,TempMin=0;
  unsigned short *Fbuff;
  unsigned long Flen=0;
  unsigned long Fpos=0;
  unsigned int tempuint;
  temp=malloc(sizeof(char)*(100));
  temp="\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0";
  if (Debug)
    printf("Loading level: %s\n", filename);
  F=fopen(filename, "rb");
  if (F==NULL)
  {
     equit("Error opening file!");
  }
  else
  {
    fseek(F, 0, SEEK_END);
    Flen=ftell(F);
    fseek(F, 0, SEEK_SET);
    Fbuff=malloc(sizeof(unsigned short)*(Flen+10));  //Allokerar minne fr collisionmasken
    memset(Fbuff, 0, Flen+10);
    fread(Fbuff, Flen, 1, F);
    fclose(F);
    bcopy(Fbuff, temp, 6);
    if (strcmp(temp, "LGL100")!=0)
    {
      printf("%s\n", temp);
      equit("Wrong filetype!");
    }
    else
    {    // Laddar banans namn
      bcopy(Fbuff+3, LevelData.Name, 20);
      Fpos=26/2;
      LevelData.ident=Fbuff[Fpos]; //indentnummer
      Fpos++;
      if (Debug)
        printf("Ident: %x\n", LevelData.ident);
      LevelData.Length=Fbuff[Fpos];  // Banans lngd i pixlar
      Fpos++;
      if (Debug)
        printf("Length: %i\n", LevelData.Length);
      LevelData.Height=Fbuff[Fpos];  // Banans lngd i pixlar
      Fpos++;
      if (Debug)
        printf("Height: %i\n", LevelData.Height);
      LevelData.BlockCount=Fbuff[Fpos];  // Antal block i banan
      Fpos++;
      if (Debug)
        printf("BlockCount: %i\n", LevelData.BlockCount);
      LevelData.EnemyCount=Fbuff[Fpos];   // Antal fiender p banan
      Fpos++;
      if (Debug)
        printf("EnemyCount: %i\n", LevelData.EnemyCount);
      LevelData.ItemCount=Fbuff[Fpos];   // Antal prylar och saker p banan
      Fpos++;
      if (Debug)
        printf("ItemCount: %i\n", LevelData.ItemCount);
      Player.x=Fbuff[Fpos];   // Player start X
      Fpos++;
      if (Debug)
        printf("Player.x: %i\n", Player.x);
      Player.y=Fbuff[Fpos];   // Player start Y
      Fpos++;
      Player.StartX=Player.x;
      Player.StartY=Player.y;
      if (Debug)
        printf("Player.y: %i\n", Player.y);
      // printf("Loading %s - %i\n", LevelData.Name, LevelData.Ident);
      if (Debug)
        printf("Allokerar minne...\n");
      LevelData.LevelBitmap=create_bitmap(LevelData.Length, LevelData.Height);   // Allokerar minne fr banbitmappen
      LevelData.LevelBackgr=create_bitmap(LevelData.Length, LevelData.Height);   // Allokerar minne fr banbitmappen
      LevelData.LevelMask=malloc(sizeof(struct TLevelMask)*((LevelData.Length*LevelData.Height)+10));  //Allokerar minne fr collisionmasken
      if (LevelData.LevelMask==0)
        equit("Not enough memory...");
      LevelData.BlockPos=malloc(sizeof(struct TItemPos)*LevelData.BlockCount+10);  // Allokerar minne fr block
      if (LevelData.BlockPos==0)
        equit("Not enough memory...");
      LevelData.EnemyPos=malloc(sizeof(struct TItemPos)*LevelData.EnemyCount+10);  // Allokerar minne fr fiender
      if (LevelData.EnemyPos==0)
        equit("Not enough memory...");
      LevelData.ItemPos=malloc(sizeof(struct TItemPos)*LevelData.ItemCount+10);    // Allokerar minne fr saker
      if (LevelData.ItemPos==0)
        equit("Not enough memory...");
      if (!create)
        memset(LevelData.LevelMask, 0, (LevelData.Length*LevelData.Height)+10);          // Nollstller alla allokerade minnesplatser
      memset(LevelData.BlockPos, 0, LevelData.BlockCount+10);
      memset(LevelData.EnemyPos, 0, LevelData.EnemyCount+10);
      memset(LevelData.ItemPos, 0, LevelData.ItemCount+10);
      clear(LevelData.LevelBitmap);
      clear(LevelData.LevelBackgr);
      for (i=0;i<LevelData.Length/LevelData.Background->w;i++)
      {
        blit(LevelData.Background, LevelData.LevelBackgr, 0,10,LevelData.Background->w*i,0,LevelData.Background->w,190);
      }
      if (LevelData.Length-(LevelData.Length/LevelData.Background->w)!=0)
      {
        blit(LevelData.Background, LevelData.LevelBackgr, 0,10,LevelData.Background->w*(LevelData.Length/LevelData.Background->w),0,LevelData.Length-(LevelData.Length/LevelData.Background->w),190);
      }
      if ((LevelData.LevelBitmap==NULL) || (LevelData.LevelBackgr==NULL))
        equit("Error creating bitmaps!");
      else // Ladda sjlva banan...
      {
        if (Debug)
          printf("Laddar koordinater till block\n");
        TempMin=0;
        for (i=0;i<LevelData.BlockCount;i++)
        {
          BlockType=Fbuff[Fpos];  // Hmta blocktypen
          Fpos++;
          if (Debug)
            printf("[%x]", BlockType);
          if (BlockType<BlockTextureCount)  // Kontrollera om det r ett felaktigt block
          {
            if (Debug)
              printf(".");
            x=Fbuff[Fpos];   // Hmta X och Y position fr blocket
            Fpos++;
            y=Fbuff[Fpos];
            Fpos++;
            if (!Design)
            {
              if ((BlockType!=15) && (BlockType!=16) && (BlockType!=22) && (BlockType!=24))
                masked_blit(Texture[BlockType].Bitmap, LevelData.LevelBitmap,  0, 0, x, y, Texture[BlockType].Width, Texture[BlockType].Height);
            }
            else
              masked_blit(Texture[BlockType].Bitmap, LevelData.LevelBitmap,  0, 0, x, y, Texture[BlockType].Width, Texture[BlockType].Height);
            LevelData.BlockPos[i].x=x;  // Sparar blocket i minnet
            LevelData.BlockPos[i].y=y;
            LevelData.BlockPos[i].Anim=0;
            LevelData.BlockPos[i].AnimChange=0;
            if (Debug)
               printf(" x:%i y:%i", x, y);
            LevelData.BlockPos[i].ident=BlockType;
            x=Fbuff[Fpos];   // Hmta X och Y position fr Stopp 1
            Fpos++;
            y=Fbuff[Fpos];
            Fpos++;
            if (Debug)
               printf(" x1:%i y1:%i", x, y);
            LevelData.BlockPos[i].Stop1x=x;
            LevelData.BlockPos[i].Stop1y=y;
            x=Fbuff[Fpos];   // Hmta X och Y position fr Stopp 2
            Fpos++;
            y=Fbuff[Fpos];
            Fpos++;
            LevelData.BlockPos[i].Stop2x=x;
            LevelData.BlockPos[i].Stop2y=y;
            if (Debug)
               printf(" x2:%i y2:%i", x, y);
          }
          else
          {
            TempMin++;
            Fpos+=6;
          }
        }
        LevelData.BlockCount-=TempMin;
        TempMin=0;
        if (Debug)
          printf("\nLaddar koordinater till fiender\n");
        for (i=0;i<LevelData.EnemyCount;i++)  // Samma som ovan fast fr fiender
        {
          BlockType=Fbuff[Fpos];
          Fpos++;
          if (Debug)
            printf("[%i]", BlockType);
          if (BlockType<EnemyTextureCount)
          {
            if (Debug)
              printf(".");
            x=Fbuff[Fpos];
            Fpos++;
            y=Fbuff[Fpos];
            Fpos++;
            //masked_blit(Enemy[BlockType].Bitmap1, LevelData.LevelBitmap,  0, 0, x, y, Enemy[BlockType].Bitmap1->w, Enemy[BlockType].Bitmap1->h);
            LevelData.EnemyPos[i].x=x;
            LevelData.EnemyPos[i].y=y;//+10
            LevelData.EnemyPos[i].StartX=x;
            LevelData.EnemyPos[i].StartY=y;//+10
            LevelData.EnemyPos[i].ident=BlockType;
            LevelData.EnemyPos[i].xdec=TRUE;
            LevelData.EnemyPos[i].xinc=FALSE;
            LevelData.EnemyPos[i].WalkDelay=WALKDELAY;
            LevelData.EnemyPos[i].Visible=TRUE;
            LevelData.EnemyPos[i].Anim=LevelData.EnemyPos[i].AnimChange=0;

            if (create)
              masked_blit(Enemy[BlockType].Bitmap1, LevelData.LevelBitmap,  0, 0, x, y, Enemy[BlockType].Bitmap1->w, Enemy[BlockType].Bitmap1->h);
            x=Fbuff[Fpos];   // Hmta X och Y position fr Stopp 1
            Fpos++;
            y=Fbuff[Fpos];
            Fpos++;
            LevelData.EnemyPos[i].Stop1x=x;
            LevelData.EnemyPos[i].Stop1y=y;
            // printf("[X1: %i]", x);
            x=Fbuff[Fpos];   // Hmta X och Y position fr Stopp 2
            Fpos++;
            y=Fbuff[Fpos];
            Fpos++;
            LevelData.EnemyPos[i].Stop2x=x;
            LevelData.EnemyPos[i].Stop2y=y;
            // printf("[X2: %i]", x);
           }
          else
          {
            TempMin++;
            Fpos+=6;
          }
        }
        LevelData.EnemyCount-=TempMin;
        TempMin=0;
        if (Debug)
          printf("\nLaddar koordinater till saker\n");
        for (i=0;i<LevelData.ItemCount;i++)   // Samma som ovan fast fr saker
        {
          BlockType=Fbuff[Fpos];
          Fpos++;
          if (Debug)
            printf("[%i]", BlockType);
          if (BlockType<ItemTextureCount)
          {
            if (Debug)
              printf(".");
            x=Fbuff[Fpos];
            Fpos++;
            y=Fbuff[Fpos];
            Fpos++;
           // printf("B:%i X:%i Y:%i ", BlockType, x, y);
            //masked_blit(Item[BlockType].Bitmap1, LevelData.LevelBitmap,  0, 0, x, y, Item[BlockType].Bitmap1->w, Item[BlockType].Bitmap1->h);
            LevelData.ItemPos[i].x=x;
            LevelData.ItemPos[i].y=y;
            LevelData.ItemPos[i].ident=BlockType;
            LevelData.ItemPos[i].Visible=TRUE;
            LevelData.ItemPos[i].Anim=LevelData.ItemPos[i].AnimChange=0;
            if (create)
              masked_blit(Item[BlockType].Bitmap1, LevelData.LevelBitmap,  0, 0, x, y, Item[BlockType].Bitmap1->w, Item[BlockType].Bitmap1->h);
            x=Fbuff[Fpos];   // Hmta X och Y position fr Stopp 1
            Fpos++;
            y=Fbuff[Fpos];
            Fpos++;
           // printf("X1:%i Y1:%i ", x, y);
            LevelData.ItemPos[i].Stop1x=x;
            LevelData.ItemPos[i].Stop1y=y;
            x=Fbuff[Fpos];   // Hmta X och Y position fr Stopp 2
            Fpos++;
            y=Fbuff[Fpos];
            Fpos++;
           // printf("X2:%i Y3:%i\n", x, y);
            LevelData.ItemPos[i].Stop2x=x;
            LevelData.ItemPos[i].Stop2y=y;
          }
          else
          {
            TempMin++;
            Fpos+=6;
          }
        }
        LevelData.ItemCount-=TempMin;
        TempMin=0;
      }
    }
    if (!create)
    {
      if (Debug)
        printf("\nSkapar blockbanor...\n");
      for (i=0;i<LevelData.BlockCount;i++)
      {
        if ((LevelData.BlockPos[i].ident==15) || (LevelData.BlockPos[i].ident==16))
        {
          LevelData.BlockPos[i].BlockBanPos=0;
          LevelData.BlockPos[i].BlockBanChange=1;
          if (Debug)
            printf("X1: %i Y1: %i X2: %i Y2: %i\n", LevelData.BlockPos[i].Stop1x, LevelData.BlockPos[i].Stop1y, LevelData.BlockPos[i].Stop2x, LevelData.BlockPos[i].Stop2y);
          if (LevelData.BlockPos[i].Stop2x<LevelData.BlockPos[i].Stop1x)
          {
            tempuint=LevelData.BlockPos[i].Stop2x;
            LevelData.BlockPos[i].Stop2x=LevelData.BlockPos[i].Stop1x;
            LevelData.BlockPos[i].Stop1x=tempuint;
            tempuint=LevelData.BlockPos[i].Stop2y;
            LevelData.BlockPos[i].Stop2y=LevelData.BlockPos[i].Stop1y;
            LevelData.BlockPos[i].Stop1y=tempuint;
            LevelData.BlockPos[i].x=LevelData.BlockPos[i].Stop1x;
            LevelData.BlockPos[i].y=LevelData.BlockPos[i].Stop1y;
          }
          Xres=LevelData.BlockPos[i].Stop2x-LevelData.BlockPos[i].Stop1x;
          Yres=LevelData.BlockPos[i].Stop2y-LevelData.BlockPos[i].Stop1y;
          if ((Xres!=0) && (Yres!=0))
          {
            xslope=Xres/Yres;
            yslope=Yres/Xres;
          }
          else
          {
            xslope=0.0;
            yslope=0.0;
          }
          if (Debug)
            printf("xslope: %f yslope: %f Xres: %f Yres: %f X1: %i Y1: %i X2: %i Y2: %i\n", xslope, yslope, Xres, Yres, LevelData.BlockPos[i].Stop1x, LevelData.BlockPos[i].Stop1y, LevelData.BlockPos[i].Stop2x, LevelData.BlockPos[i].Stop2y);
          if ((yslope!=0) && (xslope!=0) && (yslope/xslope<1) && (yslope/xslope>-1))
          {
            LevelData.BlockPos[i].BlockBan=malloc(sizeof(struct TBlockBan)*(abs(Xres)+10));
            LevelData.BlockPos[i].BlockBanCount=abs(Xres);
            if (yslope<0)
            {
              for (j=0;j<abs(Xres)+1;j++)
              {
                LevelData.BlockPos[i].BlockBan[j].y=((yslope*j));
                LevelData.BlockPos[i].BlockBan[j].x=(j);
                if (Debug)
                  printf("[X: %i Y:%i] ", LevelData.BlockPos[i].BlockBan[j].x, LevelData.BlockPos[i].BlockBan[j].y);
              }
            }
            else
            {
              for (j=0;j<abs(Xres)+1;j++)
              {
                LevelData.BlockPos[i].BlockBan[j].y=((yslope*j));
                LevelData.BlockPos[i].BlockBan[j].x=(j);
                if (Debug)
                  printf("[X: %i Y:%i] ", LevelData.BlockPos[i].BlockBan[j].x, LevelData.BlockPos[i].BlockBan[j].y);
              }
            }
          }
          else
          {
            LevelData.BlockPos[i].BlockBan=malloc((sizeof(struct TBlockBan)*(abs(Yres)+10)));
            if (Yres!=0)
            {
              LevelData.BlockPos[i].BlockBanCount=abs(Yres);
              if (yslope<0)
              {
                for (j=0;j<abs(Yres)+1;j++)
                {
                  LevelData.BlockPos[i].BlockBan[j].y=(j*-1);
                  LevelData.BlockPos[i].BlockBan[j].x=((xslope*j)*-1);
                  if (Debug)
                    printf("{X: %i Y:%i} ", LevelData.BlockPos[i].BlockBan[j].x, LevelData.BlockPos[i].BlockBan[j].y);
                }
              }
              else
              {
                for (j=0;j<abs(Yres)+1;j++)
                  {
                    LevelData.BlockPos[i].BlockBan[j].y=(j);
                    LevelData.BlockPos[i].BlockBan[j].x=((xslope*j));
                    if (Debug)
                      printf("(X: %i Y:%i) ", LevelData.BlockPos[i].BlockBan[j].x, LevelData.BlockPos[i].BlockBan[j].y);
                  }
              }
            }
            else
            {
              LevelData.BlockPos[i].BlockBanCount=abs(Xres);
              for (j=0;j<abs(Xres)+1;j++)
              {
                LevelData.BlockPos[i].BlockBan[j].y=0;
                LevelData.BlockPos[i].BlockBan[j].x=j;
                if (Debug)
                  printf("<X: %i Y:%i> ", LevelData.BlockPos[i].BlockBan[j].x, LevelData.BlockPos[i].BlockBan[j].y);
              }
            }
          }
        }
      }
      if (Debug)
        printf("\nSkapar LevelMask...\n");
      for (i=0;i<(LevelData.Length*LevelData.Height);i++)
        LevelData.LevelMask[i].mask=0;
      for (i=0;i<LevelData.BlockCount;i++)
      {
        LevelData.BlockPos[i].BlockBanMask=NULL;
        if ((LevelData.BlockPos[i].ident==15) || (LevelData.BlockPos[i].ident==16))
        {
          LevelData.BlockPos[i].BlockBanMask=malloc(sizeof(struct TLevelMask)*(Texture[LevelData.BlockPos[i].ident].Bitmap->h*Texture[LevelData.BlockPos[i].ident].Bitmap->w));
          for (j=0;j<(Texture[LevelData.BlockPos[i].ident].Bitmap->w*Texture[LevelData.BlockPos[i].ident].Bitmap->h);j++)
            LevelData.BlockPos[i].BlockBanMask[j].mask=0;
        }
        for (j=0;j<Texture[LevelData.BlockPos[i].ident].Bitmap->h;j++)
        {
          for (k=0;k<Texture[LevelData.BlockPos[i].ident].Bitmap->w;k++)
          {
            if ((getpixel(Texture[LevelData.BlockPos[i].ident].Bitmap, k, j)>0) && ((((j+LevelData.BlockPos[i].y)*LevelData.Length)+k+LevelData.BlockPos[i].x)<(LevelData.Length*LevelData.Height)))
            {
              if (LevelData.BlockPos[i].BlockBanMask!=NULL)
                LevelData.BlockPos[i].BlockBanMask[(j*Texture[LevelData.BlockPos[i].ident].Bitmap->w)+k].mask=3;
              if ((LevelData.BlockPos[i].ident==13) || (LevelData.BlockPos[i].ident==14))
                LevelData.LevelMask[((j+LevelData.BlockPos[i].y)*LevelData.Length)+k+LevelData.BlockPos[i].x].mask=2;
              else if ((LevelData.BlockPos[i].ident==15) || (LevelData.BlockPos[i].ident==16) || (LevelData.BlockPos[i].ident==23))
                LevelData.LevelMask[((j+LevelData.BlockPos[i].y)*LevelData.Length)+k+LevelData.BlockPos[i].x].mask=0;
              else if (LevelData.BlockPos[i].ident==22)
                LevelData.LevelMask[((j+LevelData.BlockPos[i].y)*LevelData.Length)+k+LevelData.BlockPos[i].x].mask=4;
              else
                LevelData.LevelMask[((j+LevelData.BlockPos[i].y)*LevelData.Length)+k+LevelData.BlockPos[i].x].mask=1;
            }
            else
            {
              if (((((j+LevelData.BlockPos[i].y)*LevelData.Length)+k+LevelData.BlockPos[i].x)<(LevelData.Length*LevelData.Height)))
              {
                if ((LevelData.BlockPos[i].ident==13) || (LevelData.BlockPos[i].ident==14))
                  LevelData.LevelMask[((j+LevelData.BlockPos[i].y)*LevelData.Length)+k+LevelData.BlockPos[i].x].mask=2;
                else if (LevelData.BlockPos[i].ident==22)
                  LevelData.LevelMask[((j+LevelData.BlockPos[i].y)*LevelData.Length)+k+LevelData.BlockPos[i].x].mask=4;
                else
                  LevelData.LevelMask[((j+LevelData.BlockPos[i].y)*LevelData.Length)+k+LevelData.BlockPos[i].x].mask=0;
              }
            }
          }
        }
      }
    }
    if (Debug)
      printf("Klart!\n");
  }
  return 0;
}


/*
int load_level(char *filename)
{
  FILE *F;
  char *temp="\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0";
  int i, j;
  unsigned char BlockType;
  unsigned int x,y,TempMin=0;
  //unsigned int ItemCount;
  if (Debug)
    printf("Loading level: %s\n", filename);
  F=fopen(filename, "r");
  if (F==NULL)
  {
     equit("Error opening file!");
  }
  else
  {
    fseek(F, 0, SEEK_SET);
    fgets(temp, 7, F);  // Kollar om filen har rtt format
    if (strcmp(temp, "LGL100")!=0)
    {
      equit("Wrong filetype!");
    }
    else
    {    // Laddar banans namn
      fgets(LevelData.Name, 20, F);
      fgetc(F);
      LevelData.ident=fgetc(F);   // Identifikationsnummer
      if (Debug)
        printf("Ident: %i\n", LevelData.ident);
      LevelData.Length=fgetc(F);  // Banans lngd i pixlar
      LevelData.Length=(LevelData.Length << 8);
      LevelData.Length+=fgetc(F);
      if (Debug)
        printf("Length: %i\n", LevelData.Length);
      LevelData.Height=fgetc(F);  // Banans lngd i pixlar
      LevelData.Height=(LevelData.Height << 8);
      LevelData.Height+=fgetc(F);
      if (Debug)
        printf("Height: %i\n", LevelData.Height);
      LevelData.BlockCount=fgetc(F);  // Antal block i banan
      LevelData.BlockCount=(LevelData.BlockCount << 8);
      LevelData.BlockCount+=fgetc(F);
      if (Debug)
        printf("BlockCount: %i\n", LevelData.BlockCount);
      LevelData.EnemyCount=fgetc(F);   // Antal fiender p banan
      LevelData.EnemyCount=(LevelData.EnemyCount << 8);
      LevelData.EnemyCount+=fgetc(F);
      if (Debug)
        printf("EnemyCount: %i\n", LevelData.EnemyCount);
      LevelData.ItemCount=fgetc(F);   // Antal prylar och saker p banan
      LevelData.ItemCount=(LevelData.ItemCount << 8);
      LevelData.ItemCount+=fgetc(F);
      if (Debug)
        printf("ItemCount: %i\n", LevelData.ItemCount);
      Player.x=fgetc(F);   // Player start X
      Player.x=(Player.x << 8);
      Player.x+=fgetc(F);
      if (Debug)
        printf("Player.x: %i\n", Player.x);
      Player.y=fgetc(F);   // Player start Y
      Player.y=(Player.y << 8);
      Player.y+=fgetc(F);
      Player.StartX=Player.x;
      Player.StartY=Player.y;
      if (Debug)
        printf("Player.y: %i\n", Player.y);
      // printf("Loading %s - %i\n", LevelData.Name, LevelData.Ident);
      if (Debug)
        printf("Allokerar minne...\n");
      LevelData.LevelBitmap=create_bitmap(LevelData.Length, LevelData.Height);   // Allokerar minne fr banbitmappen
      LevelData.LevelBackgr=create_bitmap(LevelData.Length, LevelData.Height);   // Allokerar minne fr banbitmappen
      LevelData.LevelMask=malloc(sizeof(struct TLevelMask)*((LevelData.Length*LevelData.Height)+10));  //Allokerar minne fr collisionmasken
      if (LevelData.LevelMask==0)
        equit("Not enough memory...");
      LevelData.BlockPos=malloc(sizeof(struct TItemPos)*LevelData.BlockCount+10);  // Allokerar minne fr block
      if (LevelData.BlockPos==0)
        equit("Not enough memory...");
      LevelData.EnemyPos=malloc(sizeof(struct TItemPos)*LevelData.EnemyCount+10);  // Allokerar minne fr fiender
      if (LevelData.EnemyPos==0)
        equit("Not enough memory...");
      LevelData.ItemPos=malloc(sizeof(struct TItemPos)*LevelData.ItemCount+10);    // Allokerar minne fr saker
      if (LevelData.ItemPos==0)
        equit("Not enough memory...");
      memset(LevelData.LevelMask, 0, (LevelData.Length*LevelData.Height)+10);          // Nollstller alla allokerade minnesplatser
      memset(LevelData.BlockPos, 0, LevelData.BlockCount+10);
      memset(LevelData.EnemyPos, 0, LevelData.EnemyCount+10);
      memset(LevelData.ItemPos, 0, LevelData.ItemCount+10);
      clear(LevelData.LevelBitmap);
      clear(LevelData.LevelBackgr);
      for (i=0;i<LevelData.Length/320;i++)
      {
        blit(LevelData.Background, LevelData.LevelBackgr, 0,10,320*i,0,320,190);
      }
      if (LevelData.Length-(LevelData.Length/320)!=0)
      {
        blit(LevelData.Background, LevelData.LevelBackgr, 0,10,320*(LevelData.Length/320),0,LevelData.Length-(LevelData.Length/320),190);
      }
      if ((LevelData.LevelBitmap==NULL) || (LevelData.LevelBackgr==NULL))
        equit("Error creating bitmaps!");
      else // Ladda sjlva banan...
      {
        if (Debug)
          printf("Laddar koordinater till block\n");
        TempMin=0;
        for (i=0;i<LevelData.BlockCount;i++)
        {
          BlockType=fgetc(F);  // Hmta blocktypen
          if (Debug)
            printf("[%i]", BlockType);
          if (BlockType<BlockTextureCount)  // Kontrollera om det r ett felaktigt block
          {
            if (Debug)
              printf(".");
            x=fgetc(F);   // Hmta X och Y position fr blocket
            x=(x << 8);
            x+=fgetc(F);
            y=fgetc(F);
            y=(y << 8);
            y+=fgetc(F);
            masked_blit(Texture[BlockType].Bitmap, LevelData.LevelBitmap,  0, 0, x, y, Texture[BlockType].Width, Texture[BlockType].Height);
            LevelData.BlockPos[i].x=x;  // Sparar blocket i minnet
            LevelData.BlockPos[i].y=y;
            if (Debug)
               printf("x:%i y:%i", x, y);
            LevelData.BlockPos[i].ident=BlockType;
            x=fgetc(F);   // Hmta X och Y position fr Stopp 1
            x=(x << 8);
            x+=fgetc(F);
            y=fgetc(F);
            y=(y << 8);
            y+=fgetc(F);
            LevelData.BlockPos[i].Stop1x=x;
            LevelData.BlockPos[i].Stop1y=y;
            x=fgetc(F);   // Hmta X och Y position fr Stopp 2
            x=(x << 8);
            x+=fgetc(F);
            y=fgetc(F);
            y=(y << 8);
            y+=fgetc(F);
            LevelData.BlockPos[i].Stop2x=x;
            LevelData.BlockPos[i].Stop2y=y;
          }
          else
            TempMin++;
        }
        LevelData.BlockCount-=TempMin;
        TempMin=0;
        if (Debug)
          printf("\nLaddar koordinater till fiender\n");
        for (i=0;i<LevelData.EnemyCount;i++)  // Samma som ovan fast fr fiender
        {
          BlockType=fgetc(F);
          if (Debug)
            printf("[%i]", BlockType);
          if (BlockType<EnemyTextureCount)
          {
            if (Debug)
              printf(".");
            x=fgetc(F);
            x=(x << 8);
            x+=fgetc(F);
            y=fgetc(F);
            y=(y << 8);
            y+=fgetc(F);
            //masked_blit(Enemy[BlockType].Bitmap1, LevelData.LevelBitmap,  0, 0, x, y, Enemy[BlockType].Bitmap1->w, Enemy[BlockType].Bitmap1->h);
            LevelData.EnemyPos[i].x=x;
            LevelData.EnemyPos[i].y=y;//+10
            LevelData.EnemyPos[i].StartX=x;
            LevelData.EnemyPos[i].StartY=y;//+10
            LevelData.EnemyPos[i].ident=BlockType;
            LevelData.EnemyPos[i].xdec=TRUE;
            LevelData.EnemyPos[i].xinc=FALSE;
            LevelData.EnemyPos[i].WalkDelay=WALKDELAY;
            LevelData.EnemyPos[i].Visible=TRUE;
            x=fgetc(F);   // Hmta X och Y position fr Stopp 1
            x=(x << 8);
            x+=fgetc(F);
            y=fgetc(F);
            y=(y << 8);
            y+=fgetc(F);
            LevelData.EnemyPos[i].Stop1x=x;
            LevelData.EnemyPos[i].Stop1y=y;
           // printf("[X1: %i]", x);
            x=fgetc(F);   // Hmta X och Y position fr Stopp 2
            x=(x << 8);
            x+=fgetc(F);
            y=fgetc(F);
            y=(y << 8);
            y+=fgetc(F);
            LevelData.EnemyPos[i].Stop2x=x;
            LevelData.EnemyPos[i].Stop2y=y;
           // printf("[X2: %i]", x);
          }
          else
            TempMin++;
        }
        LevelData.EnemyCount-=TempMin;
        TempMin=0;
        if (Debug)
          printf("\nLaddar koordinater till saker\n");
        for (i=0;i<LevelData.ItemCount;i++)   // Samma som ovan fast fr saker
        {
          BlockType=fgetc(F);
         // if (Debug)
         //   printf("[%i]", BlockType);
         // if (BlockType<ItemTextureCount)
          //{
            if (Debug)
              printf(".");
            x=fgetc(F);
            x=(x << 8);
            x+=fgetc(F);
            y=fgetc(F);
            y=(y << 8);
            y+=fgetc(F);
           // printf("B:%i X:%i Y:%i ", BlockType, x, y);
            //masked_blit(Item[BlockType].Bitmap1, LevelData.LevelBitmap,  0, 0, x, y, Item[BlockType].Bitmap1->w, Item[BlockType].Bitmap1->h);
            LevelData.ItemPos[i].x=x;
            LevelData.ItemPos[i].y=y;
            LevelData.ItemPos[i].ident=BlockType;
            LevelData.ItemPos[i].Visible=TRUE;
            x=fgetc(F);   // Hmta X och Y position fr Stopp 1
            x=(x << 8);
            x+=fgetc(F);
            y=fgetc(F);
            y=(y << 8);
            y+=fgetc(F);
           // printf("X1:%i Y1:%i ", x, y);
            LevelData.ItemPos[i].Stop1x=x;
            LevelData.ItemPos[i].Stop1y=y;
            x=fgetc(F);   // Hmta X och Y position fr Stopp 2
            x=(x << 8);
            x+=fgetc(F);
            y=fgetc(F);
            y=(y << 8);
            y+=fgetc(F);
           // printf("X2:%i Y3:%i\n", x, y);
            LevelData.ItemPos[i].Stop2x=x;
            LevelData.ItemPos[i].Stop2y=y;
         // }
        //  else
         //   TempMin++;
        }
        LevelData.ItemCount-=TempMin;
        TempMin=0;
      }
    }
    if (Debug)
      printf("\nSkapar LevelMask...\n");
    for (i=0;i<LevelData.Height;i++)
    {
      for (j=0;j<LevelData.Length;j++)
      {
        if (getpixel(LevelData.LevelBitmap, j, i)>0)
        LevelData.LevelMask[(i*LevelData.Length)+j].mask=1;
        else
        LevelData.LevelMask[(i*LevelData.Length)+j].mask=0;
      }
    }
    if (Debug)
      printf("Klart!\n");
  }
  fclose(F);
  return 0;
} */

int unload_level()
{
  int a;
  for (a=0;a<LevelData.BlockCount;a++)
    if (LevelData.BlockPos[a].ident==14)
    {
      if (LevelData.BlockPos[a].BlockBanMask!=NULL)
        free(LevelData.BlockPos[a].BlockBanMask);
      if (LevelData.BlockPos[a].BlockBan!=NULL)
        free(LevelData.BlockPos[a].BlockBan);
    }
  if (LevelData.LevelBitmap!=NULL)
    destroy_bitmap(LevelData.LevelBitmap);
  if (LevelData.LevelBackgr!=NULL)
    destroy_bitmap(LevelData.LevelBackgr);
  LevelData.Length=0;
  for (a=0;a<20;a++)
    LevelData.Name[a]=' ';
  LevelData.ident=0;
  LevelData.BlockCount=0;
  LevelData.EnemyCount=0;
  LevelData.ItemCount=0;
  free(LevelData.LevelMask);
  free(LevelData.BlockPos);
  free(LevelData.EnemyPos);
  free(LevelData.ItemPos);
  return 0;
}


int design_new_level(char *filename)
{
  FILE *F;
  short ActiveItem=0, ActiveEnemy=0, ActiveTexture=0, draw=TRUE, done=FALSE,  Delete=FALSE;
  unsigned short a;
  BITMAP *TempBitmap, *PlayerStartBitmap, *EnemyStop1Bitmap, *EnemyStop2Bitmap;
  unsigned short DeleteType=1000;
  unsigned short *Fbuff;
  long Flen=0;
  long Fpos=0;

  char *temp;
  int i, j;
  unsigned short BlockType;
  unsigned short x,y, TempMin;
//  unsigned int BlockCount=0, ItemCount=0, EnemyCount=0;
  unsigned short ItemType=0;

  // On filen finns s ppna ladda den i minnet
  // Om inte skapa en ny

  if (exists(filename)!=0)
  {
    load_level(filename, TRUE);
  }
  else
  {                  // Om banan nu redan skulle vara allokerad s tycker i alla fall jag att den ska avallokeras...  Eller vad sger du?
    if (Debug)
      printf("Skapar ny fil\n");
    LevelData.Length=320;
    LevelData.Height=200;
    if (LevelData.LevelBitmap!=NULL)
      unload_level();
    LevelData.BlockCount=0;
    LevelData.EnemyCount=0;
    LevelData.ItemCount=0;
    if (Debug)
      printf("Skapar bitmap och allokerar minne\n");
    LevelData.LevelBitmap=create_bitmap(LevelData.Length, LevelData.Height);   // Allokerar minne fr banbitmappen
    LevelData.BlockPos=malloc(sizeof(struct TItemPos)*(LevelData.BlockCount+10));  // Allokerar minne fr block
    LevelData.EnemyPos=malloc(sizeof(struct TItemPos)*(LevelData.EnemyCount+10));  // Allokerar minne fr fiender
    LevelData.ItemPos=malloc(sizeof(struct TItemPos)*(LevelData.ItemCount+10));    // Allokerar minne fr saker
    if (Debug)
      printf("Nollstller minne\n");
    memset(LevelData.BlockPos, 0, LevelData.BlockCount+10);
    memset(LevelData.EnemyPos, 0, LevelData.EnemyCount+10);
    memset(LevelData.ItemPos, 0, LevelData.ItemCount+10);
    LevelData.LevelBitmap=create_bitmap(320, 200);
    clear(LevelData.LevelBitmap);
  }
  if (Debug)
    printf("Start...\n");
  clear(screen);
  set_mouse_range(0,0,320,200);  // Ange grnserna fr hur musen fr flyttas
  position_mouse(0,0);           // och stt vart den ska brja
  set_palette(Dat[Pal_].dat);
  PlayerStartBitmap=create_bitmap(2*8, 8);
  clear(PlayerStartBitmap);
  textout(PlayerStartBitmap, font, "PS", 0, 0, 125);
  EnemyStop1Bitmap=create_bitmap(5*8, 8);
  clear(EnemyStop1Bitmap);
  textout(EnemyStop1Bitmap, font, "Stop1", 0, 0, 125);
  EnemyStop2Bitmap=create_bitmap(5*8, 8);
  clear(EnemyStop2Bitmap);
  textout(EnemyStop2Bitmap, font, "Stop2", 0, 0, 125);
  if (ItemType==0)
    set_mouse_sprite(Texture[ActiveTexture].Bitmap);  // Fixar till s att vi kan se en snygg (?) sprite istllet fr den hemska pilen :)
  if (ItemType==1)
    set_mouse_sprite(Enemy[ActiveEnemy].Bitmap1);
  if (ItemType==2)
    set_mouse_sprite(Item[ActiveItem].Bitmap1);
  if (ItemType==3)
    set_mouse_sprite(PlayerStartBitmap);
  textout(screen, font, MENUTEXT, 0,0,250);  // Jaja  Vi initierar en massa shit...
  hline(screen, 0, 9, 320, 100);
  show_mouse(screen);
  LevelData.xoff=0;
  LevelData.yoff=0;
  LevelData.xinc=LevelData.xdec=FALSE;
  LevelData.yinc=LevelData.ydec=FALSE;
  blit(LevelData.LevelBitmap, screen, 0,0,0,10,320,190);
  while (!done)
  {
    //textprintf(screen, font, 0,50,125,"[%i]     ", key_shifts & 0x000F);
    gKey=0;   // Denna mste nollstllas annars s blir det cp
    get_input();
    switch(gKey)  // Tangenttryckningar
    {
      case 283:   done=TRUE;  // Esc
                  break;
      case 4709:  if (ItemType==0)
                  {
                    position_mouse(mouse_x, mouse_y - Texture[ActiveTexture].Height);  // e
                  }
                  if (ItemType==1)
                    position_mouse(mouse_x, mouse_y - Enemy[ActiveEnemy].Bitmap1->h);  // e
                  if (ItemType==2)
                    position_mouse(mouse_x, mouse_y - Item[ActiveItem].Bitmap1->h);  // e
                  if (ItemType==3)
                    position_mouse(mouse_x, mouse_y - PlayerStartBitmap->h);  // e
                  break;
      case 8550:  if (ItemType==0)
                  {
                    position_mouse(mouse_x + Texture[ActiveTexture].Width, mouse_y);   // f
                  }
                  if (ItemType==1)
                    position_mouse(mouse_x + Enemy[ActiveEnemy].Bitmap1->w, mouse_y);   // f
                  if (ItemType==2)
                    position_mouse(mouse_x + Item[ActiveItem].Bitmap1->w, mouse_y);   // f
                  if (ItemType==3)
                    position_mouse(mouse_x + PlayerStartBitmap->w, mouse_y);   // f
                  break;
      case 8292:  if (ItemType==0)
                  {
                    position_mouse(mouse_x, mouse_y + Texture[ActiveTexture].Height);  // d
                  }
                  if (ItemType==1)
                    position_mouse(mouse_x, mouse_y + Enemy[ActiveEnemy].Bitmap1->h);  // d
                  if (ItemType==2)
                    position_mouse(mouse_x, mouse_y + Item[ActiveItem].Bitmap1->h);  // d
                  if (ItemType==3)
                    position_mouse(mouse_x, mouse_y + PlayerStartBitmap->h);  // d
                  break;
      case 8051:  if (ItemType==0)
                  {
                    position_mouse(mouse_x - Texture[ActiveTexture].Width, mouse_y);   // s
                  }
                  if (ItemType==1)
                    position_mouse(mouse_x - Enemy[ActiveEnemy].Bitmap1->w, mouse_y);   // s
                  if (ItemType==2)
                    position_mouse(mouse_x - Item[ActiveItem].Bitmap1->w, mouse_y);   // s
                  if (ItemType==3)
                    position_mouse(mouse_x - PlayerStartBitmap->w, mouse_y);   // s
                  break;
    }
    if (LevelData.xdec)   // Scrollar vnster
    {
      if (LevelData.xoff>0)
      {
        scare_mouse();  // Man mste skrmma bort musen innan man ska rita ngonting annars blir det vldigt cp
        LevelData.xoff--;            // Left
        blit(LevelData.LevelBitmap, screen, LevelData.xoff, LevelData.yoff,0,10, LevelData.Length, LevelData.Height);
        unscare_mouse();  // Sen r det ju frsts bra att locka fram musen igen, s att vi kan beskda dess sknhet
      }
    }
    if (LevelData.ydec)   // Scrollar upp
    {
      if (LevelData.yoff>0)
      {
        scare_mouse();  // Man mste skrmma bort musen innan man ska rita ngonting annars blir det vldigt cp
        LevelData.yoff--;
        blit(LevelData.LevelBitmap, screen, LevelData.xoff,LevelData.yoff,0,10, LevelData.Length, LevelData.Height);
        unscare_mouse();  // Sen r det ju frsts bra att locka fram musen igen, s att vi kan beskda dess sknhet
      }
    }
    if ((LevelData.xinc) && ((key_shifts & 0x000F) == 0))  // Scrollar hger
    {
      if (LevelData.xoff<(LevelData.Length-320))
      {
        if (LevelData.xoff<(65535-320))
        {
          scare_mouse();
          LevelData.xoff++;            // Right
          blit(LevelData.LevelBitmap, screen, LevelData.xoff,LevelData.yoff,0,10, LevelData.Length, LevelData.Height);
          unscare_mouse();
        }
      }
    }
    if ((LevelData.yinc) && ((key_shifts & 0x000F) == 0))  // Scrollar hger
    {
      if (LevelData.yoff<(LevelData.Height-200))
      {
        if (LevelData.yoff<(65535-200))
        {
          scare_mouse();
          LevelData.yoff++;
          blit(LevelData.LevelBitmap, screen, LevelData.xoff,LevelData.yoff,0,10, LevelData.Length, LevelData.Height);
          unscare_mouse();
        }
      }
    }
    if ((LevelData.xinc) && ((key_shifts & 0x000F) == 2))  // Scrollar hger, och utkar bitmapens storlek om det skulle behvas
    {
      if (LevelData.xoff<(65535-320))
      {
        scare_mouse();
        LevelData.xoff++;            // Right
        if (320+LevelData.xoff>LevelData.Length)
        {
          TempBitmap=create_bitmap(320+LevelData.xoff, LevelData.Height);  // Skapa en temporr bitmap med samma storlek
          clear(TempBitmap);
          blit(LevelData.LevelBitmap, TempBitmap, 0,0,0,0,320+LevelData.xoff-1,LevelData.Height);  // Kopiera till den temporra bitmapen
          destroy_bitmap(LevelData.LevelBitmap);   // Ta bort den gamla
          LevelData.LevelBitmap=create_bitmap(320+LevelData.xoff,190);  // Skapa den gamla p nytt fast lite strre
          clear(LevelData.LevelBitmap);
          blit(TempBitmap, LevelData.LevelBitmap, 0,0,0,0,320+LevelData.xoff, LevelData.Height);  // Lgg tillbaka den innehllet i den nu lite strre bitmapen
          destroy_bitmap(TempBitmap);  // Ta bort tempbitmapen
          LevelData.Length=320+LevelData.xoff;  // Spara lngden i minnet
        }
        blit(LevelData.LevelBitmap, screen, LevelData.xoff, LevelData.yoff,0,10, LevelData.Length, LevelData.Height);
        unscare_mouse();
      }
    }
    if ((LevelData.yinc) && ((key_shifts & 0x000F) == 2))  // Scrollar upp, och utkar bitmapens storlek om det skulle behvas
    {
      if (LevelData.yoff<(65535-200))
      {
        scare_mouse();
        LevelData.yoff++;            // Right
        if (200+LevelData.yoff>LevelData.Height)
        {
          TempBitmap=create_bitmap(LevelData.Length,200+LevelData.yoff);  // Skapa en temporr bitmap med samma storlek
          clear(TempBitmap);
          blit(LevelData.LevelBitmap, TempBitmap, 0,0,0,0,LevelData.Length, 200+LevelData.yoff-1);  // Kopiera till den temporra bitmapen
          destroy_bitmap(LevelData.LevelBitmap);   // Ta bort den gamla
          LevelData.LevelBitmap=create_bitmap(LevelData.Length,200+LevelData.yoff);  // Skapa den gamla p nytt fast lite strre
          clear(LevelData.LevelBitmap);
          blit(TempBitmap, LevelData.LevelBitmap, 0,0,0,0,LevelData.Length, 200+LevelData.yoff);  // Lgg tillbaka den innehllet i den nu lite strre bitmapen
          destroy_bitmap(TempBitmap);  // Ta bort tempbitmapen
          LevelData.Height=200+LevelData.yoff;  // Spara lngden i minnet
        }
        blit(LevelData.LevelBitmap, screen, LevelData.xoff, LevelData.yoff,0,10, LevelData.Length, LevelData.Height);
        unscare_mouse();
      }
    }
    if ((mouse_x>30*8) && (mouse_x<((30*8)+4*8)) && (!draw))  // Koden hr nedan fixar s att man kan klicka med musen om olika delar av texten i vre delen p skrmen
    {
      if (mouse_b==1)
      {
        scare_mouse();
        textout(screen, font, MENUTEXT, 0,0,250);
        textout(screen, font, "Exit", 30*8,0,240);
        blit(LevelData.LevelBitmap, screen, LevelData.xoff, LevelData.yoff,0,10,LevelData.Length,LevelData.Height);
        unscare_mouse();
        Delete=FALSE;
        done=TRUE;
        while (mouse_b & 1) {}
        scare_mouse();
        textout(screen, font, MENUTEXT, 0,0,250);
        unscare_mouse();
      }
    }
    if ((mouse_x>23*8) && (mouse_x<((23*8)+6*8)) && (!draw))
    {
      if (mouse_b==1)
      {
        scare_mouse();
        textout(screen, font, MENUTEXT, 0,0,250);
        textout(screen, font, "Delete", 23*8,0,240);
        blit(LevelData.LevelBitmap, screen, LevelData.xoff, LevelData.yoff,0,10,LevelData.Length,LevelData.Height);
        unscare_mouse();
        Delete=TRUE;
        while (mouse_b & 1) {}
        scare_mouse();
        textout(screen, font, MENUTEXT, 0,0,250);
        unscare_mouse();
      }
    }                       // PlayerStart
    if ((mouse_x>20*8) && (mouse_x<((20*8)+2*8)) && (!draw))
    {
      if (mouse_b==1)
      {
        scare_mouse();
        textout(screen, font, MENUTEXT, 0,0,250);
        textout(screen, font, "PS", 20*8,0,240);
        blit(LevelData.LevelBitmap, screen, LevelData.xoff, LevelData.yoff,0,10,LevelData.Length,LevelData.Height);
        unscare_mouse();
        ItemType=3;
        Delete=FALSE;
        while (mouse_b & 1) {}
        scare_mouse();
        textout(screen, font, MENUTEXT, 0,0,250);
        unscare_mouse();
      }
    }                       // Texture <
    if ((mouse_x>2*8) && (mouse_x<((2*8)+8)) && (!draw))
    {
      if (mouse_b==1)
      {
        scare_mouse();
        textout(screen, font, MENUTEXT, 0,0,250);
        textout(screen, font, "<", 2*8,0,240);
        blit(LevelData.LevelBitmap, screen, LevelData.xoff, LevelData.yoff,0,10,LevelData.Length,LevelData.Height);
        unscare_mouse();
        Delete=FALSE;
        ItemType=0;
        ActiveTexture--;
        if (ActiveTexture<0)
          ActiveTexture=BlockTextureCount-1;
        while (mouse_b & 1) {}
        scare_mouse();
        textout(screen, font, MENUTEXT, 0,0,250);
        unscare_mouse();
      }
    }                       // Texture >
    if ((mouse_x>4*8) && (mouse_x<((4*8)+8)) && (!draw))
    {
      if (mouse_b==1)
      {
        scare_mouse();
        textout(screen, font, MENUTEXT, 0,0,250);
        textout(screen, font, ">", 4*8,0,240);
        blit(LevelData.LevelBitmap, screen, LevelData.xoff, LevelData.yoff,0,10,LevelData.Length,LevelData.Height);
        unscare_mouse();
        Delete=FALSE;
        ItemType=0;
        ActiveTexture++;
        if (ActiveTexture==BlockTextureCount)
          ActiveTexture=0;
        while (mouse_b & 1) {}
        scare_mouse();
        textout(screen, font, MENUTEXT, 0,0,250);
        unscare_mouse();
      }
    }                    // Texture -
    if ((mouse_x>3*8) && (mouse_x<((3*8)+8)) && (!draw))
    {
      if (mouse_b==1)
      {
        scare_mouse();
        textout(screen, font, MENUTEXT, 0,0,250);
        textout(screen, font, "-", 3*8,0,240);
        Delete=FALSE;
        blit(LevelData.LevelBitmap, screen, LevelData.xoff, LevelData.yoff,0,10,LevelData.Length,LevelData.Height);
        unscare_mouse();
        ItemType=0;
        ActiveTexture=0;
        while (mouse_b & 1) {}
        scare_mouse();
        textout(screen, font, MENUTEXT, 0,0,250);
        unscare_mouse();
      }
    }                    // Texture Text
    if ((mouse_x>0*8) && (mouse_x<((0*8)+8)) && (!draw))
    {
      if (mouse_b==1)
      {
        scare_mouse();
        textout(screen, font, MENUTEXT, 0,0,250);
        textout(screen, font, "T", 0*8,0,240);
        Delete=FALSE;
        blit(LevelData.LevelBitmap, screen, LevelData.xoff, LevelData.yoff,0,10,LevelData.Length,LevelData.Height);
        unscare_mouse();
        ItemType=0;
        while (mouse_b & 1) {}
        scare_mouse();
        textout(screen, font, MENUTEXT, 0,0,250);
        unscare_mouse();
      }
    }                    // Enemy <
    if ((mouse_x>9*8) && (mouse_x<((9*8)+8)) && (!draw))
    {
      if (mouse_b==1)
      {
        scare_mouse();
        textout(screen, font, MENUTEXT, 0,0,250);
        textout(screen, font, "<", 9*8,0,240);
        blit(LevelData.LevelBitmap, screen, LevelData.xoff, LevelData.yoff,0,10,LevelData.Length,LevelData.Height);
        unscare_mouse();
        Delete=FALSE;
        ItemType=1;
        ActiveEnemy--;
        if (ActiveEnemy<0)
          ActiveEnemy=EnemyTextureCount-1;
        while (mouse_b & 1) {}
        scare_mouse();
        textout(screen, font, MENUTEXT, 0,0,250);
        unscare_mouse();
      }
    }                       // Enemy >
    if ((mouse_x>11*8) && (mouse_x<((11*8)+8)) && (!draw))
    {
      if (mouse_b==1)
      {
        scare_mouse();
        textout(screen, font, MENUTEXT, 0,0,250);
        textout(screen, font, ">", 11*8,0,240);
        blit(LevelData.LevelBitmap, screen, LevelData.xoff, LevelData.yoff,0,10,LevelData.Length,LevelData.Height);
        unscare_mouse();
        Delete=FALSE;
        ItemType=1;
        ActiveEnemy++;
        if (ActiveEnemy==EnemyTextureCount)
          ActiveEnemy=0;
        while (mouse_b & 1) {}
        scare_mouse();
        textout(screen, font, MENUTEXT, 0,0,250);
        unscare_mouse();
      }
    }                        // Enemy -
    if ((mouse_x>10*8) && (mouse_x<((10*8)+8)) && (!draw))
    {
      if (mouse_b==1)
      {
        scare_mouse();
        textout(screen, font, MENUTEXT, 0,0,250);
        textout(screen, font, "-", 10*8,0,240);
        Delete=FALSE;
        blit(LevelData.LevelBitmap, screen, LevelData.xoff, LevelData.yoff,0,10,LevelData.Length,LevelData.Height);
        unscare_mouse();
        ItemType=1;
        ActiveEnemy=0;
        while (mouse_b & 1) {}
        scare_mouse();
        textout(screen, font, MENUTEXT, 0,0,250);
        unscare_mouse();
      }
    }                       // Enemy Text
    if ((mouse_x>7*8) && (mouse_x<((7*8)+8)) && (!draw))
    {
      if (mouse_b==1)
      {
        scare_mouse();
        textout(screen, font, MENUTEXT, 0,0,250);
        textout(screen, font, "E", 7*8,0,240);
        Delete=FALSE;
        blit(LevelData.LevelBitmap, screen, LevelData.xoff, LevelData.yoff,0,10,LevelData.Length,LevelData.Height);
        unscare_mouse();
        ItemType=1;
        while (mouse_b & 1) {}
        scare_mouse();
        textout(screen, font, MENUTEXT, 0,0,250);
        unscare_mouse();
      }
    }                        // Item <
    if ((mouse_x>16*8) && (mouse_x<((16*8)+8)) && (!draw))
    {
      if (mouse_b==1)
      {
        scare_mouse();
        textout(screen, font, MENUTEXT, 0,0,250);
        textout(screen, font, "<", 16*8,0,240);
        ItemType=2;
        Delete=FALSE;
        blit(LevelData.LevelBitmap, screen, LevelData.xoff, LevelData.yoff,0,10,LevelData.Length,LevelData.Height);
        unscare_mouse();
        ActiveItem--;
        if (ActiveItem<0)
          ActiveItem=ItemTextureCount-1;
        while (mouse_b & 1) {}
        scare_mouse();
        textout(screen, font, MENUTEXT, 0,0,250);
        unscare_mouse();
      }
    }                       // Item >
    if ((mouse_x>18*8) && (mouse_x<((18*8)+8)) && (!draw))
    {
      if (mouse_b==1)
      {
        scare_mouse();
        textout(screen, font, MENUTEXT, 0,0,250);
        textout(screen, font, ">", 18*8,0,240);
        Delete=FALSE;
        blit(LevelData.LevelBitmap, screen, LevelData.xoff, LevelData.yoff,0,10,LevelData.Length,LevelData.Height);
        unscare_mouse();
        ItemType=2;
        ActiveItem++;
        if (ActiveItem==ItemTextureCount)
          ActiveItem=0;
        while (mouse_b & 1) {}
        scare_mouse();
        textout(screen, font, MENUTEXT, 0,0,250);
        unscare_mouse();
      }
    }                        // Item -
    if ((mouse_x>17*8) && (mouse_x<((17*8)+8)) && (!draw))
    {
      if (mouse_b==1)
      {
        scare_mouse();
        textout(screen, font, MENUTEXT, 0,0,250);
        textout(screen, font, "-", 17*8,0,240);
        Delete=FALSE;
        blit(LevelData.LevelBitmap, screen, LevelData.xoff, LevelData.yoff,0,10,LevelData.Length,LevelData.Height);
        unscare_mouse();
        ItemType=2;
        ActiveItem=0;
        while (mouse_b & 1) {}
        scare_mouse();
        textout(screen, font, MENUTEXT, 0,0,250);
        unscare_mouse();
      }
    }                       // Item Text
    if ((mouse_x>14*8) && (mouse_x<((14*8)+8)) && (!draw))
    {
      if (mouse_b==1)
      {
        scare_mouse();
        textout(screen, font, MENUTEXT, 0,0,250);
        textout(screen, font, "I", 14*8,0,240);
        Delete=FALSE;
        blit(LevelData.LevelBitmap, screen, LevelData.xoff, LevelData.yoff,0,10,LevelData.Length,LevelData.Height);
        unscare_mouse();
        ItemType=2;
        while (mouse_b & 1) {}
        scare_mouse();
        textout(screen, font, MENUTEXT, 0,0,250);
        unscare_mouse();
      }
    }
    if ((mouse_y<11) && (draw))  // Fixar s att den vanliga muspekaren syns nr man kommer till den vre delen av skrmen
    {
      set_mouse_sprite(NULL);
      draw=FALSE;
    }
    if ((mouse_y>10) && (!draw))  // Fixar tillbaka dom fina spritsen nr man kommer p ritytan
    {
      if (ItemType==0)
        set_mouse_sprite(Texture[ActiveTexture].Bitmap);  // Fixar till s att vi kan se en snygg (?) sprite istllet fr den hemska pilen :)
      if (ItemType==1)
        set_mouse_sprite(Enemy[ActiveEnemy].Bitmap1);
      if (ItemType==2)
        set_mouse_sprite(Item[ActiveItem].Bitmap1);
      if (ItemType==3)
        set_mouse_sprite(PlayerStartBitmap);
      if (Delete)
        set_mouse_sprite(NULL);
     draw=TRUE;
    }
    if ((mouse_y>10) && (Delete))
    {
      for (a=0;a<LevelData.BlockCount;a++)
      {
        if (((mouse_x+LevelData.xoff)>LevelData.BlockPos[a].x) && ((mouse_y-10+LevelData.yoff)>LevelData.BlockPos[a].y) && ((mouse_x+LevelData.xoff)<(LevelData.BlockPos[a].x+Texture[LevelData.BlockPos[a].ident].Bitmap->w)) && ((mouse_y-10+LevelData.yoff)<(LevelData.BlockPos[a].y+Texture[LevelData.BlockPos[a].ident].Bitmap->h)) && (LastIdent!=a))
        {
          LastIdent=a;
          DeleteType=0;
          scare_mouse();
          blit(LevelData.LevelBitmap, screen, LevelData.xoff, LevelData.yoff,0,10,LevelData.Length,LevelData.Height);
          for (x=LevelData.BlockPos[a].x;x<(LevelData.BlockPos[a].x+Texture[LevelData.BlockPos[a].ident].Bitmap->w);x+=2)
          {
            for (y=LevelData.BlockPos[a].y;y<(LevelData.BlockPos[a].y+Texture[LevelData.BlockPos[a].ident].Bitmap->h);y+=2)
            {
              _putpixel(screen, x-LevelData.xoff, y+10-LevelData.yoff, 125);
            }
          }
          unscare_mouse();
          break;
        }
      }
      for (a=0;a<LevelData.EnemyCount;a++)
      {
        if (((mouse_x+LevelData.xoff)>LevelData.EnemyPos[a].x) && ((mouse_y-10+LevelData.yoff)>LevelData.EnemyPos[a].y) && ((mouse_x+LevelData.xoff)<(LevelData.EnemyPos[a].x+Enemy[LevelData.EnemyPos[a].ident].Bitmap1->w)) && ((mouse_y-10+LevelData.yoff)<(LevelData.EnemyPos[a].y+Enemy[LevelData.EnemyPos[a].ident].Bitmap1->h)) && (LastIdent!=a))
        {
          LastIdent=a;
          DeleteType=1;
          scare_mouse();
          blit(LevelData.LevelBitmap, screen, LevelData.xoff, LevelData.yoff,0,10,LevelData.Length,LevelData.Height);
          for (x=LevelData.EnemyPos[a].x;x<(LevelData.EnemyPos[a].x+Enemy[LevelData.EnemyPos[a].ident].Bitmap1->w);x+=2)
          {
            for (y=LevelData.EnemyPos[a].y;y<(LevelData.EnemyPos[a].y+Enemy[LevelData.EnemyPos[a].ident].Bitmap1->h);y+=2)
            {
              _putpixel(screen, x-LevelData.xoff, y+10-LevelData.yoff, 125);
            }
          }
          unscare_mouse();
          break;
        }
      }
      for (a=0;a<LevelData.ItemCount;a++)
      {
        if (((mouse_x+LevelData.xoff)>LevelData.ItemPos[a].x) && ((mouse_y-10+LevelData.yoff)>LevelData.ItemPos[a].y) && ((mouse_x+LevelData.xoff)<(LevelData.ItemPos[a].x+Item[LevelData.ItemPos[a].ident].Bitmap1->w)) && ((mouse_y-10+LevelData.yoff)<(LevelData.ItemPos[a].y+Item[LevelData.ItemPos[a].ident].Bitmap1->h)) && (LastIdent!=a))
        {
          LastIdent=a;
          DeleteType=2;
          scare_mouse();
          blit(LevelData.LevelBitmap, screen, LevelData.xoff, LevelData.yoff,0,10,LevelData.Length,LevelData.Height);
          for (x=LevelData.ItemPos[a].x;x<(LevelData.ItemPos[a].x+Item[LevelData.ItemPos[a].ident].Bitmap1->w);x+=2)
          {
            for (y=LevelData.ItemPos[a].y;y<(LevelData.ItemPos[a].y+Item[LevelData.ItemPos[a].ident].Bitmap1->h);y+=2)
            {
              _putpixel(screen, x-LevelData.xoff, y+10-LevelData.yoff, 125);
            }
          }
          unscare_mouse();
          break;
        }
      }
    }
    if ((Delete) &&  (mouse_b==1))
    {
      if (DeleteType==0)
      {
        for (a=LastIdent;a<LevelData.BlockCount-1;a++)
        {
          LevelData.BlockPos[a].x=LevelData.BlockPos[a+1].x;
          LevelData.BlockPos[a].y=LevelData.BlockPos[a+1].y;
          LevelData.BlockPos[a].ident=LevelData.BlockPos[a+1].ident;
        }
        LevelData.BlockCount--;
        TempPos=malloc(sizeof(struct TItemPos)*(LevelData.BlockCount+10));
        memcpy(TempPos, LevelData.BlockPos, sizeof(struct TItemPos)*LevelData.BlockCount);
        LevelData.BlockPos=realloc(LevelData.BlockPos, sizeof(struct TItemPos)*(LevelData.BlockCount+10));
        memcpy(LevelData.BlockPos, TempPos, sizeof(struct TItemPos)*LevelData.BlockCount);
        free(TempPos);
        scare_mouse();
        clear(LevelData.LevelBitmap);
        for (a=0;a<LevelData.BlockCount;a++)
        {
          masked_blit(Texture[LevelData.BlockPos[a].ident].Bitmap, LevelData.LevelBitmap,  0, 0, LevelData.BlockPos[a].x, LevelData.BlockPos[a].y, Texture[LevelData.BlockPos[a].ident].Width, Texture[LevelData.BlockPos[a].ident].Height);
        }
        for (a=0;a<LevelData.EnemyCount;a++)
        {
          masked_blit(Enemy[LevelData.EnemyPos[a].ident].Bitmap1, LevelData.LevelBitmap,  0, 0, LevelData.EnemyPos[a].x, LevelData.EnemyPos[a].y, Enemy[LevelData.EnemyPos[a].ident].Bitmap1->w, Enemy[LevelData.EnemyPos[a].ident].Bitmap1->h);
        }
        for (a=0;a<LevelData.ItemCount;a++)
        {
          masked_blit(Item[LevelData.ItemPos[a].ident].Bitmap1, LevelData.LevelBitmap,  0, 0, LevelData.ItemPos[a].x, LevelData.ItemPos[a].y, Item[LevelData.ItemPos[a].ident].Bitmap1->w, Item[LevelData.ItemPos[a].ident].Bitmap1->h);
        }
        masked_blit(PlayerStartBitmap, LevelData.LevelBitmap, 0,0, Player.StartX, Player.StartY, PlayerStartBitmap->w, PlayerStartBitmap->h);
        hline(screen, 0, 9, 320, 100);
        blit(LevelData.LevelBitmap, screen, LevelData.xoff,LevelData.yoff,0,10,LevelData.Length,LevelData.Height);
        unscare_mouse();
        DeleteType=1000;
      }
      if (DeleteType==1)
      {
        for (a=LastIdent;a<LevelData.EnemyCount-1;a++)
        {
          LevelData.EnemyPos[a].x=LevelData.EnemyPos[a+1].x;
          LevelData.EnemyPos[a].y=LevelData.EnemyPos[a+1].y;
          LevelData.EnemyPos[a].ident=LevelData.EnemyPos[a+1].ident;
        }
        LevelData.EnemyCount--;
        TempPos=malloc(sizeof(struct TItemPos)*(LevelData.EnemyCount+10));
        memcpy(TempPos, LevelData.EnemyPos, sizeof(struct TItemPos)*LevelData.EnemyCount);
        LevelData.EnemyPos=realloc(LevelData.EnemyPos, sizeof(struct TItemPos)*(LevelData.EnemyCount+10));
        memcpy(LevelData.EnemyPos, TempPos, sizeof(struct TItemPos)*LevelData.EnemyCount);
        free(TempPos);
        scare_mouse();
        clear(LevelData.LevelBitmap);
        for (a=0;a<LevelData.BlockCount;a++)
        {
          masked_blit(Texture[LevelData.BlockPos[a].ident].Bitmap, LevelData.LevelBitmap,  0, 0, LevelData.BlockPos[a].x, LevelData.BlockPos[a].y, Texture[LevelData.BlockPos[a].ident].Width, Texture[LevelData.BlockPos[a].ident].Height);
        }
        for (a=0;a<LevelData.EnemyCount;a++)
        {
          masked_blit(Enemy[LevelData.EnemyPos[a].ident].Bitmap1, LevelData.LevelBitmap,  0, 0, LevelData.EnemyPos[a].x, LevelData.EnemyPos[a].y, Enemy[LevelData.EnemyPos[a].ident].Bitmap1->w, Enemy[LevelData.EnemyPos[a].ident].Bitmap1->h);
        }
        for (a=0;a<LevelData.ItemCount;a++)
        {
          masked_blit(Item[LevelData.ItemPos[a].ident].Bitmap1, LevelData.LevelBitmap,  0, 0, LevelData.ItemPos[a].x, LevelData.ItemPos[a].y, Item[LevelData.ItemPos[a].ident].Bitmap1->w, Item[LevelData.ItemPos[a].ident].Bitmap1->h);
        }
        masked_blit(PlayerStartBitmap, LevelData.LevelBitmap, 0,0, Player.StartX, Player.StartY, PlayerStartBitmap->w, PlayerStartBitmap->h);
        hline(screen, 0, 9, 320, 100);
        blit(LevelData.LevelBitmap, screen, LevelData.xoff,LevelData.yoff,0,10,LevelData.Length,LevelData.Height);
        unscare_mouse();
        DeleteType=1000;
      }
      if (DeleteType==2)
      {
        for (a=LastIdent;a<LevelData.ItemCount-1;a++)
        {
          LevelData.ItemPos[a].x=LevelData.ItemPos[a+1].x;
          LevelData.ItemPos[a].y=LevelData.ItemPos[a+1].y;
          LevelData.ItemPos[a].ident=LevelData.ItemPos[a+1].ident;
        }
        LevelData.ItemCount--;
        TempPos=malloc(sizeof(struct TItemPos)*(LevelData.ItemCount+10));
        memcpy(TempPos, LevelData.ItemPos, sizeof(struct TItemPos)*LevelData.ItemCount);
        LevelData.ItemPos=realloc(LevelData.ItemPos, sizeof(struct TItemPos)*(LevelData.ItemCount+10));
        memcpy(LevelData.ItemPos, TempPos, sizeof(struct TItemPos)*LevelData.ItemCount);
        free(TempPos);
        scare_mouse();
        clear(LevelData.LevelBitmap);
        for (a=0;a<LevelData.BlockCount;a++)
        {
          masked_blit(Texture[LevelData.BlockPos[a].ident].Bitmap, LevelData.LevelBitmap,  0, 0, LevelData.BlockPos[a].x, LevelData.BlockPos[a].y, Texture[LevelData.BlockPos[a].ident].Width, Texture[LevelData.BlockPos[a].ident].Height);
        }
        for (a=0;a<LevelData.EnemyCount;a++)
        {
          masked_blit(Enemy[LevelData.EnemyPos[a].ident].Bitmap1, LevelData.LevelBitmap,  0, 0, LevelData.EnemyPos[a].x, LevelData.EnemyPos[a].y, Enemy[LevelData.EnemyPos[a].ident].Bitmap1->w, Enemy[LevelData.EnemyPos[a].ident].Bitmap1->h);
        }
        for (a=0;a<LevelData.ItemCount;a++)
        {
          masked_blit(Item[LevelData.ItemPos[a].ident].Bitmap1, LevelData.LevelBitmap,  0, 0, LevelData.ItemPos[a].x, LevelData.ItemPos[a].y, Item[LevelData.ItemPos[a].ident].Bitmap1->w, Item[LevelData.ItemPos[a].ident].Bitmap1->h);
        }
        masked_blit(PlayerStartBitmap, LevelData.LevelBitmap, 0,0, Player.StartX, Player.StartY, PlayerStartBitmap->w, PlayerStartBitmap->h);
        hline(screen, 0, 9, 320, 100);
        blit(LevelData.LevelBitmap, screen, LevelData.xoff,LevelData.yoff,0,10,LevelData.Length,LevelData.Height);
        unscare_mouse();
        DeleteType=1000;
      }
    }
    if ((mouse_b==1) && (draw) && (!Delete))  // Placerar en sprite p skrmen samt sparar den i minnet
    {
      if (ItemType==0)
      {
        scare_mouse();
        LevelData.BlockPos[LevelData.BlockCount].x=mouse_x-1+LevelData.xoff;  // Spara i minnet   -1 har jag fr att musens positioner tydligen inte riktigt stmmer med skrmkoordinaterna
        LevelData.BlockPos[LevelData.BlockCount].y=mouse_y-11+LevelData.yoff; // Minus 11 fr att ta bort den lilla kanten lngst  upp p skrmen som r 10 pixlar stor
        LevelData.BlockPos[LevelData.BlockCount].ident=ActiveTexture;
        LevelData.BlockPos[LevelData.BlockCount].Stop1x=0;
        LevelData.BlockPos[LevelData.BlockCount].Stop1y=0;
        LevelData.BlockPos[LevelData.BlockCount].Stop2x=0;
        LevelData.BlockPos[LevelData.BlockCount].Stop2y=0;

        unscare_mouse();
        if ((ActiveTexture==15) || (ActiveTexture==16))
        {
          //while (mouse_b & 1) {}
          //set_mouse_sprite(EnemyStop1Bitmap);
          //while (!mouse_b==1) {}
          LevelData.BlockPos[LevelData.BlockCount].Stop1x=LevelData.BlockPos[LevelData.BlockCount].x;
          LevelData.BlockPos[LevelData.BlockCount].Stop1y=LevelData.BlockPos[LevelData.BlockCount].y;
          while (mouse_b & 1) {}
          //set_mouse_sprite(EnemyStop2Bitmap);
          scare_mouse();
          while (!mouse_b==1)
          {
            vsync();
            blit(LevelData.LevelBitmap, screen, LevelData.xoff,LevelData.yoff,0,10,LevelData.Length,LevelData.Height);
            line(screen, LevelData.BlockPos[LevelData.BlockCount].x-LevelData.xoff, LevelData.BlockPos[LevelData.BlockCount].y+10-LevelData.yoff, mouse_x-1, mouse_y-1, 100);
            masked_blit(Texture[ActiveTexture].Bitmap, screen, 0,0,mouse_x-1, mouse_y-1, Texture[ActiveTexture].Width, Texture[ActiveTexture].Height);
          }
          unscare_mouse();
          LevelData.BlockPos[LevelData.BlockCount].Stop2x=mouse_x-1+LevelData.xoff;
          LevelData.BlockPos[LevelData.BlockCount].Stop2y=mouse_y-11+LevelData.yoff;
          while (mouse_b & 1) {}
          set_mouse_sprite(Texture[ActiveTexture].Bitmap);
        }
        scare_mouse();

        LevelData.BlockCount++;
        //TempPos=malloc(sizeof(struct TItemPos)*(LevelData.BlockCount+10));    // Allokerar minne fr saker
        //memcpy(TempPos, LevelData.BlockPos, sizeof(struct TItemPos)*LevelData.BlockCount);
        LevelData.BlockPos= (struct TItemPos*)xrealloc(LevelData.BlockPos, sizeof(struct TItemPos)*(LevelData.BlockCount+10));
        //memcpy(LevelData.BlockPos, TempPos, sizeof(struct TItemPos)*LevelData.BlockCount);
        //free(TempPos);
        masked_blit(Texture[ActiveTexture].Bitmap, LevelData.LevelBitmap, 0,0,mouse_x-1+LevelData.xoff, mouse_y-11+LevelData.yoff, Texture[ActiveTexture].Width, Texture[ActiveTexture].Height);
        vsync();
        hline(screen, 0, 9, 320, 100);
        blit(LevelData.LevelBitmap, screen, LevelData.xoff,LevelData.yoff,0,10,LevelData.Length,LevelData.Height);
        //textprintf(screen, font, 0, 50, 125, "X:%i Y:%i I:%i ", LevelData.BlockPos[LevelData.BlockCount-1].x, LevelData.BlockPos[LevelData.BlockCount-1].y, LevelData.BlockPos[LevelData.BlockCount-1].ident);
        unscare_mouse();
        while (mouse_b & 1) {}
      }
      if (ItemType==1)
      {
        scare_mouse();
        LevelData.EnemyPos[LevelData.EnemyCount].x=mouse_x-1+LevelData.xoff;
        LevelData.EnemyPos[LevelData.EnemyCount].y=mouse_y-11+LevelData.yoff;
        LevelData.EnemyPos[LevelData.EnemyCount].ident=ActiveEnemy;
        masked_blit(Enemy[ActiveEnemy].Bitmap1, LevelData.LevelBitmap, 0,0,mouse_x-1+LevelData.xoff, mouse_y-11+LevelData.yoff, Enemy[ActiveEnemy].Bitmap1->w, Enemy[ActiveEnemy].Bitmap1->h);
        vsync();
        hline(screen, 0, 9, 320, 100);
        blit(LevelData.LevelBitmap, screen, LevelData.xoff,LevelData.yoff,0,10,LevelData.Length,LevelData.Height);
        unscare_mouse();
        while (mouse_b & 1) {}
        set_mouse_sprite(EnemyStop1Bitmap);
        while (!mouse_b==1) {}
        LevelData.EnemyPos[LevelData.EnemyCount].Stop1x=mouse_x-1+LevelData.xoff;
        LevelData.EnemyPos[LevelData.EnemyCount].Stop1y=mouse_y-11+LevelData.yoff;
        while (mouse_b & 1) {}
        set_mouse_sprite(EnemyStop2Bitmap);
        while (!mouse_b==1) {}
        LevelData.EnemyPos[LevelData.EnemyCount].Stop2x=mouse_x-1+LevelData.xoff;
        LevelData.EnemyPos[LevelData.EnemyCount].Stop2y=mouse_y-11+LevelData.yoff;
        while (mouse_b & 1) {}
        set_mouse_sprite(Enemy[ActiveEnemy].Bitmap1);
        //textprintf(screen, font, 0,50,125,"[X1: %i] [X2: %i]", LevelData.EnemyPos[LevelData.EnemyCount].Stop1x, LevelData.EnemyPos[LevelData.EnemyCount].Stop2x);
        LevelData.EnemyCount++;
        //TempPos=malloc(sizeof(struct TItemPos)*(LevelData.EnemyCount+10));    // Allokerar minne fr saker
        //memcpy(TempPos, LevelData.EnemyPos, sizeof(struct TItemPos)*LevelData.EnemyCount);
        LevelData.EnemyPos=realloc(LevelData.EnemyPos, sizeof(struct TItemPos)*(LevelData.EnemyCount+10));
        //memcpy(LevelData.EnemyPos, TempPos, sizeof(struct TItemPos)*LevelData.EnemyCount);
        //free(TempPos);
        //textprintf(screen, font, 0,50+8,125,"[X1: %i] [X2: %i]", LevelData.EnemyPos[LevelData.EnemyCount-1].Stop1x, LevelData.EnemyPos[LevelData.EnemyCount-1].Stop2x);
      }
      if (ItemType==2)
      {
        scare_mouse();
        LevelData.ItemPos[LevelData.ItemCount].x=mouse_x-1+LevelData.xoff;
        LevelData.ItemPos[LevelData.ItemCount].y=mouse_y-11+LevelData.yoff;
        LevelData.ItemPos[LevelData.ItemCount].ident=ActiveItem;
        LevelData.ItemPos[LevelData.ItemCount].Stop1x=0;
        LevelData.ItemPos[LevelData.ItemCount].Stop1y=0;
        LevelData.ItemPos[LevelData.ItemCount].Stop2x=0;
        LevelData.ItemPos[LevelData.ItemCount].Stop2y=0;
        LevelData.ItemCount++;
        //TempPos=malloc(sizeof(struct TItemPos)*(LevelData.ItemCount+10));    // Allokerar minne fr saker
        //memcpy(TempPos, LevelData.ItemPos, sizeof(struct TItemPos)*LevelData.ItemCount);
        LevelData.ItemPos=realloc(LevelData.ItemPos, sizeof(struct TItemPos)*(LevelData.ItemCount+10));
        //memcpy(LevelData.ItemPos, TempPos, sizeof(struct TItemPos)*LevelData.ItemCount);
        //free(TempPos);
        masked_blit(Item[ActiveItem].Bitmap1, LevelData.LevelBitmap, 0,0,mouse_x-1+LevelData.xoff, mouse_y-11+LevelData.yoff, Item[ActiveItem].Bitmap1->w, Item[ActiveItem].Bitmap1->h);
        vsync();
        hline(screen, 0, 9, 320, 100);
        blit(LevelData.LevelBitmap, screen, LevelData.xoff,LevelData.yoff,0,10,LevelData.Length,LevelData.Height);
        //textprintf(screen, font, 0,20,100, "X %i Y %i   ", LevelData.ItemPos[LevelData.ItemCount-1].x, LevelData.ItemPos[LevelData.ItemCount-1].y);
        unscare_mouse();
        while (mouse_b & 1) {}
      }
      if ((ItemType==3))
      {
        scare_mouse();
        Player.x=mouse_x-1+LevelData.xoff;
        Player.y=mouse_y-11+LevelData.yoff;
        Player.StartX=Player.x;
        Player.StartY=Player.y;
        //masked_blit(PlayerStartBitmap, LevelData.LevelBitmap, 0,0,mouse_x-1+LevelData.xoff, mouse_y-11, PlayerStartBitmap->w, PlayerStartBitmap->h);
        //vsync();
        //hline(screen, 0, 9, 320, 100);
        //blit(LevelData.LevelBitmap, screen, LevelData.xoff,0,0,10,LevelData.Length,190);
        clear(LevelData.LevelBitmap);
        for (a=0;a<LevelData.BlockCount;a++)
        {
          masked_blit(Texture[LevelData.BlockPos[a].ident].Bitmap, LevelData.LevelBitmap,  0, 0, LevelData.BlockPos[a].x, LevelData.BlockPos[a].y, Texture[LevelData.BlockPos[a].ident].Width, Texture[LevelData.BlockPos[a].ident].Height);
        }
        for (a=0;a<LevelData.EnemyCount;a++)
        {
          masked_blit(Enemy[LevelData.EnemyPos[a].ident].Bitmap1, LevelData.LevelBitmap,  0, 0, LevelData.EnemyPos[a].x, LevelData.EnemyPos[a].y, Enemy[LevelData.EnemyPos[a].ident].Bitmap1->w, Enemy[LevelData.EnemyPos[a].ident].Bitmap1->h);
        }
        for (a=0;a<LevelData.ItemCount;a++)
        {
          masked_blit(Item[LevelData.ItemPos[a].ident].Bitmap1, LevelData.LevelBitmap,  0, 0, LevelData.ItemPos[a].x, LevelData.ItemPos[a].y, Item[LevelData.ItemPos[a].ident].Bitmap1->w, Item[LevelData.ItemPos[a].ident].Bitmap1->h);
        }
        masked_blit(PlayerStartBitmap, LevelData.LevelBitmap, 0,0, Player.StartX, Player.StartY, PlayerStartBitmap->w, PlayerStartBitmap->h);
        hline(screen, 0, 9, 320, 100);
        blit(LevelData.LevelBitmap, screen, LevelData.xoff,LevelData.yoff,0,10,LevelData.Length,LevelData.Height);
        unscare_mouse();
        while (mouse_b & 1) {}
      }
    }
    if ((mouse_b==2) && (draw) && (!Delete))  // Nsta textur  (Hgerknappen)
    {
      if (ItemType==0)
      {
        ActiveTexture++;
        if (ActiveTexture==BlockTextureCount)
          ActiveTexture=0;
        set_mouse_sprite(Texture[ActiveTexture].Bitmap);
      }
      if (ItemType==1)
      {
        ActiveEnemy++;
        if (ActiveEnemy==EnemyTextureCount)
          ActiveEnemy=0;
        set_mouse_sprite(Enemy[ActiveEnemy].Bitmap1);
      }
      if (ItemType==2)
      {
        ActiveItem++;
        if (ActiveItem==ItemTextureCount)
          ActiveItem=0;
        set_mouse_sprite(Item[ActiveItem].Bitmap1);
      }
      while (mouse_b & 2) {}
    }
    if ((mouse_b==4) && (draw) && (!Delete))  // Fregende textur (Mittenknappen)
    {
    if (ItemType==0)
      {
        ActiveTexture--;
        if (ActiveTexture==-1)
          ActiveTexture=BlockTextureCount-1;
        set_mouse_sprite(Texture[ActiveTexture].Bitmap);
      }
    if (ItemType==1)
      {
        ActiveEnemy--;
        if (ActiveEnemy==-1)
          ActiveEnemy=EnemyTextureCount-1;
        set_mouse_sprite(Enemy[ActiveEnemy].Bitmap1);
      }
    if (ItemType==2)
      {
        ActiveItem--;
        if (ActiveItem==-1)
          ActiveItem=ItemTextureCount-1;
        set_mouse_sprite(Item[ActiveItem].Bitmap1);
      }
      while (mouse_b & 4) {}
    }
  }
  //  textprintf(screen, font, 0, 12, 100, "%i", F);

  // Spara banan!

  F=fopen(filename, "wb");
  fseek(F, 0, SEEK_SET);
/*  textprintf(screen, font, 0, 20, 100, "%i : %i", ferror(F), F);
  readkey();*/
  fputs("LGL100", F);
  fputs("Test Level 6", F);
  fseek(F, 26, SEEK_SET);
  fputc(lo(0xACFF), F);
  fputc(hi(0xACFF), F);
  fputc(lo(LevelData.Length), F);
  fputc(hi(LevelData.Length), F);
  fputc(lo(LevelData.Height), F);
  fputc(hi(LevelData.Height), F);
  fputc(lo(LevelData.BlockCount), F);
  fputc(hi(LevelData.BlockCount), F);
  fputc(lo(LevelData.EnemyCount), F);
  fputc(hi(LevelData.EnemyCount), F);
  fputc(lo(LevelData.ItemCount), F);
  fputc(hi(LevelData.ItemCount), F);
  fputc(lo(Player.x), F);
  fputc(hi(Player.x), F);
  fputc(lo(Player.y), F);
  fputc(hi(Player.y), F);
  for (a=0;a<LevelData.BlockCount;a++)
  {
    fputc(lo(LevelData.BlockPos[a].ident), F);
    fputc(hi(LevelData.BlockPos[a].ident), F);
    fputc(lo(LevelData.BlockPos[a].x), F);
    fputc(hi(LevelData.BlockPos[a].x), F);
    fputc(lo(LevelData.BlockPos[a].y), F);
    fputc(hi(LevelData.BlockPos[a].y), F);
    fputc(lo(LevelData.BlockPos[a].Stop1x), F);
    fputc(hi(LevelData.BlockPos[a].Stop1x), F);
    fputc(lo(LevelData.BlockPos[a].Stop1y), F);
    fputc(hi(LevelData.BlockPos[a].Stop1y), F);
    fputc(lo(LevelData.BlockPos[a].Stop2x), F);
    fputc(hi(LevelData.BlockPos[a].Stop2x), F);
    fputc(lo(LevelData.BlockPos[a].Stop2y), F);
    fputc(hi(LevelData.BlockPos[a].Stop2y), F);
  }
  for (a=0;a<LevelData.EnemyCount;a++)
  {
    fputc(lo(LevelData.EnemyPos[a].ident), F);
    fputc(hi(LevelData.EnemyPos[a].ident), F);
    fputc(lo(LevelData.EnemyPos[a].x), F);
    fputc(hi(LevelData.EnemyPos[a].x), F);
    fputc(lo(LevelData.EnemyPos[a].y), F);
    fputc(hi(LevelData.EnemyPos[a].y), F);
    fputc(lo(LevelData.EnemyPos[a].Stop1x), F);
    fputc(hi(LevelData.EnemyPos[a].Stop1x), F);
    fputc(lo(LevelData.EnemyPos[a].Stop1y), F);
    fputc(hi(LevelData.EnemyPos[a].Stop1y), F);
    fputc(lo(LevelData.EnemyPos[a].Stop2x), F);
    fputc(hi(LevelData.EnemyPos[a].Stop2x), F);
    fputc(lo(LevelData.EnemyPos[a].Stop2y), F);
    fputc(hi(LevelData.EnemyPos[a].Stop2y), F);
  }
  for (a=0;a<LevelData.ItemCount;a++)
  {
    fputc(lo(LevelData.ItemPos[a].ident), F);
    fputc(hi(LevelData.ItemPos[a].ident), F);
    fputc(lo(LevelData.ItemPos[a].x), F);
    fputc(hi(LevelData.ItemPos[a].x), F);
    fputc(lo(LevelData.ItemPos[a].y), F);
    fputc(hi(LevelData.ItemPos[a].y), F);
    fputc(lo(LevelData.ItemPos[a].Stop1x), F);
    fputc(hi(LevelData.ItemPos[a].Stop1x), F);
    fputc(lo(LevelData.ItemPos[a].Stop1y), F);
    fputc(hi(LevelData.ItemPos[a].Stop1y), F);
    fputc(lo(LevelData.ItemPos[a].Stop2x), F);
    fputc(hi(LevelData.ItemPos[a].Stop2x), F);
    fputc(lo(LevelData.ItemPos[a].Stop2y), F);
    fputc(hi(LevelData.ItemPos[a].Stop2y), F);
  }
  fclose(F);
  //save_pcx("Levelbmp1.pcx" ,LevelData.LevelBitmap, Texture[0].Pal);
  return 0;
}


int load_textures()
{
  int j, i=0;
  Dat=load_datafile("./gfx.dat");
  Pfont=(FONT *) Dat[Pfont_].dat;
  i=Block1_;
  for (j=0;j<TEXTURECOUNT;j++)
  {
    Texture[j].Bitmap=Dat[i].dat;
    Texture[j].Width=Texture[j].Bitmap->w;
    Texture[j].Height=Texture[j].Bitmap->h;
    i++;
  }
  Studs[0].Bitmap=(BITMAP *) Dat[Studs1_].dat;
  Studs[1].Bitmap=(BITMAP *) Dat[Studs2_].dat;
  Studs[2].Bitmap=(BITMAP *) Dat[Studs3_].dat;
  Studs[3].Bitmap=(BITMAP *) Dat[Studs4_].dat;

  Fan[0].Bitmap=(BITMAP *) Dat[Fan1_].dat;
  Fan[1].Bitmap=(BITMAP *) Dat[Fan2_].dat;

  Player.Bitmap1=(BITMAP *) Dat[Player1_1_].dat;
  Player.Bitmap2=(BITMAP *) Dat[Player1_2_].dat;
  Player.Bitmap3=(BITMAP *) Dat[Player1_3_].dat;
  Player.Bitmap4=(BITMAP *) Dat[Player1_4_].dat;
  Player.Bitmap5=(BITMAP *) Dat[Player2_1_].dat;
  Player.Bitmap6=(BITMAP *) Dat[Player2_2_].dat;
  Player.Bitmap7=(BITMAP *) Dat[Player2_3_].dat;
  Player.Bitmap8=(BITMAP *) Dat[Player2_4_].dat;
  Player.Bitmap9=(BITMAP *) Dat[Player3_1_].dat;
  Player.Bitmap10=(BITMAP *) Dat[Player3_2_].dat;
  Player.Bitmap11=(BITMAP *) Dat[Player4_1_].dat;
  Player.Bitmap12=(BITMAP *) Dat[Player4_2_].dat;
  Player.Bitmap13=(BITMAP *) Dat[Player4_3_].dat;
  Player.Bitmap14=(BITMAP *) Dat[Player5_1_].dat;
  Player.Bitmap15=(BITMAP *) Dat[Player5_2_].dat;
  Player.Bitmap16=(BITMAP *) Dat[Player5_3_].dat;
  i=Enemy1_1_;
  for (j=0;j<ENEMYCOUNT;j++)
  {
    Enemy[j].Bitmap1=(BITMAP *) Dat[i].dat;
    i++;
    Enemy[j].Bitmap2=(BITMAP *) Dat[i].dat;
    i++;
    Enemy[j].Bitmap3=(BITMAP *) Dat[i].dat;
    i++;
    Enemy[j].Bitmap4=(BITMAP *) Dat[i].dat;
    i++;
    Enemy[j].Bitmap5=(BITMAP *) Dat[i].dat;
    i++;
    Enemy[j].Bitmap6=(BITMAP *) Dat[i].dat;
    i++;
    Enemy[j].Bitmap7=(BITMAP *) Dat[i].dat;
    i++;
    Enemy[j].Bitmap8=(BITMAP *) Dat[i].dat;
    i++;
  }
  i=Item1_1_;
  for (j=0;j<ITEMCOUNT;j++)
  {
    Item[j].Bitmap1=(BITMAP *) Dat[i].dat;
    i++;
    Item[j].Bitmap2=(BITMAP *) Dat[i].dat;
    i++;
    Item[j].Bitmap3=(BITMAP *) Dat[i].dat;
    i++;
    Item[j].Bitmap4=(BITMAP *) Dat[i].dat;
    i++;
  }
  LevelData.Background=(BITMAP *) Dat[Backgr1_].dat;
  StatusBarBitmap=(BITMAP *) Dat[Status1_].dat;
  if ((!Nomusic) && (!Design)  && (Sfx))
  {
    if ((SndSample[0].Sample=MIDASloadWaveSample("./sound/Snd1.wav", MIDAS_LOOP_NO))==NULL)
      MIDASerror();
    if ((SndSample[1].Sample=MIDASloadWaveSample("./sound/Snd2.wav", MIDAS_LOOP_NO))==NULL)
      MIDASerror();
    if ((SndSample[2].Sample=MIDASloadWaveSample("./sound/Snd3.wav", MIDAS_LOOP_NO))==NULL)
      MIDASerror();
    if ((SndSample[3].Sample=MIDASloadWaveSample("./sound/Snd4.wav", MIDAS_LOOP_NO))==NULL)
      MIDASerror();
    if ((SndSample[4].Sample=MIDASloadWaveSample("./sound/Snd5.wav", MIDAS_LOOP_NO))==NULL)
      MIDASerror();
  }
  return 0;
}

/*
int load_textures()
{
  typedef struct TTextureFilename
  {
    char *a;
    char *b;
  } TTextureFilename;
  int j;
  TTextureFilename TextureFilename[TEXTURECOUNT+2];
  char *PlayerTextureFilename;
  for (j=0;j<TEXTURECOUNT;j++)
  {
    TextureFilename[j].a=malloc(sizeof(char)*(20));
    TextureFilename[j].b=malloc(sizeof(char)*(20));
  }
  PlayerTextureFilename=malloc(sizeof(char)*(20));
  Dat=load_datafile("pfont.dat");
  Pfont=(FONT *) Dat[0].dat;
  TextureFilename[0].a="Block1.pcx";
  TextureFilename[1].a="Block2.pcx";
  TextureFilename[2].a="Block3.pcx";
  TextureFilename[3].a="Block4.pcx";
  TextureFilename[4].a="Block5.pcx";
  TextureFilename[5].a="Block6.pcx";
  TextureFilename[6].a="Topp1.pcx";
  TextureFilename[7].a="Pipe1.pcx";
  TextureFilename[8].a="Block7.pcx";
  TextureFilename[9].a="Block8.pcx";
  TextureFilename[10].a="Block9.pcx";
  TextureFilename[11].a="Block10.pcx";
  TextureFilename[12].a="Block11.pcx";
  TextureFilename[13].a="Ladder1.pcx";
  TextureFilename[14].a="Platta1.pcx";
  TextureFilename[15].a="Studs1.pcx";
  TextureFilename[16].a="Block12.pcx";
  for (j=0;j<TEXTURECOUNT;j++)
  {
    Texture[j].Bitmap=load_bitmap(TextureFilename[j].a, Texture[j].Pal);
    Texture[j].Width=Texture[j].Bitmap->w;
    Texture[j].Height=Texture[j].Bitmap->h;
  }
  PlayerTextureFilename="Studs1.pcx";
  Studs[0].Bitmap=load_bitmap(PlayerTextureFilename, Player.Pal);
  PlayerTextureFilename="Studs2.pcx";
  Studs[1].Bitmap=load_bitmap(PlayerTextureFilename, Player.Pal);
  PlayerTextureFilename="Studs3.pcx";
  Studs[2].Bitmap=load_bitmap(PlayerTextureFilename, Player.Pal);
  PlayerTextureFilename="Studs4.pcx";
  Studs[3].Bitmap=load_bitmap(PlayerTextureFilename, Player.Pal);

  PlayerTextureFilename="Player1.pcx";
  Player.Bitmap1=load_bitmap(PlayerTextureFilename, Player.Pal);
  PlayerTextureFilename="Player2.pcx";
  Player.Bitmap2=load_bitmap(PlayerTextureFilename, Player.Pal);
  PlayerTextureFilename="Player3.pcx";
  Player.Bitmap3=load_bitmap(PlayerTextureFilename, Player.Pal);
  PlayerTextureFilename="Player4.pcx";
  Player.Bitmap4=load_bitmap(PlayerTextureFilename, Player.Pal);
  PlayerTextureFilename="Player5.pcx";
  Player.Bitmap5=load_bitmap(PlayerTextureFilename, Player.Pal);
  PlayerTextureFilename="Player6.pcx";
  Player.Bitmap6=load_bitmap(PlayerTextureFilename, Player.Pal);
  TextureFilename[0].a="Enemy1_1.pcx";
  TextureFilename[0].b="Enemy1_2.pcx";
  TextureFilename[1].a="Enemy2_1.pcx";
  TextureFilename[1].b="Enemy2_2.pcx";
  TextureFilename[2].a="Enemy3_1.pcx";
  TextureFilename[2].b="Enemy3_2.pcx";
  TextureFilename[3].a="Enemy4_1.pcx";
  TextureFilename[3].b="Enemy4_2.pcx";
  TextureFilename[4].a="Enemy5_1.pcx";
  TextureFilename[4].b="Enemy5_2.pcx";
  TextureFilename[5].a="Enemy6_1.pcx";
  TextureFilename[5].b="Enemy6_2.pcx";
  TextureFilename[6].a="Enemy7_1.pcx";
  TextureFilename[6].b="Enemy7_2.pcx";
  for (j=0;j<ENEMYCOUNT;j++)
  {
    Enemy[j].Bitmap1=load_bitmap(TextureFilename[j].a, Enemy[j].Pal);
    Enemy[j].Bitmap2=load_bitmap(TextureFilename[j].b, Enemy[j].Pal);
  }
  TextureFilename[0].a="Item1_1.pcx";
  TextureFilename[0].b="Item1_2.pcx";
  TextureFilename[1].a="Item2_1.pcx";
  TextureFilename[1].b="Item2_2.pcx";
  TextureFilename[2].a="Item3_1.pcx";
  TextureFilename[2].b="Item3_2.pcx";
  for (j=0;j<ITEMCOUNT;j++)
  {
    Item[j].Bitmap1=load_bitmap(TextureFilename[j].a, Item[j].Pal);
    Item[j].Bitmap2=load_bitmap(TextureFilename[j].b, Item[j].Pal);
  }
  TextureFilename[0].a="Backgr1.pcx";
  LevelData.Background=load_bitmap(TextureFilename[0].a, LevelData.Pal);
  StatusBarBitmap=load_bitmap("Status.pcx", LevelData.Pal);
  if ((!Nomusic) && (!Design)  && (Sfx))
  {
    if ((SndSample[0].Sample=MIDASloadWaveSample("Snd1.wav", MIDAS_LOOP_NO))==NULL)
      MIDASerror();
    if ((SndSample[1].Sample=MIDASloadWaveSample("Snd2.wav", MIDAS_LOOP_NO))==NULL)
      MIDASerror();
    if ((SndSample[2].Sample=MIDASloadWaveSample("Snd3.wav", MIDAS_LOOP_NO))==NULL)
      MIDASerror();
    if ((SndSample[3].Sample=MIDASloadWaveSample("Snd4.wav", MIDAS_LOOP_NO))==NULL)
      MIDASerror();
    if ((SndSample[4].Sample=MIDASloadWaveSample("Snd5.wav", MIDAS_LOOP_NO))==NULL)
      MIDASerror();
  }
  return 0;
}
  */

int remove_textures()
{
  int a;
  for (a=0;a<BlockTextureCount;a++)
  {
    if (Texture[a].Bitmap!=NULL)
      destroy_bitmap(Texture[a].Bitmap);
    Texture[a].Width=0;
    Texture[a].Height=0;
  }
  destroy_bitmap(Player.Bitmap1);
  destroy_bitmap(Player.Bitmap2);
  destroy_bitmap(Player.Bitmap3);
  destroy_bitmap(Player.Bitmap4);
  destroy_bitmap(Player.Bitmap5);
  destroy_bitmap(Player.Bitmap6);
  destroy_bitmap(Player.Bitmap7);
  destroy_bitmap(Player.Bitmap8);
  destroy_bitmap(Player.Bitmap9);
  destroy_bitmap(Player.Bitmap10);
  destroy_bitmap(Player.Bitmap11);
  destroy_bitmap(Player.Bitmap12);
  destroy_bitmap(Player.Bitmap13);
  destroy_bitmap(Player.Bitmap14);
  destroy_bitmap(Player.Bitmap15);
  destroy_bitmap(Player.Bitmap16);
  for (a=0;a<EnemyTextureCount;a++)
  {
    if (Enemy[a].Bitmap1!=NULL)
      destroy_bitmap(Enemy[a].Bitmap1);
    if (Enemy[a].Bitmap2!=NULL)
      destroy_bitmap(Enemy[a].Bitmap2);
    if (Enemy[a].Bitmap3!=NULL)
      destroy_bitmap(Enemy[a].Bitmap3);
    if (Enemy[a].Bitmap4!=NULL)
      destroy_bitmap(Enemy[a].Bitmap4);
    if (Enemy[a].Bitmap5!=NULL)
      destroy_bitmap(Enemy[a].Bitmap5);
    if (Enemy[a].Bitmap6!=NULL)
      destroy_bitmap(Enemy[a].Bitmap6);
    if (Enemy[a].Bitmap7!=NULL)
      destroy_bitmap(Enemy[a].Bitmap7);
    if (Enemy[a].Bitmap8!=NULL)
      destroy_bitmap(Enemy[a].Bitmap8);
  }
  for (a=0;a<ItemTextureCount;a++)
  {
    if (Item[a].Bitmap1!=NULL)
      destroy_bitmap(Item[a].Bitmap1);
    if (Enemy[a].Bitmap2!=NULL)
      destroy_bitmap(Item[a].Bitmap2);
    if (Item[a].Bitmap3!=NULL)
      destroy_bitmap(Item[a].Bitmap3);
    if (Enemy[a].Bitmap4!=NULL)
      destroy_bitmap(Item[a].Bitmap4);
  }
  destroy_bitmap(LevelData.Background);
  destroy_bitmap(StatusBarBitmap);
  if ((!Nomusic) && (!Design) && (Sfx))
  {
    for (a=0;a<SNDSAMPLECOUNT;a++)
    {
      MIDASfreeSample(SndSample[a].Sample);
    }
  }
  return 0;
}

void WaitRefr()
{
  Refr=TRUE;
}

int read_config(char *filename)
{
  FILE *F;
  long Flen;
  int *Fbuff;
  //printf("%s", filename);
  F=fopen(filename, "rb");
  if (F==NULL)
  {
     equit("Error opening configfile! Please run setup.exe");
  }
  else
  {
    fseek(F, 0, SEEK_END);
    Flen=ftell(F);
    fseek(F, 0, SEEK_SET);
    Fbuff=malloc(sizeof(int)*(Flen+10));
    memset(Fbuff, 0, Flen+10);
    fread(Fbuff, sizeof(int), Flen/sizeof(int), F);
    fclose(F);
    GameSpeed=Fbuff[0];
    if (GameSpeed==0)
      NoSync=TRUE;
    Sfx=Fbuff[1];
    Music=Fbuff[2];
    Debug=Fbuff[3];
    SfxVol=Fbuff[4];
    MusicVol=Fbuff[5];
  }
  return 0;
}





int view_intro()
{

  return 0;
}


int main(int argc, char *argv[])
{
  int done=FALSE;
  int i, j, k;
  float timeref=0, framecount=0;
  //clrscr();
  if (strcmp(argv[1], "create")==0)
    Design=TRUE;
  else
    Design=FALSE;
  gfxmode=GFX_TEXT;
  allegro_init();
  read_config("./lggame1.cfg");
  if (Debug)
  {
    printf("Sfx: %i\n", Sfx);
    printf("Music: %i\n", Music);
    printf("GameSpeed: %i\n", GameSpeed);
    printf("SfxVol: %i\n", SfxVol);
    printf("MusicVol: %i\n", MusicVol);
    printf("- Press [Enter] -");
    getch();
    printf("\n\n");
  }
  if ((!Sfx) && (!Music))
    Nomusic=TRUE;
  else
    Nomusic=FALSE;
  if ((!Design) || (!NOMUSIC) || (!Nomusic))
  {
    MIDASstartup();
    if (exists("midas.cfg"))
    {
      if (MIDASloadConfig("midas.cfg")==0)
        MIDASerror();
      else
        printf("MIDAS Config loaded from file\n\n");
    }
    else
    {
      if (MIDASdetectSoundCard()==0)
        MIDASerror();
      else
        printf("MIDAS Config autodetected\n\n");
    }
    if (!MIDASinit())
      MIDASerror();
    if (!MIDASopenChannels(4+4+1))
      MIDASerror();
    if ((!Nomusic) && (Music))
      if ((testmod=MIDASloadModule("./music/Chip2.xm"))==0)
        MIDASerror();
    if (!NoSync)
      MIDASsetTimerCallbacks(GameSpeed , TRUE, &WaitRefr, NULL, NULL);
    if (!MIDASallocAutoEffectChannels(SNDSAMPLECOUNT))
      MIDASerror();
  }
  install_keyboard();
  keyboard_lowlevel_callback=&KeyRelease;  // Fixa s att KeyRelease() krs vid varje keyboard interupt
  if (Design)
    install_timer();
  mouseen=TRUE;
  if (Design)
    install_mouse();
  joyen=TRUE;
  if (joyen)
    install_joystick(JOY_TYPE_AUTODETECT);

  printf("Legion Game 1\n---------------------------\n\n");
  printf("e, Upp   - Jump\nf, Right   - Right\ns, Left   - Left\nEsc - Quit\n\n");

  clear_keybuf();
  gKey=0;
  load_textures();
  view_intro();
/*  gKey=0;
  while (gKey!=283)
  {
    gKey=0;
    get_input();
    switch(lo(gKey))
    {
      case 49: if ((SndSample[0].Handle=MIDASplaySample(SndSample[0].Sample, MIDAS_CHANNEL_AUTO, 0, SAMPFREQ, 64, MIDAS_PAN_MIDDLE))==0)
                 MIDASerror();
               printf("1");
               break;
      case 50: if ((SndSample[1].Handle=MIDASplaySample(SndSample[1].Sample, MIDAS_CHANNEL_AUTO, 0, SAMPFREQ, 64, MIDAS_PAN_MIDDLE))==0)
                 MIDASerror();
               printf("2");
               break;
      case 51: if ((SndSample[2].Handle=MIDASplaySample(SndSample[2].Sample, MIDAS_CHANNEL_AUTO, 0, SAMPFREQ, 64, MIDAS_PAN_MIDDLE))==0)
                 MIDASerror();
               printf("3");
               break;
      case 52: if ((SndSample[3].Handle=MIDASplaySample(SndSample[3].Sample, MIDAS_CHANNEL_AUTO, 0, SAMPFREQ, 64, MIDAS_PAN_MIDDLE))==0)
                 MIDASerror();
               printf("4");
               break;
    }
  }*/
  gfxmode=GFX_VESA2L;

if (Design)
{
  if (argc<2)
    argv[1]="./level1.lev";
  argv[1]=fix_filename_slashes(argv[1]);
  printf("\n[Starting LG Game 1!]\n  - Switching to graphics mode... Press [Enter]\n");
  readkey();
  //printf(" OK!\n");
  if (set_gfx_mode(gfxmode, 320, 200, 0, 0)<0)
  {
    if (set_gfx_mode(GFX_VGA, 320, 200, 0, 0)<0)
      equit("Setting graphics mode (320*200*256c)!");
    gfxmode=GFX_VGA;
  }
  design_new_level(argv[2]);
}
else
{
  if (argc<2)
    argv[1]="./level1.lev";
  argv[1]=fix_filename_slashes(argv[1]);
  load_level(argv[1], FALSE);

  if (Player.y>200)
  {
    LevelData.yoff=Player.y-200;
    if ((LevelData.yoff-200)>LevelData.Height)
      LevelData.yoff=(LevelData.Height-200);
    Player.y-=LevelData.yoff;
  }
  if (Player.x>320)
  {
    LevelData.xoff=(Player.x-320);
    if ((LevelData.xoff+160)>LevelData.Length)
      LevelData.xoff=(LevelData.Length-160);
    Player.x-=LevelData.xoff;
  }
 // LevelData.yoff=159;
 // Player.y-=LevelData.yoff;
  LevelData.xoffstart=LevelData.xoff;
  LevelData.yoffstart=LevelData.yoff;
  Player.StartX=Player.x;
  Player.StartY=Player.y;

/*  for (i=0;i<LevelData.BlockCount;i++)
  {
    if (LevelData.BlockPos[i].ident==14)
    {
      printf("BlockBan : %i\n", i);
      for (j=0;j<LevelData.BlockPos[i].BlockBanCount;j++)
      {
        printf("[X:%i Y:%i]  ", LevelData.BlockPos[i].BlockBan[j].x, LevelData.BlockPos[i].BlockBan[j].y);
      }
    }
  }*/

  printf("\n[Starting LG Game 1!]\n  - Switching to graphics mode... Press [Enter]\n");
  readkey();
  if (set_gfx_mode(gfxmode, 320, 200, 0, 0)<0)
  {
    if (set_gfx_mode(GFX_VGA, 320, 200, 0, 0)<0)
      equit("Setting graphics mode (320*200*256c)!");
    gfxmode=GFX_VGA;
  }
  //printf(" OK!\n");

  Vir1=create_bitmap(320, 200);
  StatusBar=create_bitmap(320, 10);

  clear(Vir1);
  clear(StatusBar);
  blit(StatusBarBitmap, StatusBar, 0, 0, 0, 0, 320, 10);
  //save_pcx("Levelbmp.pcx" ,LevelData.LevelBitmap, Texture[0].Pal);
  done=FALSE;
/*  for (i=0;i<LevelData.Length;i++)
    for (j=0;j<LevelData.Height;j++)
      if (LevelData.LevelMask[(j*LevelData.Length)+i].mask==1)
        putpixel(screen, i, j, 100);
      else if (LevelData.LevelMask[(j*LevelData.Length)+i].mask==2)
        putpixel(screen, i, j, 50);
      else if (LevelData.LevelMask[(j*LevelData.Length)+i].mask==3)
        putpixel(screen, i, j, 60);
      else if (LevelData.LevelMask[(j*LevelData.Length)+i].mask==4)
        putpixel(screen, i, j, 70);     */
/*  for (i=0;i<LevelData.BlockCount;i++)
  {
    if (LevelData.BlockPos[i].ident==14)
      for (j=0;j<Texture[LevelData.BlockPos[i].ident].Bitmap->w;j++)
        for (k=0;k<Texture[LevelData.BlockPos[i].ident].Bitmap->h;k++)
          if (LevelData.BlockPos[i].BlockBanMask[(k*Texture[LevelData.BlockPos[i].ident].Bitmap->w)+j].mask==1)
            putpixel(screen, j+100, k+50, 120);
  }*/
//  readkey();

/*  Player.x=80;
  Player.y=10; */
  Player.xdec=Player.xinc=FALSE;
  Player.fall=FALSE;
  Player.Score=0;
  Player.Dir=0;
  Player.Health=3;
  Player.Blink=FALSE;
  Player.BlinkCount=0;
//  Enemy[0].x=50;
//  Enemy[0].y=168-18;

/*  Enemy[0].x=50;
  Enemy[0].y=20;
  Enemy[0].Dir=0;
  Enemy[0].xdec=TRUE;
  Enemy[0].xinc=FALSE;*/
  for (i=0;i<LevelData.EnemyCount;i++)
  {
    LevelData.EnemyPos[i].Dir=0;
    LevelData.EnemyPos[i].xdec=TRUE;
    LevelData.EnemyPos[i].xinc=FALSE;
  }
  //set_palette(LevelData.Pal);
  set_palette(Dat[Pal_].dat);

  if ((!Design) && (!Nomusic) && (Music))
  {
    if ((playHandle=MIDASplayModule(testmod, TRUE))==0)
      MIDASerror();
    if (MIDASsetMusicVolume(playHandle, MusicVol)==0)
      MIDASerror();
  }
  //readkey();
  timeref=biostime(0, 0);
  while (done==FALSE)
  {
    gKey=0;
    get_input();
    switch(gKey)
    {
      case 283:    done=TRUE;
                   break;
      case 12386:  LevelData.yoff++;
                   break;
    }
/*    if //(joy[0].stick[0].axis[0].pos>10)
           (joy[0].stick[0].axis[0].d2)
    {
      Player.xincj=TRUE;
      Player.xdecj=FALSE;
      Player.Dir=0;
    }
    if //(joy[0].stick[0].axis[0].pos<-10)
         (joy[0].stick[0].axis[0].d1)
    {
      Player.xdecj=TRUE;
      Player.xincj=FALSE;
      Player.Dir=1;
    }
    if //((joy[0].stick[0].axis[0].pos>-10) && (joy[0].stick[0].axis[0].pos<10))
    ((!joy[0].stick[0].axis[0].d1) && (!joy[0].stick[0].axis[0].d2))
    {
      Player.xdecj=FALSE;
      Player.xincj=FALSE;
    }
    if //((joy[0].stick[0].axis[1].pos<-10) && (!Player.jump) && (!Player.fall))
         ((joy[0].button[0].b) && (!Player.jump) && (!Player.fall))
    {
      Player.jump=TRUE;
      Player.jumpx=Player.x;
      Player.jumpy=Player.y;
      JumpPathNum=0;
    }*/
    update_level();
    update_blocks();
    update_items();
    update_enemies();
    update_player();
    //vsync();
    if (!NoSync)
      while (!Refr) {}
    blit(StatusBar, Vir1, 0, 0, 0, 0, 320, 10);
    blit(Vir1, screen, 0,0,0,0, 320,200);
    Refr=FALSE;
    framecount++;
  }
  //clear(screen);
}
  if ((!Design))
  {
    if ((!Nomusic) && (Music))
      MIDASstopModule(playHandle);
    if ((!Nomusic) && (Music))
      MIDASfreeModule(testmod);
    MIDASclose();
  }
  destroy_bitmap(Vir1);
  destroy_bitmap(StatusBar);
  if (set_gfx_mode(GFX_TEXT, 640, 480, 0, 0)<0)
    equit("Setting TEXT mode!");
  printf("Back to DOS!\n");
  if (!NoSync)
    printf("\nTo get the real FPS value, turn gane sync off (set to zero)\n");
  printf("Framecount: %f  Frames/Tick: %f  Frames/Sec: %f\n", framecount, framecount/(biostime(0, 0)-timeref), framecount/((biostime(0, 0)-timeref)/18.2));
  if (joyen)
     remove_joystick();
  if (Design)
    remove_mouse();
  if (Design)
    remove_timer();
  remove_keyboard();
  allegro_exit();
  return 0;
}
