/*  TA3D, a remake of Total Annihilation
    Copyright (C) 2005  Roland BROCHARD

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA*/

/*-----------------------------------------------------------------------------------\
|                                       weapons.h                                    |
|   Ce module contient les structures, classes et fonctions nécessaires à la lecture |
| des fichiers tdf du jeu totalannihilation concernant les armes utilisées par les   |
| unités du jeu.                                                                     |
|                                                                                    |
\-----------------------------------------------------------------------------------*/

#ifndef __WEAPON_CLASSES
#define __WEAPON_CLASSES

class WEAPON
{
public:
	int		weapon_id;			// Numéro identifiant l'arme
	char	*internal_name;		// Nom interne de l'arme
	char	*name;				// Nom de l'arme
	int		rendertype;
	bool	ballistic;
	bool	turret;
	int		range;				// portée
	float	reloadtime;			// temps de rechargement
	int		weaponvelocity;
	int		areaofeffect;		// zone d'effet
	bool	startsmoke;
	int		damage;				// Dégats causés par l'arme
	int		firestarter;
	int		accuracy;
	int		aimrate;
	int		tolerance;
	int		holdtime;
	int		energypershot;
	int		metalpershot;
	int		minbarrelangle;
	bool	unitsonly;
	float	edgeeffectiveness;
	bool	lineofsight;
	bool	soundtrigger;
	int		color[2];
	float	burstrate;
	float	duration;
	bool	beamweapon;
	int		startvelocity;			// Pour les missiles
	int		weapontimer;			// Pour les missiles
	int		weaponacceleration;		// Pour les missiles
	int		turnrate;				// Pour les missiles
	MODEL	*model;					// Modèle 3D
	float	smokedelay;
	bool	guidance;				// Guidage
	bool	tracks;
	bool	selfprop;
	bool	smoketrail;				// Laisse de la fumée en passant
	bool	noautorange;
	int		flighttime;
	bool	vlaunch;
	bool	stockpile;
	bool	targetable;				// On peut viser
	bool	commandfire;			// ne tire pas seul
	bool	cruise;
	bool	propeller;
	bool	twophase;
	int		shakemagnitude;
	float	shakeduration;

	inline void init()
	{
		weapon_id=0;			// Numéro identifiant l'arme
		internal_name=NULL;		// Nom interne de l'arme
		name=NULL;				// Nom de l'arme
		rendertype=0;
		ballistic=false;
		turret=true;
		range=100;				// portée
		reloadtime=0.0f;		// temps de rechargement
		weaponvelocity=1;
		areaofeffect=10;		// zone d'effet
		startsmoke=true;
		damage=100;				// Dégats causés par l'arme
		firestarter=0;
		accuracy=0;
		aimrate=0;
		tolerance=0;
		holdtime=0;
		energypershot=0;
		metalpershot=0;
		minbarrelangle=0;
		unitsonly=false;
		edgeeffectiveness=10;
		lineofsight=false;
		soundtrigger=false;
		color[0]=0;
		color[1]=0xFFFFFF;
		burstrate=1.0f;
		duration=1.0f;
		beamweapon=true;
		startvelocity=0;			// Pour les missiles
		weapontimer=100;			// Pour les missiles
		weaponacceleration=1;		// Pour les missiles
		turnrate=1;					// Pour les missiles
		model=NULL;					// Modèle 3D
		smokedelay=0.1f;
		guidance=true;				// Guidage
		tracks=true;
		selfprop=true;
		smoketrail=true;			// Laisse de la fumée en passant
		noautorange=true;
		flighttime=10;
		vlaunch=true;
		stockpile=true;
		targetable=true;			// On peut viser
		commandfire=false;			// ne tire pas seul
		cruise=true;
		propeller=true;
		twophase=false;
		shakemagnitude=0;
		shakeduration=0.1f;
	}

	inline void destroy()
	{
		if(internal_name)	free(internal_name);
		if(name)	free(name);
		init();
	}

	WEAPON()
	{
		init();
	}

	~WEAPON()
	{
		destroy();
	}
};

class WEAPON_MANAGER
{
public:
	int		nb_weapons;
	WEAPON	*weapon;

	void init()
	{
		nb_weapons=0;
		weapon=NULL;
	}

	WEAPON_MANAGER()
	{
		init();
	}

	void destroy()
	{
		if(nb_weapons>0 && weapon)			// Détruit les éléments
			for(int i=0;i<nb_weapons;i++)
				weapon[i].destroy();
		if(weapon)
			free(weapon);
		init();
	}

	~WEAPON_MANAGER()
	{
		destroy();
	}

	int add_weapon(char *name)			// Ajoute un élément
	{
		nb_weapons++;
		WEAPON *n_weapon=(WEAPON*) malloc(sizeof(WEAPON)*nb_weapons);
		if(weapon && nb_weapons>1)
			for(int i=0;i<nb_weapons-1;i++)
				n_weapon[i]=weapon[i];
		if(weapon)	free(weapon);
		weapon=n_weapon;
		weapon[nb_weapons-1].init();
		weapon[nb_weapons-1].internal_name=strdup(name);
		return nb_weapons-1;
	}

private:
	inline char *get_line(char *data)
	{
		int pos=0;
		while(data[pos]!=0 && data[pos]!=13 && data[pos]!=10)	pos++;
		char *d=new char[pos+1];
		memcpy(d,data,pos);
		d[pos]=0;
		return d;
	}
public:

	void load_tdf(char *data,int size=99999999);					// Charge un fichier tdf

	int get_weapon_index(char *name)
	{
		if(nb_weapons<=0)	return -1;
		for(int i=0;i<nb_weapons;i++)
			if(strcasecmp(name,weapon[i].internal_name)==0)
				return i;
		return -1;
	}

	int get_weapon_index(int weapon_id)
	{
		if(nb_weapons<=0)	return -1;
		for(int i=0;i<nb_weapons;i++)
			if(weapon[i].weapon_id==weapon_id)
				return i;
		return -1;
	}
};

extern WEAPON_MANAGER		weapon_manager;

void load_all_weapons_in_hpi(char *filename);

void load_weapons();				// Charge tout les éléments

#endif
