/*  TA3D, a remake of Total Annihilation
    Copyright (C) 2005  Roland BROCHARD

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA*/

/*---------------------------------------------------------------------------------\
|                                        gui.cpp                                   |
|         Contient les fonctions nécessaires à la gestion de l'interface de ta3D   |
|  comme les boutons, les fenêtres,...                                             |
|                                                                                  |
\---------------------------------------------------------------------------------*/

#include <allegro.h>
#include <alleggl.h>
#include <GL/glu.h>
#include "ta3dbase.h"

void glbutton(char *caption,float x1,float y1,float x2,float y2,bool etat)
{
	glDisable(GL_TEXTURE_2D);

	glBegin(GL_QUADS);
	if(!etat) {
		glColor3f(1.0f,1.0f,1.0f);	glVertex2f(x1,y1);			// Dessine les bords du bouton
		glColor3f(0.5f,0.5f,0.5f);	glVertex2f(x2,y1);
		glColor3f(0.0f,0.0f,0.0f);	glVertex2f(x2,y2);
		glColor3f(0.5f,0.5f,0.5f);	glVertex2f(x1,y2);
		}
	else {
		glColor3f(0.0f,0.0f,0.0f);	glVertex2f(x1,y1);			// Dessine les bords du bouton
		glColor3f(0.5f,0.5f,0.5f);	glVertex2f(x2,y1);
		glColor3f(1.0f,1.0f,1.0f);	glVertex2f(x2,y2);
		glColor3f(0.5f,0.5f,0.5f);	glVertex2f(x1,y2);
		}

		glVertex2f(x1+2,y1+2);			// Dessine le fond du bouton
		glVertex2f(x2-2,y1+2);
		glVertex2f(x2-2,y2-2);
		glVertex2f(x1+2,y2-2);
	glEnd();

	glEnable(GL_TEXTURE_2D);

	glBlendFunc(GL_ONE,GL_ONE_MINUS_SRC_COLOR);
	glEnable(GL_BLEND);
	if(etat)
		allegro_gl_printf(aglfont,0.5f*(x1+x2-8*strlen(caption))+1.0f,0.5f*(y1+y2-9.0f)+1.0f,0.0f,0xFFFFFF,caption);
	else
		allegro_gl_printf(aglfont,0.5f*(x1+x2-8*strlen(caption)),0.5f*(y1+y2-9.0f),0.0f,0xFFFFFF,caption);
	glDisable(GL_BLEND);
}
