/*  TA3D, a remake of Total Annihilation
    Copyright (C) 2005  Roland BROCHARD

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA*/

/*-----------------------------------------------------------------------------------\
|                                         fbi.cpp                                    |
|  Ce fichier contient les structures, classes et fonctions nécessaires à la lecture |
| des fichiers fbi du jeu totalannihilation qui sont les fichiers de données sur les |
| unités du jeu. Cela inclus les classes pour gérer les différents types d'unités et |
| le système de gestion de liens entre unités.                                       |
|                                                                                    |
\-----------------------------------------------------------------------------------*/

#include <allegro.h>
#include <alleggl.h>
#include <GL/glu.h>
#include "ta3dbase.h"
#include "3do.h"
#include "fbi.h"

UNIT_MANAGER unit_manager;

	int UNIT_TYPE::load(char *data,int size)
	{
		destroy();
		char *pos=data;
		char *f;
		char *ligne=NULL;
		int nb=0;
		int nb_inconnu=0;
		char *limit=data+size;
		while(*pos!='{') pos++;
		pos=strstr(pos,"\n")+1;
		do
		{
			nb++;
			if(ligne)
				delete ligne;
			ligne=get_line(pos);
			strlwr(ligne);
			while(pos[0]!=0 && pos[0]!=13 && pos[0]!=10)	pos++;
			while(pos[0]==13 || pos[0]==10)	pos++;
			
			f=NULL;
			if(f=strstr(ligne,"unitname=")) {
				Unitname=strdup(f+9);
				*(strstr(Unitname,";"))=0;
				}
			else if(f=strstr(ligne,"name=")) {
				name=strdup(f+5);
				*(strstr(name,";"))=0;
				}
			else if(f=strstr(ligne,"version="))	version=f[8]-'0';
			else if(f=strstr(ligne,"side=")) {
				side=strdup(f+5);
				*(strstr(side,";"))=0;
				}
			else if(f=strstr(ligne,"objectname=")) {
				ObjectName=strdup(f+11);
				*(strstr(ObjectName,";"))=0;
				}
			else if(f=strstr(ligne,"designation=")) {
				Designation_Name=strdup(f+12);
				*(strstr(Designation_Name,";"))=0;
				}
			else if(f=strstr(ligne,"description=")) {
				Description=strdup(f+12);
				*(strstr(Description,";"))=0;
				}
			else if(f=strstr(ligne,"footprintx="))			FootprintX=f[11]-'0';
			else if(f=strstr(ligne,"footprintz="))			FootprintZ=f[11]-'0';
			else if(f=strstr(ligne,"buildcostenergy="))		BuildCostEnergy=atoi(f+16);
			else if(f=strstr(ligne,"buildcostmetal="))		BuildCostMetal=atoi(f+15);
			else if(f=strstr(ligne,"maxdamage="))			MaxDamage=atoi(f+10);
			else if(f=strstr(ligne,"maxwaterdepth="))		MaxWaterDepth=atoi(f+14);
			else if(f=strstr(ligne,"minwaterdepth="))		MinWaterDepth=atoi(f+14);
			else if(f=strstr(ligne,"energyuse="))			EnergyUse=atoi(f+10);
			else if(f=strstr(ligne,"buildtime="))			BuildTime=atoi(f+10);
			else if(f=strstr(ligne,"workertime="))			WorkerTime=atoi(f+11);
			else if(f=strstr(ligne,"builder="))				Builder=(f[8]=='1');
			else if(f=strstr(ligne,"threed="))				ThreeD=(f[7]=='1');
			else if(f=strstr(ligne,"sightdistance="))		SightDistance=atoi(f+14)>>1;
			else if(f=strstr(ligne,"radardistance="))		RadarDistance=atoi(f+14)>>1;
			else if(f=strstr(ligne,"category=")) {
				if(strstr(f,"level"))		Category+=atoi(strstr(f,"level")+5);
				if(strstr(f,"arm"))			Category|=ARM;
				if(strstr(f,"weapon"))		Category|=_WEAPON;
				if(strstr(f,"commander"))	Category|=COMMANDER;
				if(strstr(f,"notair"))		Category|=NOTAIR;
				if(strstr(f,"notsub"))		Category|=NOTSUB;
				if(strstr(f,"ctrl_c"))		Category|=CTRL_C;
				}
			else if(f=strstr(ligne,"unitnumber="))		UnitNumber=atoi(f+14);
			else if(f=strstr(ligne,"frenchname=")) {
				FrenchName=strdup(f+11);
				*(strstr(FrenchName,";"))=0;
				}
			else if(f=strstr(ligne,"frenchdescription=")) {
				FrenchDescription=strdup(f+18);
				*(strstr(FrenchDescription,";"))=0;
				}
			else if(f=strstr(ligne,"canmove="))				canmove=(f[8]=='1');
			else if(f=strstr(ligne,"canpatrol="))			canmove=(f[10]=='1');
			else if(f=strstr(ligne,"canstop="))				canmove=(f[8]=='1');
			else if(f=strstr(ligne,"canguard="))			canmove=(f[9]=='1');
			else if(f=strstr(ligne,"maxvelocity="))			MaxVelocity=atof(f+12);
			else if(f=strstr(ligne,"brakerate="))			BrakeRate=atof(f+10);
			else if(f=strstr(ligne,"acceleration="))		Acceleration=atof(f+13);
			else if(f=strstr(ligne,"turnrate="))			TurnRate=atof(f+9);
			else if(f=strstr(ligne,"candgun="))				candgun=(f[8]=='1');
			else if(f=strstr(ligne,"canattack="))			canattack=(f[10]=='1');
			else if(f=strstr(ligne,"canreclamate="))		CanReclamate=(f[13]=='1');
			else if(f=strstr(ligne,"energymake="))			EnergyMake=atoi(f+11);
			else if(f=strstr(ligne,"metalmake="))			MetalMake=atof(f+10);
			else if(f=strstr(ligne,"cancapture="))			CanCapture=(f[11]=='1');
			else if(f=strstr(ligne,"hidedamage="))			HideDamage=(f[11]=='1');
			else if(f=strstr(ligne,"healtime="))			HealTime=atoi(f+9);
			else if(f=strstr(ligne,"cloakcost="))			CloakCost=atoi(f+10);
			else if(f=strstr(ligne,"cloakcostmoving="))		CloakCostMoving=atoi(f+16);
			else if(f=strstr(ligne,"builddistance="))		BuildDistance=atoi(f+14);
			else if(f=strstr(ligne,"activatewhenbuilt="))	ActivateWhenBuilt=(f[18]=='1');
			else if(f=strstr(ligne,"immunetoparalyzer="))	ImmuneToParalyzer=(f[18]=='1');
			else if(f=strstr(ligne,"sonardistance="))		SonarDistance=atoi(f+14)>>1;
			else if(f=strstr(ligne,"copyright=")) {}
			else if(f=strstr(ligne,"maxslope="))			MaxSlope=atoi(f+9);
			else if(f=strstr(ligne,"steeringmode="))		SteeringMode=atoi(f+13);
			else if(f=strstr(ligne,"bmcode="))				BMcode=atoi(f+7);
			else if(f=strstr(ligne,"zbuffer=")) {}
			else if(f=strstr(ligne,"shootme="))				ShootMe=(f[8]=='1');
			else if(f=strstr(ligne,"upright="))				Upright=(f[8]=='1');
			else if(f=strstr(ligne,"norestrict="))			norestrict=(f[11]=='1');
			else if(f=strstr(ligne,"noautofire="))			AutoFire=(f[11]!='1');
			else if(f=strstr(ligne,"energystorage="))		EnergyStorage=atoi(f+14);
			else if(f=strstr(ligne,"metalstorage="))		MetalStorage=atoi(f+13);
			else if(f=strstr(ligne,"standingmoveorder="))	StandingMoveOrder=atoi(f+18);
			else if(f=strstr(ligne,"mobilestandorders="))	MobileStandOrders=atoi(f+18);
			else if(f=strstr(ligne,"standingfireorder="))	StandingFireOrder=atoi(f+18);
			else if(f=strstr(ligne,"firestandorders="))		FireStandOrders=atoi(f+16);
			else if(f=strstr(ligne,"waterline="))			WaterLine=atoi(f+10);
			else if(f=strstr(ligne,"tedclass=")) {
				if(strstr(f,"water"))			TEDclass=CLASS_WATER;
				else if(strstr(f,"ship"))		TEDclass=CLASS_SHIP;
				else if(strstr(f,"energy"))		TEDclass=CLASS_ENERGY;
				else if(strstr(f,"vtol"))		TEDclass=CLASS_VTOL;
				else if(strstr(f,"kbot"))		TEDclass=CLASS_KBOT;
				else if(strstr(f,"plant"))		TEDclass=CLASS_PLANT;
				else if(strstr(f,"tank"))		TEDclass=CLASS_TANK;
				else if(strstr(f,"special"))	TEDclass=CLASS_SPECIAL;
				else if(strstr(f,"fort"))		TEDclass=CLASS_FORT;
				else if(strstr(f,"metal"))		TEDclass=CLASS_METAL;
				else if(strstr(f,"cnstr"))		TEDclass=CLASS_CNSTR;
				else if(strstr(f,"commander"))	TEDclass=CLASS_COMMANDER;
				else {
					printf("->tedclass id inconnu : %s\n",f);
					nb_inconnu++;
					}
				}
			else if(f=strstr(ligne,"noshadow="))			NoShadow=(f[9]=='1');
			else if(f=strstr(ligne,"buildangle="))			BuildAngle=atoi(f+11);
			else if(f=strstr(ligne,"canfly="))				canfly=(f[7]=='1');
			else if(f=strstr(ligne,"canload="))				canload=(f[8]=='1');
			else if(f=strstr(ligne,"floater="))				Floater=(f[8]=='1');
			else if(f=strstr(ligne,"bankscale="))			BankScale=atoi(f+10);
			else if(f=strstr(ligne,"tidalgenerator="))		TidalGenerator=(f[15]=='1');
			else if(f=strstr(ligne,"scale="))				Scale=1.0f;//atof(f+6)*0.5f;
			else if(f=strstr(ligne,"corpse=")) {
				char *nom=strdup(f+7);
				*(strstr(nom,";"))=0;
				Corpse=model_manager.get_model(nom);
				free(nom);
				}
			else if(f=strstr(ligne,"windgenerator=")) {
				int c=atoi(f+14);
				WindGenerator=(c>0);
				if(c>0)
					EnergyMake=c;
				}
			else if(f=strstr(ligne,"onoffable="))			onoffable=(f[10]=='1');
			else if(f=strstr(ligne,"kamikaze="))			kamikaze=(f[9]=='1');
			else if(f=strstr(ligne,"weapon1="))				Weapon1=weapon_manager.get_weapon_index(f+8);
			else if(f=strstr(ligne,"weapon2="))				Weapon2=weapon_manager.get_weapon_index(f+8);
			else if(f=strstr(ligne,"weapon3="))				Weapon3=weapon_manager.get_weapon_index(f+8);
			else if(f=strstr(ligne,"yardmap="))				{}
			else if(f=strstr(ligne,"cruisealt="))			CruiseAlt=atoi(f+10);
			else if(f=strstr(ligne,"explodeas=")) {
				if(strstr(f,"commander_blast"))			ExplodeAs=COMMANDER_BLAST;
				else if(strstr(f,"big_unitex"))			ExplodeAs=BIG_UNITEX;
				else if(strstr(f,"small_buildingex"))	ExplodeAs=SMALL_BUILDINGEX;
				else if(strstr(f,"medium_buildingex"))	ExplodeAs=MEDIUM_BUILDINGEX;
				else if(strstr(f,"small_unitex"))		ExplodeAs=SMALL_UNITEX;
				else if(strstr(f,"large_buildingex"))	ExplodeAs=LARGE_BUILDINGEX;
				else if(strstr(f,"estor_buildingex"))	ExplodeAs=ESTOR_BUILDINGEX;
				else if(strstr(f,"lightning"))			ExplodeAs=LIGHTNING;
				else if(strstr(f,"atomic_blastsml"))	ExplodeAs=ATOMIC_BLASTSML;
				else if(strstr(f,"crawl_blastsml"))		ExplodeAs=CRAWL_BLASTSML;
				else if(strstr(f,"crawl_blast"))		ExplodeAs=CRAWL_BLAST;
				else if(strstr(f,"nuclear_missile"))	ExplodeAs=NUCLEAR_MISSILE;
				else if(strstr(f,"atomic_blast"))		ExplodeAs=ATOMIC_BLAST;
				else if(strstr(f,"corpyro_blast"))		ExplodeAs=CORPYRO_BLAST;
				else {
					printf("->constante inconnue : %s\n",f);
					nb_inconnu++;
					}
				}
			else if(f=strstr(ligne,"selfdestructas=")) {
				if(strstr(f,"commander_blast"))			SelfDestructAs=COMMANDER_BLAST;
				else if(strstr(f,"big_unit"))			SelfDestructAs=BIG_UNIT;
				else if(strstr(f,"small_building"))		SelfDestructAs=SMALL_BUILDING;
				else if(strstr(f,"medium_building"))	SelfDestructAs=MEDIUM_BUILDING;
				else if(strstr(f,"small_unit"))			SelfDestructAs=SMALL_UNIT;
				else if(strstr(f,"large_building"))		SelfDestructAs=LARGE_BUILDING;
				else if(strstr(f,"estor_building"))		SelfDestructAs=ESTOR_BUILDING;
				else if(strstr(f,"crawl_blastsml"))		SelfDestructAs=CRAWL_BLASTSML;
				else if(strstr(f,"crawl_blast"))		SelfDestructAs=CRAWL_BLAST;
				else if(strstr(f,"nuclear_missile"))	SelfDestructAs=NUCLEAR_MISSILE;
				else if(strstr(f,"atomic_blast"))		SelfDestructAs=ATOMIC_BLAST;
				else if(strstr(f,"atomic_blastsml"))	SelfDestructAs=ATOMIC_BLASTSML;
				else {
					printf("->constante inconnue : %s\n",f);
					nb_inconnu++;
					}
				}
			else if(f=strstr(ligne,"maneuverleashlength="))	ManeuverLeashLength=atoi(f+20);
			else if(f=strstr(ligne,"defaultmissiontype=")) {
				if(strstr(f,"=standby;"))				DefaultMissionType=MISSION_STANDBY;
				else if(strstr(f,"=vtol_standby;"))		DefaultMissionType=MISSION_VTOL_STANDBY;
				else if(strstr(f,"=guard_nomove;"))		DefaultMissionType=MISSION_GUARD_NOMOVE;
				else {
					printf("->constante inconnue : %s\n",f);
					nb_inconnu++;
					}
				}
			else if(f=strstr(ligne,"transmaxunits="))		TransMaxUnits=atoi(f+14);
			else if(f=strstr(ligne,"transportmaxunits="))	TransportMaxUnits=atoi(f+18);
			else if(f=strstr(ligne,"transportsize="))		TransportSize=atoi(f+14);
			else if(f=strstr(ligne,"altfromsealevel="))		AltFromSeaLevel=atoi(f+16);
			else if(f=strstr(ligne,"movementclass=")) {
				if(strstr(f,"kbotss2"))			MovementClass=MOVEMENT_KBOTSS2;
				else if(strstr(f,"boatd3"))		MovementClass=MOVEMENT_BOATD3;
				else if(strstr(f,"tanksh3"))	MovementClass=MOVEMENT_TANKSH3;
				else if(strstr(f,"boatd6"))		MovementClass=MOVEMENT_BOATD6;
				else if(strstr(f,"boats6"))		MovementClass=MOVEMENT_BOATS6;
				else if(strstr(f,"tanksh2"))	MovementClass=MOVEMENT_TANKSH2;
				else if(strstr(f,"spid3"))		MovementClass=MOVEMENT_SPID3;
				else if(strstr(f,"tankds2"))	MovementClass=MOVEMENT_TANKDS2;
				else if(strstr(f,"boats4"))		MovementClass=MOVEMENT_BOATS4;
				else if(strstr(f,"kbotsf2"))	MovementClass=MOVEMENT_KBOTSF2;
				else if(strstr(f,"boats5"))		MovementClass=MOVEMENT_BOATS5;
				else if(strstr(f,"tankbh3"))	MovementClass=MOVEMENT_TANKBH3;
				else if(strstr(f,"tankdh3"))	MovementClass=MOVEMENT_TANKDH3;
				else {
					printf("->constante inconnue : %s\n",f);
					nb_inconnu++;
					}
				}
			else if(f=strstr(ligne,"isairbase="))			IsAirBase=(f[10]=='1');
			else if(f=strstr(ligne,"damagemodifier="))		DamageModifier=atof(f+15);
			else if(f=strstr(ligne,"makesmetal="))			MakesMetal=atof(f+11);
			else if(f=strstr(ligne,"sortbias="))			SortBias=atoi(f+9);
			else if(f=strstr(ligne,"extractsmetal="))		ExtractsMetal=atof(f+14);
			else if(f=strstr(ligne,"hoverattack="))			hoverattack=(f[12]=='1');
			else if(f=strstr(ligne,"stealth="))				Stealth=atoi(f+8);
			else if(f=strstr(ligne,"downloadable=")) { }
			if(f==NULL && strstr(ligne,"}")==NULL) {
				printf("inconnu: %s\n",ligne);
				nb_inconnu++;
				}
		}while(strstr(ligne,"}")==NULL && nb<1000 && pos<limit);
		delete ligne;
		if(Weapon1>-1)	weapon[0]=&(weapon_manager.weapon[Weapon1]);
		if(Weapon2>-1)	weapon[1]=&(weapon_manager.weapon[Weapon2]);
		if(Weapon3>-1)	weapon[2]=&(weapon_manager.weapon[Weapon3]);
		if(Unitname) {
			model=model_manager.get_model(Unitname);
			if(model==NULL)
				printf("%s sans modèle 3D!\n",Unitname);
			}
		else
			printf("attention: unité sans nom!\n");
		return nb_inconnu;
	}

	int UNIT_MANAGER::all_units_in_hpi(char *filename)
	{
		HPI_FILE hpi;
		hpi.load(filename);
		char *file;
		int n=0;
		int nb_inconnu=0;
		int nb_unit_old=nb_unit;
		int size;
		while(file=hpi.find("/units",n++)) {
			if(strstr(strlwr(file),".fbi")!=NULL) {			// Si le fichier est au bon format
				char *nom=strdup(strstr(strstr(file,"/")+1,"/")+1);			// Vérifie si l'unité n'est pas déjà chargée
				*(strstr(nom,"."))=0;
				strupr(nom);

				if(get_unit_index(nom)==-1) {
					byte *data=hpi.extract_memory_file(file,&size);
					nb_inconnu+=load_unit(data,size);
					if(unit_type[nb_unit-1].Unitname) {
						char nom[100];
						nom[0]=0;
						strcat(nom,"/unitpics/");
						strcat(nom,unit_type[nb_unit-1].Unitname);
						strcat(nom,".pcx");
						byte *dat=hpi.extract_memory_file(nom);
						if(dat) {
							unit_type[nb_unit-1].unitpic=load_memory_pcx(dat,pal);
							if(unit_type[nb_unit-1].unitpic) {
								unit_type[nb_unit-1].glpic=allegro_gl_make_texture(unit_type[nb_unit-1].unitpic);
								glBindTexture(GL_TEXTURE_2D,unit_type[nb_unit-1].glpic);
								allegro_gl_set_texture_format(-1);
								glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MAG_FILTER,GL_LINEAR);
								glTexParameteri(GL_TEXTURE_2D,GL_TEXTURE_MIN_FILTER,GL_LINEAR);
								}
							free(dat);
							}
						else
							unit_type[nb_unit-1].unitpic=NULL;
						}
					free(data);
					}
				free(nom);
				}
			}

		for(int i=nb_unit_old;i<nb_unit;i++) {
			gather_unit_build_data(&hpi,unit_type[i].Unitname);
			load_script_file(&hpi,unit_type[i].Unitname);
			}
		gather_build_data(&hpi);

		hpi.destroy();
		return nb_inconnu;
	}

	int UNIT_MANAGER::unit_build_menu(int index,int omb)				// Affiche et gère le menu des unités
	{
		glEnable(GL_BLEND);
		glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);

		glDisable(GL_TEXTURE_2D);
		glColor4f(0.5f,0.5f,0.5f,0.5f);
		glBegin(GL_QUADS);
			glVertex2f(0.0f,128.0f);			// Barre latérale gauche
			glVertex2f(128.0f,128.0f);
			glVertex2f(128.0f,SCREEN_H);
			glVertex2f(0.0f,SCREEN_H);

			glVertex2f(128.0f,SCREEN_H-32.0f);		// Barre inférieure
			glVertex2f(SCREEN_W,SCREEN_H-32.0f);
			glVertex2f(SCREEN_W,SCREEN_H);
			glVertex2f(128.0f,SCREEN_H);

			glVertex2f(128.0f,0.0f);				// Barre supérieure
			glVertex2f(SCREEN_W,0.0f);
			glVertex2f(SCREEN_W,32.0f);
			glVertex2f(128.0f,32.0f);
		glEnd();
		glColor4f(1.0f,1.0f,1.0f,0.75f);

		glEnable(GL_TEXTURE_2D);

		if(index<0 || index>=nb_unit) return -1;		// L'indice est incorrect

		int page=unit_type[index].page;

		int sel=-1;

		for(int i=6*page;i<min(unit_type[index].nb_unit,6*page+6);i++) {		// Affiche les différentes images d'unités constructibles
			if(mouse_x>=(i&1)*64 && mouse_x<(i&1)*64+64 && mouse_y>=128+(i-6*page>>1)*64 && mouse_y<192+(i-6*page>>1)*64) {
				glBlendFunc(GL_ONE,GL_ONE_MINUS_SRC_COLOR);
				sel=unit_type[index].BuildList[i];
				}
			else
				glBlendFunc(GL_SRC_ALPHA,GL_ONE_MINUS_SRC_ALPHA);
			PutTex(unit_type[unit_type[index].BuildList[i]].glpic,(i&1)*64,128+(i-6*page>>1)*64,(i&1)*64+64,192+(i-6*page>>1)*64);
			}
		glColor4f(1.0f,1.0f,1.0f,1.0f);
		glDisable(GL_BLEND);

		if(unit_type[index].nb_unit>0) {
			bool prec=false,suiv=false;

			if(mouse_b==1 && mouse_y>=320 && mouse_y<=336) {
				if(mouse_x>=5 && mouse_x<62)
					prec=true;
				if(mouse_x>66 && mouse_x<=123)
					suiv=true;
				}

			if(prec && omb!=1 && page>=1)
				unit_type[index].page--;
			if(suiv && omb!=1 && page*6+6<unit_type[index].nb_unit)
				unit_type[index].page++;

			glbutton("prec.",5.0f,320.0f,61.5f,336.0f,prec);
			glbutton("suiv.",66.5f,320.0f,123.0f,336.0f,suiv);
			}

		if(sel>-1) {
			glEnable(GL_BLEND);
			glBlendFunc(GL_ONE,GL_ONE_MINUS_SRC_COLOR);
			allegro_gl_printf(aglfont,128.0f,SCREEN_H-48,0.0f,0xFFFFFF,"%s M:%d E:%d",unit_type[sel].name,unit_type[sel].BuildCostMetal,unit_type[sel].BuildCostEnergy);
			if(unit_type[sel].Description)
				allegro_gl_printf(aglfont,128.0f,SCREEN_H-40,0.0f,0xFFFFFF,"%s",unit_type[sel].Description);
			glDisable(GL_BLEND);
			}

		return sel;
	}
