/*  TA3D, a remake of Total Annihilation
    Copyright (C) 2005  Roland BROCHARD

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA*/

/*-----------------------------------------------------------------------------------\
|                                      weapons.cpp                                   |
|   Ce module contient les structures, classes et fonctions nécessaires à la lecture |
| des fichiers tdf du jeu totalannihilation concernant les armes utilisées par les   |
| unités du jeu.                                                                     |
|                                                                                    |
\-----------------------------------------------------------------------------------*/

#include <allegro.h>
#include <alleggl.h>
#include <GL/glu.h>
#include "ta3dbase.h"
#include "3do.h"
#include "weapons.h"

WEAPON_MANAGER		weapon_manager;

void WEAPON_MANAGER::load_tdf(char *data,int size)
{
	char *pos=data;
	char *ligne=NULL;
	int nb=0;
	int index=0;
	int	first=nb_weapons;
	char *limit=data+size;
	char *f;
	do {
		do
		{
			nb++;
			if(ligne)
				delete ligne;
			ligne=get_line(pos);
			strlwr(ligne);
			while(pos[0]!=0 && pos[0]!=13 && pos[0]!=10)	pos++;
			while(pos[0]==13 || pos[0]==10)	pos++;

			if(strstr(ligne,"//") || strstr(ligne,"/*") || strstr(ligne,"{")) { }		// Saute les commentaires
			else if(ligne[0]=='[') {
				if(strstr(ligne,"]"))
					*(strstr(ligne,"]"))=0;
				index=add_weapon(ligne+1);
				}
			else if(f=strstr(ligne,"[damage]")) {		// Si on a trouvé un paragraphe référant aux dégats
				do {				// Parcour le paragraphe
					nb++;
					if(ligne)
						delete ligne;
					ligne=get_line(pos);
					strlwr(ligne);
					while(pos[0]!=0 && pos[0]!=13 && pos[0]!=10)	pos++;
					while(pos[0]==13 || pos[0]==10)	pos++;

					if(f=strstr(ligne,"default=")) {
						*(strstr(ligne,";"))=0;
						weapon[index].damage=atoi(f+8);
						}
				} while(strstr(ligne,"}")==NULL && nb<1000 && pos<limit);
				}
			else if(f=strstr(ligne,"name=")) {
				*(strstr(ligne,";"))=0;
				weapon[index].name=strdup(f+5);
				}
			else if(f=strstr(ligne,"id=")) {
				*(strstr(ligne,";"))=0;
				weapon[index].weapon_id=atoi(f+3);
				}
			else if(f=strstr(ligne,"rendertype=")) {
				*(strstr(ligne,";"))=0;
				weapon[index].rendertype=atoi(f+11);
				}
			else if(f=strstr(ligne,"ballistic=")) {
				*(strstr(ligne,";"))=0;
				weapon[index].ballistic=(f[10]=='1');
				}
			else if(f=strstr(ligne,"turret=")) {
				*(strstr(ligne,";"))=0;
				weapon[index].turret=(f[7]=='1');
				}
			else if(f=strstr(ligne,"range=")) {
				*(strstr(ligne,";"))=0;
				weapon[index].range=atoi(f+6);
				}
			else if(f=strstr(ligne,"reloadtime=")) {
				*(strstr(ligne,";"))=0;
				weapon[index].reloadtime=atof(f+11);
				}
			else if(f=strstr(ligne,"weaponvelocity=")) {
				*(strstr(ligne,";"))=0;
				weapon[index].weaponvelocity=atoi(f+15);
				}
			else if(f=strstr(ligne,"areaofeffect=")) {
				*(strstr(ligne,";"))=0;
				weapon[index].areaofeffect=atoi(f+13);
				}
			else if(f=strstr(ligne,"startsmoke=")) {
				*(strstr(ligne,";"))=0;
				weapon[index].startsmoke=(f[11]=='1');
				}
			else if(f=strstr(ligne,"firestarter=")) {
				*(strstr(ligne,";"))=0;
				weapon[index].firestarter=(f[12]=='1');
				}
			else if(f=strstr(ligne,"accuracy=")) {
				*(strstr(ligne,";"))=0;
				weapon[index].accuracy=atoi(f+9);
				}
			else if(f=strstr(ligne,"aimrate=")) {
				*(strstr(ligne,";"))=0;
				weapon[index].aimrate=atoi(f+8);
				}
			else if(f=strstr(ligne,"tolerance=")) {
				*(strstr(ligne,";"))=0;
				weapon[index].tolerance=atoi(f+9);
				}
			else if(f=strstr(ligne,"holdtime=")) {
				*(strstr(ligne,";"))=0;
				weapon[index].holdtime=atoi(f+8);
				}
			else if(f=strstr(ligne,"energypershot=")) {
				*(strstr(ligne,";"))=0;
				weapon[index].energypershot=atoi(f+14);
				}
			else if(f=strstr(ligne,"metalpershot=")) {
				*(strstr(ligne,";"))=0;
				weapon[index].metalpershot=atoi(f+13);
				}
			else if(f=strstr(ligne,"minbarrelangle=")) {
				*(strstr(ligne,";"))=0;
				weapon[index].minbarrelangle=atoi(f+15);
				}
			else if(f=strstr(ligne,"unitsonly=")) {
				*(strstr(ligne,";"))=0;
				weapon[index].unitsonly=(f[10]=='1');
				}
			else if(f=strstr(ligne,"edgeeffectiveness=")) {
				*(strstr(ligne,";"))=0;
				weapon[index].edgeeffectiveness=atoi(f+18);
				}
			else if(f=strstr(ligne,"lineofsight=")) {
				*(strstr(ligne,";"))=0;
				weapon[index].lineofsight=(f[12]=='1');
				}
			else if(f=strstr(ligne,"soundtrigger=")) {
				*(strstr(ligne,";"))=0;
				weapon[index].soundtrigger=(f[13]=='1');
				}
			else if(f=strstr(ligne,"color=")) {
				*(strstr(ligne,";"))=0;
				int c=atoi(f+6);
				weapon[index].color[0]=makecol(pal[c].r,pal[c].g,pal[c].b);
				}
			else if(f=strstr(ligne,"color2=")) {
				*(strstr(ligne,";"))=0;
				int c=atoi(f+7);
				weapon[index].color[1]=makecol(pal[c].r,pal[c].g,pal[c].b);
				}
			else if(f=strstr(ligne,"burstrate=")) {
				*(strstr(ligne,";"))=0;
				weapon[index].edgeeffectiveness=atof(f+10);
				}
			else if(f=strstr(ligne,"duration=")) {
				*(strstr(ligne,";"))=0;
				weapon[index].duration=atof(f+9);
				}
			else if(f=strstr(ligne,"beamweapon=")) {
				*(strstr(ligne,";"))=0;
				weapon[index].beamweapon=(f[11]=='1');
				}
			else if(f=strstr(ligne,"startvelocity=")) {
				*(strstr(ligne,";"))=0;
				weapon[index].startvelocity=atoi(f+14);
				}
			else if(f=strstr(ligne,"weapontimer=")) {
				*(strstr(ligne,";"))=0;
				weapon[index].weapontimer=atoi(f+12);
				}
			else if(f=strstr(ligne,"weaponacceleration=")) {
				*(strstr(ligne,";"))=0;
				weapon[index].weaponacceleration=atoi(f+19);
				}
			else if(f=strstr(ligne,"turnrate=")) {
				*(strstr(ligne,";"))=0;
				weapon[index].turnrate=atoi(f+9);
				}
			else if(f=strstr(ligne,"model=")) {
				*(strstr(ligne,";"))=0;
				weapon[index].model=model_manager.get_model(f+6);
				}
			else if(f=strstr(ligne,"smokedelay=")) {
				*(strstr(ligne,";"))=0;
				weapon[index].smokedelay=atof(f+11);
				}
			else if(f=strstr(ligne,"guidance=")) {
				*(strstr(ligne,";"))=0;
				weapon[index].guidance=(f[9]=='1');
				}
			else if(f=strstr(ligne,"tracks=")) {
				*(strstr(ligne,";"))=0;
				weapon[index].tracks=(f[7]=='1');
				}
			else if(f=strstr(ligne,"selfprop=")) {
				*(strstr(ligne,";"))=0;
				weapon[index].selfprop=(f[9]=='1');
				}
			else if(f=strstr(ligne,"smoketrail=")) {
				*(strstr(ligne,";"))=0;
				weapon[index].smoketrail=(f[11]=='1');
				}
			else if(f=strstr(ligne,"noautorange=")) {
				*(strstr(ligne,";"))=0;
				weapon[index].noautorange=(f[12]=='1');
				}
			else if(f=strstr(ligne,"flighttime=")) {
				*(strstr(ligne,";"))=0;
				weapon[index].flighttime=atoi(f+11);
				}
			else if(f=strstr(ligne,"vlaunch=")) {
				*(strstr(ligne,";"))=0;
				weapon[index].vlaunch=(f[8]=='1');
				}
			else if(f=strstr(ligne,"stockpile=")) {
				*(strstr(ligne,";"))=0;
				weapon[index].stockpile=(f[10]=='1');
				}
			else if(f=strstr(ligne,"targetable=")) {
				*(strstr(ligne,";"))=0;
				weapon[index].targetable=(f[11]=='1');
				}
			else if(f=strstr(ligne,"commandfire=")) {
				*(strstr(ligne,";"))=0;
				weapon[index].commandfire=(f[12]=='1');
				}
			else if(f=strstr(ligne,"cruise=")) {
				*(strstr(ligne,";"))=0;
				weapon[index].cruise=(f[7]=='1');
				}
			else if(f=strstr(ligne,"propeller=")) {
				*(strstr(ligne,";"))=0;
				weapon[index].propeller=(f[10]=='1');
				}
			else if(f=strstr(ligne,"twophase=")) {
				*(strstr(ligne,";"))=0;
				weapon[index].twophase=(f[9]=='1');
				}
			else if(f=strstr(ligne,"shakemagnitude=")) {
				*(strstr(ligne,";"))=0;
				weapon[index].shakemagnitude=atoi(f+15);
				}
			else if(f=strstr(ligne,"shakeduration=")) {
				*(strstr(ligne,";"))=0;
				weapon[index].shakeduration=atof(f+14);
				}
			else if(f=strstr(ligne,"explosiongaf=")) {	}
			else if(f=strstr(ligne,"explosionart=")) {	}
			else if(f=strstr(ligne,"waterexplosiongaf=")) {	}
			else if(f=strstr(ligne,"waterexplosionart=")) {	}
			else if(f=strstr(ligne,"lavaexplosiongaf=")) {	}
			else if(f=strstr(ligne,"lavaexplosionart=")) {	}
			else if(f=strstr(ligne,"soundhit=")) {	}
			else if(f=strstr(ligne,"soundstart=")) {	}
			else
				printf("(arme) inconnu: %s\n",ligne);

		} while(strstr(ligne,"}")==NULL && nb<1000 && pos<limit);
		delete ligne;
		ligne=NULL;
	} while(pos[0]=='[' && nb<1000 && pos<limit);
}

void load_all_weapons_in_hpi(char *filename)
{
	HPI_FILE hpi;
	hpi.load(filename);
	char *file;
	int n[10];
	int d_index=0;
	char *dir[10];
	int size;
	dir[0]=strdup("/Weapons");
	n[0]=0;
	while(d_index>-1) {
		while(file=hpi.find(dir[d_index],n[d_index]++)) {
			if(hpi.is_dir(file)) {
				dir[++d_index]=strdup(file);
				n[d_index]=0;
				}
			if(strstr(strlwr(file),".tdf")!=NULL) {			// Si le fichier est au bon format
				char *data=(char*)hpi.extract_memory_file(file,&size);
				weapon_manager.load_tdf(data,size);
				free(data);
				}
			delete file;
			}
		free(dir[d_index--]);
		}

	hpi.destroy();
}

void load_weapons()				// Charge toutes les armes
{
	al_ffblk search;

	if(al_findfirst("*.hpi",&search,0)==0)
	do
	{
		load_all_weapons_in_hpi(search.name);
	}while(al_findnext(&search)==0);
	al_findclose(&search);
	if(al_findfirst("*.ufo",&search,0)==0)
	do
	{
		load_all_weapons_in_hpi(search.name);
	}while(al_findnext(&search)==0);
	al_findclose(&search);
	if(al_findfirst("*.ccx",&search,0)==0)
	do
	{
		load_all_weapons_in_hpi(search.name);
	}while(al_findnext(&search)==0);
	al_findclose(&search);

	load_all_weapons_in_hpi("rev31.gp3");
}
