#include <allegro.h>

/* include the proper sound header */
#ifdef ALLEGRO_WINDOWS
    #include "t3sswin.h"
#else
    #ifdef __DJGPP__
        #include "t3ssdos.h"
    #else
        #include "t3ssal.h"
    #endif
#endif

#include "theme.h"
#include "reverse.h"

/* load theme from file pointer */
int load_reverse_theme_fp(REVERSE_THEME * tp, PACKFILE * fp)
{
    char header[4];
    int i, j;

    /* make sure it's the right kind of file */
    pack_fread(header, 4, fp);
    if(header[0] != 'R' || header[1] != 'T' || header[2] != 'H' || header[3] != 21)
    {
        return 0;
    }

    /* load layout data */
    tp->boardx = pack_igetl(fp);
    tp->boardy = pack_igetl(fp);
    tp->scorex[0] = pack_igetl(fp);
    tp->scorey[0] = pack_igetl(fp);
    tp->scorex[1] = pack_igetl(fp);
    tp->scorey[1] = pack_igetl(fp);
    tp->mousex = pack_igetl(fp);
    tp->mousey = pack_igetl(fp);

    /* load graphics data */
    tp->backdrop = create_bitmap(REVERSE_RX, REVERSE_RY);
    for(i = 0; i < REVERSE_RY; i++)
    {
        for(j = 0; j < REVERSE_RX; j++)
        {
            tp->backdrop->line[i][j] = pack_getc(fp);
        }
    }
    load_animation_fp(&tp->piece[0], fp);
    load_animation_fp(&tp->piece[1], fp);
    load_animation_fp(&tp->flip[0], fp);
    load_animation_fp(&tp->flip[1], fp);
    load_animation_fp(&tp->cursor[0], fp);
    load_animation_fp(&tp->cursor[1], fp);
    load_animation_fp(&tp->select[0], fp);
    load_animation_fp(&tp->select[1], fp);
    load_ncdfont_fp(&tp->font, fp);

    /* load the palette */
    for(i = 0; i < 256; i++)
    {
        tp->palette[i].r = pack_getc(fp);
        tp->palette[i].g = pack_getc(fp);
        tp->palette[i].b = pack_getc(fp);
    }

    /* load sounds */
    for(i = 0; i < REVERSE_THEME_SOUNDS; i++)
    {
        tp->sound[i] = t3ss_load_wav_fp(fp);
    }

    return 1;
}

/* load theme from filename */
int load_reverse_theme(REVERSE_THEME * tp, char * fn)
{
    PACKFILE * fp;

    fp = pack_fopen(fn, "r");
    if(fp == NULL)
    {
        return 0;
    }

    if(!load_reverse_theme_fp(tp, fp))
    {
        pack_fclose(fp);
        return 0;
    }

    pack_fclose(fp);
    return 1;
}

/* save theme to file pointer */
int save_reverse_theme_fp(REVERSE_THEME * tp, PACKFILE * fp)
{
    char header[4] = {'R', 'T', 'H', 21};
    int i, j;

    /* write identifier */
    pack_fwrite(header, 4, fp);

    /* save layout data */
    pack_iputl(tp->boardx, fp);
    pack_iputl(tp->boardy, fp);
    pack_iputl(tp->scorex[0], fp);
    pack_iputl(tp->scorey[0], fp);
    pack_iputl(tp->scorex[1], fp);
    pack_iputl(tp->scorey[1], fp);
    pack_iputl(tp->mousex, fp);
    pack_iputl(tp->mousey, fp);

    /* save graphics data */
    for(i = 0; i < REVERSE_RY; i++)
    {
        for(j = 0; j < REVERSE_RX; j++)
        {
            pack_putc(tp->backdrop->line[i][j], fp);
        }
    }
    save_animation_fp(&tp->piece[0], fp);
    save_animation_fp(&tp->piece[1], fp);
    save_animation_fp(&tp->flip[0], fp);
    save_animation_fp(&tp->flip[1], fp);
    save_animation_fp(&tp->cursor[0], fp);
    save_animation_fp(&tp->cursor[1], fp);
    save_animation_fp(&tp->select[0], fp);
    save_animation_fp(&tp->select[1], fp);
    save_ncdfont_fp(&tp->font, fp);

    /* save the palette */
    for(i = 0; i < 256; i++)
    {
        pack_putc(tp->palette[i].r, fp);
        pack_putc(tp->palette[i].g, fp);
        pack_putc(tp->palette[i].b, fp);
    }

    /* save sounds */
    for(i = 0; i < REVERSE_THEME_SOUNDS; i++)
    {
        t3ss_save_wav_fp(tp->sound[i], fp);
    }

    return 1;
}

/* save theme to filename */
int save_reverse_theme(REVERSE_THEME * tp, char * fn)
{
    PACKFILE * fp;

    fp = pack_fopen(fn, "w");
    if(fp == NULL)
    {
        return 0;
    }

    if(!save_reverse_theme_fp(tp, fp))
    {
        pack_fclose(fp);
        return 0;
    }

    pack_fclose(fp);
    return 1;
}

/* destroy loaded theme */
void destroy_reverse_theme(REVERSE_THEME * tp)
{
    int i;

    destroy_bitmap(tp->backdrop);
    for(i = 0; i < 2; i++)
    {
        destroy_animation(&tp->piece[i]);
        destroy_animation(&tp->flip[i]);
        destroy_animation(&tp->cursor[i]);
        destroy_animation(&tp->select[i]);
    }
    destroy_ncdfont(&tp->font);
    for(i = 0; i < 5; i++)
    {
        t3ss_free_wav(tp->sound[i]);
    }
}
