#ifndef CORE_H
#define CORE_H

#include "reverse.h"
#include "random.h"
#include "player.h"

#define REVERSE_AI_TYPE_BEGINNER     0
#define REVERSE_AI_TYPE_INTERMEDIATE 1
#define REVERSE_AI_TYPE_ADVANCED     2
#define REVERSE_AI_TYPE_EXPERT       3

typedef struct
{

    int x, y, amount;

} REVERSE_AI_MOVE;

typedef struct
{

    REVERSE_AI_MOVE move[REVERSE_BOARD_RX * REVERSE_BOARD_RY];
    int             move_count;

} REVERSE_AI_MOVE_LIST;

void reverse_reset_board(REVERSE_BOARD * bp);
void reverse_handle_changes(REVERSE_BOARD * bp, int turn);
void reverse_clear_changes(REVERSE_BOARD * bp);
int reverse_place(REVERSE_BOARD * bp, int turn, int x, int y);
int reverse_game_over(REVERSE_BOARD * bp);
void reverse_update_score(REVERSE_BOARD * bp, REVERSE_PLAYER * pp, int turn);
int reverse_ai_place(REVERSE_BOARD * bp, int turn, int type);
int reverse_winner(void);
int reverse_can_pass(REVERSE_BOARD * bp, int turn);

#endif
