 #include <allegro.h>

/* include the proper sound header */
#ifdef ALLEGRO_WINDOWS
    #include "t3sswin.h"
#else
    #ifdef __DJGPP__
        #include "t3ssdos.h"
    #else
        #include "t3ssal.h"
    #endif
#endif

#include "theme.h"
#include "menu.h"
#include "player.h"
#include "reverse.h"
#include "title.h"
#include "core.h"

#include "animate.h"

/* title stuff */
ANIMATION       title_animation;
BITMAP *        title_backdrop;
BITMAP *        reverse_menu_text[17] = {NULL};
extern BITMAP * reverse_screen;
extern BITMAP * reverse_cursor;
PALETTE         title_palette;
extern PALETTE  white_palette;
int             title_frame = 0;
REVERSE_MENU    reverse_menu[6];
int reverse_quit = 0;
int reverse_selected_menu = 0;
MSAMPLE * menu_move_sound;
MSAMPLE * menu_select_sound;
MSAMPLE * menu_fade_sound;
MSAMPLE * menu_back_sound;

/* game options */
int reverse_music_volume = 100;
int reverse_sound_volume = 100;
int reverse_mixing_quality = 1;
int reverse_mixing_quality_array[3] = {11025, 22050, 44100};
int reverse_difficulty = REVERSE_AI_TYPE_INTERMEDIATE;
int reverse_1st = 0;
int reverse_controller = 0;
int reverse_frame_skip = 0;
int reverse_vsync = 1;
char reverse_theme_filename[256] = "reverse.rth";
char reverse_theme_musicname[256] = "reverse.dat#reverse_game_music";
int reverse_logic_frames_t = 0;
int reverse_logic_frames;
int demo_timer = 0;

extern REVERSE_THEME reverse_theme;
extern REVERSE_PLAYER reverse_player[2];
extern int lblock;
extern int rblock;
extern int bblock;
extern int windowed;
int bbblock = 0;

/* increment frames for frameskip */
void frame_timer(void)
{
    reverse_logic_frames_t++;
}
END_OF_FUNCTION(frame_timer);

/* load config file */
int reverse_load_config(char * fn)
{
    PACKFILE * fp;
    int temp;

    fp = pack_fopen(fn, "r");
    if(fp == NULL)
    {
        return 0;
    }
    reverse_music_volume = pack_igetl(fp);
    reverse_sound_volume = pack_igetl(fp);
    reverse_mixing_quality = pack_igetl(fp);
    reverse_difficulty = pack_igetl(fp);
    reverse_1st = pack_igetl(fp);
    reverse_controller = pack_igetl(fp);
    reverse_frame_skip = pack_igetl(fp);
    reverse_vsync = pack_igetl(fp);
    temp = pack_igetl(fp);
    if(!windowed)
    {
        windowed = temp;
    }
    pack_fread(reverse_theme_filename, 256, fp);
    pack_fread(reverse_theme_musicname, 256, fp);
    pack_fclose(fp);

    return 1;
}

/* saves config file */
int reverse_save_config(char * fn)
{
    PACKFILE * fp;

    fp = pack_fopen(fn, "w");
    if(fp == NULL)
    {
        return 0;
    }
    pack_iputl(reverse_music_volume, fp);
    pack_iputl(reverse_sound_volume, fp);
    pack_iputl(reverse_mixing_quality, fp);
    pack_iputl(reverse_difficulty, fp);
    pack_iputl(reverse_1st, fp);
    pack_iputl(reverse_controller, fp);
    pack_iputl(reverse_frame_skip, fp);
    pack_iputl(reverse_vsync, fp);
    pack_iputl(windowed, fp);
    pack_fwrite(reverse_theme_filename, 256, fp);
    pack_fwrite(reverse_theme_musicname, 256, fp);
    pack_fclose(fp);

    return 1;
}

/* fixes a palette (since Allegro doesn't seem to load black correctly) */
void fix_palette(PALETTE pp)
{
    pp[255].r = 0;
    pp[255].g = 0;
    pp[255].b = 0;
}

/* transition a menu out */
void reverse_menu_out(void)
{
    float sx, sy;
    float dx, dy;
    float vx, vy;
    float bx, by;
    float bvx, bvy;
    float x, y;
    int i, j;

    sx = REVERSE_RX - reverse_menu[reverse_selected_menu].item[reverse_menu[reverse_selected_menu].selected].icon->w;
    sy = REVERSE_RY - reverse_menu[reverse_selected_menu].item[reverse_menu[reverse_selected_menu].selected].icon->h;
    x = sx;
    y = sy;
    dx = REVERSE_RX / 2 - reverse_menu[reverse_selected_menu].item[reverse_menu[reverse_selected_menu].selected].icon->w;
    dy = REVERSE_RY / 2 - reverse_menu[reverse_selected_menu].item[reverse_menu[reverse_selected_menu].selected].icon->h;
    vx = (sx - dx) / 30.0;
    vy = (sy - dy) / 30.0;
    bx = reverse_menu[reverse_selected_menu].item[reverse_menu[reverse_selected_menu].selected].icon->w;
    by = reverse_menu[reverse_selected_menu].item[reverse_menu[reverse_selected_menu].selected].icon->h;
    bvx = (bx) / 30;
    bvy = (by) / 30;

    if(reverse_frame_skip)
    {
        i = 0;
        while(i < 30)
        {
            clear_to_color(reverse_screen, 31);
            draw_animation(&title_animation, title_frame, reverse_screen, 10, 10 - 3 * i);
            if(reverse_menu[reverse_selected_menu].item[reverse_menu[reverse_selected_menu].selected].icon != NULL)
            {
                stretch_sprite(reverse_screen, reverse_menu[reverse_selected_menu].item[reverse_menu[reverse_selected_menu].selected].icon, x, y, bx, by);
            }
            if(reverse_vsync)
            {
                vsync();
            }
            reverse_blit(reverse_screen);
            reverse_logic_frames = reverse_logic_frames_t;
            reverse_logic_frames_t = 0;
            for(j = 0; j < reverse_logic_frames; j++)
            {
                title_frame++;
                x -= vx;
                y -= vy;
                bx += bvx;
                by += bvy;
                i++;
            }
        }
    }
    else
    {
        for(i = 0; i < 30; i++)
        {
            clear_to_color(reverse_screen, 31);
            draw_animation(&title_animation, title_frame, reverse_screen, 10, 10 - 3 * i);
            if(reverse_menu[reverse_selected_menu].item[reverse_menu[reverse_selected_menu].selected].icon != NULL)
            {
                stretch_sprite(reverse_screen, reverse_menu[reverse_selected_menu].item[reverse_menu[reverse_selected_menu].selected].icon, x, y, bx, by);
            }
            if(reverse_vsync)
            {
                vsync();
            }
            reverse_blit(reverse_screen);
            title_frame++;
            x -= vx;
            y -= vy;
            bx += bvx;
            by += bvy;
        }
    }
    t3ss_play_sound(menu_fade_sound, 128, 22050);
    fade_from(title_palette, white_palette, 3);
}

/* transition a menu in */
void reverse_menu_in(void)
{
    float sx, sy;
    float dx, dy;
    float vx, vy;
    float bx, by;
    float bvx, bvy;
    float x, y;
    int i, j;

    sx = REVERSE_RX - reverse_menu[reverse_selected_menu].item[reverse_menu[reverse_selected_menu].selected].icon->w;
    sy = REVERSE_RY - reverse_menu[reverse_selected_menu].item[reverse_menu[reverse_selected_menu].selected].icon->h;
    dx = REVERSE_RX / 2 - reverse_menu[reverse_selected_menu].item[reverse_menu[reverse_selected_menu].selected].icon->w;
    dy = REVERSE_RY / 2 - reverse_menu[reverse_selected_menu].item[reverse_menu[reverse_selected_menu].selected].icon->h;
    x = dx;
    y = dy;
    vx = (sx - dx) / 30.0;
    vy = (sy - dy) / 30.0;
    bx = reverse_menu[reverse_selected_menu].item[reverse_menu[reverse_selected_menu].selected].icon->w * 2;
    by = reverse_menu[reverse_selected_menu].item[reverse_menu[reverse_selected_menu].selected].icon->h * 2;
    bvx = (bx) / 60;
    bvy = (by) / 60;

    clear_to_color(reverse_screen, 31);
    stretch_sprite(reverse_screen, reverse_menu[reverse_selected_menu].item[reverse_menu[reverse_selected_menu].selected].icon, x, y, bx, by);
    reverse_blit(reverse_screen);
    fade_from(white_palette, title_palette, 3);
    reverse_logic_frames_t = 0;
    if(reverse_frame_skip)
    {
        i = 0;
        while(i < 30)
        {
            clear_to_color(reverse_screen, 31);
            draw_animation(&title_animation, title_frame, reverse_screen, 10, 10 - 90 + 3 * i);
            if(reverse_menu[reverse_selected_menu].item[reverse_menu[reverse_selected_menu].selected].icon != NULL)
            {
                stretch_sprite(reverse_screen, reverse_menu[reverse_selected_menu].item[reverse_menu[reverse_selected_menu].selected].icon, x, y, bx, by);
            }
            if(reverse_vsync)
            {
                vsync();
            }
            reverse_blit(reverse_screen);
            reverse_logic_frames = reverse_logic_frames_t;
            reverse_logic_frames_t = 0;
            for(j = 0; j < reverse_logic_frames; j++)
            {
                title_frame++;
                x += vx;
                y += vy;
                bx -= bvx;
                by -= bvy;
                i++;
            }
        }
    }
    else
    {
        for(i = 0; i < 30; i++)
        {
            clear_to_color(reverse_screen, 31);
            draw_animation(&title_animation, title_frame, reverse_screen, 10, 10 - 90 + 3 * i);
            if(reverse_menu[reverse_selected_menu].item[reverse_menu[reverse_selected_menu].selected].icon != NULL)
            {
                stretch_sprite(reverse_screen, reverse_menu[reverse_selected_menu].item[reverse_menu[reverse_selected_menu].selected].icon, x, y, bx, by);
            }
            if(reverse_vsync)
            {
                vsync();
            }
            reverse_blit(reverse_screen);
            title_frame++;
            x += vx;
            y += vy;
            bx -= bvx;
            by -= bvy;
        }
    }
}

/* transition a menu in */
void reverse_menu_back_in(void)
{
    float sx, sy;
    float dx, dy;
    float vx, vy;
    float bx, by;
    float bvx, bvy;
    float x, y;
    int i, j;

    sx = REVERSE_RX - reverse_menu[reverse_selected_menu].item[reverse_menu[reverse_selected_menu].selected].icon->w;
    sy = REVERSE_RY - reverse_menu[reverse_selected_menu].item[reverse_menu[reverse_selected_menu].selected].icon->h;
    dx = REVERSE_RX / 2 - reverse_menu[reverse_selected_menu].item[reverse_menu[reverse_selected_menu].selected].icon->w;
    dy = REVERSE_RY / 2 - reverse_menu[reverse_selected_menu].item[reverse_menu[reverse_selected_menu].selected].icon->h;
    x = dx;
    y = dy;
    vx = (sx - dx) / 30.0;
    vy = (sy - dy) / 30.0;
    bx = reverse_menu[reverse_selected_menu].item[reverse_menu[reverse_selected_menu].selected].icon->w * 2;
    by = reverse_menu[reverse_selected_menu].item[reverse_menu[reverse_selected_menu].selected].icon->h * 2;
    bvx = (bx) / 60;
    bvy = (by) / 60;

    clear_to_color(reverse_screen, 31);
    stretch_sprite(reverse_screen, reverse_menu[reverse_selected_menu].item[reverse_menu[reverse_selected_menu].selected].icon, x, y, bx, by);
    reverse_blit(reverse_screen);
    fade_from(white_palette, title_palette, 3);
    t3ss_play_mod("reverse.dat#reverse_title_music");
    reverse_logic_frames_t = 0;
    if(reverse_frame_skip)
    {
        i = 0;
        while(i < 30)
        {
            clear_to_color(reverse_screen, 31);
            draw_animation(&title_animation, title_frame, reverse_screen, 10, 10 - 90 + 3 * i);
            if(reverse_menu[reverse_selected_menu].item[reverse_menu[reverse_selected_menu].selected].icon != NULL)
            {
                stretch_sprite(reverse_screen, reverse_menu[reverse_selected_menu].item[reverse_menu[reverse_selected_menu].selected].icon, x, y, bx, by);
            }
            if(reverse_vsync)
            {
                vsync();
            }
            reverse_blit(reverse_screen);
            reverse_logic_frames = reverse_logic_frames_t;
            reverse_logic_frames_t = 0;
            for(j = 0; j < reverse_logic_frames; j++)
            {
                title_frame++;
                x += vx;
                y += vy;
                bx -= bvx;
                by -= bvy;
                i++;
            }
        }
    }
    else
    {
        for(i = 0; i < 30; i++)
        {
            clear_to_color(reverse_screen, 31);
            draw_animation(&title_animation, title_frame, reverse_screen, 10, 10 - 90 + 3 * i);
            if(reverse_menu[reverse_selected_menu].item[reverse_menu[reverse_selected_menu].selected].icon != NULL)
            {
                stretch_sprite(reverse_screen, reverse_menu[reverse_selected_menu].item[reverse_menu[reverse_selected_menu].selected].icon, x, y, bx, by);
            }
            if(reverse_vsync)
            {
                vsync();
            }
            reverse_blit(reverse_screen);
            title_frame++;
            x += vx;
            y += vy;
            bx -= bvx;
            by -= bvy;
        }
    }
    gui_fg_color = makecol(0, 0, 0);
    gui_bg_color = makecol(255, 255, 255);
}

/* update audio menu */
void reverse_menu_audio_update(void)
{
    /* draw music volume */
    rectfill(reverse_menu[REVERSE_MENU_AUDIO].item[0].bp[0], 16, 16, 16 + 102, 16 + 14, makecol(255, 255, 255));
    rectfill(reverse_menu[REVERSE_MENU_AUDIO].item[0].bp[0], 18, 18, 18 + reverse_music_volume, 18 + 12, makecol(128, 128, 128));
    rectfill(reverse_menu[REVERSE_MENU_AUDIO].item[0].bp[0], 16, 16, 16 + reverse_music_volume, 16 + 12, makecol(0, 192, 0));
    rectfill(reverse_menu[REVERSE_MENU_AUDIO].item[0].bp[1], 16, 16, 16 + 102, 16 + 14, makecol(255, 255, 255));
    rectfill(reverse_menu[REVERSE_MENU_AUDIO].item[0].bp[1], 18, 18, 18 + reverse_music_volume, 18 + 12, makecol(128, 128, 128));
    rectfill(reverse_menu[REVERSE_MENU_AUDIO].item[0].bp[1], 16, 16, 16 + reverse_music_volume, 16 + 12, makecol(0, 192, 0));

    /* draw sound volume */
    rectfill(reverse_menu[REVERSE_MENU_AUDIO].item[1].bp[0], 16, 16, 16 + 102, 16 + 14, makecol(255, 255, 255));
    rectfill(reverse_menu[REVERSE_MENU_AUDIO].item[1].bp[0], 18, 18, 18 + reverse_sound_volume, 18 + 12, makecol(128, 128, 128));
    rectfill(reverse_menu[REVERSE_MENU_AUDIO].item[1].bp[0], 16, 16, 16 + reverse_sound_volume, 16 + 12, makecol(0, 192, 0));
    rectfill(reverse_menu[REVERSE_MENU_AUDIO].item[1].bp[1], 16, 16, 16 + 102, 16 + 14, makecol(255, 255, 255));
    rectfill(reverse_menu[REVERSE_MENU_AUDIO].item[1].bp[1], 18, 18, 18 + reverse_sound_volume, 18 + 12, makecol(128, 128, 128));
    rectfill(reverse_menu[REVERSE_MENU_AUDIO].item[1].bp[1], 16, 16, 16 + reverse_sound_volume, 16 + 12, makecol(0, 192, 0));
    blit(reverse_menu_text[reverse_mixing_quality + REVERSE_MENU_TEXT_BAD], reverse_menu[REVERSE_MENU_AUDIO].item[2].bp[0], 0, 0, 16, 16, SCREEN_W, SCREEN_H);
    blit(reverse_menu_text[reverse_mixing_quality + REVERSE_MENU_TEXT_BAD], reverse_menu[REVERSE_MENU_AUDIO].item[2].bp[1], 0, 0, 16, 16, SCREEN_W, SCREEN_H);
}

/* update game menu */
void reverse_menu_game_update(void)
{
    blit(reverse_menu_text[reverse_difficulty + REVERSE_MENU_TEXT_BEGINNER], reverse_menu[REVERSE_MENU_GAME].item[0].bp[0], 0, 0, 16, 16, SCREEN_W, SCREEN_H);
    blit(reverse_menu_text[reverse_difficulty + REVERSE_MENU_TEXT_BEGINNER], reverse_menu[REVERSE_MENU_GAME].item[0].bp[1], 0, 0, 16, 16, SCREEN_W, SCREEN_H);
    blit(reverse_menu_text[reverse_1st + REVERSE_MENU_TEXT_RANDOM], reverse_menu[REVERSE_MENU_GAME].item[1].bp[0], 0, 0, 16, 16, SCREEN_W, SCREEN_H);
    blit(reverse_menu_text[reverse_1st + REVERSE_MENU_TEXT_RANDOM], reverse_menu[REVERSE_MENU_GAME].item[1].bp[1], 0, 0, 16, 16, SCREEN_W, SCREEN_H);
    blit(reverse_menu_text[reverse_controller + REVERSE_MENU_TEXT_ALL], reverse_menu[REVERSE_MENU_GAME].item[2].bp[0], 0, 0, 16, 16, SCREEN_W, SCREEN_H);
    blit(reverse_menu_text[reverse_controller + REVERSE_MENU_TEXT_ALL], reverse_menu[REVERSE_MENU_GAME].item[2].bp[1], 0, 0, 16, 16, SCREEN_W, SCREEN_H);
}

/* update graphics menu */
void reverse_menu_graphics_update(void)
{
    blit(reverse_menu_text[reverse_frame_skip == 0 ? REVERSE_MENU_TEXT_OFF : REVERSE_MENU_TEXT_AUTO], reverse_menu[REVERSE_MENU_GRAPHICS].item[0].bp[0], 0, 0, 16, 16, SCREEN_W, SCREEN_H);
    blit(reverse_menu_text[reverse_frame_skip == 0 ? REVERSE_MENU_TEXT_OFF : REVERSE_MENU_TEXT_AUTO], reverse_menu[REVERSE_MENU_GRAPHICS].item[0].bp[1], 0, 0, 16, 16, SCREEN_W, SCREEN_H);
    blit(reverse_menu_text[reverse_vsync == 0 ? REVERSE_MENU_TEXT_OFF : REVERSE_MENU_TEXT_ON], reverse_menu[REVERSE_MENU_GRAPHICS].item[1].bp[0], 0, 0, 16, 16, SCREEN_W, SCREEN_H);
    blit(reverse_menu_text[reverse_vsync == 0 ? REVERSE_MENU_TEXT_OFF : REVERSE_MENU_TEXT_ON], reverse_menu[REVERSE_MENU_GRAPHICS].item[1].bp[1], 0, 0, 16, 16, SCREEN_W, SCREEN_H);
}

/* change music volume */
void reverse_menu_music_left(void)
{
    if(reverse_music_volume > 0)
    {
        reverse_music_volume--;
        t3ss_set_music_volume(reverse_music_volume);
        t3ss_play_sound(menu_move_sound, 128, 22050);
        reverse_menu_audio_update();
        lblock = -1;
    }
}

/* change music volume */
void reverse_menu_music_right(void)
{
    if(reverse_music_volume < 100)
    {
        reverse_music_volume++;
        t3ss_set_music_volume(reverse_music_volume);
        t3ss_play_sound(menu_move_sound, 128, 22050);
        reverse_menu_audio_update();
        rblock = -1;
    }
}

/* change sound volume */
void reverse_menu_sound_left(void)
{
    if(reverse_sound_volume > 0)
    {
        reverse_sound_volume--;
        t3ss_set_sound_volume(reverse_sound_volume);
        t3ss_play_sound(menu_move_sound, 128, 22050);
        reverse_menu_audio_update();
        lblock = -1;
    }
}

/* change sound volume */
void reverse_menu_sound_right(void)
{
    if(reverse_sound_volume < 100)
    {
        reverse_sound_volume++;
        t3ss_set_sound_volume(reverse_sound_volume);
        t3ss_play_sound(menu_move_sound, 128, 22050);
        reverse_menu_audio_update();
        rblock = -1;
    }
}

/* change mixer setting */
void reverse_menu_mixing_left(void)
{
    if(reverse_mixing_quality > 0)
    {
        reverse_mixing_quality--;
        t3ss_play_sound(menu_move_sound, 128, 22050);
        reverse_menu_audio_update();
        clear_keybuf();
        key[KEY_LEFT] = 0;
    }
}

/* change mixer setting */
void reverse_menu_mixing_right(void)
{
    if(reverse_mixing_quality < 2)
    {
        reverse_mixing_quality++;
        t3ss_play_sound(menu_move_sound, 128, 22050);
        reverse_menu_audio_update();
        clear_keybuf();
        key[KEY_RIGHT] = 0;
    }
}

/* change AI setting */
void reverse_menu_difficulty_left(void)
{
    if(reverse_difficulty > 0)
    {
        reverse_difficulty--;
        t3ss_play_sound(menu_move_sound, 128, 22050);
        reverse_menu_game_update();
        clear_keybuf();
        key[KEY_LEFT] = 0;
    }
}

/* change AI setting */
void reverse_menu_difficulty_right(void)
{
    if(reverse_difficulty < 3)
    {
        reverse_difficulty++;
        t3ss_play_sound(menu_move_sound, 128, 22050);
        reverse_menu_game_update();
        clear_keybuf();
        key[KEY_RIGHT] = 0;
    }
}

/* change 1st player setting */
void reverse_menu_1st_left(void)
{
    if(reverse_1st > 0)
    {
        reverse_1st--;
        t3ss_play_sound(menu_move_sound, 128, 22050);
        reverse_menu_game_update();
        clear_keybuf();
        key[KEY_LEFT] = 0;
    }
}

/* change 1st player setting */
void reverse_menu_1st_right(void)
{
    if(reverse_1st < 2)
    {
        reverse_1st++;
        t3ss_play_sound(menu_move_sound, 128, 22050);
        reverse_menu_game_update();
        clear_keybuf();
        key[KEY_RIGHT] = 0;
    }
}

/* change controller setting */
void reverse_menu_controller_left(void)
{
    if(reverse_controller > 0)
    {
        reverse_controller--;
        t3ss_play_sound(menu_move_sound, 128, 22050);
        reverse_menu_game_update();
        if(reverse_controller == REVERSE_CONTROL_TYPE_ALL || reverse_controller == REVERSE_CONTROL_TYPE_JOYSTICK)
        {
            ncd_joy_install();
        }
        else
        {
            ncd_joy_remove();
        }
        clear_keybuf();
        key[KEY_LEFT] = 0;
    }
}

/* change controller setting */
void reverse_menu_controller_right(void)
{
    if(reverse_controller < 3)
    {
        reverse_controller++;
        t3ss_play_sound(menu_move_sound, 128, 22050);
        reverse_menu_game_update();
        if(reverse_controller == REVERSE_CONTROL_TYPE_ALL || reverse_controller == REVERSE_CONTROL_TYPE_JOYSTICK)
        {
            ncd_joy_install();
        }
        else
        {
            ncd_joy_remove();
        }
        clear_keybuf();
        key[KEY_RIGHT] = 0;
    }
}

/* change frameskip setting */
void reverse_menu_frame_skip_left(void)
{
    if(reverse_frame_skip > 0)
    {
        reverse_frame_skip--;
        t3ss_play_sound(menu_move_sound, 128, 22050);
        remove_int(frame_timer);
        reverse_menu_graphics_update();
        clear_keybuf();
        key[KEY_LEFT] = 0;
    }
}

/* change frameskip setting */
void reverse_menu_frame_skip_right(void)
{
    if(reverse_frame_skip < 1)
    {
        reverse_frame_skip++;
        t3ss_play_sound(menu_move_sound, 128, 22050);
        install_int(frame_timer, REVERSE_AUTO_SPEED);
        reverse_menu_graphics_update();
        clear_keybuf();
        key[KEY_RIGHT] = 0;
    }
}

/* change vsync setting */
void reverse_menu_vsync_left(void)
{
    if(reverse_vsync > 0)
    {
        reverse_vsync--;
        t3ss_play_sound(menu_move_sound, 128, 22050);
        reverse_menu_graphics_update();
        clear_keybuf();
        key[KEY_LEFT] = 0;
    }
}

/* change vsync setting */
void reverse_menu_vsync_right(void)
{
    if(reverse_vsync < 1)
    {
        reverse_vsync++;
        t3ss_play_sound(menu_move_sound, 128, 22050);
        reverse_menu_graphics_update();
        clear_keybuf();
        key[KEY_RIGHT] = 0;
    }
}

/* choose a new theme */
void reverse_menu_theme(void)
{
    if(file_select("Choose theme file...", reverse_theme_filename, "rth"))
    {
        t3ss_play_sound(menu_select_sound, 128, 22050);
        destroy_reverse_theme(&reverse_theme);
        if(!load_reverse_theme(&reverse_theme, reverse_theme_filename))
        {
            strcpy(reverse_theme_filename, "reverse.rth");
            if(!load_reverse_theme(&reverse_theme, reverse_theme_filename))
            {
                allegro_message("Error loading theme file.\n");
                exit(0);
            }
            else
            {
                strcpy(reverse_theme_musicname, reverse_theme_filename);
                replace_extension(reverse_theme_musicname, reverse_theme_filename, "xm", 256);
            }
        }
        else
        {
            strcpy(reverse_theme_musicname, reverse_theme_filename);
            replace_extension(reverse_theme_musicname, reverse_theme_filename, "xm", 256);
        }

    }
    else
    {
        t3ss_play_sound(menu_back_sound, 128, 22050);
    }
    clear_keybuf();
    key[KEY_ENTER] = 0;
    key[KEY_ESC] = 0;
}

/* "play" on the main menu */
void reverse_menu_play(void)
{
    reverse_menu_out();
    reverse_selected_menu = REVERSE_MENU_PLAY;
    reverse_menu[reverse_selected_menu].selected = 0;
    reverse_menu_in();
    clear_keybuf();
    key[KEY_ENTER] = 0;
}

    /* "1 player" on the play menu */
    void reverse_menu_play_1p(void)
    {
        t3ss_stop_mod();
        reverse_menu_out();

        /* decide which player will be first */
        if(reverse_1st == 0)
        {
            if(ncd_random() % 2 == 0)
            {
                reverse_player[0].type = REVERSE_PLAYER_TYPE_HUMAN;
                reverse_player[1].type = reverse_difficulty + REVERSE_PLAYER_TYPE_AI_BEGINNER;
            }
            else
            {
                reverse_player[0].type = reverse_difficulty + REVERSE_PLAYER_TYPE_AI_BEGINNER;
                reverse_player[1].type = REVERSE_PLAYER_TYPE_HUMAN;
            }
        }
        else if(reverse_1st == 1)
        {
            reverse_player[0].type = REVERSE_PLAYER_TYPE_HUMAN;
            reverse_player[1].type = reverse_difficulty + REVERSE_PLAYER_TYPE_AI_BEGINNER;
        }
        else
        {
            reverse_player[0].type = reverse_difficulty + REVERSE_PLAYER_TYPE_AI_BEGINNER;
            reverse_player[1].type = REVERSE_PLAYER_TYPE_HUMAN;
        }

        reverse_play();
        reverse_selected_menu = 0;
        reverse_menu_back_in();
    }

    /* "2 players" on the play menu */
    void reverse_menu_play_2p(void)
    {
        t3ss_stop_mod();
        reverse_menu_out();
        reverse_player[0].type = REVERSE_PLAYER_TYPE_HUMAN;
        reverse_player[1].type = REVERSE_PLAYER_TYPE_HUMAN;
        reverse_play();
        reverse_selected_menu = 0;
        reverse_menu_back_in();
    }

/* "options" on the main menu */
void reverse_menu_options(void)
{
    reverse_menu_out();
    reverse_selected_menu = REVERSE_MENU_OPTIONS;
    reverse_menu[reverse_selected_menu].selected = 0;
    reverse_menu_in();
    clear_keybuf();
    key[KEY_ENTER] = 0;
}

    /* select audio menu */
    void reverse_menu_audio(void)
    {
        reverse_menu_audio_update();
        reverse_menu_out();
        reverse_selected_menu = REVERSE_MENU_AUDIO;
        reverse_menu[reverse_selected_menu].selected = 0;
        reverse_menu_in();
        clear_keybuf();
        key[KEY_ENTER] = 0;
    }

    /* select game menu */
    void reverse_menu_game(void)
    {
        reverse_menu_game_update();
        reverse_menu_out();
        reverse_selected_menu = REVERSE_MENU_GAME;
        reverse_menu[reverse_selected_menu].selected = 0;
        reverse_menu_in();
        clear_keybuf();
        key[KEY_ENTER] = 0;
    }

    /* select graphics menu */
    void reverse_menu_graphics(void)
    {
        reverse_menu_graphics_update();
        reverse_menu_out();
        reverse_selected_menu = REVERSE_MENU_GRAPHICS;
        reverse_menu[reverse_selected_menu].selected = 0;
        reverse_menu_in();
        clear_keybuf();
        key[KEY_ENTER] = 0;
    }

/* "quit" on the main menu */
void reverse_menu_quit(void)
{
    t3ss_stop_mod();
    reverse_menu_out();
    reverse_quit = 1;
}

/* set up the title screen */
void reverse_title_init(void)
{
    /* load title data */
    load_animation(&title_animation, "reverse.dat#reverse_logo");
    title_backdrop = load_pcx("reverse.dat#reverse_title", title_palette);
    fix_palette(title_palette);
    reverse_cursor = load_pcx("reverse.dat#cursor", NULL);
    menu_move_sound = t3ss_load_wav_fn("reverse.dat#menu_sound_move");
    menu_select_sound = t3ss_load_wav_fn("reverse.dat#menu_sound_select");
    menu_fade_sound = t3ss_load_wav_fn("reverse.dat#menu_sound_fade");
    menu_back_sound = t3ss_load_wav_fn("reverse.dat#menu_sound_back");

    reverse_menu_text[REVERSE_MENU_TEXT_BAD] = load_pcx("reverse.dat#menu_text_bad", NULL);
    reverse_menu_text[REVERSE_MENU_TEXT_GOOD] = load_pcx("reverse.dat#menu_text_good", NULL);
    reverse_menu_text[REVERSE_MENU_TEXT_BEST] = load_pcx("reverse.dat#menu_text_best", NULL);
    reverse_menu_text[REVERSE_MENU_TEXT_BEGINNER] = load_pcx("reverse.dat#menu_text_beginner", NULL);
    reverse_menu_text[REVERSE_MENU_TEXT_INTERMEDIATE] = load_pcx("reverse.dat#menu_text_intermediate", NULL);
    reverse_menu_text[REVERSE_MENU_TEXT_ADVANCED] = load_pcx("reverse.dat#menu_text_advanced", NULL);
    reverse_menu_text[REVERSE_MENU_TEXT_EXPERT] = load_pcx("reverse.dat#menu_text_expert", NULL);
    reverse_menu_text[REVERSE_MENU_TEXT_RANDOM] = load_pcx("reverse.dat#menu_text_random", NULL);
    reverse_menu_text[REVERSE_MENU_TEXT_HUMAN] = load_pcx("reverse.dat#menu_text_human", NULL);
    reverse_menu_text[REVERSE_MENU_TEXT_CPU] = load_pcx("reverse.dat#menu_text_cpu", NULL);
    reverse_menu_text[REVERSE_MENU_TEXT_ALL] = load_pcx("reverse.dat#menu_text_all", NULL);
    reverse_menu_text[REVERSE_MENU_TEXT_MOUSE] = load_pcx("reverse.dat#menu_text_mouse", NULL);
    reverse_menu_text[REVERSE_MENU_TEXT_KEYBOARD] = load_pcx("reverse.dat#menu_text_keyboard", NULL);
    reverse_menu_text[REVERSE_MENU_TEXT_JOYSTICK] = load_pcx("reverse.dat#menu_text_joystick", NULL);
    reverse_menu_text[REVERSE_MENU_TEXT_OFF] = load_pcx("reverse.dat#menu_text_off", NULL);
    reverse_menu_text[REVERSE_MENU_TEXT_ON] = load_pcx("reverse.dat#menu_text_on", NULL);
    reverse_menu_text[REVERSE_MENU_TEXT_AUTO] = load_pcx("reverse.dat#menu_text_auto", NULL);

    /* set up the menus */
    initialize_reverse_menu(&reverse_menu[REVERSE_MENU_MAIN], REVERSE_MENU_MAIN);
    add_reverse_menu_item(&reverse_menu[REVERSE_MENU_MAIN], load_pcx("reverse.dat#menu_play_0", NULL), load_pcx("reverse.dat#menu_play_1", NULL), load_pcx("reverse.dat#menu_play_icon", NULL), 16, 100, NULL, NULL, reverse_menu_play);
    add_reverse_menu_item(&reverse_menu[REVERSE_MENU_MAIN], load_pcx("reverse.dat#menu_options_0", NULL), load_pcx("reverse.dat#menu_options_1", NULL), load_pcx("reverse.dat#menu_options_icon", NULL), 16, 132, NULL, NULL, reverse_menu_options);
    add_reverse_menu_item(&reverse_menu[REVERSE_MENU_MAIN], load_pcx("reverse.dat#menu_quit_0", NULL), load_pcx("reverse.dat#menu_quit_1", NULL), load_pcx("reverse.dat#menu_quit_icon", NULL), 16, 164, NULL, NULL, reverse_menu_quit);

    initialize_reverse_menu(&reverse_menu[REVERSE_MENU_PLAY], REVERSE_MENU_MAIN);
    add_reverse_menu_item(&reverse_menu[REVERSE_MENU_PLAY], load_pcx("reverse.dat#menu_1p_0", NULL), load_pcx("reverse.dat#menu_1p_1", NULL), load_pcx("reverse.dat#menu_1p_icon", NULL), 16, 100, NULL, NULL, reverse_menu_play_1p);
    add_reverse_menu_item(&reverse_menu[REVERSE_MENU_PLAY], load_pcx("reverse.dat#menu_2p_0", NULL), load_pcx("reverse.dat#menu_2p_1", NULL), load_pcx("reverse.dat#menu_2p_icon", NULL), 16, 132, NULL, NULL, reverse_menu_play_2p);

    initialize_reverse_menu(&reverse_menu[REVERSE_MENU_OPTIONS], REVERSE_MENU_MAIN);
    add_reverse_menu_item(&reverse_menu[REVERSE_MENU_OPTIONS], load_pcx("reverse.dat#menu_audio_0", NULL), load_pcx("reverse.dat#menu_audio_1", NULL), load_pcx("reverse.dat#menu_audio_icon", NULL), 16, 100, NULL, NULL, reverse_menu_audio);
    add_reverse_menu_item(&reverse_menu[REVERSE_MENU_OPTIONS], load_pcx("reverse.dat#menu_game_0", NULL), load_pcx("reverse.dat#menu_game_1", NULL), load_pcx("reverse.dat#menu_game_icon", NULL), 16, 132, NULL, NULL, reverse_menu_game);
    add_reverse_menu_item(&reverse_menu[REVERSE_MENU_OPTIONS], load_pcx("reverse.dat#menu_graphics_0", NULL), load_pcx("reverse.dat#menu_graphics_1", NULL), load_pcx("reverse.dat#menu_graphics_icon", NULL), 16, 164, NULL, NULL, reverse_menu_graphics);

        initialize_reverse_menu(&reverse_menu[REVERSE_MENU_AUDIO], REVERSE_MENU_OPTIONS);
        add_reverse_menu_item(&reverse_menu[REVERSE_MENU_AUDIO], load_pcx("reverse.dat#menu_music_0", NULL), load_pcx("reverse.dat#menu_music_1", NULL), load_pcx("reverse.dat#menu_music_icon", NULL), 16, 100, reverse_menu_music_left, reverse_menu_music_right, NULL);
        add_reverse_menu_item(&reverse_menu[REVERSE_MENU_AUDIO], load_pcx("reverse.dat#menu_sound_0", NULL), load_pcx("reverse.dat#menu_sound_1", NULL), load_pcx("reverse.dat#menu_sound_icon", NULL), 16, 132, reverse_menu_sound_left, reverse_menu_sound_right, NULL);
        add_reverse_menu_item(&reverse_menu[REVERSE_MENU_AUDIO], load_pcx("reverse.dat#menu_mix_0", NULL), load_pcx("reverse.dat#menu_mix_1", NULL), load_pcx("reverse.dat#menu_mix_icon", NULL), 16, 164, reverse_menu_mixing_left, reverse_menu_mixing_right, NULL);

        initialize_reverse_menu(&reverse_menu[REVERSE_MENU_GAME], REVERSE_MENU_OPTIONS);
        add_reverse_menu_item(&reverse_menu[REVERSE_MENU_GAME], load_pcx("reverse.dat#menu_difficulty_0", NULL), load_pcx("reverse.dat#menu_difficulty_1", NULL), load_pcx("reverse.dat#menu_difficulty_icon", NULL), 16, 100, reverse_menu_difficulty_left, reverse_menu_difficulty_right, NULL);
        add_reverse_menu_item(&reverse_menu[REVERSE_MENU_GAME], load_pcx("reverse.dat#menu_1st_0", NULL), load_pcx("reverse.dat#menu_1st_1", NULL), load_pcx("reverse.dat#menu_1st_icon", NULL), 16, 132, reverse_menu_1st_left, reverse_menu_1st_right, NULL);
        add_reverse_menu_item(&reverse_menu[REVERSE_MENU_GAME], load_pcx("reverse.dat#menu_control_0", NULL), load_pcx("reverse.dat#menu_control_1", NULL), load_pcx("reverse.dat#menu_control_icon", NULL), 16, 164, reverse_menu_controller_left, reverse_menu_controller_right, NULL);

        initialize_reverse_menu(&reverse_menu[REVERSE_MENU_GRAPHICS], REVERSE_MENU_OPTIONS);
        add_reverse_menu_item(&reverse_menu[REVERSE_MENU_GRAPHICS], load_pcx("reverse.dat#menu_frame_0", NULL), load_pcx("reverse.dat#menu_frame_1", NULL), load_pcx("reverse.dat#menu_frame_icon", NULL), 16, 100, reverse_menu_frame_skip_left, reverse_menu_frame_skip_right, NULL);
        add_reverse_menu_item(&reverse_menu[REVERSE_MENU_GRAPHICS], load_pcx("reverse.dat#menu_vsync_0", NULL), load_pcx("reverse.dat#menu_vsync_1", NULL), load_pcx("reverse.dat#menu_vsync_icon", NULL), 16, 132, reverse_menu_vsync_left, reverse_menu_vsync_right, NULL);
        add_reverse_menu_item(&reverse_menu[REVERSE_MENU_GRAPHICS], load_pcx("reverse.dat#menu_theme_0", NULL), load_pcx("reverse.dat#menu_theme_1", NULL), load_pcx("reverse.dat#menu_theme_icon", NULL), 16, 164, NULL, NULL, reverse_menu_theme);
}

/* unload title data */
void reverse_title_exit(void)
{
    int i;

    destroy_animation(&title_animation);
    destroy_bitmap(title_backdrop);
    destroy_bitmap(reverse_cursor);
    t3ss_free_wav(menu_move_sound);
    t3ss_free_wav(menu_select_sound);
    t3ss_free_wav(menu_fade_sound);
    t3ss_free_wav(menu_back_sound);
    for(i = 0; i < 6; i++)
    {
        destroy_reverse_menu(&reverse_menu[i]);
    }
    for(i = 0; i < 17; i++)
    {
        if(reverse_menu_text[i] != NULL)
        {
            destroy_bitmap(reverse_menu_text[i]);
        }
    }
}

/* update title screen */
void reverse_title_update(void)
{
    clear_to_color(reverse_screen, 31);
    draw_animation(&title_animation, title_frame, reverse_screen, 10, 10);
    draw_reverse_menu(&reverse_menu[reverse_selected_menu], reverse_screen);

    if(reverse_vsync)
    {
        vsync();
    }
    reverse_blit(reverse_screen);
}

/* handle title screen */
void reverse_title_logic(void)
{
    reverse_menu_control(&reverse_menu[reverse_selected_menu]);

    /* handle menu backing */
    if(key[KEY_ESC] || ((ncd_joy_button(0, 1) || ncd_joy_button(1, 1)) && !bbblock))
    {
        if(reverse_selected_menu != REVERSE_MENU_MAIN)
        {
            t3ss_play_sound(menu_back_sound, 128, 22050);
            reverse_menu_out();
            reverse_selected_menu = reverse_menu[reverse_selected_menu].parent;
            reverse_menu_in();
        }
        else
        {
            t3ss_play_sound(menu_move_sound, 128, 22050);
            reverse_menu[reverse_selected_menu].selected = 2;
        }
        clear_keybuf();
        key[KEY_ESC] = 0;
        demo_timer = 0;
        bbblock++;
    }
    if(!ncd_joy_button(0, 1) && !ncd_joy_button(1, 1))
    {
        bbblock = 0;
    }

    /* toggle the screen mode */
    if(key[KEY_ALT] && key[KEY_ENTER])
    {
        reverse_toggle_screen();
        set_palette(title_palette);
        gui_fg_color = makecol(0, 0, 0);
        gui_bg_color = makecol(255, 255, 255);
        key[KEY_ALT] = 0;
        key[KEY_ENTER] = 0;
    }

    title_frame++;
    demo_timer++;

    /* start demo */
    if(demo_timer > 900)
    {
        reverse_menu_out();
        reverse_demo();
        reverse_selected_menu = 0;
        reverse_menu[reverse_selected_menu].selected = 0;
        reverse_menu_in();
        demo_timer = 0;
    }
}

/* this is where the game stays until exited */
void reverse_title(void)
{
    int i;

//    reverse_title_init();
    LOCK_FUNCTION(frame_timer);
    LOCK_VARIABLE(reverse_logic_frames_t);
    title_frame = 0;
    reverse_title_update();
    fade_from(white_palette, title_palette, 3);
    gui_fg_color = makecol(0, 0, 0);
    gui_bg_color = makecol(255, 255, 255);
    t3ss_play_mod("reverse.dat#reverse_title_music");
    if(reverse_frame_skip)
    {
        install_int(frame_timer, REVERSE_AUTO_SPEED);
    }
    while(!reverse_quit)
    {
        /* handle auto frameskip */
        if(reverse_frame_skip)
        {
            reverse_logic_frames = reverse_logic_frames_t;
            reverse_logic_frames_t = 0;
            for(i = 0; i < reverse_logic_frames; i++)
            {
                reverse_title_logic();
            }
        }
        else
        {
            reverse_title_logic();
        }
        reverse_title_update();
    }
    remove_int(frame_timer);
    clear_keybuf();
    fade_out(3);
//    reverse_title_exit();
}
