#ifndef SOUND_H
#define SOUND_H

#include <allegro.h>
#include "mikmod.h"

#ifdef __cplusplus
extern "C" {
#endif

#define I_NULL -1 /* provide NULL value for signed integers */

/* sound system channel modes */
#define T3SS_CH_MONO           0
#define T3SS_CH_STEREO         1
#define T3SS_CH_REVERSE_STEREO 2

extern int t3ss_num_patterns;

int t3ss_init(long freq, int stereo);
void t3ss_exit(void);
void t3ss_set_effects_channels(int number);
void t3ss_set_reserved_channels(int number);
void t3ss_enable_effects(void);
void t3ss_enable_music(void);
void t3ss_disable_effects(void);
void t3ss_disable_music(void);
int t3ss_play_mod(char * fn);
void t3ss_stop_mod(void);
void t3ss_set_music_volume(int volume);
void t3ss_set_sound_volume(int volume);
void t3ss_set_music_pattern(int patnum);
MSAMPLE * t3ss_load_wav_fp(PACKFILE * fp);
MSAMPLE * t3ss_load_wav_fn(char * fn);
int t3ss_save_wav_fp(MSAMPLE * sp, PACKFILE * fp);
int t3ss_save_wav_fn(MSAMPLE * sp, char * fn);
void t3ss_free_wav(MSAMPLE * sp);
void t3ss_play_sound(MSAMPLE * sp, int pan, int freq);
void t3ss_play_sound_ex(MSAMPLE * sp, int chan, int vol, int pan, int freq);
void t3ss_play_sound_reserved(MSAMPLE * sp, int chan, int pan, int freq);
int t3ss_place_sound(int x, int width);

#ifdef __cplusplus
}
#endif

#endif
