/* ------------------------------------------------------------------------ */
/* ---------------- T^3 Audio System (c)2001 T^3 Software. ---------------- */
/* ------------------------------------------------------------------------ */


/* include all necessary files */
#include <allegro.h>
#include "t3ssal.h"
#include "mywav.h"


/* pointer to the MOD file */
void * t3ss_mod_file = NULL;

int t3ss_effects_channels =  4; // how many channels for sound effects
int t3ss_effects_channel =   0; // which effect channel to play sound in
int t3ss_reserved_channels = 0; // add reserved channels
int t3ss_sound_volume =    100; // volume of sound effects
int t3ss_initialized =       0; // is T3 Sound System initialized?
int t3ss_music_playing =     0; // is there music playing?
int t3ss_channel_mode =      0; // mono, stereo, or reverse stereo
int t3ss_sound_on =          1;
int t3ss_music_on =          1;
int t3ss_num_patterns =      0;



/* initialize sound system */
int t3ss_init(long freq, int stereo)
{
    if(!t3ss_initialized)
    {
        /* try to install sound */
        reserve_voices(32, 0);
        if(install_sound(DIGI_AUTODETECT, MIDI_NONE, NULL))
        {
            t3ss_initialized = 0;
            return 0;
        }
        set_volume((float)t3ss_sound_volume * 2.5, 0);

        /* setup sound channels (mono/stereo) */
        t3ss_channel_mode = stereo;

        /* start effects-only mode */
        t3ss_effects_channel = 0;
        t3ss_mod_file = NULL;

        t3ss_initialized = 1;
    }
    return 1;
}


/* deinitializes sound system */
void t3ss_exit(void)
{
    if(t3ss_initialized)
    {
        remove_sound();
        t3ss_initialized = 0;
    }
}


/* tell sound system how many effects channels you want */
void t3ss_set_effects_channels(int number)
{
    t3ss_effects_channel = 0;
    t3ss_effects_channels = number;
}


/* tell sound system how many reserved channels you want */
void t3ss_set_reserved_channels(int number)
{
    t3ss_reserved_channels = number;
}


void t3ss_enable_effects(void)
{
    t3ss_sound_on = 1;
}

void t3ss_enable_music(void)
{
    t3ss_music_on = 1;
}

void t3ss_disable_effects(void)
{
    t3ss_sound_on = 0;
}

void t3ss_disable_music(void)
{
    t3ss_music_on = 0;
}

/* play a MOD file (.XM or .UNI) */
int t3ss_play_mod(char * fn)
{
    return 1;
}


/* stop sound playback */
void t3ss_stop_mod(void)
{
}

/* set the music volume */
void t3ss_set_music_volume(int volume)
{
}


/* set the sound effects volume */
void t3ss_set_sound_volume(int volume)
{
    t3ss_sound_volume = volume;
}


/* jump to specified song pattern */
void t3ss_set_music_pattern(int patnum)
{
}


/* load a WAV sample */
MSAMPLE * t3ss_load_wav_fp(PACKFILE * fp)
{
    MSAMPLE * sp = NULL;

    if(t3ss_initialized)
    {
        sp = tc_load_wav_fp(fp);
        return sp;
    }
    return NULL;
}


/* load a WAV sample */
MSAMPLE * t3ss_load_wav_fn(char * fn)
{
    MSAMPLE * TempSample;

    if(t3ss_initialized)
    {
        TempSample = tc_load_wav(fn);
        return TempSample;
    }
    return NULL;
}


/* save a WAV sample into specified file pointer */
int t3ss_save_wav_fp(MSAMPLE * sp, PACKFILE * fp)
{
    if(sp != NULL)
    {
        tc_save_wav_fp(fp, sp);
    }

    return 0;
}


/* save a WAV sample into specified file */
int t3ss_save_wav_fn(MSAMPLE * sp, char * fn)
{
    if(sp != NULL)
    {
        tc_save_wav(fn, sp);
    }

    return 0;
}


/* release sound sample */
void t3ss_free_wav(MSAMPLE * sp)
{
    if(sp != NULL)
    {
        destroy_sample(sp);
    }
}        


/* simplified sample playing function */
void t3ss_play_sound(MSAMPLE * sp, int pan, int freq)
{
    if(sp != NULL && t3ss_initialized && t3ss_sound_on && t3ss_effects_channels > 0)
    {
        play_sample(sp, (float)t3ss_sound_volume * 2.5, pan, freq, 0);
        t3ss_effects_channel++;
        if(t3ss_effects_channel >= t3ss_effects_channels)
        {
            t3ss_effects_channel = 0;
        }
    }
}


/* plays sample with the specified parameters */
void t3ss_play_sound_ex(MSAMPLE * sp, int chan, int vol, int pan, int freq)
{
    t3ss_play_sound(sp, pan, freq);
}


/* play sound through reserved channels */
void t3ss_play_sound_reserved(MSAMPLE * sp, int chan, int pan, int freq)
{
    t3ss_play_sound(sp, pan, freq);
}


/* figure out sound panning based on X coordinate and width */
int t3ss_place_sound(int x, int width)
{
    float wr = (float)width / 256.0;
    float fx = x * wr;
        
    if(fx < 0)
    {
        return 0;
    }
    else if(fx > 255)
    {
        return 255;
    }
    return fx;
}
