#ifndef REVERSE_H
#define REVERSE_H

#include <allegro.h>

#define REVERSE_RX          320
#define REVERSE_RY          240
#define REVERSE_BOARD_RX      8
#define REVERSE_BOARD_RY      8
#define REVERSE_CONTROL_MOUSE 0
#define REVERSE_CONTROL_AI    1
#define REVERSE_STATE_NORMAL  0
#define REVERSE_STATE_FLIP    1
#define REVERSE_STATE_WAIT    2
#define REVERSE_STATE_AI      3
#define REVERSE_STATE_END     4
#define REVERSE_CONTROL_TYPE_ALL      0
#define REVERSE_CONTROL_TYPE_MOUSE    1
#define REVERSE_CONTROL_TYPE_KEYBOARD 2
#define REVERSE_CONTROL_TYPE_JOYSTICK 3

#define REVERSE_VERSION  "Reverse v1.1 (c)2001 NewCreature Design.\n"

typedef struct
{

    char data[REVERSE_BOARD_RY][REVERSE_BOARD_RX];
    char change[REVERSE_BOARD_RY][REVERSE_BOARD_RX];

} REVERSE_BOARD;

typedef struct
{

    int type;
    float x, y;
    float vx, vy;
    float dx, dy;
    int left_click;
    int right_click;

} REVERSE_CONTROLLER;

void reverse_toggle_screen(void);
void reverse_blit(BITMAP * bp);
void reverse_update();
void reverse_play(void);
void reverse_demo(void);
void reverse_title_update(void);

#endif
