#include <allegro.h>

/* include the proper sound header */
#ifdef ALLEGRO_WINDOWS
    #include "t3sswin.h"
#else
    #ifdef __DJGPP__
        #include "t3ssdos.h"
    #else
        #include "t3ssal.h"
    #endif
#endif

#include "menu.h"
#include "joy.h"
#include "reverse.h"

extern MSAMPLE * menu_move_sound;
extern MSAMPLE * menu_select_sound;
extern int demo_timer;
int lblock = 0;
int rblock = 0;
int ublock = 0;
int dblock = 0;
int bblock = 0;

/* sets initial menu state */
void initialize_reverse_menu(REVERSE_MENU * mp, int parent)
{
    mp->total_items = 0;
    mp->parent = parent;
    mp->selected = 0;
}

/* add an item to a menu */
void add_reverse_menu_item(REVERSE_MENU * mp, BITMAP * sbp, BITMAP * ubp, BITMAP * ibp, int x, int y, void(*lproc)(), void(*rproc)(), void(*eproc)())
{
    mp->item[mp->total_items].bp[REVERSE_MENU_SELECTED] = sbp;
    mp->item[mp->total_items].bp[REVERSE_MENU_UNSELECTED] = ubp;
    mp->item[mp->total_items].icon = ibp;
    mp->item[mp->total_items].x = x;
    mp->item[mp->total_items].y = y;
    mp->item[mp->total_items].left_proc = lproc;
    mp->item[mp->total_items].right_proc = rproc;
    mp->item[mp->total_items].enter_proc = eproc;
    mp->total_items++;
}

/* unload menu images */
void destroy_reverse_menu(REVERSE_MENU * mp)
{
    int i;

    for(i = 0; i < mp->total_items; i++)
    {
        if(mp->item[i].bp[0] != NULL)
        {
            destroy_bitmap(mp->item[i].bp[0]);
        }
        if(mp->item[i].bp[1] != NULL)
        {
            destroy_bitmap(mp->item[i].bp[1]);
        }
        if(mp->item[i].icon != NULL)
        {
            destroy_bitmap(mp->item[i].icon);
        }
    }
}

/* handle menu controls */
void reverse_menu_control(REVERSE_MENU * mp)
{
    ncd_joy_poll();
    if(key[KEY_UP] || ((ncd_joy_up(0) || ncd_joy_up(1)) && !ublock))
    {
        t3ss_play_sound(menu_move_sound, 128, 22050);
        mp->selected--;
        if(mp->selected < 0)
        {
            mp->selected = mp->total_items - 1;
        }
        key[KEY_UP] = 0;
        demo_timer = 0;
        ublock++;
//        clear_keybuf();
    }
    if(!ncd_joy_up(0) && !ncd_joy_up(1))
    {
        ublock = 0;
    }
    if(key[KEY_DOWN] || ((ncd_joy_down(0) || ncd_joy_down(1)) && !dblock))
    {
        t3ss_play_sound(menu_move_sound, 128, 22050);
        mp->selected++;
        if(mp->selected >= mp->total_items)
        {
            mp->selected = 0;
        }
        key[KEY_DOWN] = 0;
        demo_timer = 0;
        dblock++;
//        clear_keybuf();
    }
    if(!ncd_joy_down(0) && !ncd_joy_down(1))
    {
        dblock = 0;
    }
    if((key[KEY_LEFT] || ((ncd_joy_left(0) || ncd_joy_left(1)) && !lblock)) && mp->item[mp->selected].left_proc != NULL)
    {
        mp->item[mp->selected].left_proc();
        demo_timer = 0;
        lblock++;
    }
    if(!ncd_joy_left(0) && !ncd_joy_left(1))
    {
        lblock = 0;
    }
    if((key[KEY_RIGHT] || ((ncd_joy_right(0) || ncd_joy_right(1)) && !rblock)) && mp->item[mp->selected].right_proc != NULL)
    {
        mp->item[mp->selected].right_proc();
        demo_timer = 0;
        rblock++;
    }
    if(!ncd_joy_right(0) && !ncd_joy_right(1))
    {
        rblock = 0;
    }
    if(((key[KEY_ENTER] && !key[KEY_ALT]) || ((ncd_joy_button(0, 0) || ncd_joy_button(1, 0)) && !bblock)) && mp->item[mp->selected].enter_proc != NULL)
    {
        t3ss_play_sound(menu_select_sound, 128, 22050);
        mp->item[mp->selected].enter_proc();
        demo_timer = 0;
        bblock++;
    }
    if(!ncd_joy_button(0, 0) && !ncd_joy_button(1, 0))
    {
        bblock = 0;
    }
}

/* draw a menu */
void draw_reverse_menu(REVERSE_MENU * mp, BITMAP * bp)
{
    int i;

    for(i = 0; i < mp->total_items; i++)
    {
        draw_sprite(bp, (mp->selected == i) ? mp->item[i].bp[REVERSE_MENU_SELECTED] : mp->item[i].bp[REVERSE_MENU_UNSELECTED], mp->item[i].x, mp->item[i].y);
    }
    if(mp->item[mp->selected].icon != NULL)
    {
        draw_sprite(bp, mp->item[mp->selected].icon, REVERSE_RX - mp->item[mp->selected].icon->w, REVERSE_RY - mp->item[mp->selected].icon->h);
    }
}
