#ifndef ANIMATE_H
#define ANIMATE_H

#define ANIMATION_MAX_FRAMES           256

/* animation structure */
typedef struct
{
    BITMAP * image[ANIMATION_MAX_FRAMES];
    int w; /* width */
    int h; /* height */
    int f; /* frames */
    int d; /* speed (in delay frames) */
    char loaded;     /* is it loaded */
} ANIMATION;

/* disk functions */
int load_animation_fp(ANIMATION * ap, PACKFILE * fp);
int load_animation(ANIMATION * ap, char * fn);
int save_animation_fp(ANIMATION * ap, PACKFILE * fp);
int save_animation(ANIMATION * ap, char * fn);
void destroy_animation(ANIMATION * ap);

/* used to construct animations (used in editor) */
void initialize_animation(ANIMATION * ap);
int create_animation(ANIMATION * ap, int, int h);
int animation_add_frame(ANIMATION * ap, BITMAP * bp);
int animation_insert_frame(ANIMATION * ap, int f, BITMAP * bp);
int animation_replace_frame(ANIMATION * ap, int f, BITMAP * bp);
int animation_delete_frame(ANIMATION * ap, int f);
int animation_copy_frame(ANIMATION * ap, int f, BITMAP * bp);

/* helper functions for the programmer */
BITMAP * get_animation(ANIMATION * ap, int f);
BITMAP * get_animation_frame(ANIMATION * ap, int f);
int draw_animation_frame(ANIMATION * ap, int f, BITMAP * bp, int x, int y);
int blit_animation(ANIMATION * ap, unsigned long f, BITMAP * bp, int x, int y);
int draw_animation(ANIMATION * ap, unsigned long f, BITMAP * bp, int x, int y);
int draw_animation_trans(ANIMATION * ap, unsigned long f, BITMAP * bp, int x, int y);
int draw_animation_frame_solid(ANIMATION * ap, unsigned long f, BITMAP * bp, int x, int y, int color);
int draw_animation_solid(ANIMATION * ap, unsigned long f, BITMAP * bp, int x, int y, int color);

#endif
