#ifndef THEME_H
#define THEME_H

#include <allegro.h>

/* include the proper sound header */
#ifdef ALLEGRO_WINDOWS
    #include "t3sswin.h"
#else
    #ifdef __DJGPP__
        #include "t3ssdos.h"
    #else
        #include "t3ssal.h"
    #endif
#endif

#include "font.h"
#include "animate.h"

#define REVERSE_THEME_SOUNDS 5
#define REVERSE_SOUND_PLACE  0
#define REVERSE_SOUND_PASS   1
#define REVERSE_SOUND_BAD    2
#define REVERSE_SOUND_WIN    3
#define REVERSE_SOUND_TIE    4

/* holds reverse theme data */
typedef struct
{
    /* the backdrop image */
    BITMAP *    backdrop;

    /* the font for drawing text */
    NCDFONT     font;

    /* player piece animations */
    ANIMATION   piece[2];

    /* player piece flip animations */
    ANIMATION   flip[2];

    /* player cursor animations */
    ANIMATION   cursor[2];

    /* player selector animations */
    ANIMATION   select[2];

    /* theme palette */
    PALETTE     palette;

    /* board location */
    int         boardx;
    int         boardy;

    /* score locations */
    int         scorex[2];
    int         scorey[2];

    int         mousex;
    int         mousey;

    /* sounds */
    MSAMPLE *   sound[REVERSE_THEME_SOUNDS];

} REVERSE_THEME;

/* disk functions for reverse themes */
int  load_reverse_theme_fp(REVERSE_THEME * tp, PACKFILE * fp);
int  load_reverse_theme(REVERSE_THEME * tp, char * fn);
int  save_reverse_theme_fp(REVERSE_THEME * tp, PACKFILE * fp);
int  save_reverse_theme(REVERSE_THEME * tp, char * fn);
void destroy_reverse_theme(REVERSE_THEME * tp);

#endif
