#include <allegro.h>
#include "reverse.h"
#include "core.h"

/* start a fresh game */
void reverse_reset_board(REVERSE_BOARD * bp)
{
    int i, j;

    /* clear the board */
    for(i = 0; i < REVERSE_BOARD_RY; i++)
    {
        for(j = 0; j < REVERSE_BOARD_RX; j++)
        {
            bp->data[i][j] = -1;
        }
    }

    /* place four starting pieces */
    bp->data[3][3] = 0;
    bp->data[3][4] = 1;
    bp->data[4][3] = 1;
    bp->data[4][4] = 0;
}

/* update board according to change map */
void reverse_handle_changes(REVERSE_BOARD * bp, int turn)
{
    int i, j;

    for(i = 0; i < REVERSE_BOARD_RY; i++)
    {
        for(j = 0; j < REVERSE_BOARD_RX; j++)
        {
            if(bp->change[i][j])
            {
                bp->data[i][j] = turn;
            }
        }
    }
    reverse_clear_changes(bp);
}

/* clear change map */
void reverse_clear_changes(REVERSE_BOARD * bp)
{
    int i, j;

    for(i = 0; i < REVERSE_BOARD_RY; i++)
    {
        for(j = 0; j < REVERSE_BOARD_RX; j++)
        {
            bp->change[i][j] = 0;
        }
    }
}

/* grabs tiles to the left of specified board location */
int reverse_grab_left(REVERSE_BOARD * bp, int turn, int x, int y)
{
    int i, j;

    /* if the spot to the left is other player's and not blank */
    if(bp->data[y][x - 1] != turn && bp->data[y][x - 1] != -1)
    {
        for(i = x - 1; i >= 0 && bp->data[y][i] != -1; i--)
        {
            /* when you hit your own tile stop scanning */
            if(bp->data[y][i] == turn)
            {
                for(j = i; j <= x; j++)
                {
                    bp->change[y][j] = 1;
                }
                bp->change[y][x] = 2;
                bp->change[y][i] = 2;
                return 1;
            }
        }
    }
    return 0;
}

/* grabs tiles to the right of specified board location */
int reverse_grab_right(REVERSE_BOARD * bp, int turn, int x, int y)
{
    int i, j;

    if(bp->data[y][x + 1] != turn && bp->data[y][x + 1] != -1)
    {
        for(i = x + 1; i < REVERSE_BOARD_RX && bp->data[y][i] != -1; i++)
        {
            if(bp->data[y][i] == turn)
            {
                for(j = i; j >= x; j--)
                {
                    bp->change[y][j] = 1;
                }
                bp->change[y][x] = 2;
                bp->change[y][i] = 2;
                return 1;
            }
        }
    }
    return 0;
}

/* grabs tiles above specified board location */
int reverse_grab_up(REVERSE_BOARD * bp, int turn, int x, int y)
{
    int i, j;

    if(bp->data[y - 1][x] != turn && bp->data[y - 1][x] != -1)
    {
        for(i = y - 1; i >= 0 && bp->data[i][x] != -1; i--)
        {
            if(bp->data[i][x] == turn)
            {
                for(j = i; j <= y; j++)
                {
                    bp->change[j][x] = 1;
                }
                bp->change[y][x] = 2;
                bp->change[i][x] = 2;
                return 1;
            }
        }
    }
    return 0;
}

/* grabs tiles below specified board location */
int reverse_grab_down(REVERSE_BOARD * bp, int turn, int x, int y)
{
    int i, j;

    if(bp->data[y + 1][x] != turn && bp->data[y + 1][x] != -1)
    {
        for(i = y + 1; i < REVERSE_BOARD_RY && bp->data[i][x] != -1; i++)
        {
            if(bp->data[i][x] == turn)
            {
                for(j = i; j >= y; j--)
                {
                    bp->change[j][x] = 1;
                }
                bp->change[y][x] = 2;
                bp->change[i][x] = 2;
                return 1;
            }
        }
    }
    return 0;
}

/* grabs tiles diagonally from specified board location */
int reverse_grab_up_left(REVERSE_BOARD * bp, int turn, int x, int y)
{
    int i, j, k, l;

    if(bp->data[y - 1][x - 1] != turn && bp->data[y - 1][x - 1] != -1)
    {
        k = x - 1;
        for(i = y - 1; i >= 0 && k >= 0 && bp->data[i][k] != -1; i--)
        {
            if(bp->data[i][k] == turn)
            {
                l = k;
                for(j = i; j <= y; j++)
                {
                    bp->change[j][l] = 1;
                    l++;
                }
                bp->change[y][x] = 2;
                bp->change[i][k] = 2;
                return 1;
            }
            k--;
        }
    }
    return 0;
}

/* grabs tiles diagonally from specified board location */
int reverse_grab_up_right(REVERSE_BOARD * bp, int turn, int x, int y)
{
    int i, j, k, l;

    if(bp->data[y - 1][x + 1] != turn && bp->data[y - 1][x + 1] != -1)
    {
        k = x + 1;
        for(i = y - 1; i >= 0 && k < REVERSE_BOARD_RX && bp->data[i][k] != -1; i--)
        {
            if(bp->data[i][k] == turn)
            {
                l = k;
                for(j = i; j <= y; j++)
                {
                    bp->change[j][l] = 1;
                    l--;
                }
                bp->change[y][x] = 2;
                bp->change[i][k] = 2;
                return 1;
            }
            k++;
        }
    }
    return 0;
}

/* grabs tiles diagonally from specified board location */
int reverse_grab_down_left(REVERSE_BOARD * bp, int turn, int x, int y)
{
    int i, j, k, l;

    if(bp->data[y + 1][x - 1] != turn && bp->data[y + 1][x - 1] != -1)
    {
        k = x - 1;
        for(i = y + 1; i < REVERSE_BOARD_RY && k >= 0 && bp->data[i][k] != -1; i++)
        {
            if(bp->data[i][k] == turn)
            {
                l = k;
                for(j = i; j >= y; j--)
                {
                    bp->change[j][l] = 1;
                    l++;
                }
                bp->change[y][x] = 2;
                bp->change[i][k] = 2;
                return 1;
            }
            k--;
        }
    }
    return 0;
}

/* grabs tiles diagonally from specified board location */
int reverse_grab_down_right(REVERSE_BOARD * bp, int turn, int x, int y)
{
    int i, j, k, l;

    if(bp->data[y + 1][x + 1] != turn && bp->data[y + 1][x + 1] != -1)
    {
        k = x + 1;
        for(i = y + 1; i < REVERSE_BOARD_RY && k < REVERSE_BOARD_RX && bp->data[i][k] != -1; i++)
        {
            if(bp->data[i][k] == turn)
            {
                l = k;
                for(j = i; j >= y; j--)
                {
                    bp->change[j][l] = 1;
                    l--;
                }
                bp->change[y][x] = 2;
                bp->change[i][k] = 2;
                return 1;
            }
            k++;
        }
    }
    return 0;
}

/* find pieces to grab and modify change map */
int reverse_place(REVERSE_BOARD * bp, int turn, int x, int y)
{
    int found = 0;

    if(bp->data[y][x] != -1)
    {
        return 0;
    }
    if(reverse_grab_left(bp, turn, x, y))
    {
        found = 1;
    }
    if(reverse_grab_right(bp, turn, x, y))
    {
        found = 1;
    }
    if(reverse_grab_up(bp, turn, x, y))
    {
        found = 1;
    }
    if(reverse_grab_down(bp, turn, x, y))
    {
        found = 1;
    }
    if(reverse_grab_up_left(bp, turn, x, y))
    {
        found = 1;
    }
    if(reverse_grab_up_right(bp, turn, x, y))
    {
        found = 1;
    }
    if(reverse_grab_down_left(bp, turn, x, y))
    {
        found = 1;
    }
    if(reverse_grab_down_right(bp, turn, x, y))
    {
        found = 1;
    }
    return found;
}

/* determine if there are no empty spaces left */
int reverse_board_full(REVERSE_BOARD * bp)
{
    int i, j;

    for(i = 0; i < REVERSE_BOARD_RY; i++)
    {
        for(j = 0; j < REVERSE_BOARD_RX; j++)
        {
            if(bp->data[i][j] == -1)
            {
                return 0;
            }
        }
    }
    return 1;
}

/* determine if all the pieces are the same color */
int reverse_board_1color(REVERSE_BOARD * bp)
{
    int i, j, tempcolor;

    /* find a color */
    for(i = 0; i < REVERSE_BOARD_RY; i++)
    {
        for(j = 0; j < REVERSE_BOARD_RX; j++)
        {
            if(bp->data[i][j] != -1)
            {
                tempcolor = bp->data[i][j];
                break;
            }
        }
    }

    /* see if there's another color */
    for(i = 0; i < REVERSE_BOARD_RY; i++)
    {
        for(j = 0; j < REVERSE_BOARD_RX; j++)
        {
            if(bp->data[i][j] != -1 && bp->data[i][j] != tempcolor)
            {
                return 0;
            }
        }
    }
    return 1;
}

/* determine if there's not a possible move left */
int reverse_board_complete(REVERSE_BOARD * bp)
{
    int i, j, turn;

    for(turn = 0; turn < 2; turn++)
    {
        for(i = 0; i < REVERSE_BOARD_RY; i++)
        {
            for(j = 0; j < REVERSE_BOARD_RX; j++)
            {
                if(reverse_place(bp, turn, j, i))
                {
                    reverse_clear_changes(bp);
                    return 0;
                }
            }
        }
    }
    return 1;
}

/* check for end-game conditions */
int reverse_game_over(REVERSE_BOARD * bp)
{
    if(reverse_board_full(bp) || reverse_board_1color(bp) || reverse_board_complete(bp))
    {
        return 1;
    }
    return 0;
}

/* count player pieces (keep score) */
void reverse_update_score(REVERSE_BOARD * bp, REVERSE_PLAYER * pp, int turn)
{
    int i, j;

    pp->score = 0;
    for(i = 0; i < REVERSE_BOARD_RY; i++)
    {
        for(j = 0; j < REVERSE_BOARD_RX; j++)
        {
            if(bp->data[i][j] == turn)
            {
                pp->score++;
            }
        }
    }
}

int reverse_can_pass(REVERSE_BOARD * bp, int turn)
{
    int i, j;

    for(i = 0; i < REVERSE_BOARD_RY; i++)
    {
        for(j = 0; j < REVERSE_BOARD_RX; j++)
        {
            if(reverse_place(bp, turn, j, i))
            {
                reverse_clear_changes(bp);
                return 0;
            }
        }
    }
    return 1;
}
