#include <allegro.h>

/* include the proper sound header */
#ifdef ALLEGRO_WINDOWS
    #include "t3sswin.h"
#else
    #ifdef __DJGPP__
        #include "t3ssdos.h"
    #else
        #include "t3ssal.h"
    #endif
#endif

#include <math.h>
#include "joy.h"

/* Reverse specific modules */
#include "reverse.h"
#include "logo.h"
#include "menu.h"
#include "title.h"
#include "core.h"
#include "ai.h"
#include "theme.h"
#include "player.h"

/* additional library modules */
#include "animate.h"
#include "font.h"
#include "random.h"

REVERSE_THEME  reverse_theme;
char           reverse_path[128] = {0};
BITMAP *       reverse_screen;
int            reverse_turn = 0;
BITMAP *       reverse_cursor;
REVERSE_PLAYER reverse_player[2];
int            reverse_frame = 0;
REVERSE_BOARD  reverse_board;
int            reverse_state = REVERSE_STATE_NORMAL;
int win_count[2] = {0, 0};
int ai_level[2] = {REVERSE_AI_TYPE_EXPERT, REVERSE_AI_TYPE_EXPERT};
//REVERSE_PLAYER player[2];
float reverse_mouse_x, reverse_mouse_y;
float reverse_mouse_vx, reverse_mouse_vy;
int reverse_mouse_dx, reverse_mouse_dy;
int reverse_left_click, reverse_right_click;
int reverse_done = 0;
int aborted = 0;
BITMAP * abort_image;
BITMAP * winner[4];
PALETTE  grayscale_palette;

extern int reverse_controller;
extern int reverse_frame_skip;
extern int reverse_vsync;
extern int reverse_difficulty;
extern int reverse_mixing_quality;
extern int reverse_music_volume;
extern int reverse_sound_volume;
extern int reverse_logic_frames_t;
extern int reverse_logic_frames;

extern PALETTE white_palette;

extern MSAMPLE * menu_fade_sound;

extern char reverse_theme_filename[256];
extern char reverse_theme_musicname[256];

int debug = 0;
PACKFILE * debug_file;
char debug_string[1024] = {0};
int game_winner;
int step_mode = 0;
int windowed = 0;

/* handle screen toggling */
void reverse_toggle_screen(void)
{
    int w, h;

    #ifdef ALLEGRO_WINDOWS
        if(windowed)
        {
            if(set_gfx_mode(GFX_AUTODETECT, REVERSE_RX, REVERSE_RY, 0, 0) < 0)
            {
                allegro_message("Cannot set video mode!");
                exit(0);
            }
            windowed = 0;
        }
        else
        {
            if(set_gfx_mode(GFX_AUTODETECT_WINDOWED, REVERSE_RX, REVERSE_RY, 0, 0) < 0)
            {
                allegro_message("Cannot set video mode!");
                exit(0);
            }
            windowed = 1;
            if(desktop_color_depth() <= 8)
            {
                if(set_gfx_mode(GFX_AUTODETECT, REVERSE_RX, REVERSE_RY, 0, 0) < 0)
                {
                    allegro_message("Cannot set video mode!");
                    exit(0);
                }
                windowed = 0;
            }
            else
            {
                get_desktop_resolution(&w, &h);
                if(w > 640 && h > 480)
                {
                    if(set_gfx_mode(GFX_AUTODETECT_WINDOWED, REVERSE_RX * 2, REVERSE_RY * 2, 0, 0) < 0)
                    {
                        allegro_message("Cannot set video mode!");
                        exit(0);
                    }
                    windowed = 2;
                }
            }
        }
    #endif
    set_mouse_sprite(reverse_cursor);
}

/* fullscreen blit using current screen mode */
void reverse_blit(BITMAP * bp)
{
    if(windowed == 2)
    {
        stretch_blit(bp, screen, 0, 0, bp->w, bp->h, 0, 0, bp->w * 2, bp->h * 2);
    }
    else
    {
        blit(bp, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
    }
}

/* get everything ready */
void reverse_init(void)
{
    int w, h;

    /* set up Allegro stuff */
    allegro_init();
    set_window_title("Reverse");
    set_window_close_button(0);
    install_keyboard();
    install_mouse();
    install_timer();
    reverse_load_config("reverse.cfg");
    if(reverse_controller == REVERSE_CONTROL_TYPE_ALL || reverse_controller == REVERSE_CONTROL_TYPE_JOYSTICK)
    {
        ncd_joy_install();
    }
    t3ss_init((reverse_mixing_quality == 0) ? 11025 : (reverse_mixing_quality == 1) ? 22050 : 44100, 0);
    t3ss_set_music_volume(reverse_music_volume);
    t3ss_set_sound_volume(reverse_sound_volume);
    reverse_screen = create_bitmap(REVERSE_RX, REVERSE_RY);
    abort_image = load_pcx("reverse.dat#abort", grayscale_palette);
    winner[0] = load_pcx("reverse.dat#1p_win", NULL);
    winner[1] = load_pcx("reverse.dat#2p_win", NULL);
    winner[2] = load_pcx("reverse.dat#cpu_win", NULL);
    winner[3] = load_pcx("reverse.dat#tied", NULL);

    /* load game data */
    if(!load_reverse_theme(&reverse_theme, reverse_theme_filename))
    {
        strcpy(reverse_theme_filename, "reverse.rth");
        if(!load_reverse_theme(&reverse_theme, reverse_theme_filename))
        {
            allegro_message("Error loading theme file.\n");
            exit(0);
        }
    }

    /* randomize */
    ncd_randomize();

    reverse_title_init();

    if(debug)
    {
        debug_file = pack_fopen("debug.txt", "w");
    }

    #ifdef ALLEGRO_WINDOWS
        if(windowed)
        {
            windowed = 0;
            reverse_toggle_screen();
            set_display_switch_mode(SWITCH_BACKGROUND);
        }
        else
        {
            if(set_gfx_mode(GFX_AUTODETECT, REVERSE_RX, REVERSE_RY, 0, 0) < 0)
            {
                allegro_message("Cannot set video mode!");
                exit(0);
            }
            set_display_switch_mode(SWITCH_PAUSE);
        }
    #else
        #ifdef __BEOS__
            get_desktop_resolution(&w, &h);
            if(w > 640 && h > 480)
            {
                if(set_gfx_mode(GFX_BEOS_WINDOWED, REVERSE_RX * 2, REVERSE_RY * 2, 0, 0) < 0)
                {
                    allegro_message("Cannot set video mode!");
                    exit(0);
                }
                windowed = 2;
            }
            else
            {
                if(set_gfx_mode(GFX_BEOS_WINDOWED, REVERSE_RX, REVERSE_RY, 0, 0) < 0)
                {
                    allegro_message("Cannot set video mode!");
                    exit(0);
                }
                windowed = 1;
            }
        #else
            if(set_gfx_mode(GFX_AUTODETECT, REVERSE_RX, REVERSE_RY, 0, 0) < 0)
            {
                allegro_message("Cannot set video mode!");
                exit(0);
            }
        #endif
    #endif
    set_mouse_sprite(reverse_cursor);
}

/* get ready to exit the game */
void reverse_exit(void)
{
    if(debug)
    {
        pack_fclose(debug_file);
    }
    reverse_title_exit();
    reverse_save_config("reverse.cfg");
    destroy_reverse_theme(&reverse_theme);
    destroy_bitmap(reverse_screen);
    destroy_bitmap(abort_image);
    destroy_bitmap(winner[0]);
    destroy_bitmap(winner[1]);
    destroy_bitmap(winner[2]);
    destroy_bitmap(winner[3]);
    t3ss_exit();
    ncd_joy_remove();
    remove_timer();
    remove_mouse();
    remove_keyboard();
    allegro_exit();
}

/* get the AI mouse moving properly */
void reverse_handle_ai_mouse(REVERSE_PLAYER * pp, int startx, int starty, int endx, int endy, float speed)
{
    double hypotenuse, hratio, dx, dy;

    dx = endx - startx;
    dy = endy - starty;
    hypotenuse = sqrt(dx * dx + dy * dy);
    hratio = speed / hypotenuse;
    reverse_mouse_x = startx;
    reverse_mouse_y = starty;
    reverse_mouse_vx = dx * hratio; // these are what you're looking for
    reverse_mouse_vy = dy * hratio;
}

/* dump debug info into file */
void ai_debug_info(void)
{
    int i, j;

    for(i = 0; i < 8; i++)
    {
        for(j = 0; j < 8; j++)
        {
            sprintf(debug_string, "%d", reverse_board.change[i][j]);
            pack_fputs(debug_string, debug_file);
        }
        sprintf(debug_string, "\n", reverse_board.change[i][j]);
        pack_fputs(debug_string, debug_file);
    }
    sprintf(debug_string, "\n", reverse_board.change[i][j]);
    pack_fputs(debug_string, debug_file);
}

/* helper for win sequence */
void mark_win(int win)
{
    int i, j;

    reverse_state = REVERSE_STATE_END;
    reverse_frame = 0;
    reverse_clear_changes(&reverse_board);
    if(win == 0 || win == 1)
    {
        for(i = 0; i < REVERSE_BOARD_RY; i++)
        {
            for(j = 0; j < REVERSE_BOARD_RX; j++)
            {
                if(reverse_board.data[i][j] != win && reverse_board.data[i][j] >= 0)
                {
                    reverse_board.change[i][j] = 1;
                }
            }
        }
    }
}

/* helper for input */
void reverse_handle_input(void)
{
    int misc = 0;

    if(reverse_player[reverse_turn].type == REVERSE_PLAYER_TYPE_HUMAN)
    {
        if(reverse_left_click == 1 && reverse_mouse_x >= reverse_theme.boardx && reverse_mouse_x < reverse_theme.boardx + REVERSE_BOARD_RX * reverse_theme.piece[reverse_turn].w - 1 && reverse_mouse_y >= reverse_theme.boardy && reverse_mouse_y < reverse_theme.boardy + REVERSE_BOARD_RY * reverse_theme.piece[reverse_turn].h - 1)
        {
            reverse_left_click++;
            if(reverse_place(&reverse_board, reverse_turn, ((int)reverse_mouse_x - reverse_theme.boardx) / reverse_theme.piece[reverse_turn].w, ((int)reverse_mouse_y - reverse_theme.boardy) / reverse_theme.piece[reverse_turn].h))
            {
                t3ss_play_sound(reverse_theme.sound[REVERSE_SOUND_PLACE], 128, 22050);
                reverse_frame = 0;
                reverse_state = REVERSE_STATE_FLIP;
            }
            else
            {
                t3ss_play_sound(reverse_theme.sound[REVERSE_SOUND_BAD], 128, 22050);
            }
        }
        if(reverse_right_click == 1 && reverse_can_pass(&reverse_board, reverse_turn))
        {
            reverse_right_click++;
            t3ss_play_sound(reverse_theme.sound[REVERSE_SOUND_PASS], 128, 22050);
            reverse_turn = 1 - reverse_turn;
        }
    }
    else if(reverse_player[reverse_turn].type == REVERSE_PLAYER_TYPE_AI_BEGINNER || reverse_player[reverse_turn].type == REVERSE_PLAYER_TYPE_AI_INTERMEDIATE || reverse_player[reverse_turn].type == REVERSE_PLAYER_TYPE_AI_ADVANCED || reverse_player[reverse_turn].type == REVERSE_PLAYER_TYPE_AI_EXPERT)
    {
        if(reverse_state == REVERSE_STATE_NORMAL)
        {
            misc = reverse_ai_place(&reverse_board, reverse_turn, reverse_player[reverse_turn].type - 1);
            reverse_mouse_dx = reverse_theme.boardx + (misc % REVERSE_BOARD_RX) * reverse_theme.piece[reverse_turn].w + reverse_theme.piece[reverse_turn].w / 2;
            reverse_mouse_dy = reverse_theme.boardy + (misc / REVERSE_BOARD_RX) * reverse_theme.piece[reverse_turn].h + reverse_theme.piece[reverse_turn].h / 2;
            if(misc >= 0)
            {
                reverse_handle_ai_mouse(&reverse_player[reverse_turn], reverse_mouse_x, reverse_mouse_y, reverse_mouse_dx, reverse_mouse_dy, 4);
                reverse_state = REVERSE_STATE_AI;
            }
            else
            {
                t3ss_play_sound(reverse_theme.sound[REVERSE_SOUND_PASS], 128, 22050);
                reverse_turn = 1 - reverse_turn;
            }
        }
        else if(reverse_state == REVERSE_STATE_AI)
        {
            if(reverse_left_click == 1 && reverse_mouse_x >= reverse_theme.boardx && reverse_mouse_x < reverse_theme.boardx + REVERSE_BOARD_RX * reverse_theme.piece[reverse_turn].w - 1 && reverse_mouse_y >= reverse_theme.boardy && reverse_mouse_y < reverse_theme.boardy + REVERSE_BOARD_RY * reverse_theme.piece[reverse_turn].h - 1)
            {
                reverse_left_click++;
                if(reverse_place(&reverse_board, reverse_turn, ((int)reverse_mouse_x - reverse_theme.boardx) / reverse_theme.piece[reverse_turn].w, ((int)reverse_mouse_y - reverse_theme.boardy) / reverse_theme.piece[reverse_turn].h))
                {
                    t3ss_play_sound(reverse_theme.sound[REVERSE_SOUND_PLACE], 128, 22050);
                    reverse_frame = 0;
                    reverse_state = REVERSE_STATE_FLIP;
                }
                else
                {
                    t3ss_play_sound(reverse_theme.sound[REVERSE_SOUND_BAD], 128, 22050);
                }
                if(debug)
                {
                    ai_debug_info();
                }
            }
        }
//        reverse_turn = 1 - reverse_turn;
    }
}

/* handle controls */
void reverse_control(void)
{
    ncd_joy_poll();
    if(key[KEY_ESC] && (reverse_player[0].type == REVERSE_PLAYER_TYPE_HUMAN || reverse_player[1].type == REVERSE_PLAYER_TYPE_HUMAN))
    {
        t3ss_play_sound(menu_fade_sound, 128, 22050);
        fade_from(reverse_theme.palette, white_palette, 3);
        reverse_blit(abort_image);
        fade_from(white_palette, grayscale_palette, 3);
        clear_keybuf();
        while(1)
        {
            if(key[KEY_Y])
            {
                reverse_done = 1;
                aborted = 1;
                break;
            }
            if(key[KEY_N])
            {
                t3ss_play_sound(menu_fade_sound, 128, 22050);
                fade_from(grayscale_palette, white_palette, 3);
                reverse_update();
                fade_from(white_palette, reverse_theme.palette, 3);
                break;
            }
            if(key[KEY_ALT] && key[KEY_ENTER])
            {
                reverse_toggle_screen();
                set_palette(grayscale_palette);
                reverse_blit(abort_image);
                key[KEY_ALT] = 0;
                key[KEY_ENTER] = 0;
            }
        }
    }
    if(key[KEY_ALT] && key[KEY_ENTER])
    {
        reverse_toggle_screen();
        set_palette(reverse_theme.palette);
        key[KEY_ALT] = 0;
        key[KEY_ENTER] = 0;
    }
    if(reverse_player[reverse_turn].type == REVERSE_PLAYER_TYPE_HUMAN)
    {
        if(reverse_state == REVERSE_STATE_NORMAL)
        {
            if(reverse_controller == REVERSE_CONTROL_TYPE_ALL || reverse_controller == REVERSE_CONTROL_TYPE_MOUSE)
            {
                reverse_mouse_x = mouse_x / ((SCREEN_W == 320) ? 1 : 2);
                reverse_mouse_y = mouse_y / ((SCREEN_W == 320) ? 1 : 2);
            }
            if((mouse_b & 1 && (reverse_controller == REVERSE_CONTROL_TYPE_ALL || reverse_controller == REVERSE_CONTROL_TYPE_MOUSE)) || ((key[KEY_ENTER] && !key[KEY_ALT]) && (reverse_controller == REVERSE_CONTROL_TYPE_ALL || reverse_controller == REVERSE_CONTROL_TYPE_KEYBOARD)) || ((ncd_joy_button(0, 0) || ncd_joy_button(1, 0)) && (reverse_controller == REVERSE_CONTROL_TYPE_ALL || reverse_controller == REVERSE_CONTROL_TYPE_JOYSTICK)))
            {
                reverse_left_click++;
            }
            else
            {
                reverse_left_click = 0;
            }
            if((mouse_b & 2 && (reverse_controller == REVERSE_CONTROL_TYPE_ALL || reverse_controller == REVERSE_CONTROL_TYPE_MOUSE)) || (key[KEY_TAB] && (reverse_controller == REVERSE_CONTROL_TYPE_ALL || reverse_controller == REVERSE_CONTROL_TYPE_KEYBOARD)) || ((ncd_joy_button(0, 1) || ncd_joy_button(1, 1)) && (reverse_controller == REVERSE_CONTROL_TYPE_ALL || reverse_controller == REVERSE_CONTROL_TYPE_JOYSTICK)))
            {
                reverse_right_click++;
            }
            else
            {
                reverse_right_click = 0;
            }
            if((key[KEY_LEFT] && (reverse_controller == REVERSE_CONTROL_TYPE_ALL || reverse_controller == REVERSE_CONTROL_TYPE_KEYBOARD)) || ((ncd_joy_left(0) || ncd_joy_left(1)) && (reverse_controller == REVERSE_CONTROL_TYPE_ALL || reverse_controller == REVERSE_CONTROL_TYPE_JOYSTICK)))
            {
                reverse_mouse_x -= 1;
                position_mouse(reverse_mouse_x * ((SCREEN_W == 320) ? 1 : 2), reverse_mouse_y * ((SCREEN_W == 320) ? 1 : 2));
            }
            if((key[KEY_RIGHT] && (reverse_controller == REVERSE_CONTROL_TYPE_ALL || reverse_controller == REVERSE_CONTROL_TYPE_KEYBOARD)) || ((ncd_joy_right(0) || ncd_joy_right(1)) && (reverse_controller == REVERSE_CONTROL_TYPE_ALL || reverse_controller == REVERSE_CONTROL_TYPE_JOYSTICK)))
            {
                reverse_mouse_x += 1;
                position_mouse(reverse_mouse_x * ((SCREEN_W == 320) ? 1 : 2), reverse_mouse_y * ((SCREEN_W == 320) ? 1 : 2));
            }
            if((key[KEY_UP] && (reverse_controller == REVERSE_CONTROL_TYPE_ALL || reverse_controller == REVERSE_CONTROL_TYPE_KEYBOARD)) || ((ncd_joy_up(0) || ncd_joy_up(1)) && (reverse_controller == REVERSE_CONTROL_TYPE_ALL || reverse_controller == REVERSE_CONTROL_TYPE_JOYSTICK)))
            {
                reverse_mouse_y -= 1;
                position_mouse(reverse_mouse_x * ((SCREEN_W == 320) ? 1 : 2), reverse_mouse_y * ((SCREEN_W == 320) ? 1 : 2));
            }
            if((key[KEY_DOWN] && (reverse_controller == REVERSE_CONTROL_TYPE_ALL || reverse_controller == REVERSE_CONTROL_TYPE_KEYBOARD)) || ((ncd_joy_down(0) || ncd_joy_down(1)) && (reverse_controller == REVERSE_CONTROL_TYPE_ALL || reverse_controller == REVERSE_CONTROL_TYPE_JOYSTICK)))
            {
                reverse_mouse_y += 1;
                position_mouse(reverse_mouse_x * ((SCREEN_W == 320) ? 1 : 2), reverse_mouse_y * ((SCREEN_W == 320) ? 1 : 2));
            }
//            if(reverse_controller == REVERSE_CONTROL_TYPE_ALL || reverse_controller == REVERSE_CONTROL_TYPE_MOUSE)
//            {
//            }
        }
    }
    else if(reverse_player[reverse_turn].type == REVERSE_PLAYER_TYPE_AI_BEGINNER || reverse_player[reverse_turn].type == REVERSE_PLAYER_TYPE_AI_INTERMEDIATE || reverse_player[reverse_turn].type == REVERSE_PLAYER_TYPE_AI_ADVANCED || reverse_player[reverse_turn].type == REVERSE_PLAYER_TYPE_AI_EXPERT)
    {
        if(reverse_state == REVERSE_STATE_AI)
        {
            reverse_mouse_x += reverse_mouse_vx;
            reverse_mouse_y += reverse_mouse_vy;
            if(((reverse_mouse_vx < 0) ? ((int)reverse_mouse_x <= (int)reverse_mouse_dx) : ((int)reverse_mouse_x >= (int)reverse_mouse_dx)) && ((reverse_mouse_vy < 0) ? ((int)reverse_mouse_y <= (int)reverse_mouse_dy) : ((int)reverse_mouse_y >= (int)reverse_mouse_dy)))
            {
                reverse_left_click = 1;
                if((reverse_controller == REVERSE_CONTROL_TYPE_ALL || reverse_controller == REVERSE_CONTROL_TYPE_MOUSE) && reverse_player[reverse_turn == 0 ? 1 : 0].type == REVERSE_PLAYER_TYPE_HUMAN)
                {
                    position_mouse(reverse_mouse_x * ((SCREEN_W == 320) ? 1 : 2), reverse_mouse_y * ((SCREEN_W == 320) ? 1 : 2));
                }
            }
        }
    }
    if(reverse_state == REVERSE_STATE_NORMAL || reverse_state == REVERSE_STATE_AI)
    {
        reverse_handle_input();
        if(key[KEY_C])
        {
        }
    }
    reverse_frame++;
}

/* handle screen updates */
void reverse_update(void)
{
    int i, j;

    if(!aborted)
    {
        reverse_update_score(&reverse_board, &reverse_player[0], 0);
        reverse_update_score(&reverse_board, &reverse_player[1], 1);
        if(reverse_state == REVERSE_STATE_NORMAL || reverse_state == REVERSE_STATE_AI)
        {
            blit(reverse_theme.backdrop, reverse_screen, 0, 0, 0, 0, REVERSE_RX, REVERSE_RY);
            for(i = 0; i < REVERSE_BOARD_RY; i++)
            {
                for(j = 0; j < REVERSE_BOARD_RX; j++)
                {
                    if(reverse_board.data[i][j] >= 0)
                    {
                        blit_animation(&reverse_theme.piece[reverse_board.data[i][j]], reverse_frame, reverse_screen, reverse_theme.boardx + j * reverse_theme.piece[j % 2].w, reverse_theme.boardy + i * reverse_theme.piece[j % 2].h);
                    }
                    if(debug)
                    {
                        textprintf(reverse_screen, font, reverse_theme.boardx + j * reverse_theme.piece[j % 2].w, reverse_theme.boardy + i * reverse_theme.piece[j % 2].h, makecol(255, 255, 255), "%d", reverse_board.change[i][j]);
                    }
                }
            }
            ncd_draw_number(reverse_screen, &reverse_theme.font, reverse_theme.scorex[0], reverse_theme.scorey[0], reverse_player[0].score, 3);
            ncd_draw_number(reverse_screen, &reverse_theme.font, reverse_theme.scorex[1], reverse_theme.scorey[1], reverse_player[1].score, 3);
            if(reverse_place(&reverse_board, reverse_turn, ((int)reverse_mouse_x - reverse_theme.boardx) / reverse_theme.piece[reverse_turn].w, ((int)reverse_mouse_y - reverse_theme.boardy) / reverse_theme.piece[reverse_turn].h) && (int)reverse_mouse_x >= reverse_theme.boardx && (int)reverse_mouse_x < reverse_theme.boardx + 8 * reverse_theme.piece[reverse_turn].w && (int)reverse_mouse_y >= reverse_theme.boardy && (int)reverse_mouse_y < reverse_theme.boardy + 8 * reverse_theme.piece[reverse_turn].h && !reverse_done)
            {
                draw_animation(&reverse_theme.select[1], reverse_frame, reverse_screen, reverse_theme.boardx + (((int)reverse_mouse_x - reverse_theme.boardx) / reverse_theme.piece[reverse_turn].w) * reverse_theme.piece[reverse_turn].w, reverse_theme.boardy + (((int)reverse_mouse_y - reverse_theme.boardy) / reverse_theme.piece[reverse_turn].h) * reverse_theme.piece[reverse_turn].h);
                reverse_clear_changes(&reverse_board);
            }
            else if((int)reverse_mouse_x >= reverse_theme.boardx && (int)reverse_mouse_x < reverse_theme.boardx + 8 * reverse_theme.piece[reverse_turn].w && (int)reverse_mouse_y >= reverse_theme.boardy && (int)reverse_mouse_y < reverse_theme.boardy + 8 * reverse_theme.piece[reverse_turn].h && !reverse_done)
            {
                draw_animation(&reverse_theme.select[0], reverse_frame, reverse_screen, reverse_theme.boardx + (((int)reverse_mouse_x - reverse_theme.boardx) / reverse_theme.piece[reverse_turn].w) * reverse_theme.piece[reverse_turn].w, reverse_theme.boardy + (((int)reverse_mouse_y - reverse_theme.boardy) / reverse_theme.piece[reverse_turn].h) * reverse_theme.piece[reverse_turn].h);
            }
            if(!reverse_done)
            {
                draw_animation(&reverse_theme.cursor[reverse_turn], reverse_frame, reverse_screen, reverse_mouse_x - reverse_theme.mousex, reverse_mouse_y - reverse_theme.mousey);
            }
        }
        else if(reverse_state == REVERSE_STATE_FLIP)
        {
            if(reverse_frame >= reverse_theme.flip[reverse_turn].d * reverse_theme.flip[reverse_turn].f)
            {
                reverse_handle_changes(&reverse_board, reverse_turn);
                if(reverse_game_over(&reverse_board))
                {
                    reverse_update_score(&reverse_board, &reverse_player[0], 0);
                    reverse_update_score(&reverse_board, &reverse_player[1], 1);
                    if(reverse_player[0].score > reverse_player[1].score)
                    {
                        game_winner = 0;
                        mark_win(0);
                    }
                    else if(reverse_player[1].score > reverse_player[0].score)
                    {
                        game_winner = 1;
                        mark_win(1);
                    }
                    else
                    {
                        reverse_state = REVERSE_STATE_NORMAL;
                        reverse_done = 1;
                        reverse_update();
                    }
                }
                else
                {
                    reverse_turn = 1 - reverse_turn;
                    reverse_state = REVERSE_STATE_NORMAL;
                }
            }
            if(reverse_state != REVERSE_STATE_END)
            {
                blit(reverse_theme.backdrop, reverse_screen, 0, 0, 0, 0, REVERSE_RX, REVERSE_RY);
                for(i = 0; i < REVERSE_BOARD_RY; i++)
                {
                    for(j = 0; j < REVERSE_BOARD_RX; j++)
                    {
                        if(reverse_board.data[i][j] >= 0 && reverse_board.change[i][j] < 1)
                        {
                            blit_animation(&reverse_theme.piece[reverse_board.data[i][j]], reverse_frame, reverse_screen, reverse_theme.boardx + j * reverse_theme.piece[j % 2].w, reverse_theme.boardy + i * reverse_theme.piece[j % 2].h);
                        }
                        else if(reverse_board.change[i][j] == 1)
                        {
                            blit_animation(&reverse_theme.flip[reverse_turn], reverse_frame, reverse_screen, reverse_theme.boardx + j * reverse_theme.flip[reverse_turn].w, reverse_theme.boardy + i * reverse_theme.flip[reverse_turn].h);
                        }
                        else if(reverse_board.change[i][j] == 2)
                        {
                            blit_animation(&reverse_theme.piece[reverse_turn], reverse_frame, reverse_screen, reverse_theme.boardx + j * reverse_theme.piece[j % 2].w, reverse_theme.boardy + i * reverse_theme.piece[j % 2].h);
                        }
                        if(debug)
                        {
                            textprintf(reverse_screen, font, reverse_theme.boardx + j * reverse_theme.piece[j % 2].w, reverse_theme.boardy + i * reverse_theme.piece[j % 2].h, makecol(255, 255, 255), "%d", reverse_board.change[i][j]);
                        }
                    }
                }
                ncd_draw_number(reverse_screen, &reverse_theme.font, reverse_theme.scorex[0], reverse_theme.scorey[0], reverse_player[0].score, 3);
                ncd_draw_number(reverse_screen, &reverse_theme.font, reverse_theme.scorex[1], reverse_theme.scorey[1], reverse_player[1].score, 3);
            }
        }
        else if(reverse_state == REVERSE_STATE_END)
        {
            if(reverse_frame >= reverse_theme.flip[game_winner].d * reverse_theme.flip[game_winner].f - 1)
            {
                reverse_handle_changes(&reverse_board, game_winner);
                reverse_state = REVERSE_STATE_NORMAL;
                reverse_done = 1;
                reverse_update();
            }
            blit(reverse_theme.backdrop, reverse_screen, 0, 0, 0, 0, REVERSE_RX, REVERSE_RY);
            for(i = 0; i < REVERSE_BOARD_RY; i++)
            {
                for(j = 0; j < REVERSE_BOARD_RX; j++)
                {
                    if(reverse_board.data[i][j] >= 0 && reverse_board.change[i][j] < 1)
                    {
                        blit_animation(&reverse_theme.piece[reverse_board.data[i][j]], reverse_frame, reverse_screen, reverse_theme.boardx + j * reverse_theme.piece[j % 2].w, reverse_theme.boardy + i * reverse_theme.piece[j % 2].h);
                    }
                    else if(reverse_board.change[i][j] == 1)
                    {
                        blit_animation(&reverse_theme.flip[game_winner], reverse_frame, reverse_screen, reverse_theme.boardx + j * reverse_theme.flip[reverse_turn].w, reverse_theme.boardy + i * reverse_theme.flip[reverse_turn].h);
                    }
//                    else if(reverse_board.change[i][j] == 2)
//                    {
//                        blit_animation(&reverse_theme.piece[game_winner], reverse_frame, reverse_screen, reverse_theme.boardx + j * reverse_theme.piece[j % 2].w, reverse_theme.boardy + i * reverse_theme.piece[j % 2].h);
//                    }
                    if(debug)
                    {
                        textprintf(reverse_screen, font, reverse_theme.boardx + j * reverse_theme.piece[j % 2].w, reverse_theme.boardy + i * reverse_theme.piece[j % 2].h, makecol(255, 255, 255), "%d", reverse_board.change[i][j]);
                    }
                }
            }
            ncd_draw_number(reverse_screen, &reverse_theme.font, reverse_theme.scorex[0], reverse_theme.scorey[0], reverse_player[0].score, 3);
            ncd_draw_number(reverse_screen, &reverse_theme.font, reverse_theme.scorex[1], reverse_theme.scorey[1], reverse_player[1].score, 3);
        }
//        textprintf(reverse_screen, font, 0, 0, makecol(255, 255, 255), "State = %d", reverse_state);
//        textprintf(reverse_screen, font, 0, 8, makecol(255, 255, 255), "Frame = %d", reverse_frame);
        if(reverse_vsync)
        {
            vsync();
        }
        reverse_blit(reverse_screen);
    }
}

/* display the game winner */
void show_winner(void)
{
    if(reverse_player[0].score > reverse_player[1].score)
    {
        t3ss_play_sound(reverse_theme.sound[REVERSE_SOUND_WIN], 128, 22050);
    }
    else if(reverse_player[1].score > reverse_player[0].score)
    {
        t3ss_play_sound(reverse_theme.sound[REVERSE_SOUND_WIN], 128, 22050);
    }
    else
    {
        t3ss_play_sound(reverse_theme.sound[REVERSE_SOUND_TIE], 128, 22050);
    }
    t3ss_play_sound(menu_fade_sound, 128, 22050);
    fade_from(reverse_theme.palette, white_palette, 3);
    if(reverse_player[0].type == REVERSE_PLAYER_TYPE_HUMAN && reverse_player[1].type == REVERSE_PLAYER_TYPE_HUMAN)
    {
        if(reverse_player[0].score > reverse_player[1].score)
        {
            reverse_blit(winner[0]);
        }
        else if(reverse_player[1].score > reverse_player[0].score)
        {
            reverse_blit(winner[1]);
        }
        else
        {
            reverse_blit(winner[3]);
        }
    }
    else if(reverse_player[0].type == REVERSE_PLAYER_TYPE_HUMAN)
    {
        if(reverse_player[0].score > reverse_player[1].score)
        {
            reverse_blit(winner[0]);
        }
        else if(reverse_player[1].score > reverse_player[0].score)
        {
            reverse_blit(winner[2]);
        }
        else
        {
            reverse_blit(winner[3]);
        }
    }
    else
    {
        if(reverse_player[0].score > reverse_player[1].score)
        {
            reverse_blit(winner[2]);
        }
        else if(reverse_player[1].score > reverse_player[0].score)
        {
            reverse_blit(winner[0]);
        }
        else
        {
            reverse_blit(winner[3]);
        }
    }
    fade_from(white_palette, grayscale_palette, 3);
    clear_keybuf();
    while(!keypressed());
    clear_keybuf();
    t3ss_stop_mod();
    t3ss_play_sound(menu_fade_sound, 128, 22050);
    fade_from(grayscale_palette, white_palette, 3);
}

/* starts normal play */
void reverse_play(void)
{
    int i;

    /* reset the board for new game */
    reverse_reset_board(&reverse_board);
    reverse_clear_changes(&reverse_board);
    aborted = 0;
    reverse_state = REVERSE_STATE_NORMAL;
    reverse_turn = 0;
    reverse_mouse_x = REVERSE_RX / 2;
    reverse_mouse_y = REVERSE_RY / 2;
    if(reverse_controller == REVERSE_CONTROL_TYPE_ALL || reverse_controller == REVERSE_CONTROL_TYPE_MOUSE)
    {
        position_mouse(reverse_mouse_x * ((SCREEN_W == 320) ? 1 : 2), reverse_mouse_y * ((SCREEN_W == 320) ? 1 : 2));
    }

    reverse_done = 1;
    reverse_update();
    reverse_done = 0;
    fade_from(white_palette, reverse_theme.palette, 3);
    if(!exists(reverse_theme_musicname))
    {
        strcpy(reverse_theme_musicname, "reverse.dat#reverse_game_music");
        if(!exists(reverse_theme_musicname))
        {
            allegro_message("Error load theme music.\n");
            exit(0);
        }
    }
    t3ss_play_mod(reverse_theme_musicname);
    reverse_logic_frames_t = 0;
    while(!reverse_done)
    {
        if(reverse_frame_skip)
        {
            reverse_logic_frames = reverse_logic_frames_t;
            reverse_logic_frames_t = 0;
            for(i = 0; i < reverse_logic_frames; i++)
            {
                reverse_control();
            }
        }
        else
        {
            reverse_control();
        }
        reverse_update();
    }
    if(!aborted)
    {
        show_winner();
    }
    else
    {
        t3ss_stop_mod();
        t3ss_play_sound(menu_fade_sound, 128, 22050);
        fade_from(grayscale_palette, white_palette, 3);
    }
}

/* starts game in demo mode */
void reverse_demo(void)
{
    int i;

    /* reset the board for new game */
    reverse_reset_board(&reverse_board);
    reverse_clear_changes(&reverse_board);
    reverse_state = REVERSE_STATE_NORMAL;
    reverse_turn = 0;
    reverse_mouse_x = REVERSE_RX / 2;
    reverse_mouse_y = REVERSE_RY / 2;
    aborted = 0;
    reverse_player[0].type = ncd_random() % 4 + REVERSE_PLAYER_TYPE_AI_BEGINNER;
    reverse_player[1].type = ncd_random() % 4 + REVERSE_PLAYER_TYPE_AI_BEGINNER;
    if(debug)
    {
        sprintf(debug_string, "Player 1 is %d\nPlayer 2 is %d\n", reverse_player[0].type, reverse_player[1].type);
        pack_fputs(debug_string, debug_file);
    }

    reverse_done = 1;
    reverse_update();
    reverse_done = 0;
    fade_from(white_palette, reverse_theme.palette, 3);
    reverse_logic_frames_t = 0;
    clear_keybuf();
    while(!reverse_done && !keypressed())
    {
        if(reverse_frame_skip)
        {
            reverse_logic_frames = reverse_logic_frames_t;
            reverse_logic_frames_t = 0;
            for(i = 0; i < reverse_logic_frames; i++)
            {
                reverse_control();
            }
        }
        else
        {
            reverse_control();
        }
        reverse_update();
    }
    clear_keybuf();
    t3ss_play_sound(menu_fade_sound, 128, 22050);
    fade_from(reverse_theme.palette, white_palette, 3);
}

/* the main sequence of events */
void reverse_main(void)
{
    /* display the NCD logo */
    ncd_logo("reverse.dat#ncd_logo", "reverse.dat#ncd_sound");

    /* show the title screen */
    reverse_title();
}

int main(int argc, char * argv[])
{
    if(argc > 1)
    {
        if(argv[1][1] == 'v' || argv[1][1] == 'V')
        {
            allegro_init();
            set_window_title("Reverse");
            allegro_message(REVERSE_VERSION);
            allegro_exit();
            return 0;
        }
        #ifdef ALLEGRO_WINDOWS
            if(argv[1][1] == 'w' || argv[1][1] == 'W')
            {
                windowed = 1;
            }
        #endif
    }
    reverse_init();
    reverse_main();
    reverse_exit();

    return 0;
}
END_OF_MAIN()
