#ifndef MENU_H
#define MENU_H

#define REVERSE_MENU_SELECTED    0
#define REVERSE_MENU_UNSELECTED  1
#define REVERSE_MENU_MAX_ITEMS   8

typedef struct
{

    /* images */
    BITMAP * bp[2];
    BITMAP * icon;

    /* procedure pointers */
    void(*enter_proc)();
    void(*left_proc)();
    void(*right_proc)();

    /* variables */
    int x, y;

} REVERSE_MENU_ITEM;

typedef struct
{

    /* the items */
    REVERSE_MENU_ITEM item[REVERSE_MENU_MAX_ITEMS];

    /* variables */
    int total_items;
    int parent;
    int selected;

} REVERSE_MENU;

void initialize_reverse_menu(REVERSE_MENU * mp, int parent);
void add_reverse_menu_item(REVERSE_MENU * mp, BITMAP * sbp, BITMAP * ubp, BITMAP * ibp, int x, int y, void(*lproc)(), void(*rproc)(), void(*eproc)());
void destroy_reverse_menu(REVERSE_MENU * mp);
void reverse_menu_control(REVERSE_MENU * mp);
void draw_reverse_menu(REVERSE_MENU * mp, BITMAP * bp);

#endif
