#include <allegro.h>

/* include the proper sound header */
#ifdef ALLEGRO_WINDOWS
    #include "t3sswin.h"
#else
    #ifdef __DJGPP__
        #include "t3ssdos.h"
    #else
        #include "t3ssal.h"
    #endif
#endif

#include "reverse.h"

PALETTE  white_palette;
extern MSAMPLE * menu_fade_sound;
extern BITMAP * reverse_screen;

/* display NewCreature Design logo with specified sound */
void ncd_logo(char * fn, char * fn2)
{
    BITMAP * logo_pic;
    PALETTE  logo_palette;
    MSAMPLE * logo_sound;
    int      logo_counter;
    int i;

    /* build white palette */
    for(i = 0; i < 256; i++)
    {
        white_palette[i].r = 63;
        white_palette[i].g = 63;
        white_palette[i].b = 63;
    }

    /* set up */
    logo_sound = t3ss_load_wav_fn(fn2);
    logo_pic = load_pcx(fn, logo_palette);
    set_palette(black_palette);
    blit(logo_pic, reverse_screen, 0, 0, 0, 0, REVERSE_RX, REVERSE_RY);
    reverse_blit(reverse_screen);

    /* fade in and wait until done */
    fade_in(logo_palette, 2);
    t3ss_play_sound(logo_sound, 128, 22050);
    for(logo_counter = 0; logo_counter < 180; logo_counter++)
    {
        /* check for screen toggle */
        if(key[KEY_ALT] && key[KEY_ENTER])
        {
            reverse_toggle_screen();
            reverse_blit(reverse_screen);
            set_palette(logo_palette);
            key[KEY_ALT] = 0;
            key[KEY_ENTER] = 0;
        }
        vsync();
    }

    /* fade out */
    t3ss_play_sound(menu_fade_sound, 128, 22050);
    fade_from(logo_palette, white_palette, 4);
//    fade_out(4);
    t3ss_free_wav(logo_sound);
    destroy_bitmap(logo_pic);
}
