/*************************** Lgc ************************/
// FILE : util.c
/*******************************************************/

#include "internal.h"
/************************** variables ***********************/
int delay_textanim = 20; /* delay de l'animation du texte */
/* pour MP3 */
int nodouble=0;
#ifndef NO_MP3
MP3FILE *mp3 = 0;        /* structure MP3 */
int ret = 0;            
int MP3_PLAYED;
#endif
void playmidi (int n){
	play_midi (Data[n].dat , 1);
}
/******************* choix **************************/
int im_choix=CHOIX;

void highcolor_fade_in(BITMAP *bmp_orig, int speed)
{
   BITMAP *bmp_buff;

    if ((bmp_buff = create_bitmap(SCREEN_W, SCREEN_H)))
    {
        int a;
        if (speed <= 0) speed = 16;
        
        for (a = 0; a < 256; a+=speed)
        {
            clear(bmp_buff);
            set_trans_blender(0,0,0,a);
            draw_trans_sprite(bmp_buff, bmp_orig, 0, 0);
            vsync();
            blit(bmp_buff, screen, 0,0, 0,0, SCREEN_W, SCREEN_H);
        }
        destroy_bitmap(bmp_buff);
    } 

    blit(bmp_orig, screen, 0,0, 0,0, SCREEN_W, SCREEN_H);
}

void highcolor_fade_out(int speed)
{
    BITMAP *bmp_orig, *bmp_buff;

    if ((bmp_orig = create_bitmap(SCREEN_W, SCREEN_H)))
    {
        if ((bmp_buff = create_bitmap(SCREEN_W, SCREEN_H)))
        {
            int a;
            blit(screen, bmp_orig, 0,0, 0,0, SCREEN_W, SCREEN_H);
            if (speed <= 0) speed = 16;
        
            for (a = 255-speed; a > 0; a-=speed)
            {
                clear(bmp_buff);
                set_trans_blender(0,0,0,a);
                draw_trans_sprite(bmp_buff, bmp_orig, 0, 0);
                vsync();
                blit(bmp_buff, screen, 0,0, 0,0, SCREEN_W, SCREEN_H);
            }
            destroy_bitmap(bmp_buff);
        }
        destroy_bitmap(bmp_orig);
    }

    rectfill(screen, 0,0, SCREEN_W,SCREEN_H, makecol(0,0,0));
}
int
Choix (int x,int y,int max,int ech,int start ){
	BITMAP *image = Data[CHOIX].dat;
	BITMAP *save=create_bitmap(SCREEN_W,SCREEN_H);
	int cxx=start;
	int cx=x,cy=y;
	int up=1;

	blit(buffer2,save,0,0,0,0,SCREEN_W,SCREEN_H);
	draw_sprite (buffer2 , image , cx , cy);
	blit (buffer2,screen,0,0,0,0,SCREEN_W,SCREEN_H);

	cy+=(ech * cxx);
	while(1){
		poll_keyboard ();
		poll_joystick ();
		
		if(BTUP){
			play_sfx (SFX13);
			cxx--;
			if(cxx < 0) cxx=max-1;
			cy = y + (ech*cxx);
			rest (CHOIX_DELAY);
			blit(save,buffer2,0,0,0,0,SCREEN_W,SCREEN_H);
			draw_sprite (buffer2 , image , cx , cy);
			blit (buffer2,screen,0,0,0,0,SCREEN_W,SCREEN_H);
		
		}
		if(BTDOWN){
			play_sfx (SFX13);
			cxx++;
			if(cxx > max-1) cxx=0;
			cy = y + (ech*cxx);
			rest (CHOIX_DELAY);
			blit(save,buffer2,0,0,0,0,SCREEN_W,SCREEN_H);
			draw_sprite (buffer2 , image , cx , cy);
			blit (buffer2,screen,0,0,0,0,SCREEN_W,SCREEN_H);


		}
		if(BTSPACE){
			play_sfx(SFX15);
			break;
		}
		if(BTFULLSCREEN) {
			set_fullscreen ();
			blit (buffer2,screen,0,0,0,0,SCREEN_W,SCREEN_H);

		}
	}
	
	
	if(save) {destroy_bitmap(save);save=NULL;}
	clear_keybuf ();
	rest (200);
	clear_keybuf ();
	return cxx;
}
/***************** play_sfx ************************/

int
play_sfx (int n)
{
  return play_sample (Data[n].dat, 255, 128, 1000, 0);
}

/*********************** textanim *********************/
// si s alors retourne -1
// si espace (pour tout ecrire) alors retourne 1
// 0 si rien
int
textanim (BITMAP * bmp, ALFONT_FONT * f, char *s, int x, int y, int c1, int c2,
	  int delay, int dejaespace)
{
  int i = 0, r = alfont_text_length (f, "d");
  char m[10];
  int get;
  int dc1 = c1 , dc2 = c2;
  int bdelay = delay;
  if (!s) return -1;

  while(BTSPACE) { poll_keyboard(); poll_joystick(); }

  while (get=ugetxc(&s))
    {
      poll_keyboard();  poll_joystick();
      if(BTFULLSCREEN) {
		set_fullscreen ();
                blit (bmp, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
	}

      if(BTSPACE) dejaespace=1;
      if(get=='['){
          char name[40];
          char value[40];
	  strcpy (name,"");
          strcpy (value,"");
          while ((get=ugetxc(&s)) && get != ':'){
		usprintf (m , "%c",get);
		ustrcat (name , m);
          }

          if(get){
          while((get=ugetxc(&s)) != ']'){
		 usprintf (m , "%c",get);
		 ustrcat (value , m);
         }
	 if(!strcmp(name,"delay") || !strcmp(name,"del")){
		if(!strcmp(value,"def") || !strcmp(value,"default")) bdelay=delay;
		else if(value[0]=='+' || value[0]=='-'||value[0]=='*'){
			char c = value[0];
			char *ss=value;
			int num = atoi(ss+1);
			if(c == '+') bdelay += num;
			else if(c == '-') bdelay -= num;
			else if(c == '*') bdelay *= num;
			
		}
		else {
			bdelay = atoi(value);
		}

         }
         else if(strcmp(name,"col")==0){
		if((strcmp(value,"default")==0)||!strcmp(value,"def")) {dc2 = c2;}
		else if(strcmp(value,"red")==0) {dc2 = makecol(255,80,0);}
 		else if(strcmp(value,"green")==0) {dc2 = makecol(80,255,0);}
                else if(strcmp(value,"black")==0) {dc2 = makecol(0,0,0);}
		else if(strcmp(value,"blue")==0) {dc2 = makecol(73,222,242);}
		else if(strcmp(value,"yellow")==0) {dc2 = makecol(255,255,40);}

		else {
			int r,g,b;
			char *a;
			a=strtok(value,",");
			if(a){
				r=atoi(a);
				a=strtok(NULL,",");
				if(a){
				g=atoi(a);
				a=strtok(NULL,",");
				if(a){
					b=atoi(a);
					dc2 = makecol(r,g,b);
				}
				}
			}
		}
         }
	 

         }
       goto no;
      }

      usprintf (m, "%c", get);
      alfont_textout_aa (bmp, f, m, x + i, y, dc1);
      if(nodouble==0) alfont_textout_aa (bmp, f, m, x + i - 1, y - 1, dc2);
 
      i += alfont_text_length(f,m);
    no:
;
//      s++;

      if(!dejaespace) { 
	      rest (bdelay);
      	      blit (bmp, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
      
              // il joue le mp3 si pas espace...
              #ifndef NO_MP3
              if(MP3_PLAYED) ret = poll_mp3_file (mp3);
              #endif
      }
    }
  if(dejaespace) {
      	  blit (bmp, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
	  return 1;
  }
  return 0;
}
/*********************** draw_parle *********************/
void draw_parle(BITMAP *bmp,int x,int y,int w,int h){
	BITMAP *bit = create_bitmap(w,h);
	set_trans_blender(0,0,0,128);

	clear_to_color (bit,monde() ? makecol(200,60,40) :  makecol(40,80,255));
	draw_trans_sprite(bmp,bit,x,y);
	rect (bmp , x , y , x+w,y+h , makecol(100,100,100));
	rect (bmp , x-1 , y-1 , x+w+1,y+h+1 , BLANC);
	if(bit) {destroy_bitmap(bit);bit=NULL;}
}

void draw_parle_anim 
(BITMAP *b,BITMAP *save,int x,int y,int w,int h,int max,int delay){
	
   int dx , dy , dw=0 , dh=0;
   int dwp,dhp,i;
   dwp = w / max;
   dhp = h / max;
   for(i = 0 ; i < max ; i++){  
	  dw +=  dwp;
	  dh +=  dhp;
	  dx = (w - dw) / 2;
	  dy = ((h - dh) / 2) + y;
	  blit(save,b,0,0,0,0,SCREEN_W,SCREEN_H);
	  draw_parle (b ,  dx,dy , dw ,dh);
	  blit (b,screen,0,0,0,0,SCREEN_W,SCREEN_H);
	  rest (delay);
  }

}
/*************************** parle *****************************/
int
parle (char *s, char *s2, char *s3, char *index)
{
  char c[256];
  int i;
  int x = 0  , y = SCREEN_H-100 ;
  int dejaespace=0;
  int save_obj=obj.cur;
  int save_epee = pp.jeter_epee;
  int save_obj_en = obj.en;
  BITMAP *save=0;

  pp.jeter_epee = 0;
  obj.cur =0;
  obj.en = 0;
  ep=0;
  
  save = create_bitmap(SCREEN_W,SCREEN_H);
  if(!save) return -1;
  BLIT ();
  blit(screen,save,0,0,0,0,SCREEN_W,SCREEN_H);
  draw_parle_anim (buffer2,save,x,y,SCREEN_W,100-5,20,10); 
  
  #ifndef NO_MP3
  MP3_PLAYED = 0;
  
  if (index)
    {
      sprintf (c, "patches/mp3/%s.mp3", index);
      if (exists (c) && SOUND_DETECTED == 0)
	{
	  mp3 = open_mp3_file (c);
	  if (mp3 )
	    {
	      MP3_PLAYED = 1;
	      if (play_mp3_file (mp3, BUFSZ, 255, 128) != ALMP3_OK)
		MP3_PLAYED = 0;
	    }
	  if (MP3_PLAYED)
	    set_volume (-1, 50);

	}
    }
  #endif
  {
  char *S[3] = {s,s2,s3}; 
  int i;
  //affiche le texte anime !
  for(i=0;i<3;i++) {
  if(textanim (buffer2,game_font, S[i], 4, (y+10)+i*(2+alfont_get_font_height(game_font)),0, BLANC, delay_textanim, dejaespace)==1){
	  //ferme le mp3
  	  #ifndef NO_MP3
	  if(MP3_PLAYED) {
	  	  MP3_PLAYED=0;
	          set_volume (-1, MIDI_VOLUME);
        	  close_mp3_file (mp3);
	  }
          #endif
	  //et indique que c espace pour les autres messages !
	  dejaespace=1;
  }
  } //endfor

  if(dejaespace) {
    while (!BTSPACE){ poll_keyboard (); poll_joystick(); if(BTFULLSCREEN) {set_fullscreen();  blit (buffer2, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);}
}
  }

  }
  #ifndef NO_MP3
  if(MP3_PLAYED && !dejaespace){
	  while (poll_mp3_file (mp3) == ALMP3_OK);
  }
  #endif
  //atends qu'il lache la touche espace...
  if(dejaespace) while(BTSPACE) {poll_keyboard();poll_joystick();}
  while (!BTSPACE){ 
poll_keyboard (); poll_joystick(); 
if(BTFULLSCREEN) {
	set_fullscreen();   blit (buffer2, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
}

}

  
  if(dejaespace){
	  while (BTSPACE){ poll_keyboard (); poll_joystick(); }
  }
  while (BTSPACE){ poll_keyboard (); poll_joystick(); }

  blit(save , screen , 0,0,0,0,SCREEN_W,SCREEN_H);
  

  #ifndef NO_MP3
  if (MP3_PLAYED)
    {
      close_mp3_file (mp3);
      set_volume (-1, MIDI_VOLUME);
      MP3_PLAYED = 0;
    }
  #endif

  if(save) {destroy_bitmap(save);save=0;}
/*  obj.en = save_obj_en;
  obj.cur = save_obj;
  pp.jeter_epee = save_epee;*/
}

/********************** INC *******************/
int
INC (int j, int w, int *x, int *y)
{
  switch (j)
    {
    case 0:
      break;
    case 1:
      *x = *x + w;
      break;
    case 2:
      *y = *y + w;

      break;
    case 3:
      *x = *x + w;
      *y = *y + w;
      break;
    }
}

/***************************** Explosion *************************/		
int
Explosion (BITMAP *sprite,int x, int y, int max)
{
  int e;
  BITMAP *save;
  save = create_bitmap(map_w,map_h);
  if(!save) return -1;
  blit(buffer , save,0,0,0,0,map_w,map_h);
  
  for (e = 0; e < max; e++)
    {
	  blit(save , buffer , 0,0,0,0,map_w,map_h);
         stretch_sprite (buffer, sprite, x, y, 20 + e, 20 + e);
         BLIT();
    }
	  blit(save , buffer , 0,0,0,0,map_w,map_h);

   if(save) {destroy_bitmap(save);save=0;}
}


/***************************** explosion *************************/		
int
explosion (int x, int y, int max)
{
	Explosion (Data[EXPL0].dat,x,y,max);
}

// fonction tres utile , j'ai fait avec le Boomerang

/************************** EQUATION_DROITE_X_TO_Y ****************/
int EQUATION_DROITE_X_TO_Y(int x,int xa,int ya,int xb,int yb){
		return  (((yb - ya) * x) - ((xa * yb) + (xb * ya))) / (xb - xa);
}

/************************ EQUATION_DROITE_Y_TO_X *****************/
int EQUATION_DROITE_Y_TO_X(int y,int xa,int ya,int xb,int yb){
		return  (((xa - xb) * y) - ((xa * yb) +( ya * xb))) / (ya - yb);
}

/************************ swapvar ***********************/
int swapvar(int *p1,int *p2){
		int s=*p2;
		*p2 = *p1;
		*p1 = s;
}

/************************* input ***************/
int input (const char *d1,const char *d2){
	int x=0,y=SCREEN_H-100;
	int col=BLANC;
	int a;
	ALFONT_FONT *f=game_font;
	BLIT();
	blit(screen,buffer2,0,0,0,0,SCREEN_W,SCREEN_H);
	draw_parle (buffer2 , x,y,SCREEN_W,100-5);
	if(d1) alfont_textout_aa (buffer2 , f , d1,x+35,y+2 , col);
	if(d2) alfont_textout_aa (buffer2 , f , d2,x+35,y+20, col);
	a= Choix(x-5,y+2,2,18,0);
	affiche (buffer);
	return a;
}

/************************ yesno ***************************/

int
yesno () {return input(lang(52),lang(53));}
int
noyes () {return input(lang(53),lang(52));}


/************************ coll *****************************/
int
coll (int x1,int y1,int w1,int h1,int x2,int y2,int w2,int h2){
	return (!( ((x1)>=(x2)+(w2)) || ((x2)>=(x1)+(w1)) || ((y1)>=(y2)+(h2)) || ((y2)>=(y1)+(h1)) ));
}

/************************ teleport **************************/
void teleport (int max,int t,int col,int delay){
	int i;
	BLIT_HERE (buffer2);
	for(i = 0 ; i < max ; i++){
		int x,y;
		x = rand () % SCREEN_W;y  = rand() % SCREEN_H;
		line (buffer2 , x , y  , x + t , y + t , col);
		blit (buffer2 , screen , 0,0,0,0,SCREEN_W,SCREEN_H);
		rest (delay);
	}
}

void Tih (BITMAP *buf ,BITMAP *bmp , int yp , int ymax , int c,int del,BITMAP *show){
  int y;	
  for(y = yp ; y <= ymax ; y++){
	  clear_to_color (buf,c);
	  if(show) {
		blit(show,buf,0,0,0,0,buf->w,buf->h);
	  }
	  draw_sprite (buf , bmp,(SCREEN_W-bmp->w)/2,y);
	  blit(buf,screen,0,0,0,0,SCREEN_W,SCREEN_H);
	  rest (del);
  }

}
char* select_name (BITMAP *b , char *t,int x,int y,int col,int type){
	char text[256] ,n=0;
	/* type */
	/* 0 : all */
	/* 1 : numeric */
	BITMAP *save;
	strcpy(text,"");
	if(t) {
		strcpy(text, t);
		n=strlen(t);
	}
	save=create_bitmap(SCREEN_W,SCREEN_H);
	blit(b,save,0,0,0,0,SCREEN_W,SCREEN_H);
		blit(save,b,0,0,0,0,SCREEN_W,SCREEN_H);
		alfont_textout (b,title_font,"|",x+((n+1)*alfont_text_length(title_font," ")),y,col);
		alfont_textout (b,title_font,text,x,y,col);
		
		blit(b,screen,0,0,0,0,SCREEN_W,SCREEN_H);

	
	while (!key[KEY_ENTER]){
		int c;
		if(keypressed()){
			c=readkey()&0xff;
			if(c == 8 && n>=1){
				text[n-1]=0;
				n--;
		blit(save,b,0,0,0,0,SCREEN_W,SCREEN_H);
		alfont_textout (b,title_font,"|",10+x+(n*alfont_text_length(title_font," ")),y,col);
		alfont_textout (b,title_font,text,x,y,col);
		
		blit(b,screen,0,0,0,0,SCREEN_W,SCREEN_H);

			}

			if((isalpha(c) && type==0) || (isdigit(c) && type==1)){
				text[n]=c;
				text[n+1]=0;
				n++;
		blit(save,b,0,0,0,0,SCREEN_W,SCREEN_H);
		alfont_textout (b,title_font,"|",x+(n*alfont_text_length(title_font," ")),y,col);
		alfont_textout (b,title_font,text,x,y,col);
		
		blit(b,screen,0,0,0,0,SCREEN_W,SCREEN_H);

			}
		}
	}
	destroy_bitmap(save);
	return strdup(text);
}
int now=0;
void frapper_perso (int num){
int k;
int x,y,dir;
if(now) return;
now = 1;
dir=notdir(pp.dir);
x=pp.x;
y=pp.y;
counter_anim=0;
pp.dir = dir;

while (1){
     ANIMATION();
    {
     pp.dir = dir;
     if(!hbs ()) {pp.dir = notdir(dir);goto end;}
     pp.dir = notdir (dir);
    }

     switch(dir){
	 case 0 : if(pp.x >= x+23) goto end;break;
	 case 1 : if(pp.x <= x-23) goto end;break;
	 case 2 : if(pp.y <= y-23) goto end;break;
	 case 3 : if(pp.y >= y+23) goto end;break;

     }    
// 	 if(key[KEY_SPACE]) goto end;
     if(counter_anim >= ANIM_DELAY){
	     marcher (dir);
	     pp.anim[dir]++;
	     counter_anim = 0;
	     if(pp.anim[dir] >= 3){
		     pp.anim[dir]=0;
	     }
	     
     }
     affiche (buffer);
     BLIT ();
}
end:
pp.hp-=num;
if(pp.hp<0) {
	pp.hp=0;
}
now = 0;
}

void my_textout (BITMAP *b , ALFONT_FONT *f , const char *s , int x,int y, int c1,int c2){	
	alfont_textout_aa(b,f,s,x,y,c1);
	alfont_textout_aa(b,f,s,x-1,y-1,c2);

}
void pres_text (char *text){ 
	  ALFONT_FONT *f = pres_font;
	
	  int w = alfont_text_length(f,text);
	  int h = alfont_text_height(f);
	 blit (Data[BACK2].dat  , buffer2,0,0,0,0,SCREEN_W,SCREEN_H);

	  textanim (buffer2 , f , text , 5 , (SCREEN_H-h)/2 , 0 ,BLANC,delay_textanim,0);
	 blit(buffer2,screen,0,0,0,0,SCREEN_W,SCREEN_H);
	  while (BTSPACE) {poll_keyboard ();poll_joystick();}
	  counter=0;
	  while (!BTSPACE) {if(counter>=3000) break;poll_keyboard ();poll_joystick(); if(BTFULLSCREEN) set_fullscreen();}
}

