/*************************** Lgc ************************/
// FILE : script.c
/*******************************************************/

#include "internal.h"



//set_script_cmd
void
set_script_cmd (SCRIPT_COMMAND * cmd, int genre)
{
  cmd->genre = genre;
}


//script_cmd_PARLE_set
void
script_cmd_PARLE_set (SCRIPT_COMMAND * cmd, void *callback, const char *s1,
		      const char *s2, const char *s3, const char *s4)
{
  cmd->p1 = s1;
  cmd->p2 = s2;
  cmd->p3 = s3;
  cmd->p4 = s4;
  cmd->callback = callback;
}

//script_cmd_MARCHER_set
void
script_cmd_MARCHER_set (SCRIPT_COMMAND * cmd, int obs_index, int fois,
			int dir, int delay_zid, volatile int *counter)
{
  cmd->dir = dir;
  cmd->counter = counter;
  cmd->fois = fois;
  cmd->obs_index = obs_index;
  cmd->delay_zid = delay_zid;
}

//script_cmd_execute
void
script_cmd_execute (SCRIPT_COMMAND * cmd)
{

  switch (cmd->genre)
    {
    case SCRIPT_CMD_MARCHER:
      if (!(*(cmd->counter) >= cmd->delay_zid) && cmd->with_rest == 0)
	break;
      if (cmd->with_rest == 0)
	*(cmd->counter) = 0;
      cmd->obs_index =
	map_obs_marcher (&Map, 0, 1, cmd->obs_index, cmd->dir, cmd->fois);
      load_screen_persos ();
      if (cmd->with_rest)
	rest (cmd->delay_zid);
      break;
    case SCRIPT_CMD_PARLER:
      {
	void (*func) (const char *, const char *, const char *, const char *);
	func = cmd->callback;
	(*func) (cmd->p1, cmd->p2, cmd->p3, cmd->p4);
      }
      break;
    }
}

//script_cmd_size
int
script_cmd_size (SCRIPT_COMMAND * cmd)
{
  int ret = 0;
  switch (cmd->genre)
    {
    case SCRIPT_CMD_MARCHER:
      ret = cmd->fois;
      break;
    }
  return ret;
}


//execute_script
void
execute_script (SCRIPT_COMMAND * script)
{
  SCRIPT_COMMAND *s = script;
  while (s->genre != -1)
    {
      script_cmd_execute (s);
      affiche (buffer);
      BLIT ();
      s++;
    }
}

//script_size
int
script_size (SCRIPT_COMMAND * script)
{
  SCRIPT_COMMAND *s = script;
  int sz = 0;
  while (s->genre != -1)
    {
      sz += script_cmd_size (s);
      s++;
    }
  return sz;

}
