/*************************** Lgc ************************/
// FILE : save.c
/*******************************************************/

#include "internal.h"


#define S_INT_VAR(var) save_add_var(&thedata,var,sizeof(int),&max_save)
#define S_INT_TABLE_VAR(var,size) save_add_var(&thedata,var,sizeof(int)*(size+1),&max_save)
#define S_VAR(var,size) save_add_var(&thedata,var,size,&max_save)
#define SAVE_PACKED "p"


SAVE_DATA *thedata=0;
int max_save=0;
int *my=0;

/////////////////////////// save_add_var ////////////////////////////
void
save_add_var(SAVE_DATA **data , void *ptr,size_t size,int *max){
		int i=0;
		SAVE_DATA *d;
		*(data) = (SAVE_DATA*)realloc(*data ,  sizeof(SAVE_DATA) * ((*max) + 2));
		d=(*data)+(*max);
		d->ptr = ptr;
		d->size = size;
		(d+1)->ptr=0;
		(*max)++;
		
}

/////////////////////////// save_init /////////////////////////
void save_init(void){
		int i,e;
		thedata = (SAVE_DATA*)malloc(sizeof(SAVE_DATA));
		thedata->ptr=0;
		S_INT_TABLE_VAR(pp.item,2);
		S_INT_VAR(&Map.prog);  /* progression du jeu     */
		S_INT_VAR(&n_crystal); /* nombre de crystals     */          
		S_INT_VAR(&pp.max_items); /* maximum d'objets    */
		S_INT_TABLE_VAR(pp.item,2); /* items choisis */
		S_INT_VAR(&max_changed_obs); /* max changer obstacle*/
		S_INT_VAR(&pp.arg); /* nombre d'argents */
		S_INT_VAR(&pp.hp);     /* nombre de coeurs */
		S_INT_VAR(&pp.hpmax);  /* maximum de coeurs */
		S_INT_VAR(&pp.clef);   /* les clefs */
		S_INT_VAR(&pp.cleboss); /* cle du boss */
		S_INT_VAR(&pp.pvfrappe); /* pouvoir de frappe */
		S_VAR(&dern,sizeof(DERN));
		S_INT_VAR(&force_midi);  /* forcer un midi ?*/
		S_INT_VAR(&force_midi_stage); /* forcer un stage ?*/
		S_INT_VAR(&cle_prog); /* progression des cles des donjons*/
		S_INT_VAR(&max_troc);
		S_INT_VAR(&PPSURF);
		S_INT_VAR(&teleport_x);
		S_INT_VAR(&teleport_y);
		S_INT_VAR(&teleport_stage);

}


/////////////////////// save_close ////////////////////////
void save_close(void){
		int i;
		for(i = 0 ; i < max_save ; i++){
			if(thedata[i].ptr) thedata[i].ptr=0;
		}
		free (thedata);
		thedata = 0;
		
}

///////////////////////// save_data ////////////////////////
int
save_data(SAVE_DATA *data,PACKFILE *file){
		SAVE_DATA *d=data;
		int *TROC = get_troc();
		int i,n;
		char *s=get_cur_save();
		while(d->ptr){
				pack_fwrite(d->ptr ,  d->size , file);
				d++;
		}
		pack_fwrite ((void*)&game_counter , sizeof(volatile long), file);
		pack_fwrite((void*)pp.items , sizeof(int) * (pp.max_items + 1) , file);
		if(changed_obs) pack_fwrite(changed_obs,sizeof(CHANGED_OBS) * (max_changed_obs+1),file);
		pack_fwrite (TROC , sizeof(int) * (max_troc) , file);
		n=strlen(get_cur_save());
		pack_fwrite (&n , sizeof(int)  , file);
		pack_fwrite (get_cur_save() , n , file);
}
void set_it (int n,int a,int b){
	items[n].images[0]=a;
	items[n].images[1]=b;
	items[n].name = NULL;
	items[n].info = NULL;
}
void set_pp_epee () {
	if(pp.pvfrappe == 1)  set_it (I_EPEE, EPEE00, EPEE01);
	if(pp.pvfrappe == 2)  set_it (I_EPEE, EPEE10, EPEE11);
	if(pp.pvfrappe == 3)  set_it (I_EPEE, EPEE20, EPEE21);
 
}

//////////////////////////// load_data ////////////////////////
int
load_data(SAVE_DATA *data,PACKFILE *file){
		int i;
		SAVE_DATA *d=data;
		int *TROC = get_troc();
		while(d->ptr && !pack_feof(file)){
				pack_fread(d->ptr , d->size , file);
				d++;
		}
		pack_fread ((void*)&game_counter , sizeof(volatile long), file);
		pack_fread(pp.items , sizeof(int) * (pp.max_items + 1) , file);
		if(!pack_feof(file)){
			int n;
			char *a;
			changed_obs = (CHANGED_OBS*)realloc(changed_obs , sizeof(CHANGED_OBS) * (max_changed_obs  + 1));
			pack_fread(changed_obs , sizeof(CHANGED_OBS) * (max_changed_obs + 1),file);
			for(i = 0 ; i < max_changed_obs ; i++){
					Map.obs[changed_obs[i].layer][(changed_obs[i].st *Map.w * Map.h) + changed_obs[i].pos ] = changed_obs[i].val;
			}
			pack_fread (TROC , sizeof(int) * (max_troc) , file);
			pack_fread (&n , sizeof(int) ,file);
			pack_fread (get_cur_save(),n,file);

			a = get_cur_save();

			if(n<250) a[n]=0;


		}
		{
		}
		pp.x = dern.x;
		pp.y = dern.y;
		Map.stage = dern.stage;
		pp.dir = dern.dir;
		Map.hqst = -1;
		set_pp_epee();
		if(force_midi != -1 && Map.stage != force_midi_stage) playmidi(force_midi);
		pp.hp=pp.hpmax;
}

// save_data_filename
int
save_data_filename(SAVE_DATA *data,char *filename){
		PACKFILE *f=pack_fopen(filename,"w"SAVE_PACKED);
		if(f){
		save_data(data , f);
		pack_fclose(f);
		}
}

// load_data_filename
int
load_data_filename(SAVE_DATA *data,char *filename){

		PACKFILE *f=pack_fopen(filename,"r"SAVE_PACKED);
		if(f){
		load_data(data , f);
		pack_fclose(f);
		}
}
//save_game
void save_game(char *filename) {save_data_filename(thedata , filename);}
//load_game
void load_game(char *filename) {load_data_filename(thedata , filename);}
