/*************************** Lgc ************************/
// FILE : monster.c
/*******************************************************/

#include "internal.h"
#include "pmask.h"
//////////////// variables //////////////
int mons_im[20][3];
int nofrappe = 0;

/********************* is_monster ******************/
int
is_monster (int obs)
{
  switch (obs)
    {
    case 11:
      return 1;
    case 65:
      return 2;
    case 71:
      return 3;
    case 73:
      return 4;
    case 80:
      return 5;
    case 82:
      return 6;
	case 88 : return 7;
	case 89 : return 8;
	case 91 : return 9;
	case 98 : return 10;
	case 106 : return 11;
        case 125 : return 12;	
	case 129 : return 13;	 
        case 133 : return 14;		   
	case 137 : return 15;
	case 147 : return 16;
    }
 return 0;
}

/******************************** chose *******************/
int
chose (void)
{
  int s;
  srand(time(0));
  s= rand () % 10;
  if (s >= 0 && s <= 5)
    return 25;
  if (s >= 6)
    return 69;
}

/********************** accord_monster ******************/
int
accord_monster (int i, int genre)
{
  if (genre == MONSTRE_FRAPPE_PERSO)
    return monsters[i].accord.frappe;
  else if (genre == PERSO_FRAPPE_MONSTRE)
    return monsters[i].accord.rfrappe;
}

/****************************** set_monster *******************/
int
set_monster (int n, int v)
{
  int i;
  monsters[n].genre2 = NORMAL_MONSTER;
  monsters[n].w = ((BITMAP *) Data[mons_im[monsters[n].genre][0]].dat)->w;
  monsters[n].h = ((BITMAP *) Data[mons_im[monsters[n].genre][0]].dat)->h;

  switch (v)
    {
	case 16 : /*AZZI : 2 */
	if(!facilite) monsters[n].accord.rfrappe=0;
	else monsters[n].accord.rfrappe = 1;
	if(facilite) monsters[n].accord.frappe=0;
	monsters[n].ia.is_frappe=0;
	if(!facilite) monsters[n].hp=-1;
	else monsters[n].hp = 20;

	if(!facilite) monsters[n].vit=15;
	else monsters[n].vit=10;

	if(!facilite) monsters[n].frvit=10;
	else monsters[n].frvit=8;

	monsters[n].genre2 = BOSS_MONSTER;
	monsters[n].dir = 0;
	
	monsters[n].maxfrappe = 3;
       	  for (i = 0; i < monsters[n].maxfrappe; i++){
	      monsters[n].frappe[i].frappe = 0;
	      monsters[n].frappe[i].frappeim = BOUT0;
	 }

	break;
	case 15: /* BOSS 4*/
		monsters[n].hp=50;
		monsters[n].vit=15;
		monsters[n].frvit = 10;
		monsters[n].genre2 = BOSS_MONSTER;
		monsters[n].dir = 0;
		monsters[n].maxfrappe=8;
		monsters[n].ia.fois=0;
		monsters[n].ia.avantdir = 2;
	  for (i = 0; i < monsters[n].maxfrappe; i++){
	      monsters[n].frappe[i].frappe = 0;
	      monsters[n].frappe[i].frappeim = BOUT0;
	 }

	break;

        case 12:
		monsters[n].hp=20;
		monsters[n].vit=5;
		monsters[n].dir=0;
		monsters[n].frappe[0].frappe=0;
		monsters[n].ia.mode=0;
		monsters[n].accord.rfrappe=0;
		monsters[n].maxfrappe=3;
		monsters[n].accord.frappe=0;
		monsters[n].frvit = 10;
		monsters[n].show=0;
		monsters[n].x=0;
		monsters[n].y=0;

	  for (i = 0; i < monsters[n].maxfrappe; i++){
	      monsters[n].frappe[i].frappe = 0;
	      monsters[n].frappe[i].frappeim = BOUT4;
	 }

        break;
        case 11: /* boss poisson , BOSS3 */
		monsters[n].vit = 30;
		monsters[n].hp  = 20;
		monsters[n].genre2 = BOSS_MONSTER;
		monsters[n].ia.mode = 0;
		monsters[n].ia.im1 = BOSS22;
		monsters[n].dir = 0;
		monsters[n].ia.avantdir = 1;
		monsters[n].ia.fois=0;
		monsters[n].ia.lock = 0;
 	break;
	case 13: /* boss Oeuil , BOSS4 */
	
		monsters[n].vit = 30;
		monsters[n].ia.pouss = 0;

		monsters[n].ia.vit = 3;
		monsters[n].hp  = 20;
		monsters[n].genre2 = BOSS_MONSTER;
		monsters[n].dir = 0;
		monsters[n].accord.rfrappe=0;
		monsters[n].accord.frappe=1;
		monsters[n].ia.mode=0;
 	break;

	case 10:
	      monsters[n].vit = 5;
	      monsters[n].hp = 3;
      	      monsters[n].hpmax = 3;
	      monsters[n].ia.fois=monsters[n].vit;
	      monsters[n].ia.mode = 10;
	break;
	/////////////////////////////////////////////////
	case 8 : /* AZZI 1 */
	 monsters[n].vit = 10;
	 monsters[n].frvit = 2;
	 monsters[n].hp = monsters[n].hpmax = 10;
	 monsters[n].genre2 = BOSS_MONSTER;
	 monsters[n].maxfrappe = 1;
	 monsters[n].ia.fois=0;
	 monsters[n].ia.mode=0;
	 monsters[n].frappe[0].frappe = 0;
	 monsters[n].frappe[0].frappeim = EXPL0;
	break;

    //////////////////////////////////////////////////
    case 1:
      monsters[n].vit = 3;
      monsters[n].hp = 3;
      monsters[n].hpmax = 3;
      break;
    ////////////////////////////////////////////////
    case 14: /* monstre gele */ 
      monsters[n].vit = 8;
      monsters[n].frvit = 15;
      monsters[n].hp = 5;
      monsters[n].hpmax = 5;
      monsters[n].dir = 0;
      monsters[n].maxfrappe = 1;
      monsters[n].que_grappin = 1 ;
     monsters[n].frappe[0].frappeim = BOUT4;
      monsters[n].frappe[0].frappe = 0;
      break;
     //////////////////////////////////////////////////////

    ////////////////////////////////////////////////
    case 2:
      monsters[n].vit = 3;
      monsters[n].frvit = 3;
      monsters[n].hp = 1;
      monsters[n].hpmax = 5;
      monsters[n].dir = 0;
      monsters[n].maxfrappe = 1;
	  monsters[n].frappe[0].frappeim = FR0;
      monsters[n].frappe[0].frappe = 0;
      break;
     //////////////////////////////////////////////////////
    case 6:
      monsters[n].vit = 10;
      monsters[n].frvit = 8;
      monsters[n].hp = 3;
      monsters[n].hpmax = 3;
      monsters[n].dir = 0;
      monsters[n].maxfrappe = 1;
      monsters[n].frappe[0].frappe = 0;
	 monsters[n].frappe[0].frappeim = BOUT1;

      break;
     ////////////////////////////////////////////////////////
    case 3:
      monsters[n].vit = 10;
      monsters[n].hp = -1;
      monsters[n].hpmax = -1;
      monsters[n].ia.avantdir = 2;
      monsters[n].dir = 0;
      break;
	  ///////////////////////////////////////////////////////
    case 4:			//BOSS1
      monsters[n].vit = 10;
      monsters[n].frvit = 10;
      monsters[n].ia.fois = 0;
      monsters[n].hp = 6;
      monsters[n].hpmax = 6;
      monsters[n].ia.fois=0;
      monsters[n].genre2 = BOSS_MONSTER;
      monsters[n].ia.is_frappe = 0;
      monsters[n].ia.mode = 0;
      monsters[n].maxfrappe = 8;
      monsters[n].accord.frappe=1;
      monsters[n].accord.rfrappe=0;

      
      
	  for (i = 0; i < monsters[n].maxfrappe; i++){
	      monsters[n].frappe[i].frappe = 0;
	      monsters[n].frappe[i].frappeim = BOUT0;
	 }
	  
	  break;
	  ///////////////////////////////////////////////////////
    case 7:			//BOSS2
      monsters[n].vit = 10;
      monsters[n].frvit = 13;
      monsters[n].ia.fois = 0;
      monsters[n].dir = 0;
      monsters[n].hp = 40;
      monsters[n].genre2 = BOSS_MONSTER;
      monsters[n].ia.is_frappe = 0;
      monsters[n].ia.mode = 0;
      monsters[n].maxfrappe = 8;
     for (i = 0; i < monsters[n].maxfrappe; i++){
			monsters[n].frappe[i].frappe = 0;
		        monsters[n].frappe[i].frappeim = MUR00 ;
		}
	 break;
	 //////////////////////////////////////////////////////
   case 5:
      monsters[n].vit = 5;
      monsters[n].frvit = 10;
      monsters[n].hp = 3;
      monsters[n].hpmax = 3;
      monsters[n].dir = 0;
      monsters[n].maxfrappe = 2;
      monsters[n].frappe[0].frappe = -1;
      monsters[n].frappe[1].frappe = -1;
      monsters[n].frappe[0].frappeim =   monsters[n].frappe[1].frappeim = BOUT2;


      break;
      ////////////////////////////////////////////////////////
      case 9:
      monsters[n].vit = 5;
      monsters[n].frvit = 5;
      monsters[n].hp = 3;
      monsters[n].hpmax = 3;
      monsters[n].dir = 0;
      monsters[n].maxfrappe = 1;
      monsters[n].frappe[0].frappeim = BOUT1;
      break;
    }
}


/**************************** load_screen_monsters ******************/
int
load_screen_monsters (void)
{
  int xp, yp, i = 0, a;
  max_monsters = 0;
  
  for (yp = 0; yp < map_h - 1; yp += 20)
    {
      for (xp = 0; xp < map_w - 1; xp += 20)
	{
			
	  a = is_monster (Map.show[0][i]);
	  if (a)
	    {
	      monsters[max_monsters].vraiOBS=i;
	      monsters[max_monsters].accord.frappe = 1;
	      monsters[max_monsters].accord.rfrappe = 1;
	      monsters[max_monsters].x = xp;
	      monsters[max_monsters].y = yp;
	      monsters[max_monsters].que_grappin = 0;
	      monsters[max_monsters].maxfrappe = 0;
	      monsters[max_monsters].images = mons_im[a];
	      monsters[max_monsters].en = 1;
	      monsters[max_monsters].dir = rand () % 4;
	      monsters[max_monsters].ep = 0;
	      monsters[max_monsters].genre = a;
	      monsters[max_monsters].frvit = 1;
	      monsters[max_monsters].ia.pouss = 1;
	      monsters[max_monsters].show=1;
	      set_monster (max_monsters, a);
	      Map.show[0][i] = Map.show[1][i];
	      max_monsters++;
	    }
	  i++;
	}
    }
}

/********************************** monster_hbs ***********************/
int
monster_hbs (int n)
{
  int d = monsters[n].dir, d1x, d1y, d2x, d2y, c, vit = monsters[n].vit, x =
    monsters[n].x, y = monsters[n].y;
  if (d == 0)
    {
      d1x = ((x) / 20) + 1;
      d1y = (y + vit) / 20;
      d2x = ((x) / 20) + 1;
      d2y = ((y - vit) / 20) + 1;
    }
  if (d == 1)
    {
      d1x = ((x) / 20);
      d1y = (y + vit) / 20;
      d2x = ((x) / 20);
      d2y = ((y - vit) / 20) + 1;
    }
  if (d == 2)
    {
      d1x = ((x + vit) / 20);
      d1y = ((y) / 20);
      d2x = ((x - vit) / 20) + 1;
      d2y = ((y) / 20);
    }
  if (d == 3)
    {
      d1x = ((x + vit) / 20);
      d1y = ((y) / 20) + 1;
      d2x = ((x - vit) / 20) + 1;
      d2y = ((y) / 20) + 1;
    }
  monsters[n].pc1x = d1x;
  monsters[n].pc1y = d1y;
  monsters[n].pc2x = d2x;
  monsters[n].pc2y = d2y;

  c = Map.hbst[Map.show[0][d1x + d1y * 16]];
  c &= Map.hbst[Map.show[0][d2x + d2y * 16]];
  return c;

}



/*************************************** HBS ***************************/
int
HBS (int x, int y, int vit, int d, int *pc1x, int *pc1y, int *pc2x, int *pc2y)
{
  int d1x, d1y, d2x, d2y, c;
  if (d == 0)
    {
      d1x = ((x) / 20) + 1;
      d1y = (y + vit) / 20;
      d2x = ((x) / 20) + 1;
      d2y = ((y - vit) / 20) + 1;
    }
  if (d == 1)
    {
      d1x = ((x) / 20);
      d1y = (y + vit) / 20;
      d2x = ((x) / 20);
      d2y = ((y - vit) / 20) + 1;
    }
  if (d == 2)
    {
      d1x = ((x + vit) / 20);
      d1y = ((y) / 20);
      d2x = ((x - vit) / 20) + 1;
      d2y = ((y) / 20);
    }
  if (d == 3)
    {
      d1x = ((x + vit) / 20);
      d1y = ((y) / 20) + 1;
      d2x = ((x - vit) / 20) + 1;
      d2y = ((y) / 20) + 1;
    }

  if (pc1x)
    *pc1x = d1x;
  if (pc1y)
    *pc1y = d1y;
  if (pc2x)
    *pc2x = d2x;
  if (pc2y)
    *pc2y = d2y;


  return c;

}



/*********************************** zid_normal ********************/
int
zid_normal (int i)
{
  if (monsters[i].dir == 0
      && monsters[i].x + monsters[i].vit <= map_w - 30)
    monsters[i].x += monsters[i].vit;
  if (monsters[i].dir == 1 && monsters[i].x - monsters[i].vit >= 20)
    monsters[i].x -= monsters[i].vit;
  if (monsters[i].dir == 2 && monsters[i].y - monsters[i].vit >= 20)
    monsters[i].y -= monsters[i].vit;
  if (monsters[i].dir == 3
      && monsters[i].y + monsters[i].vit <= map_h - 30)
    monsters[i].y += monsters[i].vit;
}

/*********************************** notdir *********************/
int
notdir (int d)
{
  switch (d)
    {
    case 0:
      return 1;
    case 1:
      return 0;
    case 2:
      return 3;
    case 3:
      return 2;
    }
  return -1;
}

/*********************************** notdir2 *********************/
int
notdir2 (int d)
{
  switch (d)
    {
    case 0:
      return 3;
    case 1:
      return 2;
    case 2:
      return 1;
    case 3:
      return 0;
    }
  return -1;
}


/******************************** zid_normal_frappe ******************/
int
zid_normal_frappe (int i, int num)
{

  if (monsters[i].frappe[num].frapped == 0)
    monsters[i].frappe[num].frappex += monsters[i].frvit;
  if (monsters[i].frappe[num].frapped == 1)
    monsters[i].frappe[num].frappex -= monsters[i].frvit;
  if (monsters[i].frappe[num].frapped == 2)
    monsters[i].frappe[num].frappey -= monsters[i].frvit;
  if (monsters[i].frappe[num].frapped == 3)
    monsters[i].frappe[num].frappey += monsters[i].frvit;

  if (monsters[i].frappe[num].frappex >= map_w
      || monsters[i].frappe[num].frappex <= 0
      || monsters[i].frappe[num].frappey <= 0
      || monsters[i].frappe[num].frappey >= map_h)
    monsters[i].frappe[num].frappe = 0;

}


/******************************* zid_monster *******************/
int
zid_monster (int i)
{
  int r, f, dr, e;
  int K,n;
  ///////////////////////////////////////////////////////////
  if (monsters[i].genre == 2 || monsters[i].genre == 6)
    {

      if (!monsters[i].frappe[0].frappe){
	ll:

	  r = monster_hbs (i);
	  if (!r){
	      monsters[i].dir = rand () % 4;
	      goto ll;
          }

	  if ((monsters[i].pc1y == pp.pc1y || monsters[i].pc2y == pp.pc2y
	       || monsters[i].pc1x == pp.pc1x || monsters[i].pc2x == pp.pc2x)
	      && !monsters[i].frappe[0].frappe){
	      monsters[i].frappe[0].frappe = 1;
	      monsters[i].frappe[0].frappex = monsters[i].x;
	      monsters[i].frappe[0].frappey = monsters[i].y;
	      if ((monsters[i].pc1y == pp.pc1y || monsters[i].pc2y == pp.pc2y)
		  && pp.x > monsters[i].x)
		monsters[i].frappe[0].frapped = 0;
	      else
		if ((monsters[i].pc1y == pp.pc1y
		     || monsters[i].pc2y == pp.pc2y) && pp.x < monsters[i].x)
		monsters[i].frappe[0].frapped = 1;
	      else
		if ((monsters[i].pc1x == pp.pc1x
		     || monsters[i].pc2x == pp.pc2x) && pp.y < monsters[i].y)
		monsters[i].frappe[0].frapped = 2;
	      else
		if ((monsters[i].pc1x == pp.pc1x
		     || monsters[i].pc2x == pp.pc2x) && pp.y > monsters[i].y)
		monsters[i].frappe[0].frapped = 3;

	    }

	}

      if (monsters[i].frappe[0].frappe)
	  zid_normal_frappe (i, 0);
      

      if (!monsters[i].frappe[0].frappe)
	zid_normal (i);
   
    }

  switch (monsters[i].genre)
    {
   case 16 : /* AZZI 2 */
  if(monsters[i].x >= map_w-40) monsters[i].dir = 1;
  if(monsters[i].x <= 40) monsters[i].dir = 0;
   zid_normal (i);

if(!monsters[i].ia.is_frappe){
  int D=facilite ? 50 : 30;
  monsters[i].ia.is_frappe = 1;
  monsters[i].frappe[0].frappe = 1;
  monsters[i].frappe[1].frappe = 1;
  monsters[i].frappe[2].frappe = 1;


  monsters[i].frappe[0].frappex = monsters[i].x;
  monsters[i].frappe[0].frappey = monsters[i].y;
  monsters[i].frappe[0].frapped = 3;

  monsters[i].frappe[1].frappex = pp.x-D;
  monsters[i].frappe[1].frappey = pp.y;
  monsters[i].frappe[1].frapped = 0;

  monsters[i].frappe[2].frappex = pp.x+D;
  monsters[i].frappe[2].frappey = pp.y;
  monsters[i].frappe[2].frapped = 1;


}
else {
int d=0;
int nd;
for(n = 0 ; n < monsters[i].maxfrappe ; n++){
	if(monsters[i].frappe[n].frappe ==0 ){
		d++;
	}
}

if(d==monsters[i].maxfrappe){
 monsters[i].ia.is_frappe=0;
}
else{
zid_normal_frappe (i,0);
zid_normal_frappe (i,1);
zid_normal_frappe (i,2);
}
}

  
   break;

   case 15: /* BOSS 5*/
   zid_normal (i);
   if(monsters[i].x >= map_w-100 || monsters[i].x<=30) {
     
     play_sfx (SFX21);
	monsters[i].ia.fois++;
	if(monsters[i].ia.fois == 2){
		int d;
		monsters[i].ia.fois = 0;
		if(monsters[i].y<=0) monsters[i].ia.avantdir = 3; 
		if(monsters[i].y>=map_w-50) monsters[i].ia.avantdir = 2; 
		d  = monsters[i].dir;
		monsters[i].dir = monsters[i].ia.avantdir;
		zid_normal(i);	
		monsters[i].dir = d;

	}
	monsters[i].dir = notdir(monsters[i].dir);

	set_mons_im (15 ,monsters[i].dir?BOSS42:BOSS4 , monsters[i].dir?BOSS42:BOSS4);
	{
	for(n=0; n < monsters[i].maxfrappe ; n++){
		monsters[i].frappe[n].frappe = 1;
		monsters[i].frappe[n].frapped = rand()%4;
		monsters[i].frappe[n].frappex = rand()%map_w;
		monsters[i].frappe[n].frappey = rand()%map_h;
	}
	}
   }
{
int n;
for(n=0; n < monsters[i].maxfrappe ; n++){
	if(monsters[i].frappe[n].frappe) zid_normal_frappe (i,n);
}
}
	
   break;
   case 14 : /* monstre gele */
ls:
   monsters[i].dir = rand() % 4;
   r = monster_hbs(i);
   if(!r){
	   goto ls;
   }
   zid_normal (i);
   if(!monsters[i].frappe[0].frappe){
	   monsters[i].frappe[0].frappe = 1;
	   monsters[i].frappe[0].frapped = monsters[i].dir;
	   monsters[i].frappe[0].frappex = monsters[i].x;
	   monsters[i].frappe[0].frappey = monsters[i].y;
   }
   else   zid_normal_frappe (i,0);

   
   break;
   
   case 13 : /* BOSS 4 : oueil */
   if(monsters[i].ia.mode == 0){
	   int a=Map.show[1][4+3*16];
	   if( (monsters[i].x >= map_w-monsters[i].w || monsters[i].x <= monsters[i].w)){
		   int a;
		   monsters[i].dir = notdir (monsters[i].dir);
		   a = monsters[i].dir;
		   monsters[i].vit += 20;
		   monsters [i].dir = monsters[i].ia.vit;
		   zid_normal (i);
		   monsters[i].dir = a;
		   monsters[i].vit -= 20;
		   if( monsters[i].y >= map_h-monsters[i].y || monsters[i].y <= monsters[i].h){
			   monsters[i].ia.vit = notdir (monsters[i].ia.vit);	
		   }

	   }
	   zid_normal (i);
	   if(Map.show[0][4+3*16] == a && Map.show[0][12+3*16] == a && 
	      Map.show[0][8+5*16] == a){
		   monsters[i].ia.pouss = monsters[i].hp;
		   monsters[i].ia.mode = 1;
		   monsters[i].accord.rfrappe = 1;
	   }
   }
   if(monsters[i].ia.mode == 1){
	   if(monsters[i].ia.pouss  - monsters[i].hp >= 5) {
		   monsters[i].ia.mode=0;
		   monsters[i].accord.rfrappe = 0;
		   Map.show  [0][4+3*16] = 130; 
		   Map.show  [0][12+3*16] = 130; 
		   Map.show  [0][8+5*16] = 130; 

	   }
   }
   
   break;
   case 12: /* fantome */
	   if(monsters[i].ia.mode == 0){
		   monsters[i].ia.fois ++;
		   if(monsters[i].ia.fois >= 30){
			   monsters[i].show=1;
			   monsters[i].ia.fois=0;
			   monsters[i].ia.mode=1;
			   monsters[i].x = pp.x;
			   monsters[i].y = (rand() % pp.y);
	 	           monsters[i].accord.frappe=1;

			   
			  for (n = 0; n < monsters[i].maxfrappe; n++){
		            monsters[i].frappe[n].frappe = 1;
			    monsters[i].frappe[n].frapped=3;
			    monsters[i].frappe[n].frappex=monsters[i].x;
			    monsters[i].frappe[n].frappey=monsters[i].y;

			  }
		   }
	   }
	   else if(monsters[i].ia.mode == 1){
		   int a=0,b=0,c=0;
		   if(monsters[i].frappe [0].frappe){
		   a=1;
		   monsters[i].frappe [0].frapped=1;
		   zid_normal_frappe(i,0);
		   monsters[i].frappe [0].frapped=3;
		   zid_normal_frappe(i,0);
		   }
		   
		   if(monsters[i].frappe [2].frappe){
			   b=1;
		   monsters[i].frappe [2].frapped=0;
		   zid_normal_frappe(i,2);
		   monsters[i].frappe [2].frapped=3;
		   zid_normal_frappe(i,2);
		   }
		   
		   if(monsters[i].frappe [1].frappe) {zid_normal_frappe(i,1);c=1;}
		   if(a==0 && b==0 && c==0) {
			   monsters[i].ia.fois ++;
			   if(monsters[i].ia.fois >= 10){
			   monsters[i].ia.mode=0;
			   monsters[i].show=0;
	 	           monsters[i].accord.frappe=0;
			   monsters[i].ia.fois=0;
		
			   }
		   }
			
		   

	   }
   break;
    case 11 : /* BOSS 3*/
   if(monsters[i].ia.lock) break;	  
   if(monsters[i].ia.mode == 0){ 	   
	   if((monsters[i].x >= map_w-50 && monsters[i].dir == 0)||(monsters[i].x <= 20 && monsters[i].dir == 1)) {monsters[i].y += monsters[i].ia.avantdir * monsters[i].vit;monsters[i].dir = notdir(monsters[i].dir);}
	   if((monsters[i].y >= map_h-30) || monsters[i].y <= 0) {monsters[i].ia.avantdir=-(monsters[i].ia.avantdir);monsters[i].ia.fois++;}
	   if(monsters[i].ia.fois >= 30) {
	 	  int  t=monsters[i].ia.im1, dy = monsters[i].y;
		   monsters[i].ia.vit = monsters[i].vit;
		   monsters[i].vit = 4;
		   monsters[i].ia.mode=2;
		   monsters[i].ia.fois = 0;
		   monsters[i].ia.mode = 1;
		   monsters[i].accord.frappe = 0;
		   monsters[i].accord.rfrappe = 0;
		   monsters[i].dir = 2;
		   monsters[i].ia.lock = 1;
		   while (monsters[i].y >= 1){
			   monsters[i].y-=monsters[i].vit;
			   AFFICHE ();
			   draw_sprite (buffer,Data[t].dat,monsters[i].x,dy);
			   BLIT ();
			   rest (100);
		   }
		   monsters[i].y = dy;
		   monsters[i].ia.lock = 0;
		   monsters[i].ia.im1 = monsters[i].images [0];
		   monsters[i].ia.im2 = monsters[i].images [1];
		   monsters[i].images [0] = monsters[i].images[1] = t;

	   }
	   zid_normal (i);
   }
   else if(monsters[i].ia.mode == 1){
	   int d1,d2,c;
	   int vit=monsters[i].vit;

	   if(pp.x >  monsters[i].x) d1 = 0;
	   else if(pp.x < monsters[i].x) d1 = 1;
	   if(pp.y >  monsters[i].y) d2 = 3;
	   else if(pp.y < monsters[i].y) d2 = 2;
	   if(if_collision (Data[pp.images[0]].dat,Data[monsters[i].images[0]].dat,pp.x ,pp.y , monsters[i].x,monsters[i].y)){
		   rest (1000);
		  monsters[i].ia.mode = 2;	  
		  monsters[i].vit = monsters[i].ia.vit;
		  monsters[i].ia.avantdir = monsters[i].y;
		  monsters[i].y  = 0;
		  monsters[i].dir = 3;
		  monsters[i].images [0]= monsters[i].ia.im1;
		  monsters[i].images [1]= monsters[i].ia.im2;
		  break;

	   }
	  if(obj.cur == I_BOTTES) monsters[i].vit +=4;

	   monsters[i].dir = d1;
	   zid_normal (i);
	   monsters[i].dir = d2;
	   zid_normal (i);
	   monsters[i].vit = vit;
	  
   }
   else if(monsters[i].ia.mode == 2){
	   if(monsters[i].y >= monsters[i].ia.avantdir) {
		   monsters[i].dir = 0;
		   monsters[i].ia.mode = 0;
		   monsters[i].ia.fois=0;
		   monsters[i].accord.frappe = 1;
		   monsters[i].accord.rfrappe = 1;
		   monsters[i].ia.avantdir  =1;
		   break;
			   
	   }
	   zid_normal (i);
   }
   break;
/************************************************************/
     case 10:
rr:
     
     r = monster_hbs(i);
     if(obj.cur == I_EPEE || obj.cur == I_BOTTES) monsters[i].vit=monsters[i].ia.fois+monsters[i].ia.mode;
     else if(monsters[i].vit=monsters[i].ia.fois+monsters[i].ia.mode) monsters[i].vit=monsters[i].ia.fois;
     
     if(!r){
	     monsters[i].dir = rand() % 4;
	     if(monsters[i].vit==monsters[i].ia.fois+monsters[i].ia.mode) monsters[i].dir=notdir2(obj.dir);
	     r = monster_hbs(i);
	     if(!r && monsters[i].vit==monsters[i].ia.fois+monsters[i].ia.mode) monsters[i].dir=rand()%4;
	     if(!r) goto rr;
     }
     zid_normal(i);
     
     break;
/**************************************************************/
     case 7 :/*BOSS2*/ 
	 if(monsters[i].ia.mode == 0){
		 monsters[i].dir = rand() % 4;
		 if(monsters[i].hp <= 30) monsters[i].ia.mode++;
		 zid_normal(i);
	 }
	 else if(monsters[i].ia.mode == 1){
		 int I;
		 
		 if(!monsters[i].frappe[0].frappe){
			 int t=rand()%40;
			 monsters[i].ia.fois++;
			 if(monsters[i].ia.fois >= 3){
				 monsters[i].frvit++;
				 monsters[i].ia.fois=0;
			 }
			 
			 for(I = 0 ;  I < monsters[i].maxfrappe ; I++){
				 monsters[i].frappe[I].frappe = 1;
				 monsters[i].frappe[I].frappex = (I*40)+t;
				 monsters[i].frappe[I].frappey = 40;
				 monsters[i].frappe[I].frapped = 3;

			 }
		 }
		 
		 else {
			for(I = 0 ; I < monsters[i].maxfrappe;I++)  zid_normal_frappe  (i,I);
		 }
	 }

     break;
     
     case 8 : /* AZZI 1 */
	  
			if(monsters[i].ia.fois >= 5-monsters[i].ia.mode){
				srand(time(0));
				monsters[i].x = (rand() % (map_w-40)) + 20;
				srand(time(0));
				monsters[i].y = (rand() % (map_h-40)) + 20;
				monsters[i].ia.fois=0;
				monsters[i].ia.mode++;
				
				if(monsters[i].ia.mode >= 6){
				monsters[i].ia.mode=0;
				monsters[i].frappe[0].frappe = 1;
				monsters[i].frappe[0].frappex = monsters[i].x;
				monsters[i].frappe[0].frappey = monsters[i].y;
				if(pp.x >= monsters[i].x && pp.y >= monsters[i].y){
						monsters[i].frappe[0].frappex = monsters[i].x;
						monsters[i].frappe[0].frappey = pp.y;
						monsters[i].frappe[0].frapped = 0;

				}
				else if(pp.x >= monsters[i].x && pp.y <= monsters[i].y){
						monsters[i].frappe[0].frappex = pp.x;
						monsters[i].frappe[0].frappey = monsters[i].y;
						monsters[i].frappe[0].frapped = 2;
				}
				
				else if(pp.x <= monsters[i].x && pp.y >= monsters[i].y){
						monsters[i].frappe[0].frappex = monsters[i].x;
						monsters[i].frappe[0].frappey = pp.y;
						monsters[i].frappe[0].frapped = 1;

				}
				else if(pp.x <= monsters[i].x && pp.y <= monsters[i].y){
						monsters[i].frappe[0].frappex = pp.x;
						monsters[i].frappe[0].frappey = monsters[i].y;
						monsters[i].frappe[0].frapped = 3;
				}
			
				}
			}
				
		if(monsters[i].frappe[0].frappe){
			srand(time(0));
			zid_normal_frappe(i , 0);
		}
		monsters[i].ia.fois++;
	  
	  break;

      ////////////////////////////////////////
    case 1:
    l:
      monsters[i].dir = rand () % 4;
      r = monster_hbs (i);

      if (!r)
	goto l;
      zid_normal (i);
      break;
      ////////////////////////////////////////////
    case 5:
      if (monsters[i].frappe[0].frappe == -1)
	{
	  for (e = 0; e < monsters[i].maxfrappe; e++)
	    {
	      monsters[i].frappe[e].frappe = 1;
	      monsters[i].frappe[e].frappex = monsters[i].x;
	      monsters[i].frappe[e].frappey = monsters[i].y;
	    }
	  monsters[i].frappe[0].frapped = rand () % 4;
	  monsters[i].frappe[1].frapped =
	    notdir (monsters[i].frappe[0].frapped);

	}

      if (monsters[i].frappe[0].frappe && monsters[i].frappe[0].frappe != -1)
	{

	  zid_normal_frappe (i, 0);
	  zid_normal_frappe (i, 1);
	  if (!monsters[i].frappe[0].frappe)
	    monsters[i].frappe[0].frappe = -1;

	  if ((monsters[i].pc1y == pp.pc1y || monsters[i].pc2y == pp.pc2y
	       || monsters[i].pc1x == pp.pc1x || monsters[i].pc2x == pp.pc2x)
	      && monsters[i].frappe[0].frappe)
	    {
	      monsters[i].frappe[0].frappe = 0;
	      monsters[i].frappe[1].frappe = 0;


	    }


	}

      else
	{
	dd:
	  r = monster_hbs (i);
	  if (!r)
	    {
	      monsters[i].dir = rand () % 4;
	      goto dd;
	    }
	  zid_normal (i);

	  if ((monsters[i].pc1y == pp.pc1y || monsters[i].pc2y == pp.pc2y
	       || monsters[i].pc1x == pp.pc1x || monsters[i].pc2x == pp.pc2x)
	      && !monsters[i].frappe[0].frappe)
	    {
	      monsters[i].frappe[0].frappe = -1;
	    }

	}
      break;

      ///////////////////////////////////////////////////////

    case 3:
    rec:

      r = monster_hbs (i);

      if (!r)
	{
	  f = monsters[i].ia.avantdir;
	  dr = monsters[i].dir;
	  monsters[i].ia.avantdir = monsters[i].dir;
	  if (dr == 0 && f == 2)
	    dr = 3;
	  else if (dr == 0 && f == 3)
	    dr = 2;
	  else if (dr == 1 && f == 2)
	    dr = 3;
	  else if (dr == 1 && f == 3)
	    dr = 2;
	  else if (dr == 2 && f == 0)
	    dr = 1;
	  else if (dr == 2 && f == 1)
	    dr = 0;
	  else if (dr == 3 && f == 0)
	    dr = 1;
	  else if (dr == 3 && f == 1)
	    dr = 0;
	  monsters[i].dir = dr;
	  goto rec;
	}
      zid_normal (i);
      break;
/* monstre jaune */	    
case 9:
if(!monsters[i].frappe[0].frappe){
	monsters[i].frappe[0].frappe = 1;
	monsters[i].frappe[0].frappex = (rand() % 16) * 20;
	monsters[i].frappe[0].frappey = (rand() % 10) * 20;
	monsters[i].x = monsters[i].frappe[0].frappex;
	monsters[i].y = monsters[i].frappe[0].frappey;
	monsters[i].frappe[0].frapped = notdir (pp.dir);
	monsters[i].dir = monsters[i].frappe[0].frapped;
}
else zid_normal_frappe (i,0);
break;


////////////////////////////////////////////////////////////////          
  
    case 4:			// BOSS1 //
      switch (monsters[i].ia.mode)
	{
	case 0:
	la:
	  monsters[i].dir = rand () % 4;
	  monsters[i].ia.fois++;
	  r = monster_hbs (i);
	  if (!r)
	    goto la;
	  zid_normal (i);
	  if (monsters[i].ia.fois >= 100)
	    {
	      monsters[i].ia.mode = 1;
	      monsters[i].ia.fois = 0;
	      monsters[i].accord.rfrappe=1;
	    }
	  break;
	  
	case 1:
	  if (monsters[i].ia.is_frappe)
	    {
	      monsters[i].ia.is_frappe = 0;
	      monsters[i].ia.mode = 0;
	      monsters[i].accord.rfrappe = 0;
	      for (K = 0; K < monsters[i].maxfrappe; K++)
		monsters[i].frappe[K].frappe = 0;
	      break;
	    }
	  if (!monsters[i].frappe[0].frappe && !monsters[i].frappe[1].frappe
	      && !monsters[i].frappe[2].frappe
	      && !monsters[i].frappe[3].frappe
	      && !monsters[i].frappe[4].frappe
	      && !monsters[i].frappe[5].frappe)
	    {

	      monsters[i].ia.fois++;
	      for (K = 0; K < monsters[i].maxfrappe; K++)
		{
		  monsters[i].frappe[K].frappe = 1;
		  monsters[i].frappe[K].frappex = monsters[i].x;
		  monsters[i].frappe[K].frappey = monsters[i].y;
		}
	    }
	  else
	    {
	      monsters[i].frappe[0].frapped = 0;
	      zid_normal_frappe (i, 0);
	      monsters[i].frappe[0].frapped = 2;
	      zid_normal_frappe (i, 0);

	      monsters[i].frappe[1].frapped = 1;
	      zid_normal_frappe (i, 1);
	      monsters[i].frappe[1].frapped = 2;
	      zid_normal_frappe (i, 1);


	      monsters[i].frappe[2].frapped = 1;
	      zid_normal_frappe (i, 2);
	      monsters[i].frappe[2].frapped = 3;
	      zid_normal_frappe (i, 2);

	      monsters[i].frappe[3].frapped = 0;
	      zid_normal_frappe (i, 3);
	      monsters[i].frappe[3].frapped = 3;
	      zid_normal_frappe (i, 3);

	      monsters[i].frappe[4].frapped = 0;
	      zid_normal_frappe (i, 4);

	      monsters[i].frappe[5].frapped = 1;
	      zid_normal_frappe (i, 5);

	      monsters[i].frappe[6].frapped = 2;
	      zid_normal_frappe (i, 6);

	      monsters[i].frappe[7].frapped = 3;
	      zid_normal_frappe (i, 7);



	    }

	  if (monsters[i].ia.fois >= 2)
	    {
		    
	      for (K = 0; K < monsters[i].maxfrappe; K++){
		monsters[i].frappe[K].frappe = 0;
	      }
	      monsters[i].ia.mode = 0;
	      monsters[i].accord.rfrappe=0;
	      monsters[i].ia.fois=0;


	    }

	  break;
	}

      break;

    }

}


/********************************** zid_monsters ********************/
int
zid_monsters (void)
{
  int i, r, e, yes, mx, my, m, tx, ty;
  int p1x, p1y, p2x, pc2y;
  int fois, J, SX, SY, k, K, p, angle;
  int is, val, image;
  if (counter_monsters >= 100)
    {
      switch (pp.dir)
	{
	case 0:
	  val = 0;
	  break;
	case 1:
	  val = 9;
	  break;
	case 2:
	  val = 3;
	  break;
	case 3:
	  val = 6;
	  break;
	}
      image = pp.images[val + pp.anim[pp.dir]];
      counter_monsters = 0;

      for (i = 0; i < max_monsters; i++)
	{

	  if (monsters[i].en)
	    {

	      is = 0;
	      yes = 0;
	      hbs ();
	      if (!nofrappe)
		{
		  is =
		    if_collision (Data[image].dat,
				  Data[monsters[i].images[0]].dat, pp.x, pp.y,
				  monsters[i].x, monsters[i].y);
		  if (is)
		    goto mm;
		}


//FRAPPE
	      if (!nofrappe)
		{
		  for (K = 0; K < monsters[i].maxfrappe; K++)
		    {


		      if (monsters[i].frappe[K].frappe
			  && monsters[i].frappe[K].frappe != -1)
			{


			  is =
			    if_collision (Data[image].dat, Data[BOUT0].dat,
					  pp.x, pp.y,
					  monsters[i].frappe[K].frappex,
					  monsters[i].frappe[K].frappey);

			  if (is)
			    {
			      monsters[i].frappe[K].frappe = 0;
			      if (accord_monster (i, MONSTRE_FRAPPE_PERSO))
				goto mm;
			    }

			}

		    }
		}
//QUAND LE MONSTRE FRAPPE LE PERSO                

//            HBS (pp.x, pp.y, pp.vit, pp.dir, &pp.pc1x, &pp.pc1y, &pp.pc2x,
//                 &pp.pc2y);
/*		  
	      if ( !nofrappe &&
		  ((monsters[i].pc1x == pp.pc1x && monsters[i].pc1y-p == pp.pc1y)
		  || (monsters[i].pc2x == pp.pc2x
		      && monsters[i].pc2y-p == pp.pc2y) ) )
		{
*/
	    mm:

	      if (accord_monster (i, MONSTRE_FRAPPE_PERSO) && is && !nofrappe)
		{

		  pp.hp--;
		  if (pp.hp < 0)
		    pp.hp = 0;

		  if(nofrappe == 0){	
		  nofrappe = 0;
		  affiche (buffer);
		  if(monsters[i].ia.pouss){
			  frapper_perso (0);
		  }
		  nofrappe = 0;
		  }
		  if(pp.hp == 0 && !PERDUVAR){
			  if(!PERDU_SCENARIO()){
			  PERDUVAR=1;
			  stop_midi();
			  playmidi (MIDI21);
			  parle (lang(118),NULL,NULL,NULL);
			  rest (1000);
			  FADE (FADE_ESCALIER_SPEED);
			  blit (Data[BACK3].dat , screen, 0,0,0,0,SCREEN_W,SCREEN_H);
			  while (BTSPACE) {poll_keyboard();poll_joystick();}
			  while (!BTSPACE) {poll_keyboard();poll_joystick(); if(BTFULLSCREEN) set_fullscreen();}
			}
		  }

		}

	      if (is && !accord_monster (i, MONSTRE_FRAPPE_PERSO)
		  && !nofrappe)
		{
		
		  nofrappe = 0;
		  if(monsters[i].ia.pouss){
			  frapper_perso (0);
		  }
		  nofrappe = 0;

		}




// LE PERSO JETE L'EPEE
	      if (obj.en && obj.cur == I_EPEE)
		{
		  tx = obj.x;
		  ty = obj.y;

		  if (!pp.jeter_epee)
		    {

		      if (obj.dir == 0)
			{
			  tx = obj.x + 20;
			  ty = obj.y;
			}
		      else if (obj.dir == 1)
			{
			  tx = obj.x - 20;
			  ty = obj.y;
			}
		      else if (obj.dir == 2)
			{
			  tx = obj.x;
			  ty = obj.y - 20;
			}
		      else if (obj.dir == 3)
			{
			  tx = obj.x;
			  ty = obj.y + 20;
			}
		    }
		  
		  yes =
		    if_collision (Data
				  [items[obj.cur].
				   images[(obj.dir <= 1) ? 1 : 0]].dat,
				  Data[monsters[i].images[0]].dat, tx, ty,
				  monsters[i].x, monsters[i].y);
				  
//		  yes = coll (tx,ty,20,20,monsters[i].x,monsters[i].y,monsters[i].w,monsters[i].h);
		  if(monsters[i].que_grappin) yes=0;
		}


// LE PERSO FRAPPE LE MONSTRE
	      if (obj.en && obj.cur == I_GRAPPIN)
		{
		  yes =
		    if_collision (Data[items[obj.cur].images[0]].dat,
				  Data[monsters[i].images[0]].dat, obj.x,
				  obj.y, monsters[i].x, monsters[i].y);
		  if (yes)
		    {
		      obj.en = 0;
		      obj.cur = 0;
		      nomarcher = 0;
		    }
		}
	      if (yes && accord_monster (i, PERSO_FRAPPE_MONSTRE) )
		{
		int save=n_crystal;
		x:

		  nofrappe = 1;
       
		  play_sfx (SFX1);


		  if (monsters[i].hp != -1)
		    {
		      monsters[i].hp -= pp.pvfrappe;
		      monsters[i].ia.is_frappe = 1;

		      if (monsters[i].hp <= 0)
			{
			  monsters[i].en = 0;
			  play_sfx (SFX3);
			  explosion (monsters[i].x, monsters[i].y, 7);

			  mx = monsters[i].x / 20;
			  my = monsters[i].y / 20;
			  m = mx + my * 16;
			  if (Map.hbst[Map.show[0][m]] == 0)
			    m = (mx + 1) + (my * 16);
			  if (Map.hbst[Map.show[0][m]] == 0)
			    m = (mx) + ((my + 1) * 16);
			  if (Map.hbst[Map.show[0][m]] == 0)
			    m = (mx + 1) + ((my + 1) * 16);
			  if (!BOSS)
			    {
			      if (Map.hbst[Map.show[0][m]])
				Map.show[0][m] = chose ();
			      if (!Map.show[0][m])
				Map.show[0][m] = Map.show[1][m];
			    }
			  else
			    {
		 	   change_obstacle (Map.stage , 0 ,monsters[i].vraiOBS, Map.show[1][monsters[i].vraiOBS]);

			  if(DONNE_CRYSTAL(BOSS)){
			      BOSS = 0;
			      n_crystal++;
			      playmidi (FANFARE1);
			      midi_seek (10);
			      for (e = 0; e < 4; e++)
				{
				  explosion (monsters[i].x, monsters[i].y,
					     10);
				  K = play_sfx (SFX4);
				  while (voice_get_position (K) != -1);
				}
			      playmidi (FANFARE2);
			      VParle (PARLE_GAGNE_MONSTRE);
			      pp.x = 160;
			      pp.y = 160;
			      pp.dir = 2;
			      angle = 0;
			      for (e = 0; e < 50; e++)
				{
				  int im=CRYST;
				 
				  if( (Map.hqst != -1  && Map.hqst>=155) || (Map.hqst == -1 && Map.stage >= 155)) im=CRYST2;
				  
				  marcher (2);
				  angle = (angle + 1) % 256;
				  pp.anim[pp.dir]++;
				  if (pp.anim[pp.dir] >= 3)
				    pp.anim[pp.dir] = 0;
				  affiche (buffer);
				  rotate_sprite (buffer, Data[im].dat, 145,
						 30, itofix (angle));
				  BLIT();
				  rest (ANIM_DELAY + 100);
				}
			      FADE (FADE_ESCALIER_SPEED);
			      setpal;
			      Map.show[0][pp.pc1x + (pp.pc1y - 1) * Map.w] = 21;	// porte
			    }
			  affiche (buffer);
			 BLIT();
			 if(n_crystal != save)     {
				char a[256];
			        char b[10];
				if(n_crystal == 1) strcpy(b,lang(120));
				if(n_crystal > 1 ) strcpy(b,lang(49));
				sprintf (a , "%s %i %s",lang(119),n_crystal,b);
			      parle (a,NULL,NULL,NULL);
			
			      }

			  if(Map.stage == 316){
				playmidi (MIDI27);
				parle (lang(411),lang(412),NULL,NULL);
				affiche (buffer);
				for(i = 0 ; i < 6 ; i++){
					int im=CRYST;
					if(i>=3) im=CRYST2;
					draw_sprite (buffer,Data[im].dat,40+i*40 , 20);
				}
				parle (lang(413),NULL,NULL,NULL);
				rest (2000);
				pp.pvfrappe = 3;
				set_pp_epee ();
				playmidi (FANFARE1);
				affiche (buffer);
				fanfare (buffer, EPEE20 , pp.x , pp.y-20);
				rest (2000);
				play_place_midi (Map.place);
				parle (lang(414),NULL,NULL,NULL);
   			  }	
			  


			}
			}


		    }
          dddo:

		  nofrappe = 0;

		}

	      //d

	    }
	  monsters[i].ep++;
	  if (monsters[i].ep >= 2)
	    monsters[i].ep = 0;
	  zid_monster (i);

	}

    }



}


/******************************* show_monsters **********************/

int
show_monsters (BITMAP * bmp)
{
  int i, K;
  BITMAP *r;
  int d=0;
  for (i = 0; i < max_monsters; i++)
    {
      	    
      if (monsters[i].en)
	{
	 d=1;
	  if (monsters[i].images[monsters[i].ep] >= 0)
	    r = Data[monsters[i].images[monsters[i].ep]].dat;
	  else
	    r = MAKLOUB (Data[-monsters[i].images[monsters[i].ep]].dat);

	  if(monsters[i].show) draw_sprite (bmp, r, monsters[i].x, monsters[i].y);
	  for (K = 0; K < monsters[i].maxfrappe; K++)
	    {
	      if (monsters[i].frappe[K].frappe
		  && monsters[i].frappe[K].frappe != -1)
		{
		  if(monsters[i].show) draw_sprite (bmp, Data[monsters[i].frappe[K].frappeim].dat,
			       monsters[i].frappe[K].frappex,
			       monsters[i].frappe[K].frappey);
		}
	    }
	  if (!(monsters[i].images[monsters[i].ep] >= 0))
	    destroy_bitmap (r);
	}
    }
  if(max_monsters && !d){
	  clear_bibane (-1);
  }

}

/******************************** init_monsters ***********************/
int
init_monsters (void)
{
 int i;
  monsters = (PERSO *) malloc (sizeof (PERSO) * 160);
  if(!monsters) err(MEMORY_ERROR);
  for(i =  0 ; i < 160 ; i++){
		  monsters[i].images=0;
		  monsters[i].name=0;
	  	  monsters[i].item=0;
	  	  monsters[i].items=0;
  }
  
  set_mons_im (0, 0, 0);
  set_mons_im (1, M00, -M00);
  set_mons_im (2, M10, -M10);
  set_mons_im (3, M20, -M20);
  set_mons_im (4, BOSS0, -BOSS0);
  set_mons_im (5, M3, -M3);
  set_mons_im (6, M4, -M4);
  set_mons_im (7, BOSS1 , -BOSS1);
  set_mons_im (8, AZZI0 , -AZZI0);
  set_mons_im (9, M5    , -M5);
  set_mons_im (10,M6    , -M6);
  set_mons_im (11,BOSS20, BOSS21);
  set_mons_im (12,M70   , M71);
  set_mons_im (13,BOSS3   , -BOSS3);
  set_mons_im (14,M8   , -M8);
  set_mons_im (15,BOSS4,BOSS4);
  set_mons_im (16,AZZI0,-AZZI0);
  set_mons_im (17, -1, -1);
}

/****************************** destroy_monsters ***********************/
int
destroy_monsters (void)
{
  int i;
  if(monsters){
     free (monsters);
 	 monsters=0;
  }
}

/* BOSS */
int
boss (int st)
{
  switch (st)
    {
///////////////////
    case 74:
      parle_monstre (1);
      return 1;
////////////////////
	case 123 :
	 parle_monstre(2);
	return 2; 
///////////////////
	case 53:
	return 3;
///////////////////
	case 154:
	return 4;
	case 230:
	return 5;
///////////////////
	case 260:
	parle_monstre (6);
	return 6;	
	case 316:
	parle_monstre (6);	
	return 6;
	case 343 :
	return 6;


    }
return 0;
}

/*********************** play_boss_midi ********************/
void play_boss_midi(int boss){
		if(boss == 6) {playmidi(MIDI22);return;}
		if(boss != 3) playmidi(MIDI5);
		
}

