/*************************** Lgc ************************/
// FILE : map.c
/*******************************************************/

#include "internal.h"

#define SAVE_PACKED "p"

CHANGED_OBS *changed_obs=0;
int max_changed_obs=0;
int noShow=0;


int force_midi=-1;
int force_midi_stage=-1;

/************** force_midi *************************/
void FORCE_MIDI(int midi,int stage) {force_midi=midi;force_midi_stage=stage;}


/*************************** map_obs_marcher *******************/
int
map_obs_marcher (MAP * map, int layer_prp, int layer_arp, int obs_index,
 int dir, int px)
{
  int s = map->show[layer_prp][obs_index];
  int fx = obs_index;
  map->show[layer_prp][obs_index] = map->show[layer_arp][obs_index];
  switch (dir)
    {
    case 0:
      fx += px;
      break;
    case 1:
      fx -= px;
      break;
    case 2:
      fx -= 16 * px;
      break;
    case 3:
      fx += 16 * px;
      break;
    }
  map->show[layer_prp][fx] = s;
  return fx;
}

/******************** destroy_item *******************/
int
destroy_item (ITEM * item)
{
  int i;
  ITEM *it=item;
  while(it->images[0] != -1){
	if(it->name) {free(it->name);it->name=0;}
	if(it->info) {free(it->info);it->info=0;}
	it++;      
    }
  
  if (item)
    free (item);
}

//set_place
int
set_place (int stage)
{
 /* Chateau de AZZI */
  if(stage >= 321 && stage <= 350) return 17;
  if(stage  >= 291 && stage <= 320) return 16;
  /* Enfers  World */
  if(stage >= 262 && stage <= 290) return 15;

  if(stage == 61 || stage == 203 || stage == 261) return 14; /* shop */
  /* donjon 4 */
  if(stage >= 204 && stage <= 231) return 12;
  /* donjon 5 */
  if(stage >= 232 && stage <= 260) return 13;


  /* village Afia */	
  if(stage >= 168 && stage <= 172) 
  return 11;
  
  /* desert */
  if ((stage >= 42 && stage <= 59) && stage != 43)
  return 8;
  /* donjon 2 */
  if (stage >= 101 && stage <= 131)
    return 7;
/* donjon 3 */
  if(stage >= 132 && stage <= 154)
	  return 9;
  
  if (stage >= 89 && stage <= 100)
    return 5;
  
  if ((stage >= 25 && stage <= 30) || stage == 21)
    return 6;

  if (stage >= 70 && stage <= 88)
    return 3;			/* donjon 1 */
  
  if (Map.hqst != -1)
    return 4;
  if (stage >= 0 && stage <= 5)
    return 2;
  /* Magma */
  if(stage >= 155 && stage <= 200) return 10;
  
  return 1;
}

//get_obs
int
get_obs (MAP map, int st, int layer, int d)
{
  return map.obs[layer][(st * map.w * map.h) + d];
}
//add_changed_obs
int
add_changed_obs(int st,int layer,int d,int val){
		changed_obs = (CHANGED_OBS*)realloc(changed_obs , sizeof(CHANGED_OBS) * (max_changed_obs + 1));
		changed_obs[max_changed_obs].st = st;
		changed_obs[max_changed_obs].layer = layer;
		changed_obs[max_changed_obs].pos = d;
		changed_obs[max_changed_obs].val = val;
		max_changed_obs++;
}
//change_obstacle
int
change_obstacle (int st, int layer, int d, int val)
{
  Map.obs[layer][(st * Map.w * Map.h) + d] = val;
  add_changed_obs(st,layer,d,val);
}

//play_place_midi
int
play_place_midi (int pl)
{
  if(Map.stage == force_midi_stage && force_midi != -1) force_midi=-1;
  if(force_midi != -1) return 0;
   
  switch (pl)
    {
    case 2:
      playmidi (MIDI2);
	  break;
    case 1:
      playmidi (MIDI1);
	  break;
    case 3:
      playmidi (MIDI4);
	  break;
    case 4:
      playmidi (MIDI3);
	  break;
    case 5:
      playmidi (MIDI6);
	  break;
    case 6:
      playmidi (MIDI7);
	  break;
    case 7:
      playmidi (MIDI8);
      break;
    case 8:
      playmidi (MIDI9);
      break;
    case 9:
      playmidi (MIDI12);
      break;
    case 10:
      playmidi (MIDI14);
      break;
    case 11:
      playmidi (MIDI15);
      break;
    case 12:
      playmidi (MIDI18);
      break;
    case 13:
      playmidi (MIDI19);
      break;
    case 14:
      playmidi (MIDI20);
      break;
    case 15:
      playmidi (MIDI24);
      break;
    case 16:
      playmidi (MIDI25);
      break;
   case 17:
     playmidi (MIDI29);
     break;
      

    }
  	PLACE_SCENARIO();
}



//load_all_screen_map
void
load_all_screen_map (void)
{
  int i;
 if(!noShow){ 
  for (i = 0; i < Map.maxlayer + 1; i++)
    {
       load_screen_map (&Map, i);
    }
 }
  load_screen_persos ();
  load_screen_monsters ();
  pp.hqx = pp.x;
  pp.hqy = pp.y;
}

//load_screen_map
int
load_screen_map (MAP * m, int layer)
{
  int s = m->w * m->h * m->stage;
  int i;
  int *intb=int_bool_get();

  for (i = 0; i < m->w * m->h; i++)
    {
      int p;	    
      m->show[layer][i] = m->obs[layer][s + i];
      if(p=is_int_car (m->show[layer][i])){
	      if(intb [p]){
		      m->show[layer][i]=int_to_trace(p);
	      }
      }
      else if(p=is_int_trace(m->show[layer][i])){
	      if(!intb[p]) m->show[layer][i]=int_to_trace(p);
	      else m->show[layer][i]=car(p);
      }
      if (m->show[layer][i] == 151){
	  m->show[layer][i + 1] = 67;
	  m->show[layer][i + 2] = 67;
	  m->show[layer][i + 3] = 67;
	  m->show[layer][i + 16] = 67;
	  m->show[layer][i + 16+1] = 67;
	  m->show[layer][i + 16+2] = 67;
	  m->show[layer][i + 16+3] = 67;
	  m->show[layer][i + 32] = 67;
	  m->show[layer][i + 32+1] = 67;
	  m->show[layer][i + 32+2] = 67;
	  m->show[layer][i + 32+3] = 67;
	  m->show[layer][i + 48] = 67;
	  m->show[layer][i + 48+1] = 67;
	  m->show[layer][i + 48+2] = 67;
	  m->show[layer][i + 48+3] = 67;
	
      }
      if (m->show[layer][i] == 66)
	{
	  m->show[layer][i + 1] = 67;
	  m->show[layer][i + 16] = 67;
	  m->show[layer][i + 17] = 67;
	}
    }
}


//load_map
MAP
load_map (char *file)
{
  MAP m;
  char *s = 0;
  char c;
  PACKFILE *f;
  char l[256];
  int la = 0;
  int i = 0;
  char *ptr;
  
  f = pack_fopen (file, "r"SAVE_PACKED);
  if(!f) err(FILE_ERROR);
  
  pack_fread (&m.w, sizeof (int), f);
  pack_fread (&m.h, sizeof (int), f);
  pack_fread (&m.maxlayer, sizeof (int), f);
  pack_fread (&m.maxim, sizeof (int), f);
  pack_fread (&m.maxstage, sizeof (int), f);
/*
  m.w = 16;
  m.h = 10;
  m.maxlayer = 2;
  m.maxim = 500;
  m.maxstage = 400;

*/
  m.images = (int *) malloc (sizeof (int) * (m.maxim + 1));
  if(!m.images) err(MEMORY_ERROR);
  
  m.makloub = (int *) malloc (sizeof (int) * (m.maxim + 1));
  if(!m.makloub) err(MEMORY_ERROR);
  
  m.hbst = (int *) malloc (sizeof (int) * (m.maxim + 1));
  if(!m.hbst) err(MEMORY_ERROR);
  
  
  i = 0;
  m.obs = (unsigned char **) malloc (sizeof (unsigned char *) * (m.maxlayer + 1));
  if(!m.obs) err(MEMORY_ERROR);

  
  m.show = (int **) malloc (sizeof (int *) * (m.maxlayer + 1));
  if(!m.show) err(MEMORY_ERROR);
  
  for (i = 0; i < m.maxlayer + 1; i++)
    {
      m.obs[i] = (unsigned char *) malloc ((m.maxstage+1) * ((m.w * m.h) + 1));
	  if(!m.obs[i]) err(MEMORY_ERROR);
	  
      pack_fread (m.obs[i], m.maxstage * m.w * m.h, f);
      m.show[i] = (int *) malloc (sizeof (int) * ((m.w * m.h) + 1));
	  if(!m.show[i]) err(MEMORY_ERROR);
    }
  
 
  pack_fclose (f);
  return m;
}

//save_map
int
save_map (MAP m, char *file)
{
  char s[5];
  PACKFILE *f = pack_fopen (file, "w"SAVE_PACKED);
  int i = 0;
  if(!f) return -1;
  pack_fwrite (&m.w, sizeof (int), f);
  pack_fwrite (&m.h, sizeof (int), f);
  pack_fwrite (&m.maxlayer, sizeof (int), f);
  pack_fwrite (&m.maxim, sizeof (int), f);
  pack_fwrite (&m.maxstage, sizeof (int), f);
  for (i = 0; i < m.maxlayer + 1; i++)
    {
      pack_fwrite (m.obs[i], m.maxstage * m.w * m.h, f);
    }

  pack_fclose (f);
}

//destroy_map
int
destroy_map (MAP *m)
{
  int i;
  
  for (i = 0; i < m->maxlayer +1; i++)
    {
//      if (m->show[i]) {free(m->show[i]);m->show[i]=0;}
//      if (m->obs[i]) {free(m->obs[i]);m->obs[i]=0;}
    }
if(m->obs){
	free (m->obs);
	m->obs=0;
}
  if (m->show){
    free (m->show);
	m->show=0;
  }
  if (m->images){
    free (m->images);
	m->images=0;
	}
  if (m->hbst){
    free (m->hbst);
	m->hbst=0;
  }
  if (m->makloub){
    free (m->makloub);
	m->makloub=0;
  }
}

/************************** calcul_obs ********************/
int
calcul_obs (int w, int px, int py)
{
  return px + py * w;
}
