;---------------------------------
; installeur NSIS pour LGC
;---------------------------------
; le nom
Name "Lgc"

; informations
OutFile "lgc-installer.exe"
InstallDir $PROGRAMFILES\Lgc
LicenseText "GNU GPL"
LicenseData "COPYING.txt"


InstallDirRegKey HKLM "Software\Lgc" ""

Page directory
Page instfiles
Page license

UninstPage uninstConfirm
UninstPage instfiles
#ShowInstDetails show




; installation
Section "install"

WriteRegStr HKLM SOFTWARE\Lgc "Install_Dir" "$INSTDIR"
WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Lgc" "DisplayName" "Lgc (remove only)"
WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Lgc" "UninstallString" '"$INSTDIR\uninstall.exe"'
WriteUninstaller "uninstall.exe"

SetOutPath $INSTDIR

File lgc.exe
File data.dat

File alleg40.dll
File *.txt
SetOutPath $INSTDIR\fonts
File fonts\*.ttf
SetOutPath $INSTDIR\save
File save\empty.txt
SetOutPath $INSTDIR\lang
File lang\*.lang
SetOutPath $INSTDIR\map
File map\world.map
File icons\*.*
SetOutPath $INSTDIR
SectionEnd

Section "Start Menu Shortcuts"

  CreateDirectory "$SMPROGRAMS\Lgc"
  CreateShortCut "$SMPROGRAMS\Lgc\Uninstall.lnk" "$INSTDIR\uninstall.exe" "" "$INSTDIR\uninstall.exe" 0
  CreateShortCut "$SMPROGRAMS\Lgc\Lgc.lnk" "$INSTDIR\lgc.exe" "" "$INSTDIR\lgc.exe" 0
  CreateShortCut "$DESKTOP\Lgc.lnk" "$INSTDIR\lgc.exe" "" "$INSTDIR\lgc.exe" 0
  
SectionEnd


Section "Uninstall"
DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Lgc"
DeleteRegKey HKLM "SOFTWARE\Lgc"
Delete $INSTDIR\lgc.exe
Delete $INSTDIR\data.dat
Delete $INSTDIR\*.txt
Delete $INSTDIR\*
Delete $INSTDIR\lang\*.lang
Delete $INSTDIR\icons\*
RMDIR $INSTDIR\lang
Delete $INSTDIR\map\*
RMDIR $INSTDIR\map
RMDIR $INSTDIR\icons
Delete "$SMPROGRAMS\Lgc\*.*"
Delete "$DESKTOP\Lgc.lnk"
RMDIR "$SMPROGRAMS\Lgc"
SectionEnd
