/*************************** Lgc ************************/
// FILE : init.c
/*******************************************************/

#include "internal.h"
#include "pmask.h"
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
//#define Dernier
BITMAP *buffer2=0;
int digi_volume , midi_volume;
void set_vol (int digi  , int midi){
	if(digi != -1) digi_volume = digi;
	if(midi != -1) midi_volume = midi;
	set_volume (digi , midi);
}
/************** FONTS *******************/
ALFONT_FONT *title_font=0;
ALFONT_FONT *game_font=0,*menu_font=0,*pres_font=0;
/****************************************/

int FULLSCREEN=0;



char a[256];
/* TEMPS */
int is_game=0;
/* COULEURS */

int GRIS , BLANC;
int TRANS_COLOR;
/***************/
/********/
PALETTE pall;
ALFONT_FONT *sfont;
char current_save[256];
int SOUND_DETECTED;

int slot_number=1;
char SHOW_PERSO = 1;
MAP Map;
int n_crystal = 0;
DATAFILE *Data = 0;
OBJ obj;
BITMAP *buffer = 0;
PERSO pp;
ITEM *items = 0;
PERSO *monsters = 0;
PERSO *persos = 0;
char *filemap = 0, *afilemap = 0;

int max_monsters = 0;
int max_persos = 0;
volatile int counter_frappe, counter_monsters, counter_persos, counter_anim,
  counter = 0, counter_script = 0, counter_grappin = 0, counter_bottes = 0,
  counter_boom = 0 , counter_frappe2 = 0 , counter_menu_angle=0,counter_bombe=0,counter_bombe2=0 ;
volatile long game_counter=0;

char *get_cur_save () {return current_save;}

/* trans vars */
RGB_MAP rgb_table;
COLOR_MAP trans_table;

/********************* fonts ******************/
void init_fonts (){
	title_font = alfont_load_font("fonts/font1.ttf");
	game_font = alfont_load_font ("fonts/font2.ttf");
	menu_font = alfont_load_font ("fonts/font3.ttf");
	pres_font = alfont_load_font ("fonts/font4.ttf");
	sfont = title_font;
	alfont_set_font_size (pres_font , 30);
	alfont_set_font_size (menu_font , 20);
	alfont_set_font_size (game_font ,18)
;	alfont_set_font_size (title_font , 40);
	alfont_text_mode (-1);

}  
void destroy_fonts(){
	if(title_font) {alfont_destroy_font (title_font);title_font=0;}
	if(game_font) {alfont_destroy_font (game_font);game_font=0;}
	if(menu_font) {alfont_destroy_font(menu_font);menu_font=0;}
	if(pres_font) {alfont_destroy_font(pres_font);pres_font=0;}

}
  
// trans_init ///////////////
void trans_init(){
		int p = PAL;
		create_rgb_table(&rgb_table , Data[p].dat , NULL);
		rgb_map = &rgb_table;
		create_trans_table( &trans_table , Data[p].dat , 128,128,128,NULL);
		color_map = &trans_table;
		set_trans_blender(0,0,0,128);
}
/////////////////////////////
  
void
handle (void)
{
  counter_frappe++;
  counter_monsters++;
  counter_persos++;
  counter_script++;
  counter_anim++;
  counter_grappin++;
  counter_bottes++;
  counter_boom++;
  counter++;
  counter_frappe2++;
  counter_menu_angle++;
  counter_bombe++;counter_bombe2++;
  if(is_game) game_counter++;
}

END_OF_FUNCTION (handle);



//err
void
err (char *s)
{
  set_gfx_mode (GFX_TEXT, 0, 0, 0, 0);
  allegro_message ("ERREUR : %s\n", s);
  exit (1);
}



//init_map_image
int
init_map_image (void)
{
  set_map_image (Map, 0, ARB0, 1, 0);
  set_map_image (Map, 1, HERB0, 1, 0);
  set_map_image (Map, 2, ARB0, 0, 0);
  set_map_image (Map, 3, ROCH0, 0, 0);
  set_map_image (Map, 4, ROCH1, 0, 0);
  set_map_image (Map, 5, ROCH1, 0, 1);
  set_map_image (Map, 6, ROCH1, 0, 2);
  set_map_image (Map, 7, ROCH1, 0, 3);
  set_map_image (Map, 7, ROCH1, 0, 4);
  set_map_image (Map, 8, ROCH2, 0, 0);
  set_map_image (Map, 9, ROCH2, 0, 1);
  set_map_image (Map, 10, HERB1, 1, 0);
  set_map_image (Map, 11, M00, 0, 0);
  set_map_image (Map, 12, PERS0, 0, 0);
  set_map_image (Map, 13, DES0, 1, 0);
  set_map_image (Map, 14, TOIT1, 0, 0);
  set_map_image (Map, 15, TOIT1, 0, 1);
  set_map_image (Map, 16, TOIT3, 0, 0);
  set_map_image (Map, 17, TOIT3, 0, 1);
  set_map_image (Map, 18, TOIT2, 0, 0);
  set_map_image (Map, 19, TOIT4, 0, 0);
  set_map_image (Map, 20, TOIT4, 0, 2);
  set_map_image (Map, 21, PORTE0, 0, 0);
  set_map_image (Map, 22, FEN0, 0, 0);
  set_map_image (Map, 23, PERS1, 0, 0);
  set_map_image (Map, 24, PIER0, 0, 0);
  set_map_image (Map, 25, DIAM0, 1, 0);
  set_map_image (Map, 26, SOL0, 1, 0);
  set_map_image (Map, 27, MUR00, 0, 0);
  set_map_image (Map, 28, MUR01, 0, 0);
  set_map_image (Map, 29, MUR01, 0, 1);
  set_map_image (Map, 30, MUR01, 0, 2);
  set_map_image (Map, 31, MUR01, 0, 3);
  set_map_image (Map, 32, MUR01, 0, 4);
  set_map_image (Map, 33, PERS2, 0, 0);
  set_map_image (Map, 34, POTO0, 0, 0);
  set_map_image (Map, 35, PERS3, 0, 0);
  set_map_image (Map, 36, PERS4, 0, 0);
  set_map_image (Map, 37, PERS5, 0, 0);
  set_map_image (Map, 38, CHESE0, 0, 0);
  set_map_image (Map, 39, LIT0, 0, 0);
  set_map_image (Map, 40, EAU0, 0, 0);
  set_map_image (Map, 41, ESC0, 0, 0);
  set_map_image (Map, 42, TROU0, 0, 0);
  set_map_image (Map, 43, CHAT00, 0, 0);
  set_map_image (Map, 44, ARB0, 0, 0);
  set_map_image (Map, 45, CHAT00, 0, 2);
  set_map_image (Map, 46, CHAT00, 0, 3);
  set_map_image (Map, 47, CHAT00, 0, 4);
  set_map_image (Map, 48, CHAT01, 0, 0);
  set_map_image (Map, 49, CHAT01, 0, 1);
  set_map_image (Map, 50, SOL1, 1, 0);
  set_map_image (Map, 51, PORTE1, 0, 0);
  set_map_image (Map, 52, PORTE1, 0, 2);
  set_map_image (Map, 53, PORTE1, 0, 3);
  set_map_image (Map, 54, PORTE1, 0, 4);
  set_map_image (Map, 55, PORTE2, 0, 0);
  set_map_image (Map, 56, PORTE2, 0, 2);
  set_map_image (Map, 57, PORTE2, 0, 3);
  set_map_image (Map, 58, PORTE2, 0, 4);
  set_map_image (Map, 59, COFFRE0, 0, 0);
  set_map_image (Map, 60, COFFRE1, 0, 0);
  set_map_image (Map, 61, CLEF0, 0, 0);
  set_map_image (Map, 62, MUR2, 0, 0);
  set_map_image (Map, 63, BOUT0, 1, 0);
  set_map_image (Map, 64, MUR2, 0, 0);
  set_map_image (Map, 65, M10, 0, 0);
  set_map_image (Map, 66, ARB1, 0, 0);
  set_map_image (Map, 67, ARB0, 0, 0);
  set_map_image (Map, 68, HERB2, 1, 0);
  set_map_image (Map, 69, VIE0, 1, 0);
  set_map_image (Map, 70, SOL2, 1, 0);
  set_map_image (Map, 71, M20, 1, 0);
  set_map_image (Map, 72, PERS6, 0, 0);
  set_map_image (Map, 73, BOSS0, 0, 0);
  set_map_image (Map, 74, MUR3, 0, 0);
  set_map_image (Map, 75, MUR4, 0, 0);
  set_map_image (Map, 76, MUR5, 0, 0);
  set_map_image (Map, 77, MUR6, 0, 0);
  set_map_image (Map, 78, MUR7, 0, 0);
  set_map_image (Map, 79, SOL3, 1, 0);
  set_map_image (Map, 80, M3, 0, 0);
  set_map_image (Map, 81, HERB3, 1, 0);
  set_map_image (Map, 82, M4, 0, 0);
  set_map_image (Map, 83, SOL4, 0, 0);
  set_map_image (Map, 84, BOUT1, 1, 0);
  set_map_image (Map, 85, BOUT2, 1, 0);
  set_map_image (Map, 86, PORTE3, 0, 0);
  set_map_image (Map, 87, PORTE4, 0, 0);
  set_map_image (Map, 88, BOSS1 , 0 ,0);
  set_map_image (Map ,89, AZZI0,0,0);
  set_map_image (Map ,90, SOL5,1,0);
  set_map_image (Map, 91, M5, 0, 0);
  set_map_image (Map, 92, DES1, 1, 0);
  set_map_image (Map, 93, PERS7,0,0);
  set_map_image (Map, 94, PORTE5,0,0);
  set_map_image (Map, 95, SOL6,1,0);
  set_map_image (Map, 96, PERS8,0,0);
  set_map_image (Map, 97, MUR8,0,0);
  set_map_image (Map, 98, M6,0,0);
  set_map_image (Map, 99, BOUT3,0,0);
  set_map_image (Map, 100,TROU1,0,0);
  set_map_image (Map, 101,DEP0,0,0);
  set_map_image (Map, 102,MUR10,0,0);
  set_map_image (Map, 103,OBJ2,0,0);
  set_map_image (Map, 104,MUR9,0,0);
  set_map_image (Map, 105,OBJ3, 0, 0);
  set_map_image (Map, 106,BOSS20, 0, 0);
  set_map_image (Map, 107,AFF0, 0, 0);
  set_map_image (Map, 108,PORTE6, 0, 0);
  set_map_image (Map, 109,HERB4, 1, 0);
  set_map_image (Map, 110,ARB2, 0, 0);
  set_map_image (Map, 111,EAU1, 0, 0);
  set_map_image (Map, 112,PERS9, 0, 0);
  set_map_image (Map, 113,PERS10, 0, 0);
  set_map_image (Map, 114,MUR11, 0, 0);
  set_map_image (Map, 115,TROU2, 0, 0);
  set_map_image (Map, 116,SOL7, 1, 0);
  set_map_image (Map, 117,MUR12, 0, 0);
  set_map_image (Map, 118,MUR13, 0, 0);
  set_map_image (Map, 119,SOL8, 1, 0);
  set_map_image (Map, 120,INT0, 0, 0);
  set_map_image (Map, 121,INT1, 0, 0);
  set_map_image (Map, 122,MUR14, 0, 0);
  set_map_image (Map, 123,SOL9, 1, 0);
  set_map_image (Map, 124,SOL10, 1, 0);
  set_map_image (Map, 125,M70, 1, 0);
  set_map_image (Map, 126,MUR15, 0, 0);
  set_map_image (Map, 127,PORTE1, 0, 0);
  set_map_image (Map, 128,MUR6, 0, 0);
  set_map_image (Map, 129,BOSS3, 0, 0);
  set_map_image (Map, 130,MUR13, 0, 0);
  set_map_image (Map, 131,SOL11, 1, 0);
  set_map_image (Map, 132,MUR16, 0, 0);
  set_map_image (Map, 133,M8, 0, 0);
  set_map_image (Map, 134,SOL12, 0, 0);
  set_map_image (Map, 135,BOUT3, 0, 0);
  set_map_image (Map, 136,MUR14, 0, 0);
  set_map_image (Map, 137,BOSS4, 0, 0);
  set_map_image (Map, 138,SAVE0, 1, 0);
  set_map_image (Map, 139,SOL13, 1, 0);
  set_map_image (Map, 140,MUR17, 0, 0);
  set_map_image (Map, 141,MUR17, 0, 0);
  set_map_image (Map, 142,MUR17, 0, 0);
  set_map_image (Map, 143,BOUT3, 0, 0);
  set_map_image (Map, 144,MUR14, 0, 0);
  set_map_image (Map, 145,EAU2 ,0,0);
  set_map_image (Map, 146,AZZI1 ,0,0);
  set_map_image (Map, 147,AZZI0 ,0,0);
  set_map_image (Map, 148,AZZI0 ,0,0);
  set_map_image (Map, 149,TOIT2 ,0,1);
  set_map_image (Map, 150,WALL0 ,0,1);
  set_map_image (Map, 151,BIGARBRE ,0,0);



  set_map_image (Map, 152,-1, 0, 0);

}
FILE *logF = 0;
char *home;
char zero[256];
char *get_zero () {return (char*)zero;} 
//init
void
init (int argc, char *argv[])
{
int midi=0 , sound=0;

strcpy(zero,"zero");

#ifdef lgc_mingw32
logF = fopen ("LOG", "w");
#endif

#ifdef lgc_djgpp
logF = fopen ("LOG", "w");
#endif

#ifdef lgc_linux
{
home = getenv("HOME");
sprintf(a,"%s/.lgc",home);
mkdir(a,0777);

sprintf(a,"%s/.lgc/LOG",home);
logF = fopen(a,"w");
sprintf (a,"%s/.lgc/zero",home);
strcpy (zero , a);
}
#endif

if(logF) fprintf (logF , "##################### LGC LOG FILE ###################\n");
if(logF) fprintf (logF , "allegro_init () ... ");
if ( allegro_init () < 0) {
	if(logF) fprintf (logF , "[ERROR]\n");
	err (allegro_error);
}

init_lang ("lang/french.lang");

if(logF) fprintf (logF , "[OK]\n");
atexit (bye);
/////////////////// Pmask : utilitaire de collision /////////////////
/* initialisation de pmask */
/*
fprintf (logF , "install_pmask () ... ");
if (install_pmask () <0 ){
	fprintf (logF , "[ERROR]\n");

	err ("Echec dans l'initialisation de Pmask");
}

fprintf (logF , "[OK]\n");
*/
install_pmask ();
if(logF) fprintf (logF , "install_keyboard () ... ");

//////////////////// Clavier : obligatoire ! /////////////
  if (install_keyboard () < 0){
    fprintf (logF , "[ERROR]\n");
    err (allegro_error);
}

fprintf (logF , "[OK]\n");


if(alfont_init () < 0){
	err ("Erreur dans l'initiatisation de alfont");
}

///////////// Joystick - pas obligatoire ////////////
fprintf (logF , "install_joystick (Autodetect) ... ");

if( install_joystick(JOY_TYPE_AUTODETECT) < 0){
fprintf (logF , "[OK]\n");

}
else  fprintf (logF , "[ERROR]\n");

fprintf (logF , "install_timer ... ");

//////////////////////// Timer - obligatoire //////////////
  if (install_timer () < 0){
    fprintf (logF , "[ERROR]\n");
    err (allegro_error);
}
////////////// //////////////////////// ////////////////////
fprintf (logF , "[OK]\n");

  filemap = worldmap; /* le filemap */
  
  Map = load_map (filemap); /* chargement du Monde world.map */
#ifdef Dernier
  add_troc_item (OBJ4);
  Map.stage = 344; /* 338*/
  //facilite = 1;
  
  n_crystal= 5; 
  cle_prog = 3;
  Map.prog = 15;//13 (9)

#else

 
  Map.stage = 0;
  Map.prog = 0;
  n_crystal = 0;
#endif
  pp.zleq=0;	
  afilemap = (char *) malloc (256); /* initialisation de afilemap */
  if(!afilemap) err(MEMORY_ERROR);
  
  init_map_image (); /* initialisation des images ***********/

fprintf (logF , "set_gfx_mode (Autodetect,320,200,0,0) color_depth=16... ");


/****************** le mode 320x200x8 , obligatoire ****************/
 set_color_depth (16);
 Init_2xSaI (16);
 FULLSCREEN = 1;
  if (set_gfx_mode (GFX_AUTODETECT,640, 480, 0, 0) < 0){
    fprintf (logF , "[ERROR]\n");
    err (allegro_error);
}
set_alpha_blender ();
fprintf (logF , "[OK]\n");

////////////////////// datafile - obligatoire ! contient toutes les images et tous les sons du jeux ! ///////////////
  /*************** chargement du datafile dans le fichier Exe *******/
fprintf (logF , "load_datafile ... ");
saibuf = create_bitmap (SCREEN_W,SCREEN_H);
buffer2 = create_bitmap (SCREEN_W,SCREEN_H);
if(!buffer2) err("Malloc !");
if(!saibuf) err("Malloc!");

  Data = load_datafile ("#");


  if (!Data)
    {
	 /* si non , dans data.dat */
      Data = load_datafile ("data.dat");

	  /* si non , Erreur ! */
      if (!Data){
        fprintf (logF , "[ERROR]\n");
	err (lang(0)); /* erreur dans le chargement du datafile */
     }
    }

fprintf (logF , "[OK]\n");

fprintf (logF , "install_sound (DIGI_Autodetect,MIDI_Autodetect,) ... ");

///////////////////// le son - pas obligatoire /////////////////
  SOUND_DETECTED = -  
  install_sound (DIGI_AUTODETECT, MIDI_AUTODETECT, argv[0]);
  midi=1;
  sound=1;

  if(SOUND_DETECTED){
	  sound=0;
	  midi=1;
	  SOUND_DETECTED = -install_sound (DIGI_NONE , MIDI_AUTODETECT,argv[0]);
	  if(SOUND_DETECTED){
		  midi=0;
		  sound = 1;
		  SOUND_DETECTED = -install_sound (DIGI_AUTODETECT , MIDI_NONE,argv[0]);
		if(SOUND_DETECTED) {midi=0;sound=0;}
  	  }
  }
  if(midi) fprintf (logF , "[OK midi ,");
  else fprintf (logF , "[ERROR midi ,");
  if(sound) fprintf (logF , "OK sound ]\n");
  else fprintf (logF , "ERROR sound]\n");


 
  /* COULEURS */
  GRIS = makecol(200,200,200);
  BLANC = makecol(255,255,255);
  TRANS_COLOR = makecol(255,0,255);
  /***********/ 
  pp.arg = 0;
  set_vol (255 , 255);
  
  init_monsters (); /* initialisation des monstres */
  
  buffer = create_bitmap (SCREEN_W, SCREEN_H); /* buffer */
  if(!buffer) err(MEMORY_ERROR);
  items = (ITEM *) malloc (sizeof (ITEM) * MAX_ITEMS); /* initilisation des Objet */
  memset (items , 0 , sizeof(ITEM)*MAX_ITEMS);
  if(!items) err(MEMORY_ERROR);

  /************** LES OBJETS **************/
  set_it (I_EPEE, EPEE00, EPEE01);
  set_it (I_GANT, GANT, 0);
  set_it (I_BOTTES, BOTTES, 0);
  set_it (I_GRAPPIN, GRAPPIN0, GRAPPIN1);
  set_it (I_BOOMERANG , GRAPPIN0 , 0);
  set_it (I_FLEURS , FLEUR0 , 0);
  set_it (I_BOMBE,BOMB00,BOMB01);
  set_it (I_FEU,MAGIE0,MAGIE0);
  set_it (I_FEU+1,-1,-1);
  /****************************************/
  
  
  init_persos (); /* initlialisation des villageois , PP ... */

  Map.hqst = -1;

  Map.place = set_place (Map.stage); /* la place en fonction du stage */


  pp.cleboss = 0; /* determine si vous avez la cleboss */

  obj.en = 0;  /* objet.enabled */
  obj.cur = 0; /* objet.current */

  ///////////////////// LOCKEMENT DES VARIABLES COUNTERS ////////////
  LOCK_FUNCTION (handle);
  LOCK_VARIABLE (counter_menu_angle);
  LOCK_VARIABLE (counter_frappe2);
  LOCK_VARIABLE (counter_persos);
  LOCK_VARIABLE (counter_boom);
  LOCK_VARIABLE (counter_script);
  LOCK_VARIABLE (counter_frappe);
  LOCK_VARIABLE (counter_bottes);
  LOCK_VARIABLE (counter_grappin);
  LOCK_VARIABLE (counter_bombe);
  LOCK_VARIABLE (counter_bombe2);
///////////////////////////////////////////////////////////////////
  pp.ep = 0; /* epee */
  pp.pvfrappe=1;
  
  install_int (handle, 1); /* initlialisation de handle */
  text_mode (-1); /* afficher les textes transparents */
  load_all_screen_map ();

/////////////////// initialisation de save ///////////////////
  // addon
#ifdef Dernier

  ADD_ITEM (I_BOTTES);
  ADD_ITEM (I_GRAPPIN);
  ADD_ITEM (I_GANT);
  ADD_ITEM (I_FLEURS);
  ADD_ITEM (I_BOMBE);
  ADD_ITEM (I_FEU);
  PPSURF=1;
  add_troc_item(FLEUR0);
  pp.hpmax = 8;
  pp.hp = 8;
  pp.pvfrappe = 3; /* pouvoir de frappe */
  
  set_pp_epee ();

#endif 
  

	  dern.stage = Map.stage;
	  dern.x = pp.x;
	  dern.y = pp.y;
	  dern.dir = pp.dir;

	  save_init();

	  trans_init(); /* transparent Init */
	  strcpy(get_cur_save(),"Izza");
	  save_game (zero);
           fclose (logF);	  
	   logF=0;
	   init_fonts ();
}

//bye
void
bye (void)
{
  destroy_fonts (sfont);
  alfont_exit ();
  if(logF) {fclose (logF);logF=0;}
  delete_file("zero"); 	
  save_close();      // effacer save
  destroy_persos();  // destroy persos 
  if(changed_obs) {free(changed_obs);changed_obs=0;} /* changer obstacle */
  destroy_monsters(); // effacer les monstres 


  destroy_perso (&pp); // effacer le joueur (pp = personnage principal)

  if (Data){
  	 unload_datafile (Data); // effacer la datafile 
	 Data=0;
  }
  
 destroy_map (&Map); // effacer la map

  if (buffer){
	  destroy_bitmap (buffer); // effacer le buffer
	  buffer=0;
  }
  
  if (afilemap){
    free (afilemap); // effacer afilemap
	afilemap=0;
  }
  if(items){
	free (items);
	items = 0;
 }
 if(buffer2) {
	destroy_bitmap (buffer2);
	buffer2=0;
}
if(saibuf){
	destroy_bitmap (saibuf);
	saibuf =0;
}
  free_lang ();
}
