#ifndef INTERNAL_H
#define INTERNAL_H
/*** fichier header Internal ***/ 
#include <allegro.h>
#include <stdio.h>
#include <string.h>

#include "alfont.h"
#include "2xsai.h"
#include "data.h"

#ifndef NO_MP3
#include <almp3.h>
#include "emp3.h"
#endif

//defines
#define O_POTION 0
#define O_FLECHE 1
#define O_ETHER  2
#define O_FEU    3
#define O_GLACE  4
#define O_FOUDRE 5
/* choix */
int Choix(int x,int y,int max,int ech,int start);
#define ECH_DEFAULT 8
#define CHOIX_DELAY 100


#define MENU_ANGLE_INC 1 // la quantite de de degres de vitesse pour l'image du menu
#define MENU_ANGLE_DELAY 10  // delay de rotation de l'image du menu


//bouttons du jeu/////////
#define BTRIGHT    (key[KEY_RIGHT]  ||  joy[0].stick[0].axis[0].d2)
#define BTLEFT     (key[KEY_LEFT ]  ||  joy[0].stick[0].axis[0].d1)
#define BTUP       (key[KEY_UP   ]  ||  joy[0].stick[0].axis[1].d1)
#define BTDOWN     (key[KEY_DOWN]   ||  joy[0].stick[0].axis[1].d2)
#define BTENTER    (key[KEY_ENTER]  ||  joy[0].button[2].b)
#define BTACTION_A (key[KEY_S]      ||  joy[0].button[0].b)
#define BTACTION_B (key[KEY_D]      ||  joy[0].button[1].b)
#define BTSPACE    (key[KEY_SPACE]  ||  joy[0].button[3].b)
#define BTFULLSCREEN (key[KEY_F11])
#define BTF10 (key[KEY_F10])

//////////////////////////
#define GRAPPIN_VIT 5 // vitesse du grappin en pixel
#define GRAPPIN_DELAY 10 // delay du grappin en miliS
#define BOMBE_EXPLOSE_DELAY 2000 // delay de l'explosement de la bombe

#define T_ZID 3

// objets
#define MAX_ITEMS 13
#define I_EPEE 1
#define I_GANT 2
#define I_BOTTES 3
#define I_GRAPPIN 4
#define I_BOOMERANG 5
#define I_FLEURS 6
#define I_BOMBE 7
#define I_FEU   8
///////////
#define BOOM_VITESSE 20
#define BOOM_VITESSE_ANGLE 20
//SCROLL
////////////objets/////////////
#define OBJ_50ARG   1
#define OBJ_GANTS   2
#define OBJ_CLEBOSS 3
#define OBJ_COEUR   4
#define OBJ_1COEUR  5
#define OBJ_CLEF    6
#define OBJ_25ARG   7
#define OBJ_BOTTES  8
#define OBJ_CLEDONJON 9
#define OBJ_FLEURS  10
#define OBJ_EPEEX 11
#define OBJ_EMERAUDE 12
#define OBJ_BOMBE 13
#define OBJ_MAGIE 14
#define OBJ_GRAPPIN 15
////////////////////
#define worldmap "map/world.map"
#define maison_map "map/maison.map"
#define DELAY_PERSOS 300
#define EPEE_VIT 5
#define EPEE_DELAY 20 // delay de l'epee jette : combien de ZIDS dans EPEE_DELAY

#define ANIM_DELAY 36  // delay entre deux animations du personnage

#define MIDI_VOLUME 255 // le volume du Midi
// fade
#define FADE_ESCALIER_SPEED 20
#define FADE_PORTE_SPEED 40
#define FADE_NORMAL 28
// les genres de Parles dans Vparle
#define PARLE_GAGNE_MONSTRE 0
#define PARLE_PERDU 1
//les genres de script_command
#define SCRIPT_CMD_MARCHER 0
#define SCRIPT_CMD_PARLER  1
/* MONSTRES */
#define NORMAL_MONSTER 0
#define BOSS_MONSTER 1

#define MONSTRE_FRAPPE_PERSO 0
#define PERSO_FRAPPE_MONSTRE 1
//SCRIPT
#define SCRIPT_COUNTER_PTR &counter_script

// ERREURS
#define FILE_ERROR "erreur dans l'ouverture du fichier"
#define MEMORY_ERROR "erreur dans l'allocation memoire"

//STRUCTS

typedef struct MAP {
	unsigned char **obs;
	int w,h,stage,maxlayer,place,prog,hqst,maxstage;
	int maxim;
	int *images,*hbst,**show,*makloub;
}MAP;
typedef struct IA {
		int pouss;
		int lock;
		int avantdir , im1,im2;
		int vit;
		int is_frappe;
		int mode;
		int fois;
}IA;

typedef struct {
	int frappe,frappex,frappey,frapped,frappeim;
}FRAPPE;

typedef struct {
		int frappe,rfrappe;
}ACCORD;
typedef struct PERSO {
	int show;
	int zleq;
	int x,y,anim[4],dir,ep,vit,frvit,delay,hp,hpmax,arg,hqx,hqy,genre,jeter_epee;
	int pc1x,pc1y,pc2x,pc2y;
	int obs1,obs2;
	int pvfrappe;
	int hezz,hezz_obj;
	int cleboss,clef;
	FRAPPE frappe[255];
	int en;
	int maxfrappe;
	int *images;
	char *name;
	int *item;
	int max_items,*items;
	int genre2,w,h;
	IA ia;
	ACCORD accord;
	int bout;
	int vraiOBS;
	BITMAP *perso_bmp;
	int que_grappin;
}PERSO;

typedef struct ITEM {
	int images[4];
	char *name,*info;

}ITEM;

typedef struct OBJ {
	int en,anim,dir,cur,x,y,nx,ny,mode;
	int pc1x,pc2x,pc1y,pc2y;/*bombe*/
	int d;
	double ang;
	int r;
}OBJ;

typedef struct SCRIPT_COMMAND {
		int genre;
		int dir , fois , delay_zid , obs_index , with_rest ;    // MARCHER
		volatile int *counter;
		const char *p1,*p2,*p3,*p4; // PARLER
		void *callback;
		int avant_obs_index;
}SCRIPT_COMMAND;

typedef struct  SCRIPT{
		SCRIPT_COMMAND cmd[255];
		int maxcmd;
		int image_anim[2];
}SCRIPT;

typedef struct {
		void *ptr;
		size_t size;
}SAVE_DATA;

typedef struct {
		int st,layer,pos,val;
}CHANGED_OBS;
typedef struct {
		int stage,x,y,dir;
}DERN;
//EXTERNS
extern int show_bulle;
extern int slot_number;
extern int im_choix;
extern int teleport_x,teleport_y,teleport_stage;
extern  DERN dern;
extern CHANGED_OBS *changed_obs;						
extern int max_changed_obs;
extern int SOUND_DETECTED;
extern char SHOW_PERSO;
extern int cle_prog;
extern int nomarcher,nofrappe;
extern int yes_quit;
extern char *filemap,*afilemap;
extern int noShow;
extern int max_persos;
extern PERSO *persos;
extern volatile int counter_anim,counter_script,counter_grappin,counter_frappe2,counter_menu_angle,counter_bombe,counter_bombe2;
extern int n_crystal;
extern int delay_textanim;
extern PERSO *monsters;
extern int max_monsters;
extern PERSO pp;
extern volatile int counter_frappe,counter_monsters,counter_persos,counter,counter_bottes,counter_boom;
extern MAP Map;
extern DATAFILE *Data;
extern int BOSS;
extern int max_troc;
extern OBJ obj;
extern BITMAP *buffer;
extern ITEM *items;
extern int force_midi,force_midi_stage;
extern int PPSURF;
//INIT
int init_map_image(void);
void init(int argc,char *argv[]);
void bye(void);
void run_game(void);
void handle(void);
void err(char *s);
//MAP
void FORCE_MIDI(int midi,int stage);
int calcul_obs(int w,int px,int py);
int change_obstacle(int st,int layer,int d,int val);
int get_obs(MAP map,int st,int layer,int d);
int stage_to_maison(int st);
MAP load_map(char *file);
int save_map(MAP m,char *file);
int destroy_map(MAP *m);
int load_screen_map(MAP *m,int stage);
void load_all_screen_map(void);
int play_place_midi(int pl);
int set_place(int st);
int map_obs_marcher(MAP *map,int layer_prp,int layer_arp,int obs_index,int dir,int px);
//PLAYER
int iseau(int obs);
void do_obj();
void show_obj(BITMAP *bmp);
int set_troc_item(int d,int val);
int* get_troc();
int ret_troc(int num);
int search_troc_item(int d);
int del_troc_item(int d);
int TROC(int obj_donner,int obj_recevoir);
int clear_anim(PERSO *p);
int ADD_ITEM(int n);
int SET_ITEM(int a,int n);
int clear_bibane(int boutton);
int reshow_bibane(int boutton);
int use_item(int n);
int init_persos(void);
int marcher(int dir);
int hbs(void);
int test(int pcx,int pcy);
int show_persos(BITMAP *bmp);
int anim_persos(void);
int destroy_perso(PERSO *p);
int destroy_persos(void);
int load_screen_persos(void);
int if_collision(BITMAP *b1,BITMAP *b2,int x1,int y1,int x2,int y2);
//MONSTERS
void play_boss_midi();
int boss(int stage);
int destroy_monsters();
int load_screen_monsters(void);
int init_monsters(void);
int zid_monsters(void);
int show_monsters(BITMAP *bmp);
int is_monster(int obs);
int ret_images_monster(int n);

//UTIL
int swapvar(int *p1,int *p2);
int EQUATION_DROITE_X_TO_Y(int x,int xa,int ya,int xb,int yb);
int EQUATION_DROITE_Y_TO_X(int y,int xa,int ya,int xb,int yb);
int coll(int  x1,int y1,int w1,int h1,int x2,int y2,int w2,int h2);
int explosion(int x,int y,int max);
int parle(char *s,char *s2,char *s3,char * index);
int VParle(int genre);
int textanim(BITMAP *bmp,ALFONT_FONT *f,char *s,int x,int y,int c1,int c2,int delay, int dejaespace);
int play_sfx(int n);
//DRAW
int scroll_map(BITMAP *b1,BITMAP *b2,int dir,int fois,int delay);
int menu(void);
int show_map(BITMAP *bmp,MAP m,int layer);
int affiche(BITMAP *bmp);
#define TELEPORT_MAX 500
#define TELEPORT_SIZE 200
#define TELEPORT_COL 0
#define TELEPORT_DELAY 2

#define TELEPORT() teleport(TELEPORT_MAX,TELEPORT_SIZE,TELEPORT_COL,TELEPORT_DELAY)
#define Troc(item1,item2) TROC(item1,item2);fanfare(buffer,item2,pp.x,pp.y)
#define SCRIPT_EXEC(cmd) script_cmd_execute(cmd);\
						ANIMATION();\
						AFFICHE_BLIT();\

#define AFFICHE() affiche(buffer)
#define AFFICHE_BLIT() AFFICHE();BLIT()
#define CALCUL_OBS(px,py) calcul_obs(Map.w,px,py)
#define set_map_image(map,n,v,h,mak) {map.images[n]=v;map.hbst[n]=h;map.makloub[n]=mak;}\


#define set_mons_im(n,v1,v2)mons_im[n][0]=v1;mons_im[n][1]=v2;

#define OBS(x) (pp.obs1==x||pp.obs2==x)
#define setpal set_palette(Data[PAL].dat)
#define FADE(x) highcolor_fade_out(x);setpal
#define ANIMATION() zid_monsters();anim_persos();do_obj()

#define play_nl_midi(midi) play_midi(Data[midi].dat,0)
#define MIDI_FANFARE() play_nl_midi(FANFARE1)
#define MIDI_PLACE() play_place_midi(Map.place)
int HBS(int x,int y,int vit,int d,int *pc1x,int *pc1y,int *pc2x,int *pc2y);

BITMAP *MAKLOUB(BITMAP*);

BITMAP *MAKLOUB2(BITMAP*);

int destroy_item(ITEM *item);
int INC(int j,int w,int *x,int *y);
//SCENARIO
int DONNE_CRYSTAL(int boss);
void PLACE_SCENARIO();
void PORTE_SCENARIO();
void parle_monstre(int donjon_num);
void init_scripts();
//SCRIPT
int script_size(SCRIPT_COMMAND *script);
int script_cmd_size(SCRIPT_COMMAND *cmd);
void init_script(SCRIPT *s,int image);
void set_script_cmd(SCRIPT_COMMAND *cmd,int genre);
void script_cmd_PARLE_set(SCRIPT_COMMAND *cmd,void *callback,const char *s1,const char *s2,const char *s3,const char *s4);
void script_cmd_MARCHER_set(SCRIPT_COMMAND *cmd,int obs_index,int fois,int dir,int delay_zid,volatile int *counter);
void script_add_cmd(SCRIPT *s,int genre);
void script_cmd_execute(SCRIPT_COMMAND *cmd);
void execute_script(SCRIPT_COMMAND script[]);
///////// SAVE //////////////v
void save_init(void);
void save_add_var(SAVE_DATA **data,void *ptr,size_t size,int *max);
void save_game(char *filename);
void load_game(char *filename);
char *get_cur_save ();
int *int_bool_get();
extern int ep;
#define bmp_dup(d,s) blit(d,s,0,0,0,0,SCREEN_W,SCREEN_H)
void my_textout(BITMAP *b,ALFONT_FONT *f,const char *s ,int x,int y,int c1,int c2);
extern int PERDUVAR;
void pres_text(char *text);
void game_time(int *h,int *min,int *sec);
extern volatile long game_counter;
extern int is_game;
char *get_zero ();

/* couleurs */
extern int GRIS , BLANC;
extern int TRANS_COLOR;
extern char *home;
char *get_save();

char *lang (int id);
int init_lang (char *file);
void free_lang();
extern char **language;
extern int FULLSCREEN;
void set_fullscreen ();
extern int nodouble;
/* fonts */
extern ALFONT_FONT *title_font , *game_font , *sfont,*menu_font,*pres_font;
void playmidi (int n);
void set_vol (int,int);
extern int digi_volume , midi_volume;
void highcolor_fade_in(BITMAP *bmp_orig, int speed);
void highcolor_fade_out(int speed);
void BLIT();
void BLIT_HERE(BITMAP *a);
extern int map_w , map_h;
extern BITMAP *buffer2;
extern int SAI;
extern BITMAP *saibuf;
int PERDU_SCENARIO ();
extern int facilite;
#endif
