/* Allegro MP3 - a wrapper for Xing Technology MP3 Decoder */
/* to play MP3 files with Allegro */

/* MP3 decoder is copyright (c) 1995-1997 Xing Technology */
/* Allegro MP3 is copyright (c) 2001 Javier Gonzlez */

/* See COPYING.txt (GNU Lesser General Public License 2.1) for license */


#ifndef ALMP3_H
#define ALMP3_H

#ifdef __cplusplus
extern "C" {
#endif


/* common define */

#define ALMP3_VERSION                1
#define ALMP3_SUB_VERSION            5
#define ALMP3_VERSION_STR            "1.5"
#define ALMP3_DATE_STR               "16/08/2001"
#define ALMP3_DATE                   20010816    /* yyyymmdd */

/* error codes */
                                  
#define ALMP3_OK                     0

#define ALMP3_PLAY_BUFFERTOOSMALL    -1

#define ALMP3_POLL_PLAYJUSTFINISHED  1
#define ALMP3_POLL_NOTPLAYING        -1
#define ALMP3_POLL_FRAMECORRUPT      -2
#define ALMP3_POLL_BUFFERUNDERRUN    -3
#define ALMP3_POLL_INTERNALERROR     -4


/* API - MP3 */

typedef struct MP3 MP3;


MP3 *create_mp3(void *data, int data_len);
void destroy_mp3(MP3 *mp3);

int play_mp3(MP3 *mp3, int buffer_len, int vol, int pan);
int play_ex_mp3(MP3 *mp3, int buffer_len, int vol, int pan, int speed, int loop);
void stop_mp3(MP3 *mp3);
void rewind_mp3(MP3 *mp3);
void seek_abs_frames_mp3(MP3 *mp3, int frame);
void seek_abs_msecs_mp3(MP3 *mp3, int msecs);
void seek_abs_secs_mp3(MP3 *mp3, int secs);
void seek_rel_frames_mp3(MP3 *mp3, int frame);
void seek_rel_msecs_mp3(MP3 *mp3, int msec);
void seek_rel_secs_mp3(MP3 *mp3, int sec);
void adjust_mp3(MP3 *mp3, int vol, int pan, int speed, int loop);

int poll_mp3(MP3 *mp3);
void start_autopoll_mp3(MP3 *mp3, int speed);
void stop_autopoll_mp3(MP3 *mp3);

int mp3_get_pos_frames(MP3 *mp3);
int mp3_get_pos_msecs(MP3 *mp3);
int mp3_get_pos_secs(MP3 *mp3);
int mp3_get_length_frames(MP3 *mp3);
int mp3_get_length_secs(MP3 *mp3);
int mp3_get_length_msecs(MP3 *mp3);
int mp3_get_msecs_per_frame(MP3 *mp3);
int mp3_get_bitrate(MP3 *mp3);
int mp3_get_layer(MP3 *mp3);
int mp3_get_is_stereo(MP3 *mp3);
int mp3_get_wave_bits(MP3 *mp3);
int mp3_get_wave_is_stereo(MP3 *mp3);
int mp3_get_wave_freq(MP3 *mp3);

SAMPLE *create_sample_from_mp3(MP3 *mp3);

void *mp3_get_output_wave(MP3 *mp3, int *buffer_size);

int mp3_is_playing(MP3 *mp3);
int mp3_is_looping(MP3 *mp3);

int mp3_get_volume(MP3 *mp3);
int mp3_get_pan(MP3 *mp3);
void mp3_set_volume(MP3 *mp3, int vol);
void mp3_set_pan(MP3 *mp3, int pan);
void mp3_set_loop(MP3 *mp3, int loop);


/* API - MP3STREAM*/

typedef struct MP3STREAM MP3STREAM;


MP3STREAM *create_mp3stream(void *first_data_buffer, int data_buffer_len, int last_block);
void destroy_mp3stream(MP3STREAM *mp3);

int play_mp3stream(MP3STREAM *mp3, int buffer_len, int vol, int pan);
int play_ex_mp3stream(MP3STREAM *mp3, int buffer_len, int vol, int pan, int speed);
void stop_mp3stream(MP3STREAM *mp3);
void adjust_mp3stream(MP3STREAM *mp3, int vol, int pan, int speed);

int poll_mp3stream(MP3STREAM *mp3);
void start_autopoll_mp3stream(MP3STREAM *mp3, int speed);
void stop_autopoll_mp3stream(MP3STREAM *mp3);
void *get_mp3stream_buffer(MP3STREAM *mp3);
void free_mp3stream_buffer(MP3STREAM *mp3, int bytes_used);

int mp3stream_get_length_frames(MP3STREAM *mp3, int total_size);
int mp3stream_get_length_secs(MP3STREAM *mp3, int total_size);
int mp3stream_get_length_msecs(MP3STREAM *mp3, int total_size);
int mp3stream_get_pos_frames(MP3STREAM *mp3);
int mp3stream_get_pos_msecs(MP3STREAM *mp3);
int mp3stream_get_pos_secs(MP3STREAM *mp3);
int mp3stream_get_msecs_per_frame(MP3STREAM *mp3);
int mp3stream_get_bitrate(MP3STREAM *mp3);
int mp3stream_get_layer(MP3STREAM *mp3);

void *mp3stream_get_output_wave(MP3STREAM *mp3, int *buffer_size);

int mp3stream_is_playing(MP3STREAM *mp3);


#ifdef __cplusplus
}
#endif

#endif
