#include <allegro.h>
#include <alleggl.h>
#include "texture.h"

//Returns the next power of two bigger than the original_num (original number).
int GetNextPowerOfTwo(int original_num);

void TEXTURE::Display(float x, float y)
{
  Bind();
  
  glBegin(GL_QUADS);
		glTexCoord2f(0, 0);
		glVertex3f(x, y, 0);
		glTexCoord2f(GetWidth(), 0);
		glVertex3f(x + img_width, y, 0);
		glTexCoord2f(GetWidth(), GetHeight());
		glVertex3f(x + img_width,  y + img_height, 0);
		glTexCoord2f(0, GetHeight());
		glVertex3f(x,  y + img_height, 0);
	glEnd();
}

void TEXTURE::DisplayMirror(float x, float y)
{
  Bind();
  
  glBegin(GL_QUADS);
		glTexCoord2f(GetWidth(), 0);
		glVertex3f(x, y, 0);
		glTexCoord2f(0, 0);
		glVertex3f(x + img_width, y, 0);
		glTexCoord2f(0, GetHeight());
		glVertex3f(x + img_width,  y + img_height, 0);
		glTexCoord2f(GetWidth(), GetHeight());
		glVertex3f(x,  y + img_height, 0);
	glEnd();
}

void TEXTURE::LoadRawData(const unsigned char *data, int width, int height, 
      bool alpha, bool flip)
{
  BITMAP *new_bitmap; //A new bitmap.
  int color; //Color of each pixel.
  int rgb_counter = 0; //Counts forward for each element.
  
  //Convert that data into an allegro bitmap.
  new_bitmap = create_bitmap_ex(32, width, height);
  
  if(new_bitmap != NULL)
  {
    //Go through each pixel and make the bitmap.
    for(int y = 0; y < height; y++)
    {
      for(int x = 0; x < width; x++)
      {  
        //Create the pixel color.
        if(alpha == true)
        {
          color = makeacol32(data[rgb_counter], data[rgb_counter + 1], 
            data[rgb_counter + 2], data[rgb_counter + 3]);
          rgb_counter+=4;
        }
        else
        {
          color = makeacol32(data[rgb_counter], data[rgb_counter + 1], 
            data[rgb_counter + 2], 255);
          rgb_counter+=3;
        }
        
        //Place it in the new bitmap.
        _putpixel32(new_bitmap, x, y, color);
      }
    }
    
    //Now load the new bitmap as a texture.
    LoadBitmap(new_bitmap, flip);
  }
  
  destroy_bitmap(new_bitmap);
}

void TEXTURE::LoadBitmap(BITMAP *bitmap, bool flip)
{
  BITMAP *texture_bitmap;
  
  if(bitmap)
  {
    //Record the dimentions.
    img_width = bitmap->w;
    img_height = bitmap->h;
    tex_width = GetNextPowerOfTwo(img_width);
    tex_height = GetNextPowerOfTwo(img_height);
    width = static_cast<float>(img_width) / static_cast<float>(tex_width);
    height = static_cast<float>(img_height) / static_cast<float>(tex_height);
    
    //Create a bitmap that's the proper size for a texture.  
    texture_bitmap = create_bitmap_ex(32, tex_width, tex_height);
    
    //Clear it.
    clear_to_color(texture_bitmap, makeacol32(0, 0, 0, 0));
    
    //Now blit the original onto the new texture bitmap.  If we flip, blit to the bottom.
    if(flip)
      blit(bitmap, texture_bitmap, 0, 0, 0, tex_height - img_height, img_width, img_height);
    else
      blit(bitmap, texture_bitmap, 0, 0, 0, 0, img_width, img_height);
    
    //Now create the texture.
    if(flip)
      tex_num = allegro_gl_make_texture_ex(AGL_TEXTURE_HAS_ALPHA | 
        AGL_TEXTURE_MASKED | AGL_TEXTURE_FLIP, texture_bitmap, GL_RGBA);
    else
      tex_num = allegro_gl_make_texture_ex(AGL_TEXTURE_HAS_ALPHA | 
        AGL_TEXTURE_MASKED, texture_bitmap, GL_RGBA);
    
    //Clamp it and set filtering options.
    Bind();
    
    glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
    glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
    glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
    glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
    
    //Clean up the texture.
    destroy_bitmap(texture_bitmap);
  }
}

void TEXTURE::LoadImage(const char *filename, bool flip)
{
  BITMAP *bitmap;
  
  //Load it.
  set_color_conversion(COLORCONV_EXPAND_256);
  bitmap = load_bitmap(filename, NULL);
  
  LoadBitmap(bitmap, flip);
  
  destroy_bitmap(bitmap);
}

void TEXTURE::Bind(void)
{
  glEnable(GL_TEXTURE_2D);
  glBindTexture(GL_TEXTURE_2D, tex_num);
}

float TEXTURE::GetWidth(void)
{
  return width;
}

float TEXTURE::GetHeight(void)
{
  return height;
}

int GetNextPowerOfTwo(int original_num)
{
  int power_of_two;
  
  for(power_of_two = 1; power_of_two < original_num; power_of_two+=power_of_two)
  {
    //Keep increasing until it's equal or bigger than the original number.
  }
  
  return power_of_two;
}
