#ifndef MODEL_H_
#define MODEL_H_

#include "texture.h"

class MODEL
{
  public:
    ~MODEL();
    void Load(const char *filename, TEXTURE *texture_to_use);
    //Loads a mesh.
      //filename: File to load (in msh format).
      //texture_to_use: The texture to use with the mesh.
    void SetTranslation(float x, float y, float z);
    //Sets the translation when displaying.
      //x, y, z - Amount to move in each direction.
    void SetRotation(float x, float y, float z);
    //Sets the rotation (in degrees) for each axis for display.
      //x, y, z: Amount to rotate on each axis.
    void SetScale(float scaling);
    //Scales the model when displaying.
      //scaling: Sets how much to scale the mode.
    void AddTranslation(float x, float y, float z);
    //Adds these to the current values for the rotation.
      //x, y, z: Amount to add to translation
    void AddRotation(float x, float y, float z);
    //Adds these to the current rotation values.
      //x, y, z: Rotation angle for each axis to be added.
    void AddScale(float scaling);
    //Adds to the current scaling power.
      //scaling: Amount to add to scaling.
    void Display(void);
    //Displays the model on the screen.  Make sure it's already in 3D mode.
  private:
    int size; //total number of elements.
    float *data;
    TEXTURE *texture;
    float trans_x, trans_y, trans_z;
    float rot_x, rot_y, rot_z;
    float scale;
};

#endif
