#include <allegro.h>
#include <alleggl.h>
#include <cstdlib>
#include "texture.h"
#include "sound.h"
#include "music.h"
#include "graphics.h"
#include "resources.h"
#include "demoloop.h"
#include "credits.h"

int main() 
{
  DEMOLOOP loop;
  CREDITS credits;
  
  //Seed randomizer.
  srand(time(NULL));
  
  /* Initialize both Allegro and AllegroGL */
	allegro_init();
  graphics.InitGraphics();
  
  //Init Sound.
  sound.InitSound();
	
	/* Tell Allegro we want to use the keyboard */
	install_keyboard();
	
	graphics.Setup2DMode();
	resources.LoadArt();
	graphics.EnableNormalBlending();

  music.LoadMod("data/neko.it");
 
  loop.RunLoop();
  credits.RunCredits();
	
	//Shutdown the sound system.
	music.DestroyMod();
	sound.DestroySound();
	
	/* Finished. */
	return 0;
}
END_OF_MAIN();
