#include <allegro.h>
#include <alleggl.h>
#include <iostream>
#include <fstream>
#include "graphics.h"
#include "music.h"

#define BPS 100

using namespace std;

GRAPHICS graphics;

volatile int counter;

void Timer()
{
  counter++;
  music.Poll();
}
END_OF_FUNCTION(timer)


void GRAPHICS::InitGraphics(void)
{
  bool full_screen = false;
  int x_res = 640; 
  int y_res = 480;
  std::string option;

  //Load options.
  ifstream config_file;
  
  config_file.open("config.cfg");
  
  if(config_file)
  {
    while(!config_file.eof())
    {
      config_file >> option;
      
      if(option == "FULLSCREEN")
        config_file >> full_screen;
      if(option == "XRES")
        config_file >> x_res;
      if(option == "YRES")
        config_file >> y_res;
    }
  }
  
  config_file.close();
  
  install_allegro_gl();
  
  /* Suggest a good screen mode for OpenGL */
	allegro_gl_set(AGL_Z_DEPTH, 8);
	allegro_gl_set(AGL_COLOR_DEPTH, 32);
	allegro_gl_set(AGL_SUGGEST, AGL_Z_DEPTH | AGL_COLOR_DEPTH);

	/* Set the graphics mode */
	if(!full_screen)
	 set_gfx_mode(GFX_OPENGL_WINDOWED, x_res, y_res, 0, 0);
	else
	 set_gfx_mode(GFX_OPENGL_FULLSCREEN, x_res, y_res, 0, 0);
	
	//Set the window title.
	set_window_title("The Seasons");
	
	/* Clear the screen */
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	
	//Init timer.
	frame_time = 0;
	StartFrameTimer();
}

void GRAPHICS::Setup2DMode(void)
{
  glMatrixMode(GL_PROJECTION);
  glDisable(GL_CULL_FACE);
  glDisable(GL_DEPTH_TEST);
	glLoadIdentity();
	glOrtho(0, 640, 480, 0, -1, 1);
	glMatrixMode(GL_MODELVIEW);
  glEnable(GL_NORMALIZE);
  glLoadIdentity();
  
  glDisable(GL_LIGHT0);
  glDisable(GL_LIGHTING);
}

void GRAPHICS::Setup3DMode(float ambient, float diffuse, float specular, float alpha)
{
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  glFrustum(-1.0, 1.0, -0.75, 0.75, 1, 60.0);
	glDisable(GL_CULL_FACE);
  glEnable(GL_DEPTH_TEST);
  glMatrixMode(GL_MODELVIEW);
  glEnable(GL_NORMALIZE);
  glLoadIdentity();
  
  
  GLfloat light_ambient[] = {ambient, ambient, ambient, alpha};
  GLfloat light_diffuse[] = {diffuse, diffuse, diffuse, alpha};
  GLfloat light_specular[] = {specular, specular, specular, alpha};
      
  glLightfv(GL_LIGHT0, GL_AMBIENT, light_ambient);
  glLightfv(GL_LIGHT0, GL_DIFFUSE, light_diffuse);
  glLightfv(GL_LIGHT0, GL_SPECULAR, light_specular);

  int on = 1;

  glEnable(GL_LIGHT0);
  glEnable(GL_LIGHTING);
  glLightModeliv(GL_LIGHT_MODEL_TWO_SIDE, &on);
}

void GRAPHICS::EnableNormalBlending(void)
{
  glEnable(GL_BLEND);
  glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA); 
}

void GRAPHICS::EnableAdditiveBlending(void)
{
  glEnable(GL_BLEND);
  glBlendFunc(GL_SRC_ALPHA, GL_ONE); 
}

void GRAPHICS::DisableBlending(void)
{
  glDisable(GL_BLEND);
}

void GRAPHICS::DisableTextures(void)
{
  glDisable(GL_TEXTURE_2D);
}

void GRAPHICS::FlipScreen(void)
{
  allegro_gl_flip();
  
  //Now check the timer.
  while(counter == 0)
  {
    rest(1);
  }
  frame_time = static_cast<float>(counter) / static_cast<float>(BPS);
  counter = 0;
  
  glClear(GL_COLOR_BUFFER_BIT);
  glClear(GL_DEPTH_BUFFER_BIT);
}

void GRAPHICS::StartFrameTimer(void)
{
  install_timer();
  counter = 0;
  
  LOCK_VARIABLE(counter);
  LOCK_FUNCTION(Timer);

  //Timer gets called 100 times a second.
  install_int_ex(&Timer, BPS_TO_TIMER(BPS));
}

float GRAPHICS::FrameTime(void)
{
  return frame_time;
}

void GRAPHICS::ResetTimer(void)
{
  frame_time = 0;
  counter = 0;
}
