#include "demoloop.h"
#include "resources.h"
#include "graphics.h"
#include "model.h"
#include "butterfly.h"
#include "music.h"

bool go_next_scene;

void DEMOLOOP::RunLoop(void)
{
  BUTTERFLY butterfly;
  bool draw_far_first;
  float rot_x = 0;
  float up_amount = 5.0;
  quit = false;
  go_next_scene = false;
  
  fading_out = false;
  fading_in = true;
  fading_white_in = false;
  fading_white_out = false;
  fade_alpha = .8;
  
  state = SPRING;
  
  snow.RandomizeAll();
  leaves.RandomizeAll();
  ball.InitBall();
  butterflies.RandomizeAll();
  butterfly.SetUp(0.30);
  
  music.PlayMod();
  graphics.ResetTimer();
  
  while(!keypressed() && !quit)
  {
    if(state == SPRING)
      ShowSpring(255);
      
    if(state == SUMMER)
      ShowSummer(255);
      
    if(state == FALL)
      ShowFall(255);
    
    if(state == WINTER)
      ShowWinter(255);
    
    glColor4ub(255, 255, 255, 255);
    resources.window.Display(0,0);
    
    if(state == SPRING)
      resources.cat.Display(120, 325);
      
    if(state == SUMMER)
      resources.cat_sleep.Display(100, 420);
      
    if(state == FALL)
      resources.cat.DisplayMirror(390, 330);
    
    if(state == WINTER)
      resources.cat.Display(120, 325);
    
    //Fading stuff.
    if(fading_in)
    {
      fade_alpha+= -FADE_IN_SPEED * graphics.FrameTime();
      
      if(fade_alpha <= 0)
        fading_in = false;
      else
        FadeOut(fade_alpha);
    }
    if(fading_out)
    {
      fade_alpha+= FADE_IN_SPEED * graphics.FrameTime();
      
      if(fade_alpha >= 1)
      {
        quit = true;
        fading_in = false;
        FadeOut(1.0);
      }
      else
        FadeOut(fade_alpha);
    }
    if(fading_white_in)
    {
      fade_alpha+= FADE_WHITE_IN_SPEED * graphics.FrameTime();
      if(fade_alpha >= 1.0)
      {
        if(state == SPRING)
          state = SUMMER;
        else if(state == SUMMER)
          state = FALL;
        else if(state == FALL)
          state = WINTER;
        fading_white_in = false;
        fade_alpha = 1;
        fading_white_out = true;
      }
      else
        FadeWhite(fade_alpha);
    }
    if(fading_white_out)
    {
      fade_alpha+= -FADE_WHITE_IN_SPEED * graphics.FrameTime();
      if(fade_alpha <= 0)
      {
        fading_white_out = false;
      }
      else
        FadeWhite(fade_alpha);
    }
    
    if(go_next_scene == true)
    {      
      go_next_scene = false;
      NextScene();
    }
    
    graphics.FlipScreen();
    poll_keyboard();
    //music.Poll();
  }
}

void DEMOLOOP::ShowSpring(unsigned char alpha)
{
  glColor4ub(255, 255, 255, alpha);
  resources.spring.Display(0,0);
  butterflies.UpdateButterflies();
  butterflies.DrawButterflies();
}

void DEMOLOOP::ShowSummer(unsigned char alpha)
{
  glColor4ub(255, 255, 255, alpha);
  resources.summer.Display(0,0);
  ball.Display(alpha);
  ball.Update();
}

void DEMOLOOP::ShowFall(unsigned char alpha)
{
  glColor4ub(255, 255, 255, alpha);
  resources.fall.Display(0,0);
  leaves.Display(alpha);
  leaves.Update();
}

void DEMOLOOP::ShowWinter(unsigned char alpha)
{
  glColor4ub(255, 255, 255, alpha);
  resources.winter.Display(0,0);
  snow.DisplayAll(alpha);
  snow.Update(graphics.FrameTime());
}

void DEMOLOOP::FadeOut(float amount)
{
  graphics.DisableTextures();
  
  glColor4f(0, 0, 0, amount);
  
  glBegin(GL_QUADS);
    glVertex3f(0, 0, 0);
    glVertex3f(640, 0, 0);
    glVertex3f(640, 480, 0);
    glVertex3f(0, 480, 0);
  glEnd();
}

void DEMOLOOP::FadeWhite(float amount)
{
  graphics.DisableTextures();
  
  glColor4f(1, 1, 1, amount);
  
  graphics.EnableAdditiveBlending();
  
  glBegin(GL_QUADS);
    glVertex3f(0, 0, 0);
    glVertex3f(640, 0, 0);
    glVertex3f(640, 480, 0);
    glVertex3f(0, 480, 0);
  glEnd();
  
  graphics.EnableNormalBlending();
}

void DEMOLOOP::NextScene(void)
{
  if(state == SPRING)
  {
     fade_alpha = 0;
     fading_white_in = true;
  }
  else if(state == SUMMER)
  {
     fade_alpha = 0;
     fading_white_in = true;
  }
  else if(state == FALL)
  {
     fade_alpha = 0;
     fading_white_in = true;
  }
  else
  {
    fading_out = true;
    fade_alpha = 0;
  }
}

void TriggerNextScene(void)
{
  go_next_scene = true;
}
