#include "credits.h"
#include "graphics.h"
#include "resources.h"
#include "music.h"

#define END_FADOUT_SPEED 0.2
#define CREDITS_SPEED 30

void CREDITS::RunCredits(void)
{
  ShowTheEnd();
  RollCredits();
  Thanks();
}

void CREDITS::ShowTheEnd(void)
{
  float alpha = 0.99;
  bool fading_out = true;
  
  graphics.ResetTimer();
  
  while(!keypressed() && alpha <= 1.0)
  {
    glColor4f(1.0, 1.0, 1.0, 1.0);
    resources.the_end_text.Display(160, 200);
    
    graphics.EnableNormalBlending();
    BlackScreen(alpha);
    
    if(fading_out == true)
    {
      alpha+= -END_FADOUT_SPEED * graphics.FrameTime();
      if(alpha <= 0)
      {
        fading_out = false;
        alpha = 0;
      }
    }
    else
    {
      alpha+= END_FADOUT_SPEED * graphics.FrameTime();
    }
    graphics.FlipScreen();
    poll_keyboard();
  }
}

void CREDITS::RollCredits(void)
{
  float position = 500;
  while(!keypressed() && position > -250)
  {
    position+= -CREDITS_SPEED * graphics.FrameTime();
    glColor4f(1.0, 1.0, 1.0, 1.0);
    resources.credits_text.Display(65, position);
    graphics.FlipScreen();
    poll_keyboard();
  }
}

void CREDITS::Thanks(void)
{
  float music_vol = 1.0;
  float alpha = 1.0;
  
  while(!keypressed() && music_vol > 0)
  {
    glColor4f(1.0, 1.0, 1.0, 1.0);
    resources.credits_thanks.Display(162, 188);
    
    if(alpha > 0)
    {
      BlackScreen(alpha);
      alpha+= -END_FADOUT_SPEED * graphics.FrameTime();
    }
    
    music.SetVolume(music_vol);
    music_vol+= -0.1 * graphics.FrameTime();
    
    graphics.FlipScreen();
    poll_keyboard();
  }
}

void CREDITS::BlackScreen(float alpha)
{
  graphics.DisableTextures();
  
  glColor4f(0, 0, 0, alpha);
  
  glBegin(GL_QUADS);
    glVertex3f(0, 0, 0);
    glVertex3f(640, 0, 0);
    glVertex3f(640, 480, 0);
    glVertex3f(0, 480, 0);
  glEnd();
}
