#include "ball.h"
#include "resources.h"
#include "graphics.h"

void BALL::InitBall(void)
{
  ball.Load("data/ball.msh", &resources.ball_tex);
  ResetLeftSide();
  ball.SetScale(BALL_SCALE);
}

void BALL::Display(unsigned char alpha)
{ 
  graphics.Setup3DMode(1.0, 1.0, 1.0, static_cast<float>(alpha) / 255.0);
  graphics.EnableNormalBlending();
  ball.Display();
  graphics.Setup2DMode();
}

void BALL::ResetLeftSide(void)
{
  ball.SetTranslation(-12, -7, -5);
  x_vec = (rand() % (BALL_X_VEC_MAX - BALL_X_VEC_MIN) + BALL_X_VEC_MIN);
  y_vec = BALL_Y_VEC_MAX;
  y_accel = -2.2;
  
  ball.SetRotation(0, 0, 0);
  x_spin = rand() % (BALL_X_SPIN_MAX - BALL_X_SPIN_MIN) + BALL_X_SPIN_MIN;
  y_spin = rand() % (BALL_Y_SPIN_MAX - BALL_Y_SPIN_MIN) + BALL_Y_SPIN_MIN;
  z_spin = rand() % (BALL_Z_SPIN_MAX - BALL_Z_SPIN_MIN) + BALL_Z_SPIN_MIN;
}

void BALL::ResetRightSide(void)
{
  ball.SetTranslation(12, -7, -5);
  x_vec = -(rand() % (BALL_X_VEC_MAX - BALL_X_VEC_MIN) + BALL_X_VEC_MIN);
  y_vec = BALL_Y_VEC_MAX;
  y_accel = -2.2;
  
  ball.SetRotation(0, 0, 0);
  x_spin = -(rand() % (BALL_X_SPIN_MAX - BALL_X_SPIN_MIN) + BALL_X_SPIN_MIN);
  y_spin = -(rand() % (BALL_Y_SPIN_MAX - BALL_Y_SPIN_MIN) + BALL_Y_SPIN_MIN);
  z_spin = -(rand() % (BALL_Z_SPIN_MAX - BALL_Z_SPIN_MIN) + BALL_Z_SPIN_MIN);
}

void BALL::Update(void)
{
  ball.AddTranslation(x_vec * graphics.FrameTime(), y_vec * graphics.FrameTime(),
    0);
  
  ball.AddRotation(x_spin * graphics.FrameTime(),
    y_spin * graphics.FrameTime(), z_spin * graphics.FrameTime());
  
  y_vec+= (y_accel * graphics.FrameTime());
  
  if(y_vec < -5 && x_vec > 0)
  {
    ResetRightSide();
  }
  if(y_vec < -5 && x_vec < 0)
  {
    ResetLeftSide();
  }
}
