#ifndef GRAPHICS_H_
#define GRAPHICS_H_

class GRAPHICS
{
  public:
    //Initialize the graphics engine
    void InitGraphics(void);
    //Set up a 2D orthographic matrix.
    static void Setup2DMode(void);
    static void Setup3DMode(float ambient, float diffuse, float specular, float alpha);
    //Sets up a 3D frustrum.
    //Turn on normal alpha blending.
    static void EnableNormalBlending(void);
    //Turn on additive blending.
    static void EnableAdditiveBlending(void);
    //Disable all blenidng.
    static void DisableBlending(void);
    //Disable the use of all textures.
    static void DisableTextures(void);  
    //Flip the screen.
    void FlipScreen(void);
    float FrameTime(void);
    //Returns the frame time.
    void ResetTimer(void);
    //Resets the timer in case there was a long wait between screen updates.
  private:
    void StartFrameTimer(void);
    float frame_time;
};

extern GRAPHICS graphics;

#endif
