#include "snow.h"
#include "resources.h"

void SNOW::RandomizeAll(void)
{
  int index;
  
  for(index = 0; index < MAX_FLAKES; index++)
  {
    flakes[index].x = rand() % 640;
    flakes[index].y = rand() % 480;
    flakes[index].speed = (rand() % (MAX_SPEED - MIN_SPEED)) + MIN_SPEED;
  }
}

void SNOW::DisplayAll(unsigned char alpha)
{
  glColor4ub(255, 255, 255, alpha);
  
  int index;
  
  for(index = 0; index < MAX_FLAKES; index++)
  {
    resources.snow.Display(flakes[index].x, flakes[index].y);
  }
}

void SNOW::Update(float frame_time)
{
  int index;
  
  for(index = 0; index < MAX_FLAKES; index++)
  {
    flakes[index].y += (frame_time * flakes[index].speed);
    
    if(flakes[index].y > 480)
      ResetAboveScreen(index);
  }
}

void SNOW::ResetAboveScreen(int index)
{
  flakes[index].y = (-5) - (rand() % 15);
  flakes[index].x = flakes[index].x = rand() % 640;
  flakes[index].speed = (rand() % (MAX_SPEED - MIN_SPEED)) + MIN_SPEED;
}
