#include <cstdlib>
#include <cstdio>
#include "music.h"
#include "demoloop.h"

MUSIC music;

MUSIC::MUSIC()
{
  mod = NULL;
  player = NULL;
}

MUSIC::~MUSIC()
{
}

void MUSIC::Init(void)
{
  std::atexit(&dumb_exit);
  dumb_register_stdfiles();
  install_sound(DIGI_AUTODETECT, MIDI_NONE, NULL);
}

void MUSIC::LoadMod(const char *filename)
{
  DestroyMod();
  mod = dumb_load_it(filename);
}

void MUSIC::PlayMod(void)
{
  StopMod();
  DUH_SIGRENDERER *sr = duh_start_sigrenderer(mod, 0, 2, 0);
  if (sr == NULL) return;
  DUMB_IT_SIGRENDERER *itsr = duh_get_it_sigrenderer(sr);
  dumb_it_set_midi_callback(itsr, MidiCallback, NULL);
  //dumb_it_set_loop_callback(itsr, LoopCallback, NULL);
  player = al_duh_encapsulate_sigrenderer(sr, 1.0f, 4096, 44100);
  if (player == NULL) duh_end_sigrenderer(sr);
}

void MUSIC::StopMod(void)
{
  al_stop_duh(player);
  player = NULL;
}

void MUSIC::DestroyMod(void)
{
  StopMod();
  unload_duh(mod);
  mod = NULL;
}

void MUSIC::Poll(void)
{
  al_poll_duh(player);
}

int MUSIC::MidiCallback(void *data, int channel, unsigned char byte)
{
  if (byte == 0x90) {
    //Spring...
    TriggerNextScene();
    return 1;
  }
  if (byte == 0x91) {
    //Summer
    TriggerNextScene();
    return 1;
  }
  if (byte == 0x92) {
    //Fall
    TriggerNextScene();
    return 1;
  }
  if (byte == 0x93) {
    //Winter.
    TriggerNextScene();
    return 1;
  }
  //TODO: other events likewise - I'll tell you what numbers to use :)
  return 0;
}

int MUSIC::LoopCallback(void *data)
{
  //TODO: set a flag telling the program to exit
  TriggerNextScene();
  return 1;
}

void MUSIC::SetVolume(float vol)
{
  al_duh_set_volume(player, vol);
}
