#ifndef _LEAVES_H_
#define _LEAVES_H_

#include "model.h"

#define MAX_LEAVES 60
#define LEAF_SCALE 0.25
#define MIN_X_SPEED 1
#define MAX_X_SPEED 2
#define MIN_Y_SPEED 1
#define MAX_Y_SPEED 2
#define MIN_Z_SPEED 1
#define MAX_Z_SPEED 2
#define MIN_X_ROT_SPEED 40
#define MAX_X_ROT_SPEED 80
#define MIN_Y_ROT_SPEED 40
#define MAX_Y_ROT_SPEED 80
#define MIN_Z_ROT_SPEED 40
#define MAX_Z_ROT_SPEED 80

typedef struct LEAF
{
  float x, y, z;
  float rot_x, rot_y, rot_z;
  float x_vec, y_vec, z_vec;
  float rot_x_vec, rot_y_vec, rot_z_vec;
} LEAF;

class LEAVES
{
  public:
    void RandomizeAll(void);
    //Randomizes the positions of all the leaves and loads the leaf model.
    void Display(unsigned char alpha);
    //Displays all the leaves on the screen.
    void Update(void);
    //Updates the location and rotation of all the leaves.
  private:
    void ResetLeaf(int index);
    LEAF leaf[MAX_LEAVES];
    MODEL leaf_model;
};

#endif
