#include "leaves.h"
#include "resources.h"
#include "graphics.h"

void LEAVES::RandomizeAll(void)
{
  leaf_model.Load("data/leaf.msh", &resources.leaf_tex);
  for(int index = 0; index < MAX_LEAVES; index++)
  {
    //Location.
    leaf[index].x = (rand() % 20) - 10;
    leaf[index].y = (rand() % 14) - 7;
    leaf[index].z = (rand() % 4) - 10;
    
    //Rotation
    leaf[index].rot_x = (rand() % 360);
    leaf[index].rot_y = (rand() % 360);
    leaf[index].rot_z = (rand() % 360);
    
    //Location movement per second
    leaf[index].x_vec = ((rand() % (MAX_X_SPEED - MIN_X_SPEED)) + MIN_X_SPEED);
    leaf[index].y_vec = -((rand() % (MAX_Y_SPEED - MIN_Y_SPEED)) + MIN_Y_SPEED);
    leaf[index].z_vec = -((rand() % (MAX_Z_SPEED - MIN_Z_SPEED)) + MIN_Z_SPEED) / 2.0;
    
    //Rotation movement per second
    leaf[index].rot_x_vec = ((rand() % (MAX_X_ROT_SPEED - MIN_X_ROT_SPEED)) + MIN_X_ROT_SPEED);
    leaf[index].rot_y_vec = -((rand() % (MAX_Y_ROT_SPEED - MIN_Y_ROT_SPEED)) + MIN_Y_ROT_SPEED);
    leaf[index].rot_z_vec = -((rand() % (MAX_Z_ROT_SPEED - MIN_Z_ROT_SPEED)) + MIN_Z_ROT_SPEED);
  }
}

void LEAVES::Display(unsigned char alpha)
{
  leaf_model.SetScale(LEAF_SCALE);
  
  for(int index = 0; index < MAX_LEAVES; index++)
  {
    graphics.Setup3DMode(1.0, 0.5, 0.5, static_cast<float>(alpha) / 255.0);
    graphics.EnableNormalBlending();
    leaf_model.SetTranslation(leaf[index].x, leaf[index].y, leaf[index].z);
    leaf_model.SetRotation(leaf[index].rot_x, leaf[index].rot_y, leaf[index].rot_z);
    leaf_model.Display();
    graphics.Setup2DMode();
  }
}

void LEAVES::Update(void)
{
  for(int index = 0; index < MAX_LEAVES; index++)
  {
    leaf[index].x+=(leaf[index].x_vec * graphics.FrameTime());
    leaf[index].y+=(leaf[index].y_vec * graphics.FrameTime());
    leaf[index].z+=(leaf[index].z_vec * graphics.FrameTime());
    
    leaf[index].rot_x+=(leaf[index].rot_x_vec * graphics.FrameTime());
    leaf[index].rot_y+=(leaf[index].rot_y_vec * graphics.FrameTime());
    leaf[index].rot_z+=(leaf[index].rot_z_vec * graphics.FrameTime());
    
    if(leaf[index].x >= 14 || leaf[index].y <= -14)
      ResetLeaf(index);
  }
}

void LEAVES::ResetLeaf(int index)
{
  leaf[index].x = (rand() % 5) - 10;
  leaf[index].y = (rand() % 10);
  leaf[index].z = (rand() % 2) - 6;
}
