#include "butterfly.h"
#include "resources.h"
#include "graphics.h"

void BUTTERFLY::Draw(void)
{
  bool draw_far_first;
  float width = 1.0 - up;  //How far apart the wings are (actually on x axis).
  float height = up * .6; //How high the wings are (on the y axis).
  
  //graphics.DisableTextures();
  resources.butterfly_tex.Bind();
  
  glLoadIdentity();
  
  glTranslatef(trans_x, trans_y, trans_z);
  glRotatef(rot_y, 0, 1.0, 0);
  glScalef(scale, scale, scale);
  
  glDisable(GL_DEPTH_TEST);
  
  if(((int)rot_y % 360) > 90 && ((int)rot_y % 360) < 270)
  {
     draw_far_first = true;
  }
  else
  {
     draw_far_first = false;
  }
  
  if(draw_far_first)
  {
    glBegin(GL_QUADS);
      //Draw 2 quads.
    
      //Starting far quad.
      glNormal3f(0, 1.0 - up, -up);
      glTexCoord2f(1.0, 0);
      glVertex3f(-0.5, height / 2.0, -(width / 2.0));
      glTexCoord2f(1.0, 1.0);
      glVertex3f(0.5, height / 2.0, -(width / 2.0));
      glTexCoord2f(0.5, 1.0);
      glVertex3f(0.5, -(height / 2.0), 0);
      glTexCoord2f(0.5, 0);
      glVertex3f(-0.5, -(height / 2.0), 0);
    
      //Near quad.
      glNormal3f(0, 1.0 - up, up);
      glTexCoord2f(0.5, 1.0);
      glVertex3f(0.5, -(height / 2.0), 0);
      glTexCoord2f(0, 1.0);
      glVertex3f(0.5, height / 2.0, (width / 2.0));
      glTexCoord2f(0, 0.0);
      glVertex3f(-0.5, height / 2.0, (width / 2.0));
      glTexCoord2f(0.5, 0);
      glVertex3f(-0.5, -(height / 2.0), 0);
    glEnd();
  }
  else
  {
    glBegin(GL_QUADS);
      //Draw 2 quads.
    
      //Near quad.
      glNormal3f(0, 1.0 - up, up);
       glTexCoord2f(0.5, 1.0);
      glVertex3f(0.5, -(height / 2.0), 0);
      glTexCoord2f(0, 1.0);
      glVertex3f(0.5, height / 2.0, (width / 2.0));
      glTexCoord2f(0, 0.0);
      glVertex3f(-0.5, height / 2.0, (width / 2.0));
      glTexCoord2f(0.5, 0);
      glVertex3f(-0.5, -(height / 2.0), 0);
      
      //Starting far quad.
      glNormal3f(0, 1.0 - up, -up);
      glTexCoord2f(1.0, 0);
      glVertex3f(-0.5, height / 2.0, -(width / 2.0));
      glTexCoord2f(1.0, 1.0);
      glVertex3f(0.5, height / 2.0, -(width / 2.0));
      glTexCoord2f(0.5, 1.0);
      glVertex3f(0.5, -(height / 2.0), 0);
      glTexCoord2f(0.5, 0);
      glVertex3f(-0.5, -(height / 2.0), 0);
    glEnd();
  }
  
  glLoadIdentity();
  
  glEnable(GL_DEPTH_TEST);
}

void BUTTERFLY::SetYRot(float y)
{
  rot_y = y; 
}

void BUTTERFLY::SetTranslation(float x, float y, float z)
{
  trans_x = x;
  trans_y = y;
  trans_z = z;
}

void BUTTERFLY::SetScale(float scaling)
{
  scale = scaling;
}

void BUTTERFLY::SetUp(float wings_up)
{
  up = wings_up;
  FixUp();
}

void BUTTERFLY::AddYRot(float y)
{
  rot_y+=y;
}

void BUTTERFLY::AddTranslation(float x, float y, float z)
{
  trans_x+=x;
  trans_y+=y;
  trans_z+=z;
}

void BUTTERFLY::AddUp(float wings_up)
{
  up += wings_up;
  FixUp();
}

float BUTTERFLY::GetUp(void)
{
  return up;
}

void BUTTERFLY::FixUp(void)
{ 
  if(up > 1.0)
  {
    up = up = 1.0;
  }
  else if(up < 0)
  {
    up = 0;
  }
}

float BUTTERFLY::GetX(void)
{
  return trans_x;
}

float BUTTERFLY::GetY(void)
{
  return trans_y;
}

float BUTTERFLY::GetZ(void)
{
  return trans_z;
}
