#ifndef _BUTTERFLIES_H_
#define _BUTTERFLIES_H_

#include "butterfly.h"

#define MAX_BUTTERFLIES 12
#define BUTTERFLY_SCALE 0.4
#define BUTTERFLY_X_MIN -7
#define BUTTERFLY_X_MAX 7
#define BUTTERFLY_Y_MIN -7
#define BUTTERFLY_Y_MAX 7
#define BUTTERFLY_Z_MIN -10
#define BUTTERFLY_Z_MAX -4
#define BUTTERFLY_SPPED 0.5
#define FLUTTER_SPEED 8
#define MAX_FLUTTER 0.9
#define MIN_FLUTTER 0.1

typedef struct BUTTERFLY_AI
{
  float target_x, target_y, target_z;
  float fluttering_speed;
} BUTTERFLY_AI;

class BUTTERFLIES
{
  public:
    void DrawButterflies(void);
    //Draws all the butterflies.
    void UpdateButterflies(void);
    //Updates the butterfly AI and positions.
    void RandomizeAll(void);
    //Randomizes all the butterflies.
    void FindNewDestination(int index);
  private:
    BUTTERFLY butterfly[MAX_BUTTERFLIES];
    BUTTERFLY_AI ai[MAX_BUTTERFLIES];
};

#endif
