#ifndef _TEXTURE_H_
#define _TEXTURE_H_

#include <allegro.h>
#include <alleggl.h>

class TEXTURE
{
  public:
    void Display(float x, float y);
    //Displays the texture as a sprite.
      //x, y - Coordinates to place on the screen.
    void DisplayMirror(float x, float y);
    void LoadRawData(const unsigned char *data, int width, int height, 
      bool alpha, bool flip);
    //Loads raw data as a texture.
      //data - Data to load.
      //width - Width of the bitmap.
      //height - Height of the bitmap.
      //alpha - True if there's an alpha channel.
      //flip - True to flip the final image.
      
    void LoadBitmap(BITMAP *bitmap, bool flip = false);
    //Loads an allegro bitmap as a texture.
      //bitmap - Bitmap to load.
      //flip - True to flip the image.
    
    void LoadImage(const char *filename, bool flip = false);
    //Loads an image from a file.
      //filename - Filename to load.
      //flip - true to flip the final image.
    
    void Bind(void);
    //Binds the texture for use and also tells OpenGL to use texturing.
    
    float GetWidth(void);
    float GetHeight(void);
    //Returns the max height / width for the texture as a number between 0 and 1.
  private:
    GLuint tex_num; //OpenGL Texture Number.
    int img_width, img_height; //Image dimentions.
    int tex_width, tex_height; //Texture dimentions (power of two).
    float width, height; //The relative widths for the texture coordinates.
};

#endif
