#include <allegro.h>
#include <alleggl.h>
#include <iostream>
#include <fstream>
#include "model.h"

using namespace std;

MODEL::~MODEL()
{
  delete[] data;
}

void MODEL::Load(const char *filename, TEXTURE *texture_to_use)
{
  ifstream in_file;
  
  size = 0;
  texture = texture_to_use;
  
  in_file.open(filename);
  
  if(in_file)
  {
    in_file >> size;
    
    data = new float[size * 8];
    
    for(int index = 0; index < (size * 8); index++)
    {
      in_file >> data[index];
    }
  }
  
  SetTranslation(0, 0, 0);
  SetRotation(0, 0, 0);
  scale = 1.0;
  in_file.close();
}

void MODEL::Display(void)
{
  glLoadIdentity();
  
  glTranslatef(trans_x, trans_y, trans_z);
  glRotatef(rot_z, 0, 0, 1.0);
  glRotatef(rot_y, 0, 1.0, 0);
  glRotatef(rot_x, 1.0, 0, 0);
  glScalef(scale, scale, scale);
  
  texture->Bind();
  
  glInterleavedArrays(GL_T2F_N3F_V3F, 0, data);
  glDrawArrays(GL_TRIANGLES, 0, size);
  
  glLoadIdentity();
}

void MODEL::SetTranslation(float x, float y, float z)
{
  trans_x = x;
  trans_y = y;
  trans_z = z;
}

void MODEL::SetRotation(float x, float y, float z)
{
  rot_x = x;
  rot_y = y;
  rot_z = z;
}

void MODEL::SetScale(float scaling)
{
  scale = scaling;
}

void MODEL::AddTranslation(float x, float y, float z)
{
  trans_x+=x;
  trans_y+=y;
  trans_z+=z;
}

void MODEL::AddRotation(float x, float y, float z)
{
  rot_x+=x;
  rot_y+=y;
  rot_z+=z;
}

void MODEL::AddScale(float scaling)
{
  scale+=scaling;
}
