#include <cstdlib>
#include <cmath>
#include "butterflies.h"
#include "graphics.h"

void BUTTERFLIES::DrawButterflies(void)
{
  float x_distance;
  float z_distance;
  float new_angle;
  
  graphics.Setup3DMode(1.0, 1.0, 1.0, 1.0);
  
  for(int index = 0; index < MAX_BUTTERFLIES; index++)
  {
    x_distance = ai[index].target_x - butterfly[index].GetX();
    z_distance = ai[index].target_z - butterfly[index].GetZ();
    
    new_angle = z_distance * 40;
    if(x_distance > 0)
    {
      new_angle = 180 - z_distance * 40;
    }
    
    //new_angle = asin(z_distance / x_distance) * (57.2957795);
    //new_angle = 0;
    butterfly[index].SetYRot(new_angle);
    //butterfly[index].SetYRot(0);
    butterfly[index].Draw();
  }
  
  graphics.Setup2DMode();
}

void BUTTERFLIES::RandomizeAll(void)
{
  for(int index = 0; index < MAX_BUTTERFLIES; index++)
  {
    float new_x, new_y, new_z;
    
    //Random wing location
    butterfly[index].SetUp((float)(rand() % 50) / 50);
    if((rand() % 2) == 1)
      ai[index].fluttering_speed = FLUTTER_SPEED;
    else
      ai[index].fluttering_speed = -FLUTTER_SPEED;
    
    //Random actual location.
    new_x = (rand() % (BUTTERFLY_X_MAX - BUTTERFLY_X_MIN)) + BUTTERFLY_X_MIN;
    new_y = (rand() % (BUTTERFLY_Y_MAX - BUTTERFLY_Y_MIN)) + BUTTERFLY_Y_MIN;
    new_z = (rand() % (BUTTERFLY_Z_MAX - BUTTERFLY_Z_MIN)) + BUTTERFLY_Z_MIN;
    butterfly[index].SetTranslation(new_x, new_y, new_z);
    
    //Set the scaling for all of them.
    butterfly[index].SetScale(BUTTERFLY_SCALE);
    
    //Set AI variables.
    FindNewDestination(index);
  }
}

void BUTTERFLIES::FindNewDestination(int index)
{
  ai[index].target_x = (rand() % (BUTTERFLY_X_MAX - BUTTERFLY_X_MIN)) + BUTTERFLY_X_MIN;
  ai[index].target_y = (rand() % (BUTTERFLY_Y_MAX - BUTTERFLY_Y_MIN)) + BUTTERFLY_Y_MIN;
  ai[index].target_z = (rand() % (BUTTERFLY_Z_MAX - BUTTERFLY_Z_MIN)) + BUTTERFLY_Z_MIN;
}

void BUTTERFLIES::UpdateButterflies(void)
{
  for(int index = 0; index < MAX_BUTTERFLIES; index++)
  {
    //Update the x position.
    if(butterfly[index].GetX() < ai[index].target_x)
    {
      butterfly[index].AddTranslation(BUTTERFLY_SPPED * graphics.FrameTime(), 0 , 0);
      if(butterfly[index].GetX() >= ai[index].target_x)
      {
        butterfly[index].SetTranslation(ai[index].target_x, butterfly[index].GetY(), butterfly[index].GetZ());
      }
    }
    if(butterfly[index].GetX() > ai[index].target_x)
    {
      butterfly[index].AddTranslation(-BUTTERFLY_SPPED * graphics.FrameTime(), 0 , 0);
      if(butterfly[index].GetX() <= ai[index].target_x)
      {
        butterfly[index].SetTranslation(ai[index].target_x, butterfly[index].GetY(), butterfly[index].GetZ());
      }
    }
    
    //Update Y
    if(butterfly[index].GetY() < ai[index].target_y)
    {
      butterfly[index].AddTranslation(0, BUTTERFLY_SPPED * graphics.FrameTime(), 0);
      if(butterfly[index].GetY() >= ai[index].target_y)
      {
        butterfly[index].SetTranslation(butterfly[index].GetX(), ai[index].target_y, butterfly[index].GetZ());
      }
    }
    if(butterfly[index].GetY() > ai[index].target_y)
    {
      butterfly[index].AddTranslation(0, -BUTTERFLY_SPPED * graphics.FrameTime(), 0);
      if(butterfly[index].GetY() <= ai[index].target_y)
      {
        butterfly[index].SetTranslation(butterfly[index].GetX(), ai[index].target_y, butterfly[index].GetZ());
      }
    }
    
    //Update Z
    if(butterfly[index].GetZ() < ai[index].target_z)
    {
      butterfly[index].AddTranslation(0, 0, BUTTERFLY_SPPED * graphics.FrameTime());
      if(butterfly[index].GetZ() >= ai[index].target_z)
      {
        butterfly[index].SetTranslation(butterfly[index].GetX(), butterfly[index].GetY(), ai[index].target_z);
      }
    }
    if(butterfly[index].GetZ() > ai[index].target_z)
    {
      butterfly[index].AddTranslation(0, 0, -BUTTERFLY_SPPED * graphics.FrameTime());
      if(butterfly[index].GetZ() <= ai[index].target_z)
      {
        butterfly[index].SetTranslation(butterfly[index].GetX(), butterfly[index].GetY(), ai[index].target_z);
      }
    }
    
    //check to see if we need a new location.
    if(butterfly[index].GetX() == ai[index].target_x)
    {
      if(butterfly[index].GetY() == ai[index].target_y)
      {
        if(butterfly[index].GetZ() == ai[index].target_z)
        {
          FindNewDestination(index);
        }
      }
    }
    
    //Update flutterings.
    butterfly[index].AddUp(ai[index].fluttering_speed * graphics.FrameTime());
    if(butterfly[index].GetUp() > MAX_FLUTTER)
    {
       butterfly[index].SetUp(MAX_FLUTTER);
       ai[index].fluttering_speed = -FLUTTER_SPEED;
     }
     if(butterfly[index].GetUp() < MIN_FLUTTER)
     {
       butterfly[index].SetUp(MIN_FLUTTER);
       ai[index].fluttering_speed = FLUTTER_SPEED;
     }
  }
}
