#include "allegro.h"

#define MAXPOINTS 10
#define MAXPAN 255
#define MAXVOL 200
#define BREAK 10
#define HIGHFREQ 2000

typedef struct POINT {
       int x,y;
} POINT; 

// global array for storing point positions
POINT points[MAXPOINTS];
// reset the points
void InitPoints();
// rescales the pan and volume values according to screen resolution
double PanVolRescaler(int b1, int b2, int pos);

void main(void)
{
  allegro_init(); //initializes allegro
  install_keyboard(); //installs the keyboard routines
  install_timer();
  install_mouse();
  install_sound (DIGI_AUTODETECT, MIDI_AUTODETECT, NULL);
  
  set_gfx_mode(GFX_AUTODETECT_WINDOWED,800,600,0,0);
  
  BITMAP *crosshair;
  crosshair = load_bitmap("crosshair.bmp", NULL);
  set_mouse_sprite(crosshair);
  set_mouse_sprite_focus(15,15);
  show_mouse(screen);

  SAMPLE *sound;
  sound = load_sample("sound.wav");

  int i,x,y,count,p;
  int startpan, endpan;
  int startvol, endvol;
  int startfreq, endfreq;
  int pan, vol, freq;
    
  // initialize the points array
  InitPoints();     
  
  count = 0;
  startpan = 0;
  endpan = 0;
  startvol = 0;
  startfreq = 0;
  endfreq = 0;
  endvol = 0;
  pan = 130;
  vol = 200;
  freq = 1000;
  
  while (!key[KEY_ESC])
  {
        x = mouse_x;
        y = mouse_y;
        
        textprintf(screen,font,0,0,15,"[DEL] clears screen; Left Click assigns a point, Right Click starts synthesis. %d %d ",x,y);
     
        if (mouse_b & 1) // left mouse click
        {
          circlefill(screen,x,y,20,15);  
          
          if (count < MAXPOINTS) // add point to array
          {
            points[count].x = x;
            points[count].y = y;
            //textprintf(screen,font,30,30,15, "Px: %d, Py: %d, count: %d ", points[count].x,points[count].y,count);     
            count++;         
          }
          // rest otherwise the if condition is verified more than once!
          rest(100);
        } 

        if (mouse_b & 2) // right mouse click
        {
          // start synthesis!
          play_sample(sound, 100, 150, 2000, 1);
          
          //fade in?
          
          
          // now move the sound across the points
          for (i=0; i<MAXPOINTS-1; i++)
          {
              if (points[i].x != -1 && points[i+1].x != -1)
              {
                 // pan according to x position
                 startpan = (int) PanVolRescaler(MAXPAN, SCREEN_W, points[i].x); 
                 endpan = (int) PanVolRescaler(MAXPAN, SCREEN_W, points[i+1].x); 
                 
                 startfreq = HIGHFREQ - 3*points[i].y;
                 freq = startfreq;
                 //textprintf(screen,font,60,60,15, "P1x: %d, P2x: %d, Startpan: %d , EndPan: %d ", points[i].x,points[i+1].x,startpan,endpan);
                 
                 if (startpan < endpan)
                 {
                     for (pan = startpan; pan < endpan; pan++)
                     {
                         adjust_sample(sound, vol, pan, freq, 1);
                         rest(BREAK);
                     }
                 }
                 else
                 {
                     for (pan = startpan; pan > endpan; pan--)
                     {
                         adjust_sample(sound, vol, pan, freq, 1);
                         rest(BREAK);
                     }
                     
                 } //end if startpan >= endpan
                         
                 // now change frequency according to y axis   
                 //startfreq = HIGHFREQ - 3*points[i].y;
                 endfreq = HIGHFREQ - 3*points[i+1].y;   
                 
                 if (startfreq < endfreq)
                 {
                     for (freq = startfreq; freq < endfreq; freq++)
                     {
                         adjust_sample(sound, vol, pan, freq, 1);
                         rest(BREAK);
                     }
                 }
                 else
                 {
                     for (freq = startfreq; freq > endfreq; freq--)
                     {
                         adjust_sample(sound, vol, pan, freq, 1);
                         rest(BREAK);
                     }  
                 }        
                              
              } // end if points[i].x != -1 && points[i+1].x != -1
          }    // end for    

          // fade out
          p = BREAK * 2;
          for (i=vol;i>0;i--)
          {
              adjust_sample(sound, i, pan, freq, 1);
              rest(p);
          }
          
        }    // end if mouse button 2
          
        if (key[KEY_DEL])
        {
             //clear the screen and the points
             rectfill(screen,0,0,800,600,0);  
             stop_sample(sound);  
             InitPoints(); 
             count = 0;        
        }
  }
  
  allegro_exit();
 
}

END_OF_MAIN();

void InitPoints()
{
  int i;
     
  for (i=0;i<MAXPOINTS;i++)
  {
      points[i].x = -1;
      points[i].y = -1;
  } 
}

double PanVolRescaler (int b1, int b2, int pos)
{
       double res;
       
       res = pos * b1 / b2;
       
       return res;
}
